;name	ppdef.inc
;title -- .ALL/.PRS/.DRS FILE FORMAT (7/20/89)
;
;  Copyright (C) 1987 WordPerfect Corp., All Rights Reserved
;  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
;------------------------------------------------------------
;

;------	variable block (used in pdefs, maps and global)

varntab	equ	0		;(word)	-> numeric table (size=4*varncnt)
varncnt	equ	varntab+2	;(word)	# numeric variables
varstab	equ	varncnt+2	;(word)	-> string table (size=2*varscnt)
varscnt	equ	varstab+2	;(word)	# string variables
varftab	equ	varscnt+2	;(word)	-> function table (size=2*varfcnt)
varfcnt	equ	varftab+2	;(word)	# function variables
varpool	equ	varfcnt+2	;(word)	-> variable pool
varplsz	equ	varpool+2	;(word)	variable pool size
fxvarb	equ	varplsz+2	;====== variable block fixed size
;	dd	? dup(?)	;numeric table (values)
;	dw	? dup(?)	;string table (-> into pool)
;	dw	? dup(?)	;function table (-> into pool)
;	db	? dup(?)	;variable pool
;	db	0		;fill byte for word alignment (as needed)

;------ file prefix

pfxid	equ	0		;(4byt)	-1, "WPC"
pfxlen	equ	pfxid+4		;(dwrd)	length of file prefix
pfxprod	equ	pfxlen+4	;(byte)	product (wp=1)
pfxfile	equ	pfxprod+1	;(byte)	file type (.prs=16, .all=19, .drs=20)
pfxmajv	equ	pfxfile+1	;(byte)	major version number
pfxminv	equ	pfxmajv+1	;(byte)	minor version number
pfxcrpt	equ	pfxminv+1	;(word)	encryption key (0 = not locked)
pfxres	equ	pfxcrpt+2	;(word)	reserved
pfxpdef	equ	pfxres+2	;(dwrd)	-> pdef area
pfxppsz	equ	pfxpdef+4	;(word) pdef area prefix size
pfxmap	equ	pfxppsz+2	;(dwrd)	-> character map area
pfxmlsz	equ	pfxmap+4	;(word)	map area prefix loadable size
pfxpstb	equ	pfxmlsz+2	;(dwrd)	-> ps table area
pfxplsz	equ	pfxpstb+4	;(word)	ps table area prefix loadable size
pfxsdef	equ	pfxplsz+2	;(dwrd)	-> sfdef area
pfxspsz	equ	pfxsdef+4	;(word) sfdef area prefix size
pfxtypf	equ	pfxspsz+2	;(dwrd) -> typeface area
pfxtlsz	equ	pfxtypf+4	;(word) typeface area loadable size
pfxfdat	equ	pfxtlsz+2	;(dwrd) -> font data area
pfxfdsz	equ	pfxfdat+4	;(word) font data area prefix loadable size
pfxgvar	equ	pfxfdsz+2	;(dword) -> global variable area 
pfxgvsz	equ	pfxgvar+4	;(word) global variable area loadable size 
pfxflib	equ	pfxgvsz+2	;(dwrd) -> shar font libraries area 
pfxflsz	equ	pfxflib+4	;(word) shar font libraries area prefix size 
pfxkrn	equ	pfxflsz+2	;(dwrd) -> kerning table area
pfxkrsz	equ	pfxkrn+4	;(word) kerning area loadable size
fxfile	equ	pfxkrsz+2	;====== file prefix fixed size

;------	pdef area prefix

pdcnt	equ	0		;(word)	# pdefs in pdef area
pdloc	equ	pdcnt+2		;(word)	-> pdef location/size table
;				;  (size=pdlcsz*pdcnt)
pdlcsz	equ	pdloc+2		;(byte) pdef loc/size table entry size (each)
pdflgs	equ	pdlcsz+1	;(byte) flags.
				;	(applicable only to .prs files).	
 ?subed	equ	01h		;	substitute font list was edited by user.
 ?afced	equ	02h		;	afc list was edited by user.
 ?frmed	equ	04h		;	forms edited by user
 ?pded	equ	08h		;	pdef edited by user
				;	  (but *not* sust fonts, afcs, forms)
 ?sfed	equ	10h		;	sheet feeders edited by user
 ?maped	equ	20h		;	maps edited by user
 ?psed	equ	40h		;	ps table edited by user
 ?tfed	equ	80h		;	typefaces edited by user
pdname	equ	pdflgs+1	;(word)	-> pdef name table (size=2*pdcnt)
pdpool	equ	pdname+2	;(word)	-> pdef name pool
pdplsz	equ	pdpool+2	;(word)	pdef area name pool size
pdtype	equ	pdplsz+2	;(word) -> pdef type table (size=pdcnt)
pdstyp	equ	pdtype+2	;(word) -> pdef soft font format tbl (sz=pdcnt)
fxpdefa	equ	pdstyp+2	;====== pdef area prefix fixed size
;	dw	? dup(?)	;pdef location/size table (see below)
;	dw	? dup(?)	;pdef name table (pdef name pool ->'s)
;	db	? dup(?)	;pdef name pool
;	db	? dup(?)	;pdef type table
 ?escp	equ	0		;	escape sequence printers
 ?posts	equ	1		;	postscript
 ?plttr	equ	2		;	plotter
 ?gss	equ	3		;	gss driver
 ?wndrv	equ	4		;	window's driver
 ?mxpty	equ	?gss		;	current maximum printer type
;	db	? dup(?)	;pdef subtype table (-1 not set)
 ?othr	equ	0		;	any type not listed
 ?hp2	equ	1		;	hp laserjet ser II or compatible
 ?hpp	equ	2		;	hp plus or compatible
 ?h2000	equ	3		;	hp 2000
 ?lbp2	equ	4		;	canon LBP ii
 ?lc2f	equ	5		;	lasermaster lc2/lx6 (300 dpi)
 ?lx6f	equ	6		;	lasermaster lx6 (600 dpi)
 ?altps	equ	7		;	alternative postscript pdl (qem)
 ?pstsc	equ	8		;	postscript
 ?hpdsk	equ	9		;	hp deskjet
 ?wwhpp	equ	10		;	white writer hp plus compatible
 ?wwhp2	equ	11		;	white writer hp II compatible
 ?lbp3	equ	12		;	canon LBP iii
 ?hdskp	equ	13		;	hp deskjet plus
 ?bsbpa	equ	14		;	bitstream bpa
 ?apsg	equ	15		;	alternative postscript pdl (generic)
 ?ljiip	equ	16		;	laserjet iip
 ?ljiii	equ	17		;	laserjet iii
 ?i4019	equ	18		;	ibm 4019
 ?bj130	equ	19		;	bubble jet 130e
;------	pdef loc/size table entry

pdloff	equ	0		;(dwrd)	-> pdef within pdef area
pdllsiz	equ	pdloff+4	;(word) pdef loadable region size
pdflbsz	equ	pdllsiz+2	;(word) font library size
pdnlsiz	equ	pdflbsz+2	;(word)	pdef non-loadable size
pdfmsiz	equ	pdnlsiz+2	;(word) forms library size
fxpdl	equ	pdfmsiz+2	;======	pdef loc/size table entry fixed size
;WARNING:  fxpdl should not be used for indexing--use pdlcsz instead!

;------	pdef loadable region prefix

pdres	equ	0		;(word)	-> resource area
pdressz	equ	pdres+2		;(word)	resource area size
pdppass	equ	pdressz+2	;(word)	-> ppass dependent area
pdppssz	equ	pdppass+2	;(word)	ppass dependent area size
pdgroup	equ	pdppssz+2	;(word)	-> group area
pdgrpsz	equ	pdgroup+2	;(word)	group area size
pdvars	equ	pdgrpsz+2	;(word)	-> pdef variable block
pdvarsz	equ	pdvars+2	;(word)	pdef variable block size
pdaltpl	equ	pdvarsz+2	;(word) -> alternate font pool
pdaltsz	equ	pdaltpl+2	;(word) alternate font pool size
pdfstpl	equ	pdaltsz+2	;(word) -> font string pool
pdfstsz	equ	pdfstpl+2	;(word) font string pool size
pdtopm	equ	pdfstsz+2	;(word) minimum top margin		(wpu)
pdlftm	equ	pdtopm+2	;(word) minimum left margin		(wpu)
pdbotm	equ	pdlftm+2	;(word) minimum bottom margin		(wpu)
pdrgtm	equ	pdbotm+2	;(word) minimum right margin		(wpu)
pdnfnt	equ	pdrgtm+2	;(word) maximum # fonts/page
pdlar	equ	pdnfnt+2	;(word) look ahead region (for DeskJet)(wpu)
fxpdef	equ	pdlar+2		;====== pdef prefix fixed size
;	dw	? dup(?)	;alternate font pool--each entry:
;				;	dw	# of alternate fonts
;				;	dw	length dup(font ->s)
;	db	? dup(?)	;font string pool
;	db	0		;fill byte for word alignment (as needed)

;------	resource area

rscnt	equ	0		;(word) # of resources 
rsdef	equ	rscnt+2		;(word) -> resource defs 
;				;  (size = rscnt * rsdsz) 
rsdsz	equ	rsdef+2		;(byte) size of resource defs 
rsfill	equ	rsdsz+1		;(byte) fill byte for word alignment 
fxres	equ	rsfill+1	;====== resource area prefix fixed size 
 
;------	resource def 
 
rscflgs	equ	0		;(byte) resource load method flags 
 ?rui	equ	1h		;	user intervention required
 ?reuse	equ	2h		;	re-usable (swappable)
 ?rjob	equ	4h		;	loadable during a job 
 ?rlifo	equ	8h		;	last-in-first-out 
 ?rpage	equ	10h		;	page-oriented swapping 
 ?dslib	equ	20h		;	display libraries in cart & fonts in wp
rsctype	equ	rscflgs+1	;(byte) resource type (see ftype)
rscqtot	equ	rsctype+1	;(word) total resource quantity
rscqavl	equ	rscqtot+2	;(word) available resource quantity
rscid	equ	rscqavl+2	;(byte) resource id 
rscfil	equ	rscid+1		;(byte)	fill byte for word alignment
rscmaxf	equ	rscfil+1	;(byte)	maximum number of fonts
rscavlf	equ	rscmaxf+1	;(byte)	available fonts
fxrscd	equ	rscavlf+1	;======	resource def size 
;WARNING:  fxrscd should NOT be used for indexing--use rsdsz instead! 

;------	ppass-dependent area

ppstab	equ	0		;(word) -> pdef string table (see ppsdrv.inc)
ppstnum	equ	ppstab+2	;(word) # of entries in string table
ppstbmp	equ	ppstnum+2	;(word) -> string table bitmap
ppsmpsz	equ	ppstbmp+2	;(word) string bitmap size (bytes)
ppdrvtb	equ	ppsmpsz+2	;(word) -> driver type table (see ppsdrv.inc)
				;	plotters:  -> fill table
ppgrtb 	equ	ppdrvtb+2	;(word) -> graphics resolution table (see below)
				;    (size = ppgrsz*ppgrcnt)
ppgrcnt	equ	ppgrtb+2	;(byte) # of entries in graphics resolution table
ppgrsz	equ	ppgrcnt+1	;(byte) graphics resolution table entry size
ppstrpl	equ	ppgrsz+1	;(word) -> pdef string pool
ppsplsz	equ	ppstrpl+2	;(word) pdef string pool size
ppehcbd	equ	ppsplsz+2	;(byte) enhancement board
 ?nobd	equ	0		;	none
 ?lc23	equ	1		;	lasermaster lc2 (300 dpi)
 ?lx63	equ	2		;	lasermaster lx6 (300 dpi)
 ?lx64	equ	3		;	lasermaster lx6 (400 dpi)
 ?lx66	equ	4		;	lasermaster lx6 (600 dpi)
 ?lx610	equ	5		;	lasermaster lx6 (1000 dpi)
 ?ive	equ	6		;	intel visual edge
 ?dptlp	equ	7		;	dp-tek laserport
				; LASERMASTER and compatables ONLY ABOVE 100!
 ?lc2	equ	101		;	lasermaster lc2
 ?lx6lo	equ	102		;	lasermaster lx6 low res.
 ?lx6hi	equ	104		;	lasermaster lx6 high res.
 ?gp1280 equ	107		;	lasermaster glasspage 1280
ppflag0	equ	ppehcbd+1	;(byte) ppass flags:
 ?phcen	equ	01h		;	char cell centered around print head
 ?pngch	equ	02h		;	don't print graphic characters
 ?mltcp	equ	04h		;	printer supports multiple copies
 ?pshtg	equ	08h		;	use printer's halftoning 
 ?kzero	equ	10h		;	do not remove trailing zeros
 ?grot	equ	80h		;	graphics must be rotated for landscape
ppflag1	equ	ppflag0+1	;(byte) ppass flags
 ?ssmov	equ	01h		;	move up/down for super/sub
 ?colps	equ	02h		;	color PostScript printer
;04h was type thru available flags (state unknown)
 ?msbbt	equ	08h		;	bottom pin = most significant bit
 ?setub	equ	10h		;	set unused bits for graphics

 ?latxt	equ	40h		;	scan for text in the look ahead region
				;	(pdlar) while printing graphics
 ?order	equ	80h		;	print adv/sup/sub on separate passes
ppdrnum	equ	ppflag1+1	;(byte) # of entries in driver type table
ppavail	equ	ppdrnum+1	;(word) not used yet (type 0, 1 printers)
				;	plotters:  fill table size (bytes) 
pprgb	equ	ppavail+2	;(word) -> id, red, green, blue table
ppclcnt	equ	pprgb+2		;(byte) # of entries in rgb & color id tables
ppclmax	equ	ppclcnt+1	;(byte) maximum value for rgb normalization
ppgexcp	equ	ppclmax+1	;(word) -> list of bytes special handling needs
				;	 to be done in graphics (-1 = none)
ppgxcnt	equ	ppgexcp+2	;(word)	# of entries in ppgexcp list
fxppass	equ	ppgxcnt+2	;====== fixed-length portion
;	dw	? dup(?)	;pdef string table (see ppsdrv.inc)
;	db4	? dup(?)	;(4 bytes) id, red, green, blue table
;	db	? dup(?)	;string table bitmap
;	db	? dup(?)	;driver type table (see ppsdrv.inc)
;	db	? dup(?)	;graphics resolution table (see below)
;	db	? dup(?)	;pdef string pool
;	db	0		;fill byte for word alignment (as needed)
;	db	? dup(?)	;sorted list of bytes that require special 
				;  handling in graphics
;	db	0		;fill byte for word alignment (as needed)

;------ graphics resolution table entry

grdpiy	equ	0		;(word) vertical resolution (dots/inch)
grdpix	equ	grdpiy+2	;(word) horizontal resolution (dots/inch)
grvmu	equ	grdpix+2	;(word) vertical motion unit
grhmu	equ	grvmu+2		;(word) horizontal motion unit
grdpic	equ	grhmu+2		;(word) graphics density value used in Xfer
grpsu	equ	grdpic+2	;(word) pin spacing unit (pins/inch)
grdpc	equ	grpsu+2		;(word) column height (# of pins)
grpmsk	equ	grdpc+2		;(word) pin mask for graphics data
fxgrtbl	equ	grpmsk+2	;====== graphics resolution table entry
;WARNING:  fxgrtbl should not be used for indexing--use ppgrsz instead!

;------	equates used to reference plotter-specific values

ppflt	equ	ppdrvtb		;(word) -> fill table prefix
ppfltsz	equ	ppavail		;(word) fill prefix & table size (bytes) 

;------	fill table prefix

fltcnt	equ	0		;(byte) # of fill table entries
fltyps	equ	fltcnt+1	;(127 bytes) entry numbers (nth) for fill 
				;  types (1-127)
				;  0 = 1st entry in fill table
				; -1 = no entry defined
fltesz	equ	fltyps+127	;(byte) size of a fill table entry
fltbl	equ	fltesz+1	;(word) -> 1st fill table entry (prefix size)
fxfltpx	equ	fltbl+2		;======	fixed-length portion

;------	fill table entry

filpat	equ	0		;(byte) pattern number
filang	equ	filpat+1	;(byte) angle (degrees)
filspc	equ	filang+1	;(word) spacing between lines in pat. (1200ths)
fxflt	equ	filspc+2	;====== fill table entry
;WARNING:  fxflt should not be used for indexing--use fltesz instead!


;------	group area prefix

grppsiz	equ	0		;(word)	-> 1st group def (size of prefix)
grpcnt	equ	grppsiz+2	;(word)	# group defs in group area
grppool	equ	grpcnt+2	;(word)	-> group def pool
grpplsz	equ	grppool+2	;(word)	group def pool size
grpmpl	equ	grpplsz+2	;(word) -> group member pool
grpmpsz	equ	grpmpl+2	;(word) group member pool size
grplen	equ	grpmpsz+2	;(byte)	group def length (each) (for indexing)
grpfil	equ	grplen+1	;(byte)	fill byte (in case no group def pool)
fxgrpa	equ	grpfil+1	;====== group area prefix fixed size
;	db	? dup(?)	;group def pool (shift in/out strings)
;	db	0		;fill byte for word alignment (as needed)
;	dw	? dup(?)	;group member font pool--each entry:
;				;	dw	# of group members
;				;	dw	length dup(font ->s)

;------	group def (numbered consecutively, org 0)

glod	equ	0		;(word) -> load group string (group def pool)
gunlod	equ	glod+2		;(word) -> unload group str (group def pool)
gtype	equ	gunlod+2	;(byte) font (resource) type (see ftype)
gruse	equ	gtype+1		;(byte) resource actually used (nth)
gquan	equ	gruse+1		;(word) resource quantity used
gmbr	equ	gquan+2		;(word) ->group members (group member pool)
gflags	equ	gmbr+2		;(byte) group flags (see fflgs):
;?init	equ	08h		;	initially present
;?loded	equ	10h		;	already loaded
;?lockd	equ	20h		;	locked, can't unload
;?incl	equ	80h		;	include in .PRS file (Used only by WP)
gfill	equ	gflags+1	;(byte) fill byte for word alignment
fxgrp	equ	gfill+1		;====== fixed-length portion
fxsgrp	equ	fxgrp		;shar group def is same size as normal grp def
;WARNING!  fxgrp should NOT be used for indexing--use grplen instead!

;------ pdef variable block (see structure on page 1)

;------	nonsharable font lib prefix

;NOTE:	Font library variables modifed by FIXLIB are indicated by "FIXL:"

lib1st	equ	0		;(word) -> 1st font def (prefix size)
libsiz	equ	lib1st+2	;(word) size of font defs (total)
libtypn	equ	libsiz+2	;(word) # of font (resource) types
libslen	equ	libtypn+2	;(byte) length of shar portion of font def
libnlen	equ	libslen+1	;(byte) length of shar+non portion of font def
libdefl	equ	libnlen+1	;(byte) length of font def (including .drs)
libflgs	equ	libdefl+1	;(byte) flags
 ?pandl	equ	01h		;	port and land in each font (no rev.)
 ?4ori	equ	02h		;	all four orientations in each font
 ?gfont	equ	04h		;	all fonts in lib are graphic fonts (.drs files)
 ?pspc	equ	08h		;	use space width from ps table (else 3M)
;				;	   (if set, fonts have no maps, but incl. font data)
libcnts	equ	libflgs+1	;(libtypn words) # of fonts in each type
; 				;	# of built-in fonts
;				;	# of fonts which belong to groups that
;				;		are of type cartridge slots.
;				;	# of memory (kb) 
;				;	# of memory (font slots) 
;				;	# of print wheel fonts
?ftypn	equ	5		;	total number of font types defined
libcnte	equ	libcnts+?ftypn*2 ;end of libcnt
fxflib	equ	libcnts+?ftypn*2 ;====== fixed-length portion

;------	font def (in order of font types)

fnmhash	equ	0		;(word)	hash of full font name
;				;	(full name = typeface + extension)
ftypnum	equ	fnmhash+2	;(word) typeface # (org 0)
;				; FIXL:	typeface area offset of typeface def
fmapnum	equ	ftypnum+2	;(word) map ID # (not used for .drs files)
;				; FIXL:	org 0 map loc table entry #
fpstbnm	equ	fmapnum+2	;(word) ps table ID# (-1=monospaced font)
;				; FIXL:	org 0 ps loc/scaling table entry #
;				;	(-1=monospaced font)
fppsiz	equ	fpstbnm+2	;(word) printer point size of font (3600ths)
;				;	(suggested height if scaleable font)
fwid	equ	fppsiz+2	;(word) avg *normal* charwidth (or scale factor)
;				;	mono: non-postscript: *normal* char
;				;		width (fwunits units)
;				;	      postscript: width scale factor
;				;		(1000ths, causes font scaling)
;				; 	ps:   width scale factor (1000ths, used
;				;		to scale widths from ps table)
fdlead	equ	fwid+2		;(word)	additional leading (signed wpu)
fbbias	equ	fdlead+2	;(word) baseline bias (signed wpu)
fhunits	equ	fbbias+2	;(word) horiz motion units
;				;	postscript: always 1200
fhmin	equ	fhunits+2	;(word) numerator of horiz motion units
;				;	postscript: always 1
fvunits	equ	fhmin+2		;(word) vertical motion units
;				;	postscript: width of mono font
;				;		(postscript units)
fvmin	equ	fvunits+2	;(word) numerator for fractional units of vert motion
;				;	postscript: slant (10ths of degrees)
fwunits	equ	fvmin+2		;(word) monospaced char width units
;				;	postscript: always -1 (indicates
;				;		postscript units)
fquan	equ	fwunits+2	;(word) resource quantity used
flod	equ	fquan+2		;(word) -> load font
fulod	equ	flod+2		;(word) -> unload font
fsel	equ	fulod+2		;(word) -> select font string
;				;	postscript: -> WPDL string containing
;				;		postscript fontname
fdsel	equ	fsel+2		;(word) -> deselect font
;				;	postscript: -> font already encoded?
;				;		string
fori	equ	fdsel+2		;(byte)	orientations supported by font: (FIXL)
;(high 4 bits)			;
 ?port	equ	10h		;	    portrait
 ?land	equ	20h		;	    landscape
 ?rport	equ	40h		;	    reverse-portrait
 ?rland	equ	80h		; 	    reverse-landscape
;				;	postscript: all orientations are
;				;		always marked as supported
fflgs	equ	fori+1		;(byte)
 ?highq	equ	01h		;	supports high quality   
;				;	   for .drs file = outline font
 ?medq	equ	02h		;	supports medium quality
;				;	   for .drs file = vector w/ curves font
 ?lowq	equ	04h		;	supports low quality
;				;	   for .drs file = vector font
 ?diaup	equ	08h		;	diacriticals positioned for uppercase
 ?diadj	equ	10h		;	need to adjust diac. on upper & lower
 ?greek	equ	20h		;	"greeked" font for preview (.drs files only)
fflgs1	equ	fflgs+1		;(byte) font flags:
;	equ	01h		;	unused, state undefined
 ?selcd	equ	02h		;	already selected
 ?nafc	equ	04h		;	do not use as an afc
 ?grp	equ	10h		;	member of one group?
 ?mgrp	equ	20h		;	member of two or more groups?
fflgs2	equ	fflgs1+1	;(byte) other font def flags
 ?nfont	equ	01h		;	don't display font in wp font list
 ?dsabl	equ	02h		;	*disable* bit reserved for font mapper
 ?scale	equ	04h		;	font is uniformly scalable
 ?init	equ	08h		;	font is initially present
 ?loded	equ	10h		;	already loaded
 ?lockd	equ	20h		;	locked, can't unload
 ?alfit	equ	40h		;	used internally by ALLFIT and SOMEFIT
 ?incl	equ	80h		;	include in .PRS file
fcadj	equ	fflgs2+1	;(word) character cell adjust (wpu +/-)
fcell50	equ	fcadj+2		;(word)	font cell (for 5.0 docs) (3600ths)
fxfdefs	equ	fcell50+2	;====== shar font def size (for .all)

;add libslen before using following equates

nfalt	equ	0		;(word) -> alternate font list
nfafc	equ	nfalt+2		;(word) -> afc list in afc pool
nfaflg	equ	nfafc+2		;(word) attribute afc flags
;				;	bit 0=highest precedence
nfcflg	equ	nfaflg+2	;(word) charset afc flags, bit 0 = charset 0
nfoafc	equ	nfcflg+2	;(byte) orientation afc flags
 ?aprt	equ	01h		;	portrait
 ?alnd	equ	02h		;	landscape
 ?arprt	equ	04h		;	reverse-portrait
 ?arlnd	equ	08h		;	reverse-landscape
nfavail	equ	nfoafc+1	;(byte)	fill byte
nftype	equ	nfavail+1	;(byte) font type
 ?built	equ	0		;	built-in
 ?slot	equ	1		;	cartridge slot
 ?soft	equ	2		;	memory (quantity units is kilo bytes) 
 ?fslot	equ	3		;	memory (quantity units is font slots) 
 ?wheel	equ	4		;	print wheel 
nfruse	equ	nftype+1	;(byte) resource assigned to by user (nth)
;				;	-1 = not assigned (or part of group)
nfwidp	equ	nfruse+1	;(word)	(reserved for use by FIXLIB)
;				;FIXL:	*normal* char width (wpu)
nfchrs	equ	nfwidp+2	;(dwrd) (undefined until fixlib is called)
;				;FIXL:	character set completeness bits:
;				;	1 bit/charset in *each* word
;				;	(bit n = charset n)
;				;	bit meanings (1st bit = 1st word):
;				;	  00 = charset not supported
;				;	  10 = charset supported 1-25%
;				;	  01 = charset supported 26-59%
;				;	  11 = charset supported 60%-100%
fxfdef	equ	fxfdefs+nfchrs+4;====== non shar font def size (for .prs/.all)

;add libnlen before using following equates

fdgid	equ	0		;(16 words) font data group ID #'s
;				;	(only used for .drs files)
;				;	(1 word for each character set)
fxfgdef	equ	fxfdef+fdgid+32	;====== font def size (for .drs)

;WARNING:  fxfdefs/fxfdef/fxfgdef should NOT be used for indexing --
;		use flfntsz or libdefl instead!

;------	equates used to reference postscript-specific values

fpsmonw  equ	fvunits		;(word)	width of monospaced font
;				;	(postscript units)
fpsslnt	equ	fvmin		;(word) amount to slant font (10ths of degrees)
fpsnam	equ	fsel		;(word) -> postscript font name
fpsenc	equ	fdsel		;(word) -> font already encoded? string

;------	pdef non-loadable region 

pnafcpl	equ	0		;(word) -> auto font change pool
pnafcsz	equ	pnafcpl+2	;(word) auto font change pool size
pnrstbl	equ	pnafcsz+2	;(word) -> res name table
pnrstsz	equ	pnrstbl+2	;(word) res name table size
pnfontn	equ	pnrstsz+2	;(word)	-> font def name table
pnftnsz	equ	pnfontn+2	;(word)	font def name table size
pngrpnm	equ	pnftnsz+2	;(word)	-> group def name table
pngpnsz	equ	pngrpnm+2	;(word)	group def name table size
pnvarnm	equ	pngpnsz+2	;(word)	-> pdef variable name tables
pnvrnsz	equ	pnvarnm+2	;(word)	pdef variable name tables size (total)
pnvnpl	equ	pnvrnsz+2	;(word)	-> variable name pool
pnvplsz	equ	pnvnpl+2	;(word)	variable name pool size
pnfpool	equ	pnvplsz+2	;(word)	-> font/group/resource name pool
pnfplsz	equ	pnfpool+2	;(word)	font/group/resource name pool size
pncmnt	equ	pnfplsz+2	;(word)	-> comment area (help screen)
pncmtsz	equ	pncmnt+2	;(word)	comment area size
pnflu	equ	pncmtsz+2	;(word) -> shar font libraries used table
				;  (count = pnflusz/pnflues)
pnflusz	equ	pnflu+2		;(word) size of shar font libs used table
pnflues	equ	pnflusz+2	;(byte) size of shar font libs used table entry
pnflgs	equ	pnflues+1	;(byte) flags
 ?skpsa	equ	01h		;	don't set up afc's for sup/subscripts
fxpdefn	equ	pnflgs+1	;====== pdef nonload prefix fixed size
;	dw	? dup(?)	;afc pool--each afc entry looks like this:
;				;	dw	font ->
;				;afc list has 1 entry/set bit in faflg
;				;followed by 1 entry/set bit in fcflg
;				;followed by 1 entry/set bit in foflg
;				;afc list size = 2*(#_in_faflg+#_in_fcflg
;				;		    +#_in_foflg)
;	dw	? dup(?)	;resource name table (f/g/r name pool ->'s)
;				;  (-1 = use resource type name)
;	dw	? dup(?)	;font def name table (f/g/r name pool ->'s)
;	dw	? dup(?)	;group def name table (f/g/r name pool ->'s)
;	dw	? dup(?)	;pdef var name tables (var name pool ->'s)
;				;  (-> for numerics, then strings, then funcs)
;				;  (3 separate parcels are used by PTR, but
;				;  the size stored in pdvrnsz is collective)
;	db	? dup(?)	;variable name pool
;	db	? dup(?)	;font/group/resource name pool
;	db	? dup(?)	;comment area
;	db	? dup(?)	;sharable font libs used table

;------	sharable font libraries used table entry

fluid	equ	0		;(word) id of sharable font library
flutype	equ	fluid+2		;(byte) font (resource) type
fxflu	equ	flutype+1	;======	shar fnt lib's used entry fixed size
;WARNING: fxflu should not be used for indexing--use pnfltsz instead!

;------	form def area prefix (entire form def area is loadable)

frmdefp	equ	0		;(word) -> 1st form def (size of prefix)
frmcnt	equ	frmdefp+2	;(word) # form defs in form def area
frmname	equ	frmcnt+2	;(word) -> form def name table
frmpool	equ	frmname+2	;(word) -> form def name pool
frmplsz	equ	frmpool+2	;(word) form def name pool size
frmsiz	equ	frmplsz+2	;(byte) form def size (each)
frmflgs	equ	frmsiz+1	;(byte) form def flags
 ?mcsam	equ	01h		;	manual & continuous load in same place
 ?led	equ	10h		;	long edge duplexing supported
 ?sed	equ	20h		;	short edge duplexing supported
frmiwid	equ	frmflgs+1	;(word) insertion width
frmmlen	equ	frmiwid+2	;(word) maximum length
frm1lab	equ	frmmlen+2	;(word) -> 1st label def
frmlbsz	equ	frm1lab+2	;(word) size of label defs (all)
frmldsz	equ	frmlbsz+2	;(byte) size of label def (each)
frmfil	equ	frmldsz+1	;(byte) fill byte for word alignment
fxforma	equ	frmfil+1	;====== form def area prefix fixed size
;	dw	? dup(?)	;form name table
;	db	? dup(?)	;form def name pool
;	db	0		;fill byte for word alignment (as needed)

;------	form def

frmtopl	equ	0		;(word) length of top edge of form (wpu)
frmsidl	equ	frmtopl+2	;(word) length of side edge of form (wpu)
frmtopa	equ	frmsidl+2	;(word) top text adjust of form ( wpu)
frmsida	equ	frmtopa+2	;(word) side text adjust of form ( wpu)
frmflg	equ	frmsida+2	;(byte) form flags
 ?fprt	equ	01h		;  portrait form
 ?flnd	equ	02h		;  landscape form
 ?fpri	equ	04h		;  primary form
 ?flod	equ	08h		;  form is currently loaded
 ?fdsz	equ	10h		;  form size is dependant on country (default)
frmloc	equ	frmflg+1	;(byte) location of form:
;				;	0	= continuous
;				;       1-31    = bin number
;				;	32	= manual feed
frmtype	equ	frmloc+1	;(word) type of form
;				; if high bit set, then -> to form name
;				; 	0	= "all other" (the 'else' form)
;				;	1	= blank standard
;				;	2	= blank bond
;				;	3	= letterhead
;				;	4	= labels
;				;	5	= envelope
;				;	6	= transparency
;				;	7	= cardstock
frmlab	equ	frmtype+2	;(word) -> label def (-1 = none)
frmflg2	equ	frmlab+2	;(byte) form flags
 ?binde	equ	01h		;	0 = long edge binding (side in port.)
				;	1 = short edge binding (top in port.)
 ?dodup	equ	02h		;	1 = duplexing enabled
frmfill	equ	frmflg2+1	;(byte) fill byte for word alignment
fxform	equ	frmfill+1	;====== form def structure - fixed length

frmilen	equ	frmtopl
frmtlen	equ	frmsidl
frmioff	equ	frmtopa
frmtoff	equ	frmsida

;------	label def

lblrow	equ	0		;(byte) label rows
lblcol	equ	lblrow+1	;(byte) label columns
lbltlf	equ	lblcol+1	;(word) label top left (wpu)
lblttp	equ	lbltlf+2	;(word) label top top (wpu)
lblwid	equ	lblttp+2	;(word) label width (wpu)
lbllen	equ	lblwid+2	;(word) label length (wpu)
lbldrw	equ	lbllen+2	;(word) label distance between rows (wpu)
lbldcl	equ	lbldrw+2	;(word) label distance between columns (wpu)
lblmlf	equ	lbldcl+2	;(word) label margin left (wpu)
lblmrt	equ	lblmlf+2	;(word) label margin right (wpu)
lblmtp	equ	lblmrt+2	;(word) label margin top (wpu)
lblmbt	equ	lblmtp+2	;(word) label margin bottom (wpu)
fxlbl	equ	lblmbt+2	; end of label structure

;WARNING: fxlbl should not be used for indexing--use frmldsz instead!

;------	map area prefix loadable region

mapcnt	equ	0		;(word)	# maps in map area
mapid	equ	mapcnt+2	;(word) -> map ID table (size=2*mapcnt)
mnxtid	equ	mapid+2		;(word) ID # for the next map created
maploc	equ	mnxtid+2	;(word)	-> map loc/size table
;				;  (size=maplcsz*mapcnt)
maplcsz	equ	maploc+2	;(byte)	map loc/size table entry size (each)
mapavl	equ	maplcsz+1	;(byte)	(fill byte -- available, always 0)
mapsets	equ	mapavl+1	;(word)	-> map char set completeness table
				;  (size=4*mapcnt)
mapname	equ	mapsets+2	;(word)	-> map name table (size=2*mapcnt)
mappool	equ	mapname+2	;(word)	-> map name pool
mapplsz	equ	mappool+2	;(word)	map name pool size
fxmapa	equ	mapplsz+2	;====== map area prefix fixed size
;	dw	? dup(?)	;map ID table
;	dw	? dup(?)	;map loc/size table (see below)
;	dd	? dup(?)	;map char set completeness table
;				;(see fchrs for description)

;------	map area prefix non-loadable region

;	dw	? dup(?)	;map name table (map name pool ->'s)
;	db	? dup(?)	;map name pool

;------	map loc/size table entry

mploff	equ	0		;(dwrd)	-> map in map area
mplasiz	equ	mploff+4	;(word) actual size of map loadable region
mplnsiz	equ	mplasiz+2	;(word)	map non-loadable region
mplxsiz	equ	mplnsiz+2	;(word)	expanded size of map loadable region
;				;  (if mplasiz=mplxsiz, map is expanded)
fxmpl	equ	mplxsiz+2	;======	map loc/size table entry fixed size
;WARNING:  fxmpl should not be used for indexing--use maplcsz instead!

;------	map loadable region

mchrtab	equ	0		;(word) -> map character table
;				;  (expanded size=2*[mccnt added up])
mvars	equ	mchrtab+2	;(word)	-> map variable block
mvarsz	equ	mvars+2		;(word)	map variable block size
mstpool	equ	mvarsz+2	;(word)	-> map string pool
mstplsz	equ	mstpool+2	;(word)	map string pool size
mbitmap	equ	mstplsz+2	;(word) -> bitmap
				;  (size=([mccnt added up]+7)/8)
mvarnam	equ	mbitmap+2	;(word)	-> map variable name tables
mvarnsz	equ	mvarnam+2	;(word)	map variable name tables size (total)
mvarnpl	equ	mvarnsz+2	;(word)	-> map variable name pool
mvrnpsz	equ	mvarnpl+2	;(word)	map variable name pool size
mccnt	equ	mvrnpsz+2	;(16 bytes) # of characters (0 -- #-1),
				;one for each character set
fxmap	equ	mccnt+16	;====== map prefix fixed size
;	dw	? dup(?)	;map variable block
;	db	? dup(?)	;map string pool (0f000h size limit)
;NOTE:	map character table and bitmap must be last data in map loadable region
;	(for expansion)
;	dw	? dup(?)	;map character table:
;				;	-1 = not in map (expanded maps only)
;				;	00000h-0Efffh = map string pool offset
;				;	0f0xxh-0fexxh = map to char code xxh,
;				;	  high byte determines display method
;				;		decimal	-2
;				;		hex	-3
;				;		octal	-4
;				;		ascii	-5
;				;		binary	-6
;	db	? dup(?)	;map bitmap
;				;first bit corresponds to last entry in table.
;	db	0		;fill byte for word alignment (as needed)

;------	map non-loadable region

;	dw	? dup(?)	;map variable name tables (var name pool ->'s)
;				;  (-> for numerics, then strings, then funcs)
;				;  (3 separate parcels are used by PTR, but
;				;  the size stored in mvarnsz is collective)
;	db	? dup(?)	;map variable name pool

;------	font data area prefix (for .drs files only)

fdcnt	equ	0		;(word)	# font data groups in font data area
;				;   NOTE: 1 group = all the character data
;				;   for 1 character set in 1 font
fdid	equ	fdcnt+2		;(word) -> font data ID table (size=2*fdcnt)
fdnxtid	equ	fdid+2		;(word) ID # for the next font data group created
fdloc	equ	fdnxtid+2	;(word)	-> font data loc/size table
;				;  (size=fdlcsz*fdcnt)
fdlcsz	equ	fdloc+2		;(byte) font data loc/size table entry size (each)
fdavail	equ	fdlcsz+1	;(byte) (available)
fdname	equ	fdavail+1	;(word)	-> font data name table (size=2*fdcnt)
fdnpool	equ	fdname+2	;(word)	-> font data name pool
fdnplsz	equ	fdnpool+2	;(word)	font data name pool size
fxfdat	equ	fdnplsz+2	;====== font data area prefix fixed size
;	dw	? dup(?)	;font data ID table
;	dw	? dup(?)	;font data location/size table (see below)

;------	font data area prefix non-loadable region

;	dw	? dup(?)	;font data name table (font data name pool ->'s)
;	db	? dup(?)	;font data name pool

;------	font data loc/size table entry

fdloff	equ	0		;(dwrd)	-> font data group within font data area
fdlasiz	equ	fdloff+4	;(word) actual size of font data group
fdlxsiz	equ	fdlasiz+2	;(word)	expanded size of font data group
;				;  (if fdlasiz=fdlxsiz, font data is expanded)
fxfdl	equ	fdlxsiz+2	;======	font data loc/size table entry fixed size
;WARNING:  fxfdl should not be used for indexing--use fdlcsz instead!

;------	font data group prefix

fdgflgs	 equ	0		;(byte) font data group flags:
 ?ncwid	 equ	01h		;  bitmap chars, height and width in nibbles
 ?bcwid	 equ	02h		;  bitmap chars, height and width in bytes
 ?wcwid	 equ	04h		;  bitmap chars, height and width in words
 ?bchar	 equ	04h		;  bitmap chars, height and width in bytes
 ?vchar	 equ	08h		;  VCF format characters (vectors, outlines)
fdgscn	 equ	fdgflgs+1	;(byte) scanning code for bitmap chars
;				;	0 = left to right, top to bottom
;				;	1 = bottom to top, left to right
;				;	2 = top to bottom, left to right
;				;	3 = right to left, top to bottom
fdgcnt	 equ	fdgscn+1	;(word) # of entries in char data loc table
fdgloc	 equ	fdgcnt+2	;(word) -> char data loc table (size=fdgcnt*2)
fdgpl	 equ	fdgloc+2	;(word) -> char data pool
fdgplsz	 equ	fdgpl+2		;(word) size of char pool
fxfdg	 equ	fdgplsz+2	;====== font data group prefix fixed size
;	 dw	? dup(?)	;char data loc table (->'s into char data pool)
;	 db 	? dup(?)	;char data pool
;	 db	0		;fill byte for word alignment (as needed)

;Character definition for bitmap chars 255x255 pixels or less
;cell and character width and height stored in bytes
;	db	?		;(byte+) length (in PTR expression format -- if > 255, then 255,length, etc.)
;	dw	?		;(word) character cell width         (pixels)
bchrw	equ	0		;(byte) character width              (pixels)
bchrh	equ	bchrw+1		;(byte) character height             (pixels)
bchrx	equ	bchrh+1		;(word) signed character x offset in cell   (pixels)
bchry	equ	bchrx+2		;(word) signed character y offset in cell   (pixels)
bchrbit	equ	bchry+2		;the bitmap (size=[(bchrw+7)/8]*bchrh)
;	db 	? dup(?)

;Character definition for vector/outline characters (bytes)
;	db	?		;(byte+) length (in PTR expression format -- if > 255, then 255,length, etc.)
;	dw	?		;(word) character cell width
;	db	? dup(?)	;char data in VCF format
 
;------	ps table area prefix loadable region

pscnt	equ	0		;(word)	# ps tables in ps table area
psid	equ	pscnt+2		;(word)	-> ps ID table (size=2*pscnt)
psnxtid	equ	psid+2		;(word)	ID # for next ps table created
psloc	equ	psnxtid+2	;(word)	-> pstab location/size table
;				;  (size=pslcsz*pscnt)
pslcsz	equ	psloc+2		;(byte)	pstab loc/size table entry size (each)
pscalts	equ	pslcsz+1	;(byte)	pstab scaling table entry size
pscalt	equ	pscalts+1	;(word) -> pstab scaling table
;				;	(size=pscalts*pscnt)
psnmtab	equ	pscalt+2	;(word)	-> pstab name table (size=2*pscnt)
psnpool	equ	psnmtab+2	;(word)	-> pstab name pool
psnplsz	equ	psnpool+2	;(word)	pstab name pool size
fxpsa	equ	psnplsz+2	;====== ps table area prefix fixed size
;	dw	? dup(?)	;pstab ID table
;	dw	? dup(?)	;pstab location/size table (see below)
;	dw	? dup(?)	;pstab scaling table (see below)

;------	ps table area prefix non-loadable region

;	dw	? dup(?)	;pstab name table (pstab name pool ->'s)
;	db	? dup(?)	;pstab name pool

;------	pstab location/size table

psloff	equ	0		;(dwrd)	-> ps table in ps area
pslasiz	equ	psloff+4	;(word) actual size of ps table
pslkrn	equ	pslasiz+2	;(word) ID of kern table (-1 = none)
pslxsiz	equ	pslkrn+2	;(word)	expanded size of ps table
;				;  (if pslasiz=pslxsiz, pstab is expanded)
fxpsl	equ	pslxsiz+2	;======	pstab loc/size table entry fixed size
;WARNING:  fxpsl should not be used for indexing--use pslcsz instead!

;------	pstab scaling table

psptsz	equ	0		;(word) ptsize table was created for (3600ths)
psavgwd	equ	psptsz+2	;(word) average width of chars in table (wpu)
psunits	equ	psavgwd+2	;(word)	pstab char width units (300=300ths)
;				;	postscript: -1 = postscript units
fxscal	equ	psunits+2	;======	pstab scaling table entry fixed size
;WARNING:  fxscal should not be used for indexing--use pscalts instead!

;------	ps table
pswtab	equ	0		;(word) -> width table
;				;  (size=[pstccnt added up] bytes or words)
psatab	equ	pswtab+2	;(word) -> adjust table (if any)
;				;  (size=[pstccnt added up] bytes or words)
pstbit	equ	psatab+2	;(word)	-> bitmap
				;  (size=([pstccnt added up]+7)/8)
pstccnt	equ	pstbit+2	;(16 bytes) # of characters (0 -- #-1),
				;one for each character set
pstflgs	equ	pstccnt+16	;(byte)	size flags:
 ?bwid	equ	01h		;  byte widths
 ?wwid	equ	02h		;  word widths   
 ?badj	equ	04h		;  byte adjust factors
 ?wadj	equ	08h		;  word adjust factors
pstflg2	equ	pstflgs+1	;(byte) flags:
 ?kpavw	equ	01h		;  keep average width
fxps	equ	pstflg2+1	;====== ps table fixed size
;	db/dw	? dup(?)	;width table
;	db	0		;fill byte for word alignment (as needed)
;	db/dw	? dup(?)	;adjust table
;	db	0		;fill byte for word alignment (as needed)
;	db	? dup(?)	;bitmap (must be last data in ps table)
;				;first bit corresponds to last entry in table.
;	db	0		;fill byte for word alignment (as needed)
;NOTE:	tables that can be compressed and bitmap must be last
;	adjust table must be after width table.

;------	kern table area prefix loadable region

krncnt	equ	0		;(word)	# kern tables in kern table area
krnid	equ	krncnt+2	;(word)	-> kern ID table (size=2*krncnt)
krnxtid	equ	krnid+2		;(word)	ID # for next kern table created
krnloc	equ	krnxtid+2	;(word)	-> kern location/size table
;				;  (size=krnlcsz*krncnt)
krnlcsz	equ	krnloc+2	;(byte)	kern loc/size table entry size (each)
krnaval	equ	krnlcsz+1	;(byte)	available
krnmtab	equ	krnaval+1	;(word)	-> kern name table (size=2*krncnt)
krnpool	equ	krnmtab+2	;(word)	-> kern name pool
krnplsz	equ	krnpool+2	;(word)	kern name pool size
fxkrna	equ	krnplsz+2	;====== kern table area prefix fixed size
;	dw	? dup(?)	;kern ID table
;	dw	? dup(?)	;kern location/size table (see below)

;------	kern table area prefix non-loadable region

;	dw	? dup(?)	;kern name table (kern name pool ->'s)
;	db	? dup(?)	;kern name pool

;------	kern location/size table

krnloff	equ	0		;(dwrd)	-> kern table in kern area
krnsiz	equ	krnloff+4	;(word) size of kern table
fxkrnl	equ	krnsiz+2	;======	kernt loc/size table entry fixed size
;WARNING:  fxkrnl should not be used for indexing--use krnlcsz instead!

;------ kern table
krnbcnt	equ	0		;(word) # byte pairs
krnwcnt	equ	krnbcnt+2	;(word)	# word pairs
krnptab	equ	krnwcnt+2	;(word) -> kern pair table
;				;  (size = krnbcnt*2 + krnwcnt*4)
krnvtab	equ	krnptab+2	;(word)	-> kern value table
;				;  (size = krnbcnt+krnwcnt (*2 if word values))
krnflg	equ	krnvtab+2	;(byte) kern flags
 ?bwval	equ	01h		;  1 = word values in kern value table
krnfill	equ	krnflg+1	;(byte) fill byte for word alignment
krnptsz	equ	krnfill+1	;(word) ptsize table was created for (3600ths)
fxkrn	equ	krnptsz+2	;====== kern prefix size
;	dw	? dup(?)	;kern pair table
;				;  db  left char	\ ASCII
;				;  db  right char	/ kern pairs
;				;(NOTE: ASCII kern pairs must be *sorted* in
;				;ascending order, sorted by right char first
;				;and left char last.  This is the same as
;				;treating the two bytes as a word on a system
;				;which stores low byte first and then sorting
;				;the words from lowest to highest values.)
;				;  dw  left char	\ NON-ASCII
;				;  dw  right char	/ kern pairs
;				;(NOTE: NON-ASCII kern pairs must be *sorted*
;				;in ascending order, sorted by right char
;				;first and left char last.  This is the same
;				;as treating the two words as a doubleword on
;				;a system which stores low word first and
;				;then sorting the doublewords from lowest to
;				;highest values.)
;	db/dw	? dup(?)	;kern value table
;				;(One value for each kern pair, sequence of
;				;kern pair table determines sequence of
;				;values.)

;------	sfdef area prefix

sfdcnt	equ	0		;(word)	# sfdefs in sfdef area
sfdloc	equ	sfdcnt+2	;(word)	-> sfdef loc/s tbl (sz=sfdcnt*sfdlcsz)
sfdlcsz	equ	sfdloc+2	;(byte) sfdef loc/size table entry size (each)
sfdavl	equ	sfdlcsz+1	;(byte) (available)
sfdname	equ	sfdavl+1	;(word)	-> sfdef name table (size=sfdcnt*2)
sfdpool	equ	sfdname+2	;(word)	-> sfdef name pool
sfdplsz	equ	sfdpool+2	;(word)	sfdef name pool size
fxsfa	equ	sfdplsz+2	;====== sfdef area prefix fixed size
;	dw	? dup(?)	;sfdef location/size table (see below)
;	dw	? dup(?)	;name table (sfdef name pool ->'s)
;	db	? dup(?)	;sfdef name pool

;------	sfdef location/size table entry

sfloff	equ	0		;(dwrd)	-> sfdef within sfdef area
sfllsiz	equ	sfloff+4	;(word) size of sfdef loadable region
sfnlsiz	equ	sfllsiz+2	;(word)	size of sfdef nonloadable region
fxsfl	equ	sfnlsiz+2	;======	sfdef loc/size table entry fixed size
;WARNING:  fxsfl should not be used for indexing--use sfdlcsz instead!

;------	sfdef loadable region

sselect	equ	0		;(word) -> select bin string (in pool)
sinsert	equ	sselect+2	;(word)	-> insert page string (in pool)
seject	equ	sinsert+2	;(word)	-> eject page string (in pool)
sbindef	equ	seject+2	;(word) -> bin default tbl (sz=sbincnt*sbinsz)
sbinsz	equ	sbindef+2	;(byte) bin default table entry size
sfavail	equ	sbinsz+1	;(byte) fill byte - available
sbincnt	equ	sfavail+1	;(word) # of defined bins 
sfbntb	equ	sbincnt+2	;(word) sfdef bin name tbl (sz=sbincnt*2) 
sfbnpl	equ	sfbntb+2	;(word) sfdef bin name pool
sfbnpsz	equ	sfbnpl+2	;(word) sfdef bin name pool size
spool	equ	sfbnpsz+2	;(word)	-> sfdef pool
spoolsz	equ	spool+2		;(word) sfdef pool size
scmnt	equ	spoolsz+2	;(word) -> comment area
scmntsz	equ	scmnt+2		;(word) comment area size
fxsf	equ	scmntsz+2	;====== sfdef fixed size
;	dw	? dup(?)	;bin default table (see below)
;	dw	? dup(?)	;sfdef bin name table
;	db	? dup(?)	;sfdef bin name pool
;	db	? dup(?)	;sfdef pool (for eject and insert strings)
;	db	0		;fill byte for word alignment (as needed)

;------	bin default table entry

bintopo	equ	0		;(word)	top offset when form is inserted
binlfto	equ	bintopo+2	;(word)	left offset
fxbin	equ	binlfto+2	;======	bin default table entry fixed size

;------	sfdef non-loadable region

;	db	? dup(?)	;comment area

;------	typeface area loadable region

typcnt	equ	0		;(word) # typefaces defined
typid	equ	typcnt+2	;(word) -> typeface ID table (size=typcnt*2)
typnxt	equ	typid+2		;(word) ID # for next typeface created
typdef	equ	typnxt+2	;(word) -> typeface defs (size=typcnt*typdefl)
typname	equ	typdef+2	;(word) -> typeface name table (size=typcnt*2)
typpool	equ	typname+2	;(word) -> typeface name pool
typplsz	equ	typpool+2	;(word) typeface name pool size
typdefl	equ	typplsz+2	;(byte) length of typeface def.
typfil	equ	typdefl+1	;(byte)	fill byte
fxtyp	equ	typfil+1	;====== typeface loadable region fixed size
;	dw	? dup(?)	;typeface ID table
;	dw	? dup(?)	;typeface defs
;

;------	typeface def

tfcaps	equ	0		;(word)	cap height	 	 (psu)
tfx	equ	tfcaps+2	;(word)	x height		 (psu)
tft	equ	tfx+2		;(word) lowercase t height	 (psu)
tfasc	equ	tft+2		;(word) maximum ascender height  (psu)
tfdesc	equ	tfasc+2		;(word)	maximum descender height (psu)
tfitadj	equ	tfdesc+2	;(word)	italic adjust (caps)	 (psu, +/-)
tfdsclw	equ	tfitadj+2	;(word) low word of descriptor 
tfdschb	equ	tfdsclw+2	;(byte)	high byte of descriptor
tfflgs1	equ	tfdschb+1	;(byte) tf def flags
 ?scaps	equ	01h		;	small caps font
 ?shadw	equ	02h		;	shadow font
 ?outln	equ	04h		;	outline font
 ?ital	equ	08h		;	italic or oblique
 ?ps	equ	10h		;	ps font		(font descriptor only)
;weight - high three bits
 ?wxl	equ	00000000b	;	extra light
 ?wl	equ	00100000b	;	light
 ?wn	equ	01000000b	;	normal
 ?wdb	equ	01100000b	;	demi-bold	
 ?wb	equ	10000000b	;	bold
 ?wh	equ	10100000b	;	heavy
 ?wbl	equ	11000000b	;	black
 ?wubl	equ	11100000b	;	ultra-black
tfhash	equ	tfflgs1+1	;(byte) hash of typeface name
tffill	equ	tfhash+1	;(byte) fill byte for word alignment
fxtf	equ	tffill+1	;======	typeface def fixed size

;------	typeface area non-loadable region

;	dw	? dup(?)	;typeface name table (typeface name pool ->'s)
;	db	? dup(?)	;typeface name pool

;------	global variable area prefix (loadable region)
 
gvblk	equ	0		;(word) -> global variable block 
gvblksz	equ	gvblk+2		;(word) global variable block size 
gvntb	equ	gvblksz+2	;(word) -> global variable name tables 
gvntbsz	equ	gvntb+2		;(word) global variable name tables size (total) 
gvnpl	equ	gvntbsz+2	;(word) -> global variable name pool 
gvnplsz	equ	gvnpl+2		;(word) global variable name pool size 
fxgv 	equ	gvnplsz+2	;====== global variable area prefix fixed size 
 
;------ global variable block (see structure on page 1) 
 
;------	global variable nonloadable region

;	dw	? dup(?)	;global var name tables (var name pool ->'s) 
;				;  (-> for numerics, then strings, then funcs) 
;				;  (3 separate parcels are used by PTR, but 
;				;  the size stored in gvntbsz is collective) 
;	db	? dup(?)	;global variable name pool 

;------	sharable font libraries area prefix 
 
flcnt	equ	0		;(word) # font libraries in font libraries area 
flid	equ	flcnt+2		;(word) -> font libraries id table 
flnxtid	equ	flid+2		;(word) id # for the next font lib created 
flloc	equ	flnxtid+2	;(word) -> font lib location/size table 
;				;  (size=fllcsz*flcnt) 
flname	equ	flloc+2 	;(word) -> name table (size=2*flcnt) 
flpool	equ	flname+2	;(word) -> name pool 
flplsz	equ	flpool+2	;(word) name pool size 
fltype	equ	flplsz+2	;(word) -> type table (size=flcnt)
fllcsz	equ	fltype+2	;(byte) loc/size table entry size (each) 
flfntsz	equ	fllcsz+1	;(byte) size of font defs in font libraries 
flgrpsz	equ	flfntsz+1	;(byte)	group def length (each) (for indexing)
flafill	equ	flgrpsz+1	;(byte)	fill byte for word alignment
fxfla	equ	flafill+1	;====== font lib area prefix fixed size 
;	dw	? dup(?)	;font lib ID table 
;	dw	? dup(?)	;font lib location/size table (see below) 
;	dw	? dup(?)	;font lib name table (font lib name pool ->'s) 
;	db	? dup(?)	;font lib name pool 
;	db	? dup(?)	;font lib type table
 
;------	shar font lib loc/size table entry 
 
floff	equ	0		;(dwrd) -> font lib within font lib area 
flsiz	equ	floff+4		;(word) font lib size 
fxfll	equ	flsiz+2		;======	font lib loc/size tab entry fixed size 
;WARNING:  fxfll should not be used for indexing--use fllcsz instead! 
 
;------	sharable font lib prefix 

flfontn	equ	0		;(word) -> font def name table 
flftnsz	equ	flfontn+2 	;(word) font def name table size 
flgrpnm	equ	flftnsz+2 	;(word) -> group def name table 
flgpnsz	equ	flgrpnm+2 	;(word) group def name table size 
flfpool	equ	flgpnsz+2 	;(word) -> font/group name pool 
flfplsz	equ	flfpool+2 	;(word) font/group name pool size 
flgmpl	equ	flfplsz+2	;(word) -> group member pool
flgmpsz	equ	flgmpl+2	;(word) group member pool size
flstrpl	equ	flgmpsz+2	;(word) -> font/group string pool 
flstrsz	equ	flstrpl+2 	;(word) font/group string pool size 
flgrps	equ	flstrsz+2	;(word) -> group definitions
;				;  (size = flgcnt * flgrpsz) 
flgcnt	equ	flgrps+2	;(word) # of groups in font library
flfonts	equ	flgcnt+2 	;(word) -> font definitions 
;				;  (size = flfcnt * flfntsz) 
flfcnt	equ	flfonts+2 	;(word) # font defs in font lib
;				;  (all of one type)
flflgs	equ	flfcnt+2	;(byte) sharable font library flags
 ?fludt	equ	01h		;	update font library (ptr /update)
flfill	equ	flflgs+1	;(byte) fill byte for word alignment
fxfl equ	flfill+1	;====== font lib prefix fixed size 
;	dw	? dup(?)	;font def name table (f/g name pool ->'s) 
;	dw	? dup(?)	;group def name table (f/g name pool ->'s) 
;	db	? dup(?)	;font/group name pool 
;	db	0		;fill byte for word alignment (as needed) 
;	dw	? dup(?)	;group member font pool--each entry:
;				;	dw	# of group members
;				;	dw	length dup(font ->s)
;	db	? dup(?)	;font/group string pool 
;	db	0		;fill byte for word alignment (as needed) 
 
;------	sharable font libraries group defs (same as pdef groups) 
 
;------	sharable font libraries font defs	
 
;see pdef non shar font defs (sharable font defs are shorter)

;------	consistency checking

check	macro	condition,message
	if	condition
		ERROR:	message
	endif
	endm

;------	getmps (wpscn1) assumes similar ps/map prefixes and loc/size tables

	check	<psloc-maploc>,<PSLOC not the same as MAPLOC>
	check	<psloc-krnloc>,<PSLOC not the same as KRNLOC>
	check	<pslcsz-maplcsz>,<PSLCSZ not the same as MAPLCSZ>
	check	<pslcsz-krnlcsz>,<PSLCSZ not the same as KRNLCSZ>

;------	initpq (wpscn1) assumes locations are 1st dwords in location tables

	check	<pdloff>,<PDLOFF not 1st entry in location table>
	check	<sfloff>,<SFLOFF not 1st entry in location table>
	check	<floff>,<FLOFF not 1st entry in location table>
	check	<krnloff>,<KRNLOFF not 1st entry in location table>
	check	<psloff>,<PSLOFF not 1st entry in location table>
	check	<mploff>,<MPLOFF not 1st entry in location table>

purge	check

;------	ppread assumes variable name pool pointer follows variable name
;	table pointer.
