;name	wpdl.inc
;title	equates for wpdl expressions.
;
;  Copyright (C) 1989 WordPerfect Corp., All Rights Reserved
;  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
;------------------------------------------------------------
;description (up to 5 lines)
;
;segments:	cs = codeseg
;		ds = dataseg
;		es = 

.xcref			;Don't cross reference include files.

include	macros.inc

.cref			;Restore cross reference.


;------	ddl compact form function code assignments
;
;	To add a WPDL code, insert the code in logical place and adjust
;	equates below, fix PPASCI and PPCOMP to handle the code.
;	Inserting or deleting a code requires version # change and conversion.
;
;NOTE:	{ } denotes a byte
;	[ ] denotes a word
;
;	Parameters for functions are separated by DSEP's
;	and terminated by DENDP.  If DENDP is encountered when
;	more parameters are expected, the remaining parameters
;	are defaulted.  Likewise, a DSEP without its parameter
;	should be defaulted.

;------	functional listing of wpdl codes
;
;NOTE:	Additional codes added to WPDL must be added at the end of the
;	numeric listing.  This means that some codes that are grouped
;	may end up with gaps in the groupings.  It is important that any
;	such holes be documented so that the WPDL interpreter can be
;	modified to handle the gaps.

;------	constants

dcbin	equ	000	;binary constant	{value}	follows
dcoct	equ	001	;octal constant		{value}	follows
dcdec	equ	002	;decimal constant	{value}	follows
dchex	equ	003	;hex constant		{value}	follows
dcchr	equ	004	;character constant	{value}	follows
dcbinl	equ	005	;binary constant	[value]	follows
dcoctl	equ	006	;octal constant		[value]	follows
dcdecl	equ	007	;decimal constant	[value]	follows
dchexl	equ	008	;hex constant		[value]	follows
dcchrl	equ	009	;character constant	[value]	follows

;------	user-defined expressions and numeric variables

dpdin	equ	010	;pdef integer		{number} follows
dmpin	equ	011	;map integer		{number} follows
dpdst	equ	012	;pdef string		{number} follows
dmpst	equ	013	;map string		{number} follows
dpdfn	equ	014	;pdef function		{number} follows
dmpfn	equ	015	;map functionn	{number} follows
dpdinl	equ	016	;pdef integer		[number] follows
dmpinl	equ	017	;map integer		[number] follows
dpdstl	equ	018	;pdef string		[number] follows
dmpstl	equ	019	;map string		[number] follows
dpdfnl	equ	020	;pdef function		[number] follows
dmpfnl	equ	021	;map function		[number] follows

;Note:  ptr convert assumes long pdef & map vars are 6 byte greater than short.

;GAP!!!!!!!!!!

dgvin	equ	158	;global integer		{number} follows
dgvst	equ	159	;global string		{number} follows
dgvfn	equ	160	;global function	{number} follows
dgvinl	equ	161	;global integer		[number] follows
dgvstl	equ	162	;global string		[number] follows
dgvfnl	equ	163	;global function	[number] follows

;Note:  ptr convert assumes long glob vars are 3 byte greater than short.

;GAP!!!!!!!!!!

;------	built-in variables

dbuiltv	equ	022	;1st built-in variable

dhunits	equ	022	;units of horiz motion
dvunits	equ	023	;units of vert motion
dypos	equ	024	;current y pos (low byte)  (vunits)
dxpos	equ	025	;current x pos (low byte)  (hunits)
dpitch	equ	026	;current pitch (hunits)
dptsize	equ	027	;point-size (3600ths) of current font
dhs	equ	028	;current horz spacing (hunits)
dvs	equ	029	;current vert spacing (vunits)
dwght50	equ	030	;weight of current font (5.0)
dslant	equ	031	;slant of current font
dqual	equ	032	;quality of current font
dnomwid	equ	033	;nominal char width of current font (psu)
dcurwid	equ	034	;width of current character (hunits)
dcap	equ	035	;caps height of current font (psu)
dxhght	equ	036	;x height of current font (psu)
drem	equ	037	;remainder from last divide (psu)
dyes	equ	038	;constant = 1
dno	equ	039	;constant = 0
dbin	equ	040	;sheet feeder bin #
dorient	equ	041	;orientation
dchrnum	equ	042	;current char num (low byte char#, high byte char set#)
dres	equ	043	;resource id used by current font/group
dwunits	equ	044	;units of char widths
ddhght	equ	045	;descender height of current font (psu)
dpage	equ	046	;physical page # of current page
dcopies	equ	047	;# of copies to be printed
dpsize	equ	048	;paper size (type #)
dpwid	equ	049	;paper width (wpu)
dplen	equ	050	;paper length (wpu)
dgphwid	equ	051	;graph width
dgdens	equ	052	;graph density
dgrph	equ	053	;graphics?
dusrd	equ	054	;userdefined
dattr	equ	055	;attributes (being done by driver)
			;0001h extra large (chapter heading)
			;0002h very large (heading)
			;0004h large (sub-heading)
			;0008h small print
			;0010h fine print
			;0020h superscript
			;0040h subscript
			;0080h outline
			;0100h italics
			;0200h shadow
			;0400h redline
			;0800h double underline
			;1000h bold
			;2000h strike-out
			;4000h underline
			;8000h small caps
dred	equ	056	;red value of rgb
dgreen	equ	057	;green value of rgb
dblue	equ	058	;blue value of rgb
dgexc	equ	059	;graphic exception byte
dduplx	equ	060	;duplex 0 - none
			;	1 - long edge
			;	2 - short edge
dwght	equ	061	;weight (5.1 - inserted demi-bold...)

dbuilt1	equ	061	;end of 1st gap of built-in vars

;GAP!!!!!!!!!!

dhun	equ	140	;hunits numerator
dvun	equ	141	;vunits numerator
dfntnum	equ	142	;unique font # for each font, 0-1500
dgrpnum	equ	143	;unique group # for each group, 0-1500
dcolor	equ	144	;color
dgdepth	equ	145	;graph depth
dgcnt	equ	146	;graph count
dgphgt	equ	147	;graph height
dgray	equ	148	;gray scale
dgphx	equ	149	;x resolution
dgphy	equ	150	;y resolution

;------	numeric functions

drdfil	equ	062	;readfile("filename",filepos[,cnt])
			;	(cnt > 5)
dfilsz	equ	063	;filesize("filename")

;------	strings/character codes
;
;	# of values after code		format of values
;	----------------------		----------------
;		1			{value}
;		2			{value}{value}
;		n			{count}{value} . . . {value}
;		nn			[count]{value} . . . {value}
;

dbin1	equ	064	;single binary value	:01100001:
doct1	equ	065	;single octal value	{123}
ddec1	equ	066	;single decimal value	[065]
dhex1	equ	067	;single hex value	<3A>
dasc1	equ	068	;single ascii value	"Z"
dbin2	equ	069	;two binary values	:11000101,11110000:
doct2	equ	070	;two octal values	{277,076}
ddec2	equ	071	;two decimal values	[065,110]
dhex2	equ	072	;two hex values		<3A,FF>
dasc2	equ	073	;two ascii values	"ZX"
dbinn	equ	074	;0-255 binary values	:00000110,00011101:
doctn	equ	075	;0-255 octal values	{377,056,177,034,000}
ddecn	equ	076	;0-255 decimal values	[013,010,027,125,034]
dhexn	equ	077	;0-255 hex values	<3A,FF,45,00,0C>
dascn	equ	078	;0-255 ascii values	"ABCde"
dbinnn	equ	079	;256+ binary values	:00011101,...:
doctnn	equ	080	;256+ octal values	{377,...}
ddecnn	equ	081	;256+ decimal values	[013,...]
dhexnn	equ	082	;256+ hex values	<3A,...>
dascnn	equ	083	;256+ ascii values	"ABCde"

;------	flow control (all locations are relative to the start of the string)
;
;	code		is followed by
;	----		--------------
;	dif		[location of delseif, delse, or dendif]
;	delse		[location of dendif]
;	delseif		[location of delseif, delse, or dendif]
;	dendif		---
;	dwhile		[location of dewhile + 3]
;	dewhile		[location of [location] past dwhile]
;

dif	equ	084	;if
delse	equ	085	;else
delseif	equ	086	;elseif
dendif	equ	087	;endif
dwhile	equ	088	;while
dewhile	equ	089	;endwhile

;------	string output functions

dhi	equ	090	;hi(word)
dlo	equ	091	;lo(word)
dhilo	equ	092	;hilo(word)
dlohi	equ	093	;lohi(word)
ddown	equ	094	;download("filename.ext")
dascii	equ	095	;ascii(value,digits)
dsetmth	equ	096	;setmethod(driver#,method#)  {dsetmth}{drv#}{method#}

;GAP!!!!!!!!!!

dfntsel	equ	164	;send select font string
dfndsel	equ	165	;send deselect font string

;------	operators

dlpar	equ	098	;left paren
drpar	equ	099	;right paren
d2com	equ	100	;2's complement
dnot	equ	101	;bitwise not
dlnot	equ	102	;logical not
dmul	equ	103	;multiply
ddiv	equ	104	;divide
dmod	equ	105	;modulo
dadd	equ	106	;add
dsub	equ	107	;subtract
dshl	equ	108	;shift left
dshr	equ	109	;shift right
dless	equ	110	;less than
dlesse	equ	111	;less than or equal
dgreat	equ	112	;greater than
dgreate	equ	113	;greater than or equal
dequ	equ	114	;equal
dnequ	equ	115	;not equal
dand	equ	116	;bitwise and
dxor	equ	117	;bitwise xor
dor	equ	118	;bitwise or
dland	equ	119	;logical and
dlor	equ	120	;logical or
dassign	equ	121	;assignment
dpequ	equ	122	;plus equal
dmequ	equ	123	;minus equal

;!!!!!!	GAP
ddivr	equ	151	;rounded divide
;!!!!!!	GAP

;------	other

dnop	equ	124	;no-op
drep	equ	125	;reposition (same as old <D>)
dcmnt	equ	126	;comment (semicolon+text+null)
dnl	equ	127	;newline (for appearance)
dspc1	equ	128	;1 space
dspc2	equ	129	;2 spaces
dspcn	equ	130	;<n> spaces		{n} follows
dtab1	equ	131	;1 tab
dtab2	equ	132	;2 tabs
dtabn	equ	133	;<n> tabs		{n} follows
dsep	equ	134	;parameter seperator (comma)
dendp	equ	135	;end of parameter list
dprompt	equ	136	;prompt("message","message", ...)
dbeep	equ	137	;beep
dendx	equ	138	;return value from numeric expression
dinvc	equ	139	;invalid code

;!!!!!!	GAP
dwait	equ	152	;wait
dclrpmt	equ	153	;clear prompt

;!!!!!!	GAP
dtext	equ	157	;begintext ... endtext	[# text bytes] follows
;note:	BEGINTEXT and ENDTEXT must be the only commands on the line
;	or they will be treated as part of the ascii text region:
;		BEGINTEXT
;		text text text text begintext
;		text text (i.e., postscript commands) endtext
;		ENDTEXT

;		097	;not used

wpdl_size	equ	165	;HIGHEST TOKEN NUMBER IN LIST
;Types of drivers for setmethod - see ppsdrv.inc
; & driver methods.
;method type 0 = not supported
;Horz	equ	0			;0
     ;HMI
     ;MSHMI
     ;Relative HS
     ;Absolute HS
;Vert	equ	Horz+1			;1
     ;VMI
     ;Relative VS
     ;Absolute VS
;Bold	equ	Vert+1			;2
     ;Auto on same pass
     ;Multiple passes
     ;Triple Overstrike on same pass (true HMI only)
     ;Double overstrike on same pass (true HMI only)
     ;Backspace bolding
;Und	equ	Bold+1			;3
     ;Auto on same pass
     ;Auto on separate pass
     ;WP's own on second pass
     ;Backspace underlining
;DblUnd	equ	Und+1			;4
     ;Same as single underline (driver #1)
     ;Auto on same pass
     ;Twin pass - auto single underline on separate passes
     ;Twin pass - WP's own on second pass
     ;Single pass - WP's own on second pass
     ;Auto on separate pass
;Redlin	equ	DblUnd+1		;5
     ;Auto on same pass
     ;WP's own on second pass
     ;Backspace redlining
;Stkout	equ	Redlin+1		;6
     ;Auto on same pass
     ;WP's own on second pass
     ;Backspace strikeout
;Italic	equ	Stkout+1		;7
     ;Same as single underline
     ;Auto on same pass
;Shadow	equ	Italic+1		;8
     ;Auto shadowing
     ;shadow on second pass
;outline				;12
     ;Auto outline
;super					;13
     ;Auto
;subscript				;14
     ;Auto

;------	structures

tacvlen	equ	12			;max size of text characters
taccode	equ	0			;(byte)  code to translate
tacval	equ	taccode+1		;(str)   text characters
taccnt	equ	tacval+tacvlen		;(byte)  # of trailing bytes to skip
tacproc	equ	taccnt+1		;(word)  routine to interpret code
tacend	equ	tacproc+2		;(byte)  ending character
taclen	equ	tacend+1		;length of tac structure

tac	macro	code,str,cnt,routine,last
	local	string
	db	code
ifnb	<str>
string:	db	str
	fill = tacvlen+(offset string)-$
	if	fill
	db	fill dup(0)		;pad with nulls if necessary
	endif
else
	db	tacvlen dup(0)
endif
ifnb	<cnt>
	db	cnt
else
	db	0
endif
ifnb	<routine>
	dw	offset routine
else
	dw	0
endif
ifnb	<last>
	db	last
else
	db	0
endif
	endm

;------	error codes returned from tocomp (parser)

d_cmd	equ	0			;invalid command
d_spc	equ	1			;too many spaces (internal error)
d_tab	equ	2			;too many tabs (internal error)
d_full	equ	3			;buffer is full
d_rpar	equ	4			;missing right parenthesis
d_numa	equ	5			;missing or invalid numeric argument
d_lpar	equ	6			;missing left parenthesis
d_comma	equ	7			;missing comma (argument separator)
d_stra	equ	8			;missing or invalid string argument
d_eif	equ	9			;missing endif
d_ewhl	equ	10			;missing endwhile
d_num	equ	11			;invalid numeric expression
d_many	equ	12			;too many arguments
d_big	equ	13			;number is too big
d_quote	equ	14			;missing closing quotation mark
d_null	equ	15			;zero length (null) string
d_brace	equ	16			;missing closing brace
d_ilist	equ	17			;invalid char in byte list
d_nmstr	equ	18			;numeric string limited to 2 chars
d_lval	equ	19			;invalid lvalue in assignment
d_numd	equ	20			;invalid digit(s) in number
d_beg	equ	21			;begintext not alone on line
d_end	equ	22			;missing endtext
