; emm240 - EMS driver for HP100LX/200LX
; modifications davidb 1999
; Emm200 version 2.00
; Copyright (C) 1994 Hiroyuki Sekiya


		IDEAL
		INCLUDE "emm200.inc"
		INCLUDE "dev.inc"
		INCLUDE "emm67h.h"
		INCLUDE "emmtask.h"
		INCLUDE "emmmem.h"
		INCLUDE "emmheap.h"
		INCLUDE "emmmisc.h"

;
;	foCXhCo{
;
SEGMENT		_DEV

header		_dh	<-1, 0C000h, strategy, dev_init, "EMMXXXX0">
					; device header
packet		_fp	?		; command packet address

; strategy entry
PROC		strategy	FAR
		mov	[cs:packet.ofs], bx
		mov	[cs:packet.seg], es
		ret
ENDP

; IO request entry
PROC		iorequest	FAR
		pushf
		pushm	bx, ds
		lds	bx, [cs:packet.fp]
		mov	[(_cp bx).status], stOK
		cmp	[(_cp bx).command], 0Ch
		jbe	@@exit
		mov	[(_cp bx).status], stUNKNOWNCMD
	@@exit:
		popm	ds, bx
		popf
		ret
ENDP

ENDS		_DEV

;
;	f[^
;
SEGMENT		_DATA

patch_char	DB	0		; EMS̃foCX镶
quietly		DB	0		; flag whether to display messages

copyright	DB	NWL, "EMM240.EXE ver.2.00 Copyright (C) 1994 Hiroyuki Sekiya", NWL, EOS
usage		DB	NWL
		DB	"[device mode]", NWL
		DB	"device=emm240.exe <file> [-Fn] [-Hn] [-Q]", NWL
		DB	"	file	EMS-file name", NWL
		DB	"	-Fn	Number of page frame (1~8; default is 4)", NWL
		DB	"	-Hn	Number of handle (2~255; default is 16)", NWL
		DB	"	-Q	Quietly", NWL, NWL
		DB	"[command mode]", NWL
		DB	"prompt>emm240 [-E|-D]", NWL
		DB	"	-E	Enable EMS device", NWL
		DB	"	-D	Disable EMS device", NWL, EOS
msg_ver_err	DB	"Too old DOS version", NWL, EOS
msg_no_file	DB	"EMS-file not found", NWL, EOS
msg_bad_drive	DB	"EMS-file must be on C:", NWL, EOS
msg_not_ready	DB	"C drive not ready", NWL, EOS
msg_bad_size	DB	"Illegal file size", NWL, EOS
msg_not_16k	DB	"EMS-file must start from 16KBytes boundary", NWL, EOS
msg_non_cont	DB	"EMS-file contains non-contiguous blocks", NWL, EOS
msg_exists	DB	"EMM already exists", NWL, EOS
msg_no_ems	DB	"EMM not exists", NWL, EOS
msg_enabled	DB	"EMS device is enabled", NWL, EOS
msg_disabled	DB	"EMS device is disabled"
crlf		DB	NWL, EOS
msg_stat1	DB	"Page frame	: ", EOS
msg_stat2	DB	NWL, "Physical pages	: ", EOS
msg_stat3	DB	NWL, "Logical pages	: ", EOS
msg_stat4	DB	NWL, "EMM Handles	: ", EOS

ENDS		_DATA

SEGMENT		_BSS

file_name	DB	0, 127 DUP (?)
page_buf	DB	PAGE_SIZE DUP (?)
map_temp	DW	8 DUP (?)

ENDS		_BSS



;
;	R[h
;
SEGMENT		_TEXT

; parse command line parameters
; IN:	es	program segment prefix
;   	nc	I
; OUT:	cy	sȃIvV
; MODIFIED:	ax, si

PROC		parse_cmd_opt
		mov	si, 81h
	@@loop:
		seges
		lodsb
		cmp	al, CR
	;;	clc
		je	@@done
		cmp	al, ' '
		jbe	@@loop
		cmp	al, '-'
		je	@@opt
		cmp	al, '/'
		jne	@@error
	@@opt:
		seges
		lodsb
		_toupper al
		cmp	al, 'E'
		je	@@enable
		cmp	al, 'D'
		je	@@disable
		jmp	@@error
	@@enable:
		mov	[patch_char], 'E'
		jmp	@@loop
	@@disable:
		mov	[patch_char], '$'
		jmp	@@loop
	@@error:
		stc
	@@done:
		ret
ENDP

; main procedure - start point in command mode
PROC	main
		cld
		movseg	ds, cs

	; show copyright message
		mov	dx, OFFSET copyright
		mov	ah, 09h
		int	21h		; puts

	; parse command line
    	call	parse_cmd_opt
		cmp	[patch_char], 0
		mov	dx, OFFSET usage
		je	@@err

	; enable/disable EMS Interrupt
		mov	ax, 3567h
		int	21h		; get vector
		mov	si, OFFSET header.devname + 1
		mov	di, si
		mov	cx, 7
		rep cmpsb
		mov	dx, OFFSET msg_no_ems
		jne	@@err
		mov	al, [patch_char]
		mov	[es:header.devname], al
		mov	dx, OFFSET msg_enabled
		cmp	al, 'E'
		je	@@exit
		mov	dx, OFFSET msg_disabled
	@@exit:
		mov	ah, 09h
		int	21h		; puts
		mov	ax, 4C00h
		int	21h		; terminate
	@@err:
		mov	ah, 09h
		int	21h		; puts
		mov	ax, 4C01h
		int	21h		; terminate
ENDP


; In device mode: parse command line options
; ->	--
; <-	[file_name]
;   	[max_frame]
;	    [max_handle]
;       [quietly]
; ><	ax, si, di
PROC		parse_dev_opt
		pushm	ds, es
		lds	si, [packet.fp]
		lds	si, [(_cp ds:si).bpbptr.fp]
		movseg	es, cs
	@@loop1:
		lodsb
		cmp	al, CR
		je	@@optend
		cmp	al, LF
		je	@@optend
		cmp	al, ' '
		ja	@@loop1
	@@loop2:
		lodsb
		cmp	al, CR
		je	@@optend
		cmp	al, LF
		je	@@optend
		cmp	al, ' '
		jbe	@@loop2
		cmp	al, '/'
		je	@@opt
		cmp	al, '-'
		je	@@opt

	@@filename:
		mov	di, OFFSET file_name
	@@name_loop:
		stosb
		lodsb
		cmp	al, ' '
		ja	@@name_loop
		clr	al
		stosb
		dec	si
		jmp	@@loop2

	@@opt:
		lodsb
		_toupper al
		cmp	al, 'H'
		je	@@H
		cmp	al, 'F'
		je	@@F
		cmp	al, 'Q'
		je	@@Q
		jmp	@@optend
	@@H:
		call	atoi
		jc	@@loop1
		cmp	ax, 2
		jb	@@loop2
		cmp	ax, 255
		ja	@@loop2
		mov	[es:max_handle], ax
		jmp	@@loop2
	@@F:
		call	atoi
		jc	@@loop1
		tst	ax
		jz	@@loop2
		cmp	ax, 8
		ja	@@loop2
		mov	[es:max_frame], ax
		jmp	@@loop2
	@@Q:
		mov	[es:quietly], 1
		jmp	@@loop2

	@@optend:
		popm	es, ds
		ret
ENDP

; check whether an EMM handler already exists
; ->	--
; <-	zr	gݍ܂Ă
;   	nz	gݍ܂ĂȂ
; ><	--
PROC		emm_exists
		pushall	es
		mov	ax, 3567h
		int	21h		; get vector
		mov	si, OFFSET header.devname
		mov	di, si
		mov	cx, 8 / 2
		rep cmpsw
		popall	es
		ret
ENDP

; get cluster address of EMS file
; ->	bx	File Handle (of EMM240.DAT) 
; <-	ax	Starting Cluster of required file
; ><	ax
PROC		get_top_cluster
		pushm	bx, cx, di, es
		mov	di, bx		; = handle
		mov	ah, 51h
		int	21h		; get PSP into bx
		mov	es, bx
		les	bx, [es:34h]	; es:bx = Job File Table from PSP
		mov	cl, [es:bx+di]	; cl = system file table entry
		clr	ch

		mov	ah, 52h
		int	21h		; get list of lists
		les	bx, [es:bx+4] ; es:bx = First System File Table
	@@loop:
		cmp	cx, [es:bx+4]
		jb	@@found      ; the file is in this table
		sub	cx, [es:bx+4]
		les	bx, [es:bx]	; next file table
		jmp	@@loop
	@@found:
		mov	al, 3Bh		; 3Bh = sizeof System file table entry
		mul	cl
		mov	di, ax		; di = offset of our file
		mov	ax, [es:bx+6+di+0Bh] ; ax = starting cluster of file
		popm	es, di, cx, bx
		ret
ENDP

; converts cluster entry to sector number
; ->	es:di	DPB
;	ax	cluster number
; <-	ax  sector number
; ><	ax
PROC		clst_to_sect
		push	cx
		sub	ax, 2
		mov	cl, [(_dpb es:di).clst_shift]
		shl	ax, cl
		add	ax, [(_dpb es:di).top_data_sect]
		pop	cx
		ret
ENDP

; converts a sector number to a page number
; ->	es:di	DPB
;	ax	sector number
; <-	cy	if set -> not on 16K boundary
;	nc	ax	16K page no.
; ><	ax
PROC	sect_to_page
		pushm	bx, dx
		mul	[(_dpb es:di).bytes_per_sec] ;dx:ax = bytes to sector
		mov	bx, PAGE_SIZE
		div	bx
		tst	dx
		stc
		jnz	@@exit
		add	ax, 42 ; ax = 16K page number (42 * 16K = 672K = start of disk?)
		clc
	@@exit:
		popm	dx, bx
		ret
ENDP

; Compares the EMS file with the memory ram page
; ->	bx	EMS file handle
;	[max_page]
;	[ram_page]
; <-	cy	page status
;	nc	nz	v
;		zr	v
; ><	--
PROC		comp_file_and_page
		pushm	ax, cx, dx, si, di, es

		; save the current mappings
		movseg	es, cs
		mov	di, OFFSET map_temp
		call	save_map_reg

		clr	cx
		mov	dx, cx		; cx:dx = 0 offset
		mov	ax, 4200h	; from start of file
		int	21h			; dx:ax = file pointer (at start of file)
		mov	cx, [max_page]
		mov	dx, [ram_page]
		dec	dx
		mov	ax, FRAME_SEG
		mov	es, ax

	@@loop:
		inc	dx

		pushm	cx, dx
		mov	dx, OFFSET page_buf
		mov	cx, PAGE_SIZE
		mov	ah, 3Fh
		int	21h		; read file handle into ds:[page_buf]
		popm	dx, cx
		jc	@@exit

		pushm	bx, cx
		clr	bx		; physical page no = 0, dx = [ram page]
		call	map_ram_page
		clr	di
		mov	si, OFFSET page_buf
		mov	cx, PAGE_SIZE / 2
		rep cmpsw
		popm	cx, bx

		loopz	@@loop
		clc
	@@exit:
		pushf
		mov	si, OFFSET map_temp
		call	restore_map_reg
		popf

		popm	es, di, si, dx, cx, ax
		ret
ENDP

; cheks whether the EMS file is legal
; ->	[file_name]
; <-	[ram_page]
;       [max_page]
;	    [free_page]
; ><	ax, bx, cx, dx, di
PROC		check_ems_file
		push	es

	; check the name & location of the file
		mov	ax, [WORD file_name]
		cmp	al, 0
		je	@@no_file
		cmp	ah, ':'
		jne	@@no_drive
		_toupper al
		sub	al, 'A'
		jmp	@@chk_drive
	@@no_drive:
		mov	ah, 19h
		int	21h		; get disk
	@@chk_drive:
		cmp	al, 2		; C:
		jne	@@bad_drive

	; now get theDPB for this file
		push	ds
		mov	dl, al
		inc	dl
		mov	ah, 32h
		int	21h		; get DPB
		movseg	es, ds
		mov	di, bx		; es:di = DPB
		pop	ds
		cmp	al, -1
		je	@@not_ready

	; EMSt@CI[v
		mov	dx, OFFSET file_name
		mov	ax, 3D00h
		int	21h		; open handle
		jc	@@no_file
		mov	bx, ax		; bx = file handle

	; EMSt@C̃TCYy[W߂
		clr	cx
		mov	dx, cx		; cx:dx = offset 0
		mov	ax, 4202h	; code 02 = from end of file
		int	21h		; dx:ax = file length
		jc	@@bad_size  ; error getting file size
		mov	cx, PAGE_SIZE
		div	cx
		tst	dx			; dx is remainder
		jnz	@@bad_size	; file size must divisible by 16K
		tst	ax
		jz	@@bad_size	; must be > 0 Pages
		cmp	ax, 2048
		ja	@@bad_size	; must be < 2048 Pages
		mov	[max_page], ax
		mov	[free_page], ax

	; 擪y[Wԍ߂
		call	get_top_cluster ; ax = top cluster
		call	clst_to_sect    ; ax = first sector
		call	sect_to_page	; ax = first 16K page no
		jc	@@not_just_16k
		mov	[ram_page], ax  ; [ram_page] = 16k logical page no of start addr

	; t@C[hƃy[W[ḧv
		call	comp_file_and_page
		jc	@@non_contiguous
		jne	@@non_contiguous
		mov	ah, 3Eh
		int	21h		; close handle
		clc
		jmp	@@exit

	@@no_file:
		mov	dx, OFFSET msg_no_file
		jmp	@@err_exit
	@@bad_drive:
		mov	dx, OFFSET msg_bad_drive
		jmp	@@err_exit
	@@not_ready:
		mov	dx, OFFSET msg_not_ready
		jmp	@@err_exit
	@@bad_size:
		mov	dx, OFFSET msg_bad_size
		jmp	@@err_exit
	@@not_just_16k:
		mov	dx, OFFSET msg_not_16k
		jmp	@@err_exit
	@@non_contiguous:
		mov	dx, OFFSET msg_non_cont
	@@err_exit:
		mov	ah, 09h
		int	21h		; puts
		stc
	@@exit:
		pop	es
		ret
ENDP

; EMS̊eXe[^X\
; ><	ax, dx
PROC		put_status
		cmp	[quietly], 0
		jne	@@exit

		mov	dx, OFFSET msg_stat1
		mov	ah, 09h
		int	21h
		mov	ax, FRAME_SEG
		call	put_hexw

		mov	dx, OFFSET msg_stat2
		mov	ah, 09h
		int	21h
		mov	ax, [max_frame]
		call	put_int

		mov	dx, OFFSET msg_stat3
		mov	ah, 09h
		int	21h
		mov	ax, [max_page]
		call	put_int

		mov	dx, OFFSET msg_stat4
		mov	ah, 09h
		int	21h
		mov	ax, [max_handle]
		call	put_int

		mov	dx, OFFSET crlf
		mov	ah, 09h
		int	21h
	@@exit:
		ret
ENDP

; main function in device mode
PROC		dev_init	FAR
		pushall	ds, es
		movseg	ds, cs
		cld

	; display copyright message
		mov	dx, OFFSET copyright
		mov	ah, 09h
		int	21h		; puts

	; check DOS version
		call	get_dos_version
		cmphl	ax, 5, 0	; 5.0ȍ~H
		jb	@@err_dos_ver

	; check if already loaded
		call	emm_exists
		jz	@@already_exists

	; parse command line
		call	parse_dev_opt

	; check whether EMS file is OK
		call	check_ems_file
		jc	@@error

	; EMMƃ^XNj^̏
		call	init_emm
		call	init_task_mon

	; Xe[^X\
		call	put_status

	; 풓
		mov	[header.ioreq], OFFSET iorequest
		les	bx, [packet.fp]
		call	get_dev_size
		mov	[(_cp es:bx).addr.ofs], ax
		mov	[(_cp es:bx).addr.seg], cs
		mov	[(_cp es:bx).status], stOK
		jmp	@@exit

	@@err_dos_ver:
		mov	dx, OFFSET msg_ver_err
		jmp	@@puts
	@@already_exists:
		mov	dx, OFFSET msg_exists
	@@puts:
		mov	ah, 09h
		int	21h		; puts

	; 풓
	@@error:
		les	bx, [packet.fp]
		mov	[header.attr], 0	; block device
		mov	[(_cp es:bx).media], 0
		mov	[(_cp es:bx).addr.ofs], 0
		mov	[(_cp es:bx).addr.seg], cs
		mov	[(_cp es:bx).status], stGENERALERR
	@@exit:
		popall	es, ds
		ret
ENDP

ENDS		_TEXT

		END	main
