; emm67h.asm - int 67h service routines
; Copyright(C) 1994 Hiroyuki Sekiya


		IDEAL
		INCLUDE "emm200.inc"
		INCLUDE "emm67h.h"
		INCLUDE "emmmem.h"
		INCLUDE "emmheap.h"
		INCLUDE "emmtask.h"

;
;	\
;

; map_and_call\
STRUC _call
  addr		_fp	?
  len		DB	?
  map		_fp	?
ENDS

; move_source_dest\(fucn57)
STRUC _movinf
  type		DB	?
  handle	DW	?
  addr		_fp	?
ENDS
STRUC _move
  len		_long	?
  src		_movinf	?
  dst		_movinf	?
ENDS


;
;	foCXf[^̈
;
SEGMENT		_DEVDAT

; EMMt@NṼe[u
		EVENDATA
emm_func_tbl	DW	func40, func41, func42, func43, func44, func45
		DW	func46, func47, func48, func49, func4A, func4B
		DW	func4C, func4D, func4E, func4F, func50, func51
		DW	func52, func53, func54, func55, func56, func57
		DW	func58
MAX_EMM_FUNC	= ($ - emm_func_tbl) / 2

max_frame	DW	4	; y[W
max_handle	DW	16	; nh

ENDS		_DEVDAT


SEGMENT		_DEVBSS

; _y[W֘A
ram_page	DW	?	; EMSt@C̐擪y[Wԍ
max_page	DW	?	; _y[W
free_page	DW	?	; AP[gy[W
page_table	DW	?	; y[Wgp󋵃e[ũAhX

; y[W}bv֘A
map_table	DW	?	; t[󋵃e[ũAhX
save_map	DW	?	; y[W}bvZ[ü̃AhX
save_map_idx	DW	?	; y[W}bvZ[ü̃CfbNX

; EMMnh֘A
handle_table	DW	?	; nhe[ũAhX
handle_names	DW	?	; nhe[ũAhX

ENDS		_DEVBSS


;
;	foCXR[ḧ
;
SEGMENT		_DEV

; EMM荞݃T[rX[`
		EVEN
PROC		int67h	FAR
_CS		EQU	<WORD bp+4>
_IP		EQU	<WORD bp+2>
_BP		EQU	<WORD bp>
_AX		EQU	<WORD bp-2>
_AL		EQU	<BYTE bp-2>
_AH		EQU	<BYTE bp-1>
_DS		EQU	<WORD bp-4>
; X^bNɃvbVꂽWX^
		cld
		push	bp
		mov	bp, sp
		pushm	ax, ds
		sub	ah, 40h
		cmp	ah, MAX_EMM_FUNC
		jnb	@@invalid
		movseg	ds, cs
		xchg	ax, bx
		mov	bl, bh
		clr	bh
		add	bx, bx
		mov	bx, [emm_func_tbl+bx]
		push	OFFSET @@exit	; ^[AhX
		push	bx		; R[AhX
		mov	bx, ax
		mov	ax, [_AX]
		retn			; near call̓
	@@invalid:
		mov	ah, 84h		; t@NV`
	@@exit:
		mov	[_AH], ah
		popm	ds, ax
		pop	bp
		iret
ENDP

; nh
; ->	dx	EMMnh
; <-	--
; ><	--
		EVEN
PROC		set_null_name
		pushm	ax, cx, di, es
		movseg	es, cs
		mov	di, dx
		shlm	di, 3		; *= 8
		add	di, [handle_names]
		mov	cx, 8 / 2
		clr	ax
		rep stosw
		popm	es, di, cx, ax
		ret
ENDP

; nhI[vĂ邩H
; ->	dx	EMMnh
; <-	cy	nhzĂ
;	nc	nz	I[vĂ
;		zr	I[vĂȂ
; ><	--
		EVEN
PROC		check_handle
		cmp	dx, [max_handle]
		cmc
		jc	@@exit
		push	bx
		mov	bx, dx
		add	bx, bx
		add	bx, [handle_table]
		cmp	[WORD bx], 0
		pop	bx
		clc
	@@exit:
		ret
ENDP

;---------------------------------------
; `EMMt@NV
;---------------------------------------
		EVEN
PROC		undefined_func
LABEL		func49		PROC
LABEL		func4A		PROC
		mov	ah, 84h		; t@NV`
		ret
ENDP

;---------------------------------------
; Xe[^X̎擾
; ->	--
; <-	ah	UgR[h
;---------------------------------------
		EVEN
PROC		func40
		call	is_in_sysmgr
		jz	@@in_sysmgr
		clr	ah		; ُȂ
	@@exit:
		ret

	@@in_sysmgr:
		mov	ah, 80h		; }l[W삵Ȃ
		jmp	@@exit
ENDP

;---------------------------------------
; y[Wt[AhX̎擾
; ->	--
; <-	ah	UgR[h
;	bx	y[Wt[AhX
;---------------------------------------
		EVEN
PROC		func41
		mov	bx, FRAME_SEG
		clr	ah
		ret
ENDP

;---------------------------------------
; AP[gy[W̎擾
; ->	--
; <-	ah	UgR[h
;	bx	AP[gy[W
;	dx	y[W
;---------------------------------------
		EVEN
PROC		func42
		mov	bx, [free_page]
		mov	dx, [max_page]
		clr	ah
		ret
ENDP

;---------------------------------------
; y[W̃AP[g
; ->	bx	AP[gy[W
; <-	ah	UgR[h
;	dx	EMMnh
;---------------------------------------
		EVEN
PROC		func43
		pushm	cx, si, di, es

		tst	bx
		jz	@@zero_page

		cmp	bx, [free_page]
		ja	@@no_page

	; 󂫃nh
		movseg	es, ds
		mov	di, [handle_table]
		mov	cx, [max_handle]
		clr	ax
		repne scasw
		jne	@@no_handle
		lea	si, [di-2]	; 󂫃nḧʒu
		mov	dx, si
		sub	dx, [handle_table]
		shr	dx, 1		; nh
		call	set_null_name

	; y[Wm
		mov	di, [page_table]
		sub	[free_page], bx
		mov	cx, bx
	@@loop:
		push	cx
		mov	cx, [max_page]
		clr	ax
		repne scasw
		pop	cx
		lea	ax, [di-2]
		mov	[si], ax
		mov	si, ax
		loop	@@loop
		mov	[WORD si], -1	; end of handle page
		clr	ah
	@@exit:
		popm	es, di, si, cx
		ret

	@@no_handle:
		mov	ah, 85h		; nhȂ
		jmp	@@exit
	@@no_page:
		mov	ah, 88h		; 󂫃y[WȂ
		jmp	@@exit
	@@zero_page:
		mov	ah, 89h		; 0y[Wmۂ悤Ƃ
		jmp	@@exit
ENDP

;---------------------------------------
; nhy[W̃}bv/A}bv
; ->	al	y[Wԍ
;	bx	_y[Wԍ
;	dx	EMMnh
; <-	ah	UgR[h
;---------------------------------------
		EVEN
PROC		func44
		pushm	bx, cx, dx, si

	; nȟ
		cmp	dx, [max_handle]
		jnb	@@no_handle
		mov	si, dx
		add	si, si
		add	si, [handle_table]
		cmp	[WORD si], 0
		je	@@no_handle

	; y[W̌
		mov	al, [_AL]
		clr	ah
		cmp	ax, [max_frame]
		jnb	@@no_frame

		cmp	bx, -1
		jne	@@map

	; A}bv
	@@unmap:
		mov	bx, ax
		mov	si, ax
		add	si, si
		add	si, [map_table]
		mov	dx, [si]
		cmp	dx, [max_page]
		jnb	@@no_page
		mov	[WORD si], -1
		call	unmap_ram_page
		jmp	@@done

	; }bv
	@@map:
		mov	cx, bx		; _y[Wԍ
		mov	bx, ax		; y[Wԍ
		lodsw
		cmp	ax, -1
		je	@@no_page
		inc	cx
	@@loop:
		mov	si, ax
		lodsw
		cmp	ax, -1
		loopnz	@@loop
		tst	cx
		jnz	@@no_page
	@@found:
		lea	dx, [si-2]
		sub	dx, [page_table]
		shr	dx, 1		; _y[Wԍ
		mov	si, bx
		add	si, si
		add	si, [map_table]
		mov	[si], dx
		add	dx, [ram_page]
		call	map_ram_page

	@@done:
		clr	ah
	@@exit:
		popm	si, dx, cx, bx
		ret

	@@no_handle:
		mov	ah, 83h		; sȃnh
		jmp	@@exit
	@@no_page:
		mov	ah, 8Ah		; _y[Wԍ傫
		jmp	@@exit
	@@no_frame:
		mov	ah, 8Bh		; y[Wԍ傫
		jmp	@@exit
ENDP

;---------------------------------------
; y[W̉
; ->	dx	EMMnh
; <-	ah	UgR[h
;---------------------------------------
		EVEN
PROC		func45
		pushm	cx, si, di, es

	; nh
		cmp	dx, [max_handle]
		jnb	@@no_handle
		mov	si, dx
		add	si, si
		add	si, [handle_table]
		cmp	[WORD si], 0
		je	@@no_handle

	; y[W}bvZ[uꂽ܂܂ɂȂĂȂH
		mov	di, dx
		add	di, di
		add	di, [save_map_idx]
		cmp	[WORD di], -1
		jne	@@page_mapped	; gp

	; nh
		call	set_null_name

	; _y[W
		jmp	@@1
		EVEN
	@@loop:
		inc	[free_page]
	@@1:
		clr	ax
		xchg	[si], ax
		mov	si, ax
		cmp	ax, -1		; end of handle page
		jne	@@loop
		clr	ah
	@@exit:
		popm	es, di, si, cx
		ret

	@@no_handle:
		mov	ah, 83h		; sȃnh
		jmp	@@exit
	@@page_mapped:
		mov	ah, 86h		; y[W}bvZ[uꂽ܂
		jmp	@@exit
ENDP

;---------------------------------------
; EMMo[W̎擾
; ->	--
; <-	ah	UgR[h
;	al	o[Wԍ
;---------------------------------------
		EVEN
PROC		func46
		clr	ah
		mov	[_AL], 40h	; ver4.0
		ret
ENDP

;---------------------------------------
; y[W}bṽZ[u
; ->	dx	EMMnh
; <-	ah	UgR[h
;---------------------------------------
		EVEN
PROC		func47
		pushm	di, es
		call	check_handle
		jbe	@@no_handle	; sȃnh

	; nhZ[uł͂ȂH
		mov	di, dx
		add	di, di
		add	di, [save_map_idx]
		cmp	[WORD di], -1
		jne	@@used

	; y[W}bvZ[u
		mov	al, [BYTE max_frame]
		add	al, al
		mul	dl
		add	ax, [save_map]
		mov	[di], ax
		mov	di, ax
		movseg	es, ds
		call	save_map_reg
		clr	ah
	@@exit:
		popm	es, di
		ret

	@@no_handle:
		mov	ah, 83h		; sȃnh
		jmp	@@exit
	@@used:
		mov	ah, 8Dh		; nhZ[uĂ
		jmp	@@exit
ENDP

;---------------------------------------
; y[W}bṽXgA
; ->	dx	EMMnh
; <-	ah	UgR[h
;---------------------------------------
		EVEN
PROC		func48
		push	si
		call	check_handle
		jbe	@@no_handle

	; Z[uf[^
		mov	si, dx
		add	si, si
		add	si, [save_map_idx]
		mov	ax, -1
		xchg	[si], ax
		cmp	ax, -1
		je	@@no_data

	; y[W}bvXgA
		mov	si, ax
		call	restore_map_reg
		clr	ah
	@@exit:
		pop	si
		ret

	@@no_handle:
		mov	ah, 83h		; sȃnh
		jmp	@@exit
	@@no_data:
		mov	ah, 8Eh		; y[W}bvZ[uĂȂ
		jmp	@@exit
ENDP

;---------------------------------------
; nhJEg̎擾
; ->	--
; <-	ah	UgR[h
;	bx	I[vĂEMMnh̐
;---------------------------------------
		EVEN
PROC		func4B
		pushm	cx, si
		clr	bx
		mov	si, [handle_table]
		mov	cx, [max_handle]
	@@loop:
		lodsw
		cmp	ax, 1		; if (ax <> 0) then inc(bx)
		sbb	bx, -1
		loop	@@loop
		popm	si, cx
		clr	ah
		ret
ENDP

;---------------------------------------
; nhy[W̎擾
; ->	dx	EMMnh
; <-	ah	UgR[h
;	bx	EMMnhɃAP[gĂy[W
;---------------------------------------
		EVEN
PROC		func4C
		push	si
		cmp	dx, [max_handle]
		jnb	@@no_handle
		mov	si, dx
		add	si, si
		add	si, [handle_table]
		lodsw
		tst	ax
		jz	@@no_handle
		clr	bx
		jmp	@@1
		EVEN
	@@loop:
		inc	bx
		mov	si, ax
		lodsw
	@@1:
		cmp	ax, -1		; end of handle page
		jne	@@loop
		clr	ah
	@@exit:
		pop	si
		ret

	@@no_handle:
		mov	ah, 83h		; sȃnh
		jmp	@@exit
ENDP

;---------------------------------------
; Snhy[W̎擾
; ->	es:di	]AhX
; <-	ah	UgR[h
;	bx	I[vĂEMMnh̐
;---------------------------------------
		EVEN
PROC		func4D
		pushm	cx, dx, di
		clr	cx		; cx = I[vnh
		mov	dx, cx		; dx = nh
	@@loop:
		call	func4C		; nhy[W̎擾
		tst	ah
		jnz	@@next
		mov	ax, dx		; nh
		stosw
		mov	ax, bx		; y[W
		stosw
		inc	cx
	@@next:
		inc	dx
		cmp	dx, [max_handle]
		jb	@@loop
		mov	bx, cx		; I[vnh
		clr	ah
		popm	di, dx, cx
		ret
ENDP

;---------------------------------------
; y[W}bṽZ[u/XgA
; ->	al	Tut@NVԍ
;		00h	Z[u
;		01h	XgA
;		02h	Z[u&XgA
;		03h	Z[upzTCY擾
;	ds:si	͌(01h/02h)
;	es:di	o͐(00h/02h)
; <-	ah	UgR[h
;	al	z̃TCY(03h)
;---------------------------------------
		EVEN
PROC		func4E
		pushm	dx
		cmp	al, 03h
		ja	@@no_func
		jb	@@save

	@@func03:
		mov	al, [BYTE max_frame]
		add	al, al
		mov	[_AL], al
		jmp	@@done

	@@save:
		cmp	al, 01h
		je	@@restore
		call	save_map_reg

	@@restore:
		tst	al
		jz	@@done
		push	ds
		mov	ds, [_DS]
		call	restore_map_reg
		pop	ds

	@@done:
		clr	ah
	@@exit:
		popm	dx
		ret

	@@no_func:
		mov	ah, 8Fh		; Tut@NV
		jmp	@@exit
;;	@@bad_page:
;;		mov	ah, 0A3h	; z̓es
;;		jmp	@@exit
ENDP

;---------------------------------------
; y[W}bv̈ꕔZ[u/XgA
; 蔲Ȃ̂ŏɂׂẴy[WZ[u
; ->	al	Tut@NVԍ
;		00h	y[W}bv̈ꕔZ[u
;		01h	y[W}bv̈ꕔXgA
;		02h	Z[ü̃TCY擾
; <-	ah	UgR[h
;---------------------------------------
		EVEN
PROC		func4F
		cmp	al, 02h
		jb	func4E
		ja	@@no_func
		inc	al
		jmp	func4E
	@@no_func:
		mov	ah, 8Fh		; Tut@NV
		ret
ENDP

;---------------------------------------
; y[W̃}bv/A}bv
; ->	al	Tut@NVԍ
;		00h	y[W
;		01h	ZOg
;	dx	EMMnh
;	cx	zGg
;	ds:si	
; <-	ah	UgR[h
;---------------------------------------
		EVEN
PROC		func50
		pushm	bx, cx, si, es
		cmp	al, 01h
		ja	@@no_func
		mov	es, [_DS]
	@@loop:
		seges
		lodsw
		mov	bx, ax		; _y[Wԍ
		seges
		lodsw
		cmp	[_AL], 0	; y[WH
		je	@@call
	; ZOg𕨗y[Wԍɕϊ
		sub	ax, FRAME_SEG
		jc	@@bad_segment
		test	ax, 03FFh	; 0400h̔{H
		jnz	@@bad_segment
		xchg	al, ah
		shrm	ax, 2		; /= 4
	@@call:
		push	[_AX]
		mov	[_AL], al
		call	func44		; map handle page
		pop	[_AX]
		tst	ah
		loopz	@@loop
	@@exit:
		popm	es, si, cx, bx
		ret

	@@bad_segment:
		mov	ah, 8Bh		; ZOg
		jmp	@@exit
	@@no_func:
		mov	ah, 8Fh		; Tut@NV
		jmp	@@exit
ENDP

;---------------------------------------
; y[W̍ăAP[g
; ->	dx	EMMnh
;	bx	Vy[W
; <-	ah	UgR[h
;	bx	t@NVs̃y[W
;---------------------------------------
		EVEN
PROC		func51
		pushm	cx, si
		cmp	dx, [max_handle]
		jae	@@no_handle
		mov	si, dx
		add	si, si
		add	si, [handle_table]
		lodsw
		tst	ax
		jz	@@no_handle
		mov	cx, bx		; Vy[W
		jcxz	@@trunc

	; y[W𒲂ׂ
		inc	cx
		jmp	@@1
		EVEN
	@@loop1:
		mov	si, ax
		lodsw
	@@1:
		cmp	ax, -1		; end of handle page
		loopnz	@@loop1
		jne	@@trunc
		jcxz	@@done		; y[W̕ύXȂ

	; Vy[W̕傫ꍇ
	@@add:
		cmp	cx, [free_page]
		ja	@@no_page
		sub	[free_page], cx
		pushm	di, es
		movseg	es, ds
		mov	di, [page_table]
		sub	si, 2
	@@loop2:
		push	cx
		mov	cx, [max_page]
		clr	ax
		repne scasw
		pop	cx
		lea	ax, [di-2]
		mov	[si], ax
		mov	si, ax
		loop	@@loop2
		mov	[WORD si], -1	; end of handle page
		popm	es, di
		jmp	@@done

	; Vy[W̕ꍇ
	@@trunc:
		mov	[WORD si-2], -1	; end of handle page
	@@loop3:
		mov	si, ax
		lodsw
		mov	[WORD si-2], 0
		inc	[free_page]
		cmp	ax, -1		; end of handle page
		jne	@@loop3

	@@done:
		clr	ah
	@@exit:
		popm	si, cx
		ret

	@@no_handle:
		mov	ah, 83h		; sȃnh
		jmp	@@exit
	@@no_page:
		sub	bx, cx
		mov	ah, 88h		; 󂫃y[WȂ
		jmp	@@exit
ENDP

;---------------------------------------
; nh֘A
; ->	al	Tut@NVԍ
;---------------------------------------
		EVEN
PROC		func52
		cmp	al, 02h
		ja	@@no_func
		je	@@func02
		call	check_handle
		jbe	@@no_handle
		tst	al
		jnz	@@func01

	; al = 00h nh̎擾
	; ->	dx	EMMnh
	; <-	ah	UgR[h
	;	al	(0 = ; 1 = s)
	@@func00:
		mov	[_AL], 0	; 
		jmp	@@done

	; al = 01h nh̐ݒ
	; ->	dx	EMMnh
	;	bl	VAgr[g
	; <-	ah	UgR[h
	@@func01:
		tst	bl		; ?
		jnz	@@bad_attr
		jmp	@@done

	; al = 02h nh̗L̒
	; ->	--
	; <-	ah	UgR[h
	;	al	0 = ̂݃T|[g; 1 = sT|[g
	@@func02:
		mov	[_AL], 0	; ̂݃T|[g

	@@done:
		clr	ah
	@@exit:
		ret

	@@no_handle:
		mov	ah, 83h		; sȃnh
		jmp	@@exit
	@@no_func:
		mov	ah, 8Fh		; Tut@NV
		jmp	@@exit
	@@bad_attr:
		mov	ah, 91h		; T|[gĂȂ
		jmp	@@exit
ENDP

;---------------------------------------
; nh֘A(̂P)
; ->	al	Tut@NVԍ
;---------------------------------------
		EVEN
PROC		func53
		pushm	cx, si, di
		cmp	al, 01h
		ja	@@no_func
		call	check_handle
		jbe	@@no_handle
		tst	al
		jnz	@@func01

	; al = 00h nh̎擾
	; ->	dx	EMMnh
	;	es:di	o͐(8oCg̃obt@̃AhX)
	; <-	ah	UgR[h
	@@func00:
		mov	si, dx
		shlm	si, 3		; *= 8
		add	si, [handle_names]
		mov	cx, 8 / 2
		rep movsw
		jmp	@@done

	; al = 01h nh̐ݒ
	; ->	dx	EMMnh
	;	ds:si	nhւ̃|C^
	; <-	ah	UgR[h
	@@func01:
		push	dx
	;;	mov	al, 01h
		call	func54		; nh̃T[`
		pop	dx
		tst	ah
		jz	@@dupli

		pushm	ds, es
		movseg	es, cs
		mov	di, dx
		shlm	di, 3		; *= 8
		add	di, [handle_names]
		mov	ds, [_DS]
		mov	cx, 8 / 2
		rep movsw
		popm	es, ds

	@@done:
		clr	ah
	@@exit:
		popm	di, si, cx
		ret

	@@no_func:
		mov	ah, 8Fh		; Tut@NV
		jmp	@@exit
	@@no_handle:
		mov	ah, 83h		; sȃnh
		jmp	@@exit
	@@dupli:
		mov	ah, 0A1h	; nhɎgĂ
		jmp	@@exit
ENDP

;---------------------------------------
; nh֘A(̂Q)
; ->	al	Tut@NVԍ
;---------------------------------------
		EVEN
PROC		func54
		pushm	cx, si, di
		cmp	al, 02h
		ja	@@no_func
		je	@@func02
		tst	al
		jnz	@@func01

	; al = 00h nhfBNg̎擾
	; ->	es:di	o͐
	; <-	ah	UgR[h
	;	al	I[vnh
	@@func00:
		mov	si, [handle_table]
		mov	cx, [max_handle]
		mov	[_AL], 0
	@@loop0:
		lodsw
		tst	ax
		jz	@@next
		inc	[_AL]
		pushm	cx, si
		sub	si, 2
		sub	si, [handle_table]
		shr	si, 1		; si = nh
		mov	ax, si
		stosw
		shlm	si, 3		; *= 8
		add	si, [handle_names]
		mov	cx, 8 / 2
		rep movsw
		popm	si, cx
	@@next:
		loop	@@loop0
		jmp	@@done

	; al = 01h nh̃T[`
	; ->	ds:si	nhւ̃|C^(8oCg)
	; <-	ah	UgR[h
	;	dx	EMMnh
	@@func01:
		push	es		;{
		mov	es, [_DS]
		mov	di, si
		mov	si, [handle_names]
		mov	cx, [max_handle]
		jmp	@@1
		EVEN
	@@loop1:
		add	si, 8
	@@1:
		pushm	cx, si, di
		mov	cx, 8 / 2
		rep cmpsw
		popm	di, si, cx
		loopnz	@@loop1
		pop	es		;}
		jnz	@@no_name
		mov	dx, si
		sub	dx, [handle_names]
		shrm	dx, 3		; /= 8
		jmp	@@done

	; al = 02h nh̎擾
	; ->	--
	; <-	ah	UgR[h
	;	bx	nh
	@@func02:
		mov	bx, [max_handle]

	@@done:
		clr	ah
	@@exit:
		popm	di, si, cx
		ret

	@@no_name:
		mov	ah, 0A0h	; nhȂ
		jmp	@@exit
	@@no_func:
		mov	ah, 8Fh		; Tut@NV
		jmp	@@exit
ENDP

; incomplete
;---------------------------------------
; y[W}bv̕ύXƃWv
; ->	al	y[WԍZOgAhXȂ̂tO
;	dx	EMMnh
;	ds:si	map_and_jump\̂ւ̃|C^
; <-	ah	UgR[h
;---------------------------------------
		EVEN
PROC		func55
		;
		;	܂CvgĂȂ
		;
		jmp	undefined_func
	IF 0
		push	ds
		mov	ds, [_DS]
		
		pop	ds
		ret
	ENDIF
ENDP

; incomplete
;---------------------------------------
; y[W}bv̕ύXƃR[
; ->	al	y[WԍZOgAhXȂ̂tO
;	dx	EMMnh
;	ds:si	map_and_call\̂ւ̃|C^
; <-	ah	UgR[h
;---------------------------------------
		EVEN
PROC		func56
		;
		;	܂CvgĂȂ
		;
		jmp	undefined_func
	IF 0
		push	ds
		mov	ds, [_DS]
		
		pop	ds
		ret
	ENDIF
ENDP

IF 1
;{
;---------------------------------------
; ̈̈ړƌ
; ->	al	Tut@NVԍ
;		00h	ړ
;		01h	
;	ds:si	_move\̂ւ̃|C^
; <-	ah	UgR[h
;---------------------------------------
		EVENDATA
src_handle	DW	?
src_page	DW	?
src_addr	_fp	?
dst_handle	DW	?
dst_page	DW	?
dst_addr	_fp	?
		EVEN
PROC		func57
		pushm	bx, cx, dx, si, di, ds, es

		push	ax
		clr	dx		; handle 0
		call	func47		; save page map
		pop	ax

		cmp	al, 1
		ja	@@no_func
		mov	bx, OFFSET __xchg
		je	@@1
		mov	bx, OFFSET __move
	@@1:
		mov	ds, [_DS]
		les	ax, [(_move ds:si).src.addr.fp]
		mov	cx, [(_move ds:si).src.handle]
		mov	dx, FRAME_SEG
		cmp	[(_move ds:si).src.type], 1
		ja	@@bad_type
		je	@@set_src_addr
		mov	dx, es
		call	__normalize
		clr	cx
	@@set_src_addr:
		mov	[cs:src_handle], cx
		mov	[cs:src_addr.seg], dx
		mov	[cs:src_addr.ofs], ax
		mov	[cs:src_page], es

		les	ax, [(_move ds:si).dst.addr.fp]
		mov	cx, [(_move ds:si).dst.handle]
		mov	dx, FRAME_SEG + PAGE_SIZE / 10h * 2
		cmp	[(_move ds:si).dst.type], 1
		ja	@@bad_type
		je	@@set_dst_addr
		mov	dx, es
		call	__normalize
		clr	cx
	@@set_dst_addr:
		mov	[cs:dst_handle], cx
		mov	[cs:dst_addr.seg], dx
		mov	[cs:dst_addr.ofs], ax
		mov	[cs:dst_page], es

		mov	dx, [(_move ds:si).len.hi]
		mov	ax, [(_move ds:si).len.lo]
		cmp	dx, 0100h	; over 1MBytes ?
		ja	@@too_long
		mov	cx, PAGE_SIZE
		div	cx
		mov	cx, ax
		jcxz	@@rest
	@@loop:
		call	__map_page

	; move or exchange
		pushm	cx
		mov	cx, PAGE_SIZE
		sti
		call	bx
		cli
		popm	cx

		inc	[cs:src_page]
		cmp	[cs:src_handle], 0
		jne	@@4
		add	[cs:src_addr.seg], PAGE_SIZE / 10h
	@@4:
		inc	[cs:dst_page]
		cmp	[cs:dst_handle], 0
		jne	@@5
		add	[cs:dst_addr.seg], PAGE_SIZE / 10h
	@@5:
		loop	@@loop

	@@rest:
		mov	cx, dx
		call	__map_page
		call	bx
	@@done:
		clr	ah
	@@exit:
		movseg	ds, cs
		push	ax
		clr	dx
		call	func48		; restore page map
		pop	ax

		popm	es, ds, di, si, dx, cx, bx
		ret

	@@no_func:
		mov	ah, 8Fh		; Tut@NV
		jmp	@@exit
	@@too_long:
		mov	ah, 96h		; TCY1MB𒴂Ă
		jmp	@@exit
	@@bad_type:
		mov	ah, 98h		; ^Cv
		jmp	@@exit

		EVEN
	PROC	__normalize
		push	ax
		shr	ax, 4
		add	dx, ax
		pop	ax
		and	ax, 0Fh
		ret
	ENDP

		EVEN
	PROC	__map_page
		pushm	bx, dx
		movseg	ds, cs
		mov	dx, [cs:dst_handle]
		tst	dx
		jz	@@2
		mov	bx, [cs:dst_page]
		mov	[_AL], 2
		call	func44
		inc	bx
		inc	[_AL]
		call	func44
	@@2:
		les	di, [cs:dst_addr.fp]
		
		mov	dx, [cs:src_handle]
		tst	dx
		jz	@@1
		mov	bx, [cs:src_page]
		mov	[_AL], 0
		call	func44		; map handle page
		inc	bx
		inc	[_AL]
		call	func44
	@@1:
		lds	si, [cs:src_addr.fp]
	@@exit:
		popm	dx, bx
		ret
	ENDP

	; move data from ds:si to es:di
		EVEN
	PROC	__move
		shr	cx, 1
		rep movsw
		adc	cx, cx
		rep movsb
		ret
	ENDP

	; exchange data between ds:si and es:di
		EVEN
	PROC	__xchg
		push	cx
		shr	cx, 1
		EVEN
	@@loop:
		lodsw
		xchg	[es:di], ax
		mov	[ds:si-2], ax
		add	di, 2
		loop	@@loop
		pop	cx
		and	cx, 1
		jcxz	@@exit
		lodsb
		xchg	[es:di], al
		mov	[ds:si-2], al
		inc	di
	@@exit:
		ret
	ENDP
ENDP
;}
ELSE
;{
;---------------------------------------
; ̈̈ړƌ
; ->	al	Tut@NVԍ
;		00h	ړ
;		01h	
;	ds:si	_move\̂ւ̃|C^
; <-	ah	UgR[h
;---------------------------------------
STRUC _meminf
  handle	DW	?
  page		DW	?
  addr		_fp	?
ENDS
		EVEN
PROC		func57
SEGMENT		_DEVDAT
  src		_meminf	?
  dst		_meminf	?
ENDS		_DEVDAT
		pushm	bx, cx, dx, si, di, ds, es

		push	ax
		clr	dx		; handle 0
		call	func47		; save page map
		pop	ax

		cmp	al, 1
		ja	@@no_func
		mov	bx, OFFSET __xchg
		je	@@1
		mov	bx, OFFSET __move
	@@1:
		mov	ds, [_DS]
		push	si
		add	si, OFFSET (_move 0).src
		mov	di, OFFSET src
		call	__init_meminf
		pop	si
		jc	@@bad_type

		push	si
		add	si, OFFSET (_move 0).dst
		mov	di, OFFSET dst
		call	__init_meminf
		pop	si
		jc	@@bad_type

		mov	dx, [(_move ds:si).len.hi]
		mov	ax, [(_move ds:si).len.lo]
		cmp	dx, 0100h	; over 1MBytes ?
		ja	@@too_long
		mov	cx, PAGE_SIZE
		div	cx
		mov	cx, ax
		jcxz	@@rest
	@@loop:
		call	__map_page

	; move or exchange
		pushm	cx
		mov	cx, PAGE_SIZE
		sti
		call	bx
		cli
		popm	cx

		inc	[cs:src.page]
		cmp	[cs:src.handle], 0
		jne	@@4
		add	[cs:src.addr.seg], PAGE_SIZE / 10h
	@@4:
		inc	[cs:dst.page]
		cmp	[cs:dst.handle], 0
		jne	@@5
		add	[cs:dst.addr.seg], PAGE_SIZE / 10h
	@@5:
		loop	@@loop

	@@rest:
		mov	cx, dx
		call	__map_page
		call	bx
	@@done:
		clr	ah
	@@exit:
		movseg	ds, cs
		push	ax
		clr	dx
		call	func48		; restore page map
		pop	ax

		popm	es, ds, di, si, dx, cx, bx
		ret

	@@no_func:
		mov	ah, 8Fh		; Tut@NV
		jmp	@@exit
	@@too_long:
		mov	ah, 96h		; TCY1MB𒴂Ă
		jmp	@@exit
	@@bad_type:
		mov	ah, 98h		; ^Cv
		jmp	@@exit

		EVEN
	PROC	__normalize
		push	ax
		shrm	ax, 4
		add	dx, ax
		pop	ax
		and	ax, 0Fh
		ret
	ENDP

		EVEN
	PROC	__init_meminf
		les	ax, [(_movinf ds:si).addr.fp]
		mov	cx, [(_movinf ds:si).handle]
		mov	dx, FRAME_SEG
		cmp	[(_movinf ds:si).type], 1
		ja	@@err
		je	@@set_addr
		mov	dx, es
		call	__normalize
		clr	cx
	@@set_addr:
		mov	[(_meminf cs:di).handle], cx
		mov	[(_meminf cs:di).addr.seg], dx
		mov	[(_meminf cs:di).addr.ofs], ax
		mov	[(_meminf cs:di).page], es
		clc
		ret
	@@err:
		stc
		ret
	ENDP

		EVEN
	PROC	__map_page
		pushm	bx, dx
		movseg	ds, cs
		mov	dx, [cs:dst.handle]
		tst	dx
		jz	@@2
		mov	bx, [cs:dst.page]
		mov	[_AL], 2
		call	func44
		inc	bx
		inc	[_AL]
		call	func44
	@@2:
		les	di, [cs:dst.addr.fp]
		
		mov	dx, [cs:src.handle]
		tst	dx
		jz	@@1
		mov	bx, [cs:src.page]
		mov	[_AL], 0
		call	func44		; map handle page
		inc	bx
		inc	[_AL]
		call	func44
	@@1:
		lds	si, [cs:src.addr.fp]
	@@exit:
		popm	dx, bx
		ret
	ENDP

	; ړ
	; ->	ds:si	
	;	es:di	
	;	cx	oCg
	; ><	cx, di, di
		EVEN
	PROC	__move
		shr	cx, 1
		rep movsw
		adc	cx, cx
		rep movsb
		ret
	ENDP

	; 
	; ->	ds:si	AhX1
	;	es:di	AhX2
	;	cx	oCg
	; ><	ax, cx, si, di
		EVEN
	PROC	__xchg
		shr	cx, 1
		pushf			;{
		EVEN
	@@loop:
		lodsw
		xchg	[es:di], ax
		mov	[ds:si-2], ax
		add	di, 2
		loop	@@loop
		popf			;}
		jnc	@@exit
		lodsb
		xchg	[es:di], al
		mov	[ds:si-2], al
		inc	di
	@@exit:
		ret
	ENDP
ENDP
;}
ENDIF

;---------------------------------------
; y[W̎擾֘A
; ->	al	Tut@NVԍ
;---------------------------------------
		EVEN
PROC		func58
		cmp	al, 01h
		ja	@@no_func
		je	@@func01

	; al = 00h y[Wz̎擾
	; ->	es:di	o͐([max_frame]*4oCg)
	; <-	ah	UgR[h
	;	cx	y[W
	@@func00:
		pushm	bx, di
		mov	bx, FRAME_SEG
		clr	cx
	@@loop:
		mov	ax, bx
		stosw
		mov	ax, cx
		stosw
		add	bx, PAGE_SIZE / 10h
		inc	cx
		cmp	cx, [max_frame]
		jb	@@loop
		popm	di, bx
		jmp	@@done

	; al = 01h y[W̎擾
	; ->	--
	; <-	ah	UgR[h
	;	cx	y[W
	@@func01:
		mov	cx, [max_frame]

	@@done:
		clr	ah
	@@exit:
		ret

	@@no_func:
		mov	ah, 8Fh		; Tut@NV
		jmp	@@exit
ENDP

ENDS		_DEV


SEGMENT		_TEXT

; ef[^̈̊mۂƏ
; ->	[max_frame]
;	[max_page]
;	[max_handle]
; <-	[map_table]
;	[page_table]
;	[handle_table]
;	[handle_names]
;	[save_map_idx]
;	[save_map]
; ><	ax, cx, di
PROC		init_table
		push	es
		movseg	es, ds

	; map_table
		mov	cx, [max_frame]
		add	cx, cx
		call	alloc_buffer
		mov	[map_table], di
		shr	cx, 1
		mov	ax, -1
		rep stosw

	; page_table
		mov	cx, [max_page]
		add	cx, cx
		call	alloc_buffer
		mov	[page_table], di
		shr	cx, 1
		clr	ax
		rep stosw

	; handle_table
		mov	cx, [max_handle]
		add	cx, cx
		call	alloc_buffer
		mov	[handle_table], di
		shr	cx, 1
		mov	ax, -1
		stosw			; OSnh͊JĂ
		dec	cx
		clr	ax
		rep stosw

	; handle_names
		mov	cx, [max_handle]
		shlm	cx, 3		; *= 8
		call	alloc_buffer
		mov	[handle_names], di
		shr	cx, 1
		clr	ax
		rep stosw

	; save_map_idx
		mov	cx, [max_handle]
		add	cx, cx
		call	alloc_buffer
		mov	[save_map_idx], di
		shr	cx, 1
		mov	ax, -1
		rep stosw

	; save_map
		mov	al, [BYTE max_handle]
		mul	[BYTE max_frame]
		add	ax, ax
		mov	cx, ax
		call	alloc_buffer
		mov	[save_map], di

		pop	es
		ret
ENDP

PROC		init_emm
		call	init_table
		mov	dx, OFFSET int67h
		mov	ax, 2567h
		int	21h		; set vector
		ret
ENDP

ENDS		_TEXT

END
