/*
 * $Id: dynstring.h 339 2008-06-01 14:26:27Z luigi $
 *
 * An implementation of dynamic strings (and in general, extensible
 * data structures) inherited from the one i wrote myself for asterisk.
 *
 * USE: declare the dynamic string:	dynstr s = NULL;
 * then use as asprintf(), e.g.		dsprintf(&s, fmt, ...);
 * or, to append a chunk of bytes:	ds_append(&s, ptr, len)
 *
 * Use ds_len(s), ds_data(s), ds_reset(s), ds_free(s) to get the
 * length, data pointer, reset the content, and free the memory.
 *
 * This code has been originally designed for strings, however
 * ds_append() supports appending arbitrary chunks of bytes to
 * the structure.
 */

#ifndef __DYNSTRING_H
#define __DYNSTRING_H
typedef struct __dynstr * dynstr;

/* sprintf and append bytes to a dynamic string */
int dsprintf(dynstr *s, const char *fmt, ...);
int ds_append(dynstr *s, const void *d, int len);
const char *ds_data(dynstr s);	// returns a pointer to the content
int ds_len(dynstr s);		// returns the string lenght
void ds_reset(dynstr s);	// resets the buffer to empty string
void ds_free(dynstr s);		// frees the space
#endif	/* __DYNSTRING_H */
