/* headers for http_get and friends
**
** Originally based on a simple version by Al Globus <globus@nas.nasa.gov>.
** Debugged and prettified by Jef Poskanzer <jef@mail.acme.com>.  Also includes
** ifdefs to handle https via OpenSSL.
*/

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdarg.h>	// va_arg
#include <stdlib.h>	// free

void usage();
void show_error( char* cause );

#include "dynstring.h"

/* ssl socket support */
struct my_sock;
struct my_sock *open_client_socket( char* hostname, unsigned short port, int do_ssl );
void safe_close(struct my_sock *fd);
int safe_write(struct my_sock *fd, const char *buf, int bytes);
int safe_read(struct my_sock *fd, char *buf, int len);

#include "minixml.h"
