/* 
 * SPCA508 chip based cameras initialization data
 *
 */
#ifndef SPCA508_INIT_H
#define SPCA508_INIT_H

/* Frame packet header offsets for the spca508 */
#define SPCA508_OFFSET_TYPE 1
#define SPCA508_OFFSET_COMPRESS 2
#define SPCA508_OFFSET_FRAMSEQ 8
#define SPCA508_OFFSET_WIN1LUM 11
#define SPCA508_OFFSET_DATA 37

#define SPCA508_SNAPBIT 0x20
#define SPCA508_SNAPCTRL 0x40
/*************** I2c ****************/
#define SPCA508_INDEX_I2C_BASE 0x8800

/*
   Initialization data: this is the first set-up data written to the
   device (before the open data).
 */
static __u16 spca508_init_data[][3] =
#define IGN(x)			/* nothing */
{
    /*  line   URB    req,  value, index */
    /*    22     1 *//* READ { 0, 0x0 IGN(URB_FUNCTION_GET_DESCRIPTOR_FROM_DEVICE:), 0x00   } ->
       0000: 12 01 10 01 00 00 00 08 33 07 10 01 00 00 01 02
       0010: 00 01  */
    /*    44     2 *//* READ { 0, 0x0 IGN(URB_FUNCTION_GET_DESCRIPTOR_FROM_DEVICE:), 0x00   } ->
       0000: 09 02 89 00 01 01 00 80 32 09 04 00 00 01 ff 00
       0010: 00 00 07 05 81 01 00 00 01 09 04 00 01 01 ff 00
       0020: 00 00 07 05 81 01 80 00 01 09 04 00 02 01 ff 00
       0030: 00 00 07 05 81 01 80 01 01 09 04 00 03 01 ff 00  */
    /*    68     3 *//* READ { 0, 0x0 IGN(URB_FUNCTION_GET_DESCRIPTOR_FROM_DEVICE:), 0x00   } ->
       0000: 09 02 89 00 01 01 00 80 32 09 04 00 00 01 ff 00
       0010: 00 00 07 05 81 01 00 00 01 09 04 00 01 01 ff 00
       0020: 00 00 07 05 81 01 80 00 01 09 04 00 02 01 ff 00
       0030: 00 00 07 05 81 01 80 01 01 09 04 00 03 01 ff 00
       0040: 00 00 07 05 81 01 00 02 01 09 04 00 04 01 ff 00
       0050: 00 00 07 05 81 01 80 02 01 09 04 00 05 01 ff 00
       0060: 00 00 07 05 81 01 00 03 01 09 04 00 06 01 ff 00
       0070: 00 00 07 05 81 01 80 03 01 09 04 00 07 01 ff 00
       0080: 00 00 07 05 81 01 ff 03 01  */
    /*   104     4 *//* UNKNOWN DIRECTION (URB_FUNCTION_SELECT_CONFIGURATION:) */
						/* 44274  1804 */ {0, 0x0000, 0x870b},
						// 



						/* 44299  1805 */ {0, 0x0020, 0x8112},
						// Video drop enable, ISO streaming disable
						/* 44324  1806 */ {0, 0x0003, 0x8111},
						// Reset compression & memory
						/* 44349  1807 */ {0, 0x0000, 0x8110},
						// Disable all outputs
    /* 44372  1808 *//* READ { 0, 0x0000, 0x8114 } ->
       0000: 00  */
						/* 44398  1809 */ {0, 0x0000, 0x8114},
						// SW GPIO data
						/* 44423  1810 */ {0, 0x0008, 0x8110},
						// Enable charge pump output
						/* 44527  1811 */ {0, 0x0002, 0x8116},
						// 200 kHz pump clock
    /* 44555  1812 *//* UNKNOWN DIRECTION (URB_FUNCTION_SELECT_INTERFACE:) */
						/* 44590  1813 */ {0, 0x0003, 0x8111},
						// Reset compression & memory
						/* 44615  1814 */ {0, 0x0000, 0x8111},
						// Normal mode (not reset)
						/* 44640  1815 */ {0, 0x0098, 0x8110},
						// Enable charge pump output, sync.serial,external 2x clock
						/* 44665  1816 */ {0, 0x000d, 0x8114},
						// SW GPIO data
						/* 44690  1817 */ {0, 0x0002, 0x8116},
						// 200 kHz pump clock
						/* 44715  1818 */ {0, 0x0020, 0x8112},
						// Video drop enable, ISO streaming disable


    // ---------------------------------------
						/* 44740  1819 */ {0, 0x000f, 0x8402},
						// memory bank
						/* 44765  1820 */ {0, 0x0000, 0x8403},
						// ... address


    // ---------------------------------------
    // 0x88__ is Synchronous Serial Interface.
    // TBD: This table could be expressed more compactly
    // using spca508_write_i2c_vector().
    // TBD: Should see if the values in spca50x_i2c_data
    // would work with the VQ110 instead of the values
    // below.

						/* 44790  1821 */ {0, 0x00c0, 0x8804},
						// SSI slave addr
						/* 44815  1822 */ {0, 0x0008, 0x8802},
						// 375 Khz SSI clock
    /* 44838  1823 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 44862  1824 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
						/* 44888  1825 */ {0, 0x0008, 0x8802},
						// 375 Khz SSI clock
						/* 44913  1826 */ {0, 0x0012, 0x8801},
						// SSI reg addr
						/* 44938  1827 */ {0, 0x0080, 0x8800},
						// SSI data to write
    /* 44961  1828 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 44985  1829 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45009  1830 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
						/* 45035  1831 */ {0, 0x0008, 0x8802},
						// 375 Khz SSI clock
						/* 45060  1832 */ {0, 0x0012, 0x8801},
						// SSI reg addr
						/* 45085  1833 */ {0, 0x0000, 0x8800},
						// SSI data to write
    /* 45108  1834 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45132  1835 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45156  1836 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
						/* 45182  1837 */ {0, 0x0008, 0x8802},
						// 375 Khz SSI clock
						/* 45207  1838 */ {0, 0x0011, 0x8801},
						// SSI reg addr
						/* 45232  1839 */ {0, 0x0040, 0x8800},
						// SSI data to write
    /* 45255  1840 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45279  1841 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45303  1842 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 45329  1843 */ {0, 0x0008, 0x8802},
    /* 45354  1844 */ {0, 0x0013, 0x8801},
    /* 45379  1845 */ {0, 0x0000, 0x8800},
    /* 45402  1846 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45426  1847 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45450  1848 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 45476  1849 */ {0, 0x0008, 0x8802},
    /* 45501  1850 */ {0, 0x0014, 0x8801},
    /* 45526  1851 */ {0, 0x0000, 0x8800},
    /* 45549  1852 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45573  1853 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45597  1854 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 45623  1855 */ {0, 0x0008, 0x8802},
    /* 45648  1856 */ {0, 0x0015, 0x8801},
    /* 45673  1857 */ {0, 0x0001, 0x8800},
    /* 45696  1858 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45720  1859 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45744  1860 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 45770  1861 */ {0, 0x0008, 0x8802},
    /* 45795  1862 */ {0, 0x0016, 0x8801},
    /* 45820  1863 */ {0, 0x0003, 0x8800},
    /* 45843  1864 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45867  1865 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 45891  1866 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 45917  1867 */ {0, 0x0008, 0x8802},
    /* 45942  1868 */ {0, 0x0017, 0x8801},
    /* 45967  1869 */ {0, 0x0036, 0x8800},
    /* 45990  1870 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46014  1871 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46038  1872 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 46064  1873 */ {0, 0x0008, 0x8802},
    /* 46089  1874 */ {0, 0x0018, 0x8801},
    /* 46114  1875 */ {0, 0x00ec, 0x8800},
    /* 46137  1876 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46161  1877 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46185  1878 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 46211  1879 */ {0, 0x0008, 0x8802},
    /* 46236  1880 */ {0, 0x001a, 0x8801},
    /* 46261  1881 */ {0, 0x0094, 0x8800},
    /* 46284  1882 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46308  1883 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46332  1884 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 46358  1885 */ {0, 0x0008, 0x8802},
    /* 46383  1886 */ {0, 0x001b, 0x8801},
    /* 46408  1887 */ {0, 0x0000, 0x8800},
    /* 46431  1888 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46455  1889 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46479  1890 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 46505  1891 */ {0, 0x0008, 0x8802},
    /* 46530  1892 */ {0, 0x0027, 0x8801},
    /* 46555  1893 */ {0, 0x00a2, 0x8800},
    /* 46578  1894 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46602  1895 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46626  1896 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 46652  1897 */ {0, 0x0008, 0x8802},
    /* 46677  1898 */ {0, 0x0028, 0x8801},
    /* 46702  1899 */ {0, 0x0040, 0x8800},
    /* 46725  1900 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46749  1901 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46773  1902 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 46799  1903 */ {0, 0x0008, 0x8802},
    /* 46824  1904 */ {0, 0x002a, 0x8801},
    /* 46849  1905 */ {0, 0x0084, 0x8800},
    /* 46872  1906 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46896  1907 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 46920  1908 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 46946  1909 */ {0, 0x0008, 0x8802},
    /* 46971  1910 */ {0, 0x002b, 0x8801},
    /* 46996  1911 */ {0, 0x00a8, 0x8800},
    /* 47019  1912 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47043  1913 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47067  1914 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 47093  1915 */ {0, 0x0008, 0x8802},
    /* 47118  1916 */ {0, 0x002c, 0x8801},
    /* 47143  1917 */ {0, 0x00fe, 0x8800},
    /* 47166  1918 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47190  1919 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47214  1920 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 47240  1921 */ {0, 0x0008, 0x8802},
    /* 47265  1922 */ {0, 0x002d, 0x8801},
    /* 47290  1923 */ {0, 0x0003, 0x8800},
    /* 47313  1924 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47337  1925 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47361  1926 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 47387  1927 */ {0, 0x0008, 0x8802},
    /* 47412  1928 */ {0, 0x0038, 0x8801},
    /* 47437  1929 */ {0, 0x0083, 0x8800},
    /* 47460  1930 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47484  1931 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47508  1932 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 47534  1933 */ {0, 0x0008, 0x8802},
    /* 47559  1934 */ {0, 0x0033, 0x8801},
    /* 47584  1935 */ {0, 0x0081, 0x8800},
    /* 47607  1936 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47631  1937 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47655  1938 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 47681  1939 */ {0, 0x0008, 0x8802},
    /* 47706  1940 */ {0, 0x0034, 0x8801},
    /* 47731  1941 */ {0, 0x004a, 0x8800},
    /* 47754  1942 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47778  1943 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47802  1944 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 47828  1945 */ {0, 0x0008, 0x8802},
    /* 47853  1946 */ {0, 0x0039, 0x8801},
    /* 47878  1947 */ {0, 0x0000, 0x8800},
    /* 47901  1948 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47925  1949 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 47949  1950 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 47975  1951 */ {0, 0x0008, 0x8802},
    /* 48000  1952 */ {0, 0x0010, 0x8801},
    /* 48025  1953 */ {0, 0x00a8, 0x8800},
    /* 48048  1954 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48072  1955 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48096  1956 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 48122  1957 */ {0, 0x0008, 0x8802},
    /* 48147  1958 */ {0, 0x0006, 0x8801},
    /* 48172  1959 */ {0, 0x0058, 0x8800},
    /* 48195  1960 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48219  1961 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48243  1962 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 48269  1963 */ {0, 0x0008, 0x8802},
    /* 48294  1964 */ {0, 0x0000, 0x8801},
    /* 48319  1965 */ {0, 0x0004, 0x8800},
    /* 48342  1966 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48366  1967 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48390  1968 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 48416  1969 */ {0, 0x0008, 0x8802},
    /* 48441  1970 */ {0, 0x0040, 0x8801},
    /* 48466  1971 */ {0, 0x0080, 0x8800},
    /* 48489  1972 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48513  1973 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48537  1974 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 48563  1975 */ {0, 0x0008, 0x8802},
    /* 48588  1976 */ {0, 0x0041, 0x8801},
    /* 48613  1977 */ {0, 0x000c, 0x8800},
    /* 48636  1978 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48660  1979 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48684  1980 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 48710  1981 */ {0, 0x0008, 0x8802},
    /* 48735  1982 */ {0, 0x0042, 0x8801},
    /* 48760  1983 */ {0, 0x000c, 0x8800},
    /* 48783  1984 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48807  1985 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48831  1986 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 48857  1987 */ {0, 0x0008, 0x8802},
    /* 48882  1988 */ {0, 0x0043, 0x8801},
    /* 48907  1989 */ {0, 0x0028, 0x8800},
    /* 48930  1990 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48954  1991 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 48978  1992 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 49004  1993 */ {0, 0x0008, 0x8802},
    /* 49029  1994 */ {0, 0x0044, 0x8801},
    /* 49054  1995 */ {0, 0x0080, 0x8800},
    /* 49077  1996 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49101  1997 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49125  1998 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 49151  1999 */ {0, 0x0008, 0x8802},
    /* 49176  2000 */ {0, 0x0045, 0x8801},
    /* 49201  2001 */ {0, 0x0020, 0x8800},
    /* 49224  2002 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49248  2003 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49272  2004 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 49298  2005 */ {0, 0x0008, 0x8802},
    /* 49323  2006 */ {0, 0x0046, 0x8801},
    /* 49348  2007 */ {0, 0x0020, 0x8800},
    /* 49371  2008 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49395  2009 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49419  2010 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 49445  2011 */ {0, 0x0008, 0x8802},
    /* 49470  2012 */ {0, 0x0047, 0x8801},
    /* 49495  2013 */ {0, 0x0080, 0x8800},
    /* 49518  2014 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49542  2015 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49566  2016 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 49592  2017 */ {0, 0x0008, 0x8802},
    /* 49617  2018 */ {0, 0x0048, 0x8801},
    /* 49642  2019 */ {0, 0x004c, 0x8800},
    /* 49665  2020 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49689  2021 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49713  2022 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 49739  2023 */ {0, 0x0008, 0x8802},
    /* 49764  2024 */ {0, 0x0049, 0x8801},
    /* 49789  2025 */ {0, 0x0084, 0x8800},
    /* 49812  2026 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49836  2027 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49860  2028 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 49886  2029 */ {0, 0x0008, 0x8802},
    /* 49911  2030 */ {0, 0x004a, 0x8801},
    /* 49936  2031 */ {0, 0x0084, 0x8800},
    /* 49959  2032 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 49983  2033 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 50007  2034 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 50033  2035 */ {0, 0x0008, 0x8802},
    /* 50058  2036 */ {0, 0x004b, 0x8801},
    /* 50083  2037 */ {0, 0x0084, 0x8800},
    /* 50106  2038 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    // ---------------------------------------
						/* 50132  2039 */ {0, 0x0012, 0x8700},
						// Clock speed 48Mhz/(2+2)/2= 6 Mhz
						/* 50157  2040 */ {0, 0x0000, 0x8701},
						// CKx1 clock delay adj
						/* 50182  2041 */ {0, 0x0000, 0x8701},
						// CKx1 clock delay adj
						/* 50207  2042 */ {0, 0x0001, 0x870c},
						// CKOx2 output

    // ---------------------------------------
						/* 50232  2043 */ {0, 0x0080, 0x8600},
						// Line memory read counter (L)
						/* 50257  2044 */ {0, 0x0001, 0x8606},
						// reserved
						/* 50282  2045 */ {0, 0x0064, 0x8607},
						// Line memory read counter (H) 0x6480=25,728
						/* 50307  2046 */ {0, 0x002a, 0x8601},
						// CDSP sharp interpolation mode, line sel for color sep, edge enhance enab
						/* 50332  2047 */ {0, 0x0000, 0x8602},
						// optical black level for user settng = 0
						/* 50357  2048 */ {0, 0x0080, 0x8600},
						// Line memory read counter (L)
						/* 50382  2049 */ {0, 0x000a, 0x8603},
						// optical black level calc mode: auto; optical black offset = 10
						/* 50407  2050 */ {0, 0x00df, 0x865b},
						// Horiz offset for valid pixels (L)=0xdf
						/* 50432  2051 */ {0, 0x0012, 0x865c},
						// Vert offset for valid lines (L)=0x12

    // The following two lines seem to be the "wrong" resolution.
    // But perhaps these indicate the actual size of the sensor
    // rather than the size of the current video mode.
						/* 50457  2052 */ {0, 0x0058, 0x865d},
						// Horiz valid pixels (*4) (L) = 352
						/* 50482  2053 */ {0, 0x0048, 0x865e},
						// Vert valid lines (*4) (L) = 288

						/* 50507  2054 */ {0, 0x0015, 0x8608},
						// A11 Coef ...
    /* 50532  2055 */ {0, 0x0030, 0x8609},
    /* 50557  2056 */ {0, 0x00fb, 0x860a},
    /* 50582  2057 */ {0, 0x003e, 0x860b},
    /* 50607  2058 */ {0, 0x00ce, 0x860c},
    /* 50632  2059 */ {0, 0x00f4, 0x860d},
    /* 50657  2060 */ {0, 0x00eb, 0x860e},
    /* 50682  2061 */ {0, 0x00dc, 0x860f},
    /* 50707  2062 */ {0, 0x0039, 0x8610},
						/* 50732  2063 */ {0, 0x0001, 0x8611},
						// R offset for white balance ...
    /* 50757  2064 */ {0, 0x0000, 0x8612},
    /* 50782  2065 */ {0, 0x0001, 0x8613},
    /* 50807  2066 */ {0, 0x0000, 0x8614},
						/* 50832  2067 */ {0, 0x005b, 0x8651},
						// R gain for white balance ...
    /* 50857  2068 */ {0, 0x0040, 0x8652},
    /* 50882  2069 */ {0, 0x0060, 0x8653},
    /* 50907  2070 */ {0, 0x0040, 0x8654},
    /* 50932  2071 */ {0, 0x0000, 0x8655},
						/* 50957  2072 */ {0, 0x0001, 0x863f},
						// Fixed gamma correction enable, USB control, lum filter disable, lum noise clip disable
						/* 50982  2073 */ {0, 0x00a1, 0x8656},
						// Window1 size 256x256, Windows2 size 64x64, gamma look-up disable, new edge enhancement enable
						/* 51007  2074 */ {0, 0x0018, 0x8657},
						// Edge gain high thresh
						/* 51032  2075 */ {0, 0x0020, 0x8658},
						// Edge gain low thresh
						/* 51057  2076 */ {0, 0x000a, 0x8659},
						// Edge bandwidth high threshold
						/* 51082  2077 */ {0, 0x0005, 0x865a},
						// Edge bandwidth low threshold

    //--------------------------------
						/* 51107  2078 */ {0, 0x0030, 0x8112},
						// Video drop enable, ISO streaming enable
    /* 51130  2079 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 51154  2080 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 51180  2081 */ {0, 0xa908, 0x8802},
						/* 51205  2082 */ {0, 0x0034, 0x8801},
						// SSI reg addr
						/* 51230  2083 */ {0, 0x00ca, 0x8800},
						// SSI data to write
    /* 51253  2084 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 51277  2085 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 51301  2086 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 51327  2087 */ {0, 0x1f08, 0x8802},
    /* 51352  2088 */ {0, 0x0006, 0x8801},
    /* 51377  2089 */ {0, 0x0080, 0x8800},
    /* 51400  2090 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */


    //----- Read back coefs we wrote earlier.
    /* 51424  2091 *//* READ { 0, 0x0000, 0x8608 } ->
       0000: 15  */
    /* 51448  2092 *//* READ { 0, 0x0000, 0x8609 } ->
       0000: 30  */
    /* 51472  2093 *//* READ { 0, 0x0000, 0x860a } ->
       0000: fb  */
    /* 51496  2094 *//* READ { 0, 0x0000, 0x860b } ->
       0000: 3e  */
    /* 51520  2095 *//* READ { 0, 0x0000, 0x860c } ->
       0000: ce  */
    /* 51544  2096 *//* READ { 0, 0x0000, 0x860d } ->
       0000: f4  */
    /* 51568  2097 *//* READ { 0, 0x0000, 0x860e } ->
       0000: eb  */
    /* 51592  2098 *//* READ { 0, 0x0000, 0x860f } ->
       0000: dc  */
    /* 51616  2099 *//* READ { 0, 0x0000, 0x8610 } ->
       0000: 39  */
    /* 51640  2100 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 51664  2101 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 08  */
    /* 51690  2102 */ {0, 0xb008, 0x8802},
    /* 51715  2103 */ {0, 0x0006, 0x8801},
    /* 51740  2104 */ {0, 0x007d, 0x8800},
    /* 51763  2105 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

#if 0
    /* experimental.  dark version. */
    {0, 0xba, 0x8705},		/* total pixel clocks per hsync cycle (L) */
    {0, 0x00, 0x8706},		/* total pixel clocks per hsync cycle (H in 2:0) */
    {0, 0x5a, 0x8707},		/* total pixel clocks per hsync blank period (L) */
#elif 0
    /* experimental.  factory default. */
    {0, 0x8e, 0x8705},		/* total pixel clocks per hsync cycle (L) */
    {0, 0x03, 0x8706},		/* total pixel clocks per hsync cycle (H in 2:0) */
    {0, 0x5a, 0x8707},		/* total pixel clocks per hsync blank period (L) */
#elif 0
    /* experimental.  light. */
    {0, 0xba, 0x8705},		/* total pixel clocks per hsync cycle (L) */
    {0, 0x01, 0x8706},		/* total pixel clocks per hsync cycle (H in 2:0) */
    {0, 0x10, 0x8707},		/* total pixel clocks per hsync blank period (L) */
#endif

#if 1
    // This chunk is seemingly redundant with
    // earlier commands (A11 Coef...), but if I disable it,
    // the image appears too dark.  Maybe there was some kind of
    // reset since the earlier commands, so this is necessary again.
    /* 51789  2106 */ {0, 0x0015, 0x8608},
    /* 51814  2107 */ {0, 0x0030, 0x8609},
    /* 51839  2108 */ {0, 0xfffb, 0x860a},
    /* 51864  2109 */ {0, 0x003e, 0x860b},
    /* 51889  2110 */ {0, 0xffce, 0x860c},
    /* 51914  2111 */ {0, 0xfff4, 0x860d},
    /* 51939  2112 */ {0, 0xffeb, 0x860e},
    /* 51964  2113 */ {0, 0xffdc, 0x860f},
    /* 51989  2114 */ {0, 0x0039, 0x8610},
    /* 52014  2115 */ {0, 0x0018, 0x8657},
#endif

						/* 52039  2116 */ {0, 0x0000, 0x8508},
						// Disable compression.
    // Previous line was: /* 52039  2116 */ { 0, 0x0021, 0x8508 }, // Enable compression.
						/* 52064  2117 */ {0, 0x0032, 0x850b},
						// compression stuff
						/* 52089  2118 */ {0, 0x0003, 0x8509},
						// compression stuff
						/* 52114  2119 */ {0, 0x0011, 0x850a},
						// compression stuff
						/* 52139  2120 */ {0, 0x0021, 0x850d},
						// compression stuff
						/* 52164  2121 */ {0, 0x0010, 0x850c},
						// compression stuff
						/* 52189  2122 */ {0, 0x0003, 0x8500},
						// *** Video mode: 160x120
						/* 52214  2123 */ {0, 0x0001, 0x8501},
						// Hardware-dominated snap control
						/* 52239  2124 */ {0, 0x0061, 0x8656},
						// Window1 size 128x128, Windows2 size 128x128, gamma look-up disable, new edge enhancement enable
						/* 52264  2125 */ {0, 0x0018, 0x8617},
						// Window1 start X (*2)
						/* 52289  2126 */ {0, 0x0008, 0x8618},
						// Window1 start Y (*2)
						/* 52314  2127 */ {0, 0x0061, 0x8656},
						// Window1 size 128x128, Windows2 size 128x128, gamma look-up disable, new edge enhancement enable
						/* 52339  2128 */ {0, 0x0058, 0x8619},
						// Window2 start X (*2)
						/* 52364  2129 */ {0, 0x0008, 0x861a},
						// Window2 start Y (*2)
						/* 52389  2130 */ {0, 0x00ff, 0x8615},
						// High lum thresh for white balance
						/* 52414  2131 */ {0, 0x0000, 0x8616},
						// Low lum thresh for white balance
						/* 52439  2132 */ {0, 0x0012, 0x8700},
						// Clock speed 48Mhz/(2+2)/2= 6 Mhz
						/* 52464  2133 */ {0, 0x0012, 0x8700},
						// Clock speed 48Mhz/(2+2)/2= 6 Mhz
    /* 52487  2134 *//* READ { 0, 0x0000, 0x8656 } ->
       0000: 61  */


						/* 52513  2135 */ {0, 0x0028, 0x8802},
						// 375 Khz SSI clock, SSI r/w sync with VSYNC
    /* 52536  2136 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 52560  2137 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 28  */
						/* 52586  2138 */ {0, 0x1f28, 0x8802},
						// 375 Khz SSI clock, SSI r/w sync with VSYNC
						/* 52611  2139 */ {0, 0x0010, 0x8801},
						// SSI reg addr
						/* 52636  2140 */ {0, 0x003e, 0x8800},
						// SSI data to write
    /* 52659  2141 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 52685  2142 */ {0, 0x0028, 0x8802},
    /* 52708  2143 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 52732  2144 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 28  */
    /* 52758  2145 */ {0, 0x1f28, 0x8802},
    /* 52783  2146 */ {0, 0x0000, 0x8801},
    /* 52808  2147 */ {0, 0x001f, 0x8800},
    /* 52831  2148 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
						/* 52857  2149 */ {0, 0x0001, 0x8602},
						// optical black level for user settning = 1

#if 0
    // NOTE: Code like this case lets this driver (often) work
    // in 352x288 resolution, apparently by slowing down the
    // clock.

						/* 52464  2133 */ {0, 0x002F, 0x8700},
						// Clock speed 
#else
    // Original:
						/* 52882  2150 */ {0, 0x0023, 0x8700},
						// Clock speed 48Mhz/(3+2)/4= 2.4 Mhz
#endif

						/* 52907  2151 */ {0, 0x000f, 0x8602},
						// optical black level for user settning = 15

    /* 52932  2152 */ {0, 0x0028, 0x8802},
    /* 52955  2153 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* 52979  2154 *//* READ { 0, 0x0001, 0x8802 } ->
       0000: 28  */
    /* 53005  2155 */ {0, 0x1f28, 0x8802},
    /* 53030  2156 */ {0, 0x0010, 0x8801},
    /* 53055  2157 */ {0, 0x007b, 0x8800},
    /* 53078  2158 *//* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
						/* 53104  2159 */ {0, 0x002f, 0x8651},
						// R gain for white balance ...
    /* 53129  2160 */ {0, 0x0080, 0x8653},
    /* 53152  2161 *//* READ { 0, 0x0000, 0x8655 } ->
       0000: 00  */
    /* 53178  2162 */ {0, 0x0000, 0x8655},

						/* 53203  2163 */ {0, 0x0030, 0x8112},
						// Video drop enable, ISO streaming enable
						/* 53228  2164 */ {0, 0x0020, 0x8112},
						// Video drop enable, ISO streaming disable
    /* 53252  2165 *//* UNKNOWN DIRECTION (URB_FUNCTION_SELECT_INTERFACE: (ALT=0) ) */

    {0, 0, 0}
};

/*
 * Data to initialize the camera using the internal CCD
 */
static __u16 spca508_open_data[][3] = {
    /* line       bmRequest,value,index */
    {0, 0, 0}
};

/*
 * Initialization data for Intel EasyPC Camera CS110
 */
static __u16 spca508cs110_init_data[][3] = {
    {0, 0x0000, 0x870b},	/* Reset CTL3 */
    {0, 0x0003, 0x8111},	/* Soft Reset compression, memory, TG & CDSP */
    {0, 0x0000, 0x8111},	/* Normal operation on reset */
    {0, 0x0090, 0x8110},	/* External Clock 2x & Synchronous Serial Interface Output */
    {0, 0x0020, 0x8112},	/* Video Drop packet enable */
    {0, 0x0000, 0x8114},	/* Software GPIO output data */
    {0, 0x0001, 0x8114},
    {0, 0x0001, 0x8114},
    {0, 0x0001, 0x8114},
    {0, 0x0003, 0x8114},

    /* Initial sequence Synchronous Serial Interface */
    {0, 0x000f, 0x8402},	/* Memory bank Address */
    {0, 0x0000, 0x8403},	/* Memory bank Address */
    {0, 0x00ba, 0x8804},	/* SSI Slave address */
    {0, 0x0010, 0x8802},	/* 93.75kHz SSI Clock Two DataByte */
    {0, 0x0010, 0x8802},	/* 93.75kHz SSI Clock two DataByte */

    {0, 0x0001, 0x8801},
    {0, 0x000a, 0x8805},	/* a - NWG: Dunno what this is about */
    {0, 0x0000, 0x8800},
    {0, 0x0010, 0x8802},

    {0, 0x0002, 0x8801},
    {0, 0x0000, 0x8805},
    {0, 0x0000, 0x8800},
    {0, 0x0010, 0x8802},

    {0, 0x0003, 0x8801},
    {0, 0x0027, 0x8805},
    {0, 0x0001, 0x8800},
    {0, 0x0010, 0x8802},

    {0, 0x0004, 0x8801},
    {0, 0x0065, 0x8805},
    {0, 0x0001, 0x8800},
    {0, 0x0010, 0x8802},

    {0, 0x0005, 0x8801},
    {0, 0x0003, 0x8805},
    {0, 0x0000, 0x8800},
    {0, 0x0010, 0x8802},

    {0, 0x0006, 0x8801},
    {0, 0x001c, 0x8805},
    {0, 0x0000, 0x8800},
    {0, 0x0010, 0x8802},

    {0, 0x0007, 0x8801},
    {0, 0x002a, 0x8805},
    {0, 0x0000, 0x8800},
    {0, 0x0010, 0x8802},



    {0, 0x0002, 0x8704},	/* External input CKIx1 */
    {0, 0x0001, 0x8606},	/* 1 Line memory Read Counter (H) Result: (d)410 */
    {0, 0x009a, 0x8600},	/* Line memory Read Counter (L) */
    {0, 0x0001, 0x865b},	/* 1 Horizontal Offset for Valid Pixel(L) */
    {0, 0x0003, 0x865c},	/* 3 Vertical Offset for Valid Lines(L) */
    {0, 0x0058, 0x865d},	/* 58 Horizontal Valid Pixel Window(L) */


    {0, 0x0006, 0x8660},	/* Nibble data + input order */


    {0, 0x000a, 0x8602},	/* Optical black level set to 0x0a */
					/* 1945 */ {0, 0x0000, 0x8603},
					/* Optical black level Offset */

    /* 1962 */// { 0, 0x0000, 0x8611 }, /* 0 R  Offset for white Balance */
    /* 1963 */// { 0, 0x0000, 0x8612 }, /* 1 Gr Offset for white Balance */
    /* 1964 */// { 0, 0x0000, 0x8613 }, /* 1f B  Offset for white Balance */
    /* 1965 */// { 0, 0x0000, 0x8614 }, /* f0 Gb Offset for white Balance */

    {0, 0x0040, 0x8651},	/* 2b BLUE gain for white balance  good at all 60 */
    {0, 0x0030, 0x8652},	/* 41 Gr Gain for white Balance (L) */
    {0, 0x0035, 0x8653},	/* 26 RED gain for white balance */
    {0, 0x0035, 0x8654},	/* 40Gb Gain for white Balance (L) */
    {0, 0x0041, 0x863f},	/* Fixed Gamma correction enabled (makes colours look better) */

					/* 2422 */ {0, 0x0000, 0x8655},
					/* High bits for white balance*****brightness control*** */

    {0, 0, 0}
};

static __u16 spca508_sightcam_init_data[][3] = {
/* This line seems to setup the frame/canvas */
    /*368  */ {0, 0x000f, 0x8402},

/* Theese 6 lines are needed to startup the webcam */
    /*398  */ {0, 0x0090, 0x8110},
    /*399  */ {0, 0x0001, 0x8114},
    /*400  */ {0, 0x0001, 0x8114},
    /*401  */ {0, 0x0001, 0x8114},
    /*402  */ {0, 0x0003, 0x8114},
    /*403  */ {0, 0x0080, 0x8804},

/* This part seems to make the pictures darker? (autobrightness?) */
    /*436  */ {0, 0x0001, 0x8801},
    /*437  */ {0, 0x0004, 0x8800},
    /*439  */ {0, 0x0003, 0x8801},
    /*440  */ {0, 0x00e0, 0x8800},
    /*442  */ {0, 0x0004, 0x8801},
    /*443  */ {0, 0x00b4, 0x8800},
    /*445  */ {0, 0x0005, 0x8801},
    /*446  */ {0, 0x0000, 0x8800},

    /*448  */ {0, 0x0006, 0x8801},
    /*449  */ {0, 0x00e0, 0x8800},
    /*451  */ {0, 0x0007, 0x8801},
    /*452  */ {0, 0x000c, 0x8800},

/* This section is just needed, it probably
 * does something like the previous section,
 * but the cam won't start if it's not included.
 */
    /*484  */ {0, 0x0014, 0x8801},
    /*485  */ {0, 0x0008, 0x8800},
    /*487  */ {0, 0x0015, 0x8801},
    /*488  */ {0, 0x0067, 0x8800},
    /*490  */ {0, 0x0016, 0x8801},
    /*491  */ {0, 0x0000, 0x8800},
    /*493  */ {0, 0x0017, 0x8801},
    /*494  */ {0, 0x0020, 0x8800},
    /*496  */ {0, 0x0018, 0x8801},
    /*497  */ {0, 0x0044, 0x8800},

/* Makes the picture darker - and the
 * cam won't start if not included
 */
    /*505  */ {0, 0x001e, 0x8801},
    /*506  */ {0, 0x00ea, 0x8800},
    /*508  */ {0, 0x001f, 0x8801},
    /*509  */ {0, 0x0001, 0x8800},
    /*511  */ {0, 0x0003, 0x8801},
    /*512  */ {0, 0x00e0, 0x8800},

/* seems to place the colors ontop of each other #1 */
    /*517  */ {0, 0x0006, 0x8704},
    /*518  */ {0, 0x0001, 0x870c},
    /*519  */ {0, 0x0016, 0x8600},
    /*520  */ {0, 0x0002, 0x8606},

/* if not included the pictures becomes _very_ dark */
    /*521  */ {0, 0x0064, 0x8607},
    /*522  */ {0, 0x003a, 0x8601},
    /*523  */ {0, 0x0000, 0x8602},

/* seems to place the colors ontop of each other #2 */
    /*524  */ {0, 0x0016, 0x8600},
    /*525  */ {0, 0x0018, 0x8617},
    /*526  */ {0, 0x0008, 0x8618},
    /*527  */ {0, 0x00a1, 0x8656},

/* webcam won't start if not included */
    /*528  */ {0, 0x0007, 0x865b},
    /*529  */ {0, 0x0001, 0x865c},
    /*530  */ {0, 0x0058, 0x865d},
    /*531  */ {0, 0x0048, 0x865e},

/* adjusts the colors */
    /*541  */ {0, 0x0049, 0x8651},
    /*542  */ {0, 0x0040, 0x8652},
    /*543  */ {0, 0x004c, 0x8653},
    /*544  */ {0, 0x0040, 0x8654},

    {0, 0, 0}
};

static __u16 spca508_sightcam2_init_data[][3] = {
#if 1
/* 35 */ {0, 0x0020, 0x8112},

/* 36 */ {0, 0x000f, 0x8402},
/* 37 */ {0, 0x0000, 0x8403},

/* 38 */ {0, 0x0008, 0x8201},
/* 39 */ {0, 0x0008, 0x8200},
/* 40 */ {0, 0x0001, 0x8200},
/* 43 */ {0, 0x0009, 0x8201},
/* 44 */ {0, 0x0008, 0x8200},
/* 45 */ {0, 0x0001, 0x8200},
/* 48 */ {0, 0x000a, 0x8201},
/* 49 */ {0, 0x0008, 0x8200},
/* 50 */ {0, 0x0001, 0x8200},
/* 53 */ {0, 0x000b, 0x8201},
/* 54 */ {0, 0x0008, 0x8200},
/* 55 */ {0, 0x0001, 0x8200},
/* 58 */ {0, 0x000c, 0x8201},
/* 59 */ {0, 0x0008, 0x8200},
/* 60 */ {0, 0x0001, 0x8200},
/* 63 */ {0, 0x000d, 0x8201},
/* 64 */ {0, 0x0008, 0x8200},
/* 65 */ {0, 0x0001, 0x8200},
/* 68 */ {0, 0x000e, 0x8201},
/* 69 */ {0, 0x0008, 0x8200},
/* 70 */ {0, 0x0001, 0x8200},
/* 73 */ {0, 0x0007, 0x8201},
/* 74 */ {0, 0x0008, 0x8200},
/* 75 */ {0, 0x0001, 0x8200},
/* 78 */ {0, 0x000f, 0x8201},
/* 79 */ {0, 0x0008, 0x8200},
/* 80 */ {0, 0x0001, 0x8200},

/* 84 */ {0, 0x0018, 0x8660},
/* 85 */ {0, 0x0010, 0x8201},

/* 86 */ {0, 0x0008, 0x8200},
/* 87 */ {0, 0x0001, 0x8200},
/* 90 */ {0, 0x0011, 0x8201},
/* 91 */ {0, 0x0008, 0x8200},
/* 92 */ {0, 0x0001, 0x8200},

/* 95 */ {0, 0x0000, 0x86b0},
/* 96 */ {0, 0x0034, 0x86b1},
/* 97 */ {0, 0x0000, 0x86b2},
/* 98 */ {0, 0x0049, 0x86b3},
/* 99 */ {0, 0x0000, 0x86b4},
/* 100 */ {0, 0x0000, 0x86b4},

/* 101 */ {0, 0x0012, 0x8201},
/* 102 */ {0, 0x0008, 0x8200},
/* 103 */ {0, 0x0001, 0x8200},
/* 106 */ {0, 0x0013, 0x8201},
/* 107 */ {0, 0x0008, 0x8200},
/* 108 */ {0, 0x0001, 0x8200},

/* 111 */ {0, 0x0001, 0x86b0},
/* 112 */ {0, 0x00aa, 0x86b1},
/* 113 */ {0, 0x0000, 0x86b2},
/* 114 */ {0, 0x00e4, 0x86b3},
/* 115 */ {0, 0x0000, 0x86b4},
/* 116 */ {0, 0x0000, 0x86b4},

/* 118 */ {0, 0x0018, 0x8660},

/* 119 */ {0, 0x0090, 0x8110},
/* 120 */ {0, 0x0001, 0x8114},
/* 121 */ {0, 0x0001, 0x8114},
/* 122 */ {0, 0x0001, 0x8114},
/* 123 */ {0, 0x0003, 0x8114},

/* 124 */ {0, 0x0080, 0x8804},
/* 157 */ {0, 0x0003, 0x8801},
/* 158 */ {0, 0x0012, 0x8800},
/* 160 */ {0, 0x0004, 0x8801},
/* 161 */ {0, 0x0005, 0x8800},
/* 163 */ {0, 0x0005, 0x8801},
/* 164 */ {0, 0x0000, 0x8800},
/* 166 */ {0, 0x0006, 0x8801},
/* 167 */ {0, 0x0000, 0x8800},
/* 169 */ {0, 0x0007, 0x8801},
/* 170 */ {0, 0x0000, 0x8800},
/* 172 */ {0, 0x0008, 0x8801},
/* 173 */ {0, 0x0005, 0x8800},
/* 175 */ {0, 0x000a, 0x8700},
/* 176 */ {0, 0x000e, 0x8801},
/* 177 */ {0, 0x0004, 0x8800},
/* 179 */ {0, 0x0005, 0x8801},
/* 180 */ {0, 0x0047, 0x8800},
/* 182 */ {0, 0x0006, 0x8801},
/* 183 */ {0, 0x0000, 0x8800},
/* 185 */ {0, 0x0007, 0x8801},
/* 186 */ {0, 0x00c0, 0x8800},
/* 188 */ {0, 0x0008, 0x8801},
/* 189 */ {0, 0x0003, 0x8800},
/* 191 */ {0, 0x0013, 0x8801},
/* 192 */ {0, 0x0001, 0x8800},
/* 194 */ {0, 0x0009, 0x8801},
/* 195 */ {0, 0x0000, 0x8800},
/* 197 */ {0, 0x000a, 0x8801},
/* 198 */ {0, 0x0000, 0x8800},
/* 200 */ {0, 0x000b, 0x8801},
/* 201 */ {0, 0x0000, 0x8800},
/* 203 */ {0, 0x000c, 0x8801},
/* 204 */ {0, 0x0000, 0x8800},
/* 206 */ {0, 0x000e, 0x8801},
/* 207 */ {0, 0x0004, 0x8800},
/* 209 */ {0, 0x000f, 0x8801},
/* 210 */ {0, 0x0000, 0x8800},
/* 212 */ {0, 0x0010, 0x8801},
/* 213 */ {0, 0x0006, 0x8800},
/* 215 */ {0, 0x0011, 0x8801},
/* 216 */ {0, 0x0006, 0x8800},
/* 218 */ {0, 0x0012, 0x8801},
/* 219 */ {0, 0x0000, 0x8800},
/* 221 */ {0, 0x0013, 0x8801},
/* 222 */ {0, 0x0001, 0x8800},

/* 224 */ {0, 0x000a, 0x8700},
/* 225 */ {0, 0x0000, 0x8702},
/* 226 */ {0, 0x0000, 0x8703},
/* 227 */ {0, 0x00c2, 0x8704},
/* 228 */ {0, 0x0001, 0x870c},

/* 229 */ {0, 0x0044, 0x8600},
/* 230 */ {0, 0x0002, 0x8606},
/* 231 */ {0, 0x0064, 0x8607},
/* 232 */ {0, 0x003a, 0x8601},
/* 233 */ {0, 0x0008, 0x8602},
/* 234 */ {0, 0x0044, 0x8600},
/* 235 */ {0, 0x0018, 0x8617},
/* 236 */ {0, 0x0008, 0x8618},
/* 237 */ {0, 0x00a1, 0x8656},
/* 238 */ {0, 0x0004, 0x865b},
/* 239 */ {0, 0x0002, 0x865c},
/* 240 */ {0, 0x0058, 0x865d},
/* 241 */ {0, 0x0048, 0x865e},
/* 242 */ {0, 0x0012, 0x8608},
/* 243 */ {0, 0x002c, 0x8609},
/* 244 */ {0, 0x0002, 0x860a},
/* 245 */ {0, 0x002c, 0x860b},
/* 246 */ {0, 0x00db, 0x860c},
/* 247 */ {0, 0x00f9, 0x860d},
/* 248 */ {0, 0x00f1, 0x860e},
/* 249 */ {0, 0x00e3, 0x860f},
/* 250 */ {0, 0x002c, 0x8610},
/* 251 */ {0, 0x006c, 0x8651},
/* 252 */ {0, 0x0041, 0x8652},
/* 253 */ {0, 0x0059, 0x8653},
/* 254 */ {0, 0x0040, 0x8654},
/* 255 */ {0, 0x00fa, 0x8611},
/* 256 */ {0, 0x00ff, 0x8612},
/* 257 */ {0, 0x00f8, 0x8613},
/* 258 */ {0, 0x0000, 0x8614},
/* 259 */ {0, 0x0001, 0x863f},
/* 260 */ {0, 0x0000, 0x8640},
/* 261 */ {0, 0x0026, 0x8641},
/* 262 */ {0, 0x0045, 0x8642},
/* 263 */ {0, 0x0060, 0x8643},
/* 264 */ {0, 0x0075, 0x8644},
/* 265 */ {0, 0x0088, 0x8645},
/* 266 */ {0, 0x009b, 0x8646},
/* 267 */ {0, 0x00b0, 0x8647},
/* 268 */ {0, 0x00c5, 0x8648},
/* 269 */ {0, 0x00d2, 0x8649},
/* 270 */ {0, 0x00dc, 0x864a},
/* 271 */ {0, 0x00e5, 0x864b},
/* 272 */ {0, 0x00eb, 0x864c},
/* 273 */ {0, 0x00f0, 0x864d},
/* 274 */ {0, 0x00f6, 0x864e},
/* 275 */ {0, 0x00fa, 0x864f},
/* 276 */ {0, 0x00ff, 0x8650},
/* 277 */ {0, 0x0060, 0x8657},
/* 278 */ {0, 0x0010, 0x8658},
/* 279 */ {0, 0x0018, 0x8659},
/* 280 */ {0, 0x0005, 0x865a},
/* 281 */ {0, 0x0018, 0x8660},
/* 282 */ {0, 0x0003, 0x8509},
/* 283 */ {0, 0x0011, 0x850a},
/* 284 */ {0, 0x0032, 0x850b},
/* 285 */ {0, 0x0010, 0x850c},
/* 286 */ {0, 0x0021, 0x850d},
/* 287 */ {0, 0x0001, 0x8500},
/* 288 */ {0, 0x0000, 0x8508},
/* 289 */ {0, 0x0012, 0x8608},
/* 290 */ {0, 0x002c, 0x8609},
/* 291 */ {0, 0x0002, 0x860a},
/* 292 */ {0, 0x0039, 0x860b},
/* 293 */ {0, 0x00d0, 0x860c},
/* 294 */ {0, 0x00f7, 0x860d},
/* 295 */ {0, 0x00ed, 0x860e},
/* 296 */ {0, 0x00db, 0x860f},
/* 297 */ {0, 0x0039, 0x8610},
/* 298 */ {0, 0x0012, 0x8657},
/* 299 */ {0, 0x000c, 0x8619},
/* 300 */ {0, 0x0004, 0x861a},
/* 301 */ {0, 0x00a1, 0x8656},
/* 302 */ {0, 0x00c8, 0x8615},
/* 303 */ {0, 0x0032, 0x8616},

/* 306 */ {0, 0x0030, 0x8112},
/* 313 */ {0, 0x0020, 0x8112},
/* 314 */ {0, 0x0020, 0x8112},
/* 315 */ {0, 0x000f, 0x8402},
/* 316 */ {0, 0x0000, 0x8403},

/* 317 */ {0, 0x0090, 0x8110},
/* 318 */ {0, 0x0001, 0x8114},
/* 319 */ {0, 0x0001, 0x8114},
/* 320 */ {0, 0x0001, 0x8114},
/* 321 */ {0, 0x0003, 0x8114},
/* 322 */ {0, 0x0080, 0x8804},

/* 355 */ {0, 0x0003, 0x8801},
/* 356 */ {0, 0x0012, 0x8800},
/* 358 */ {0, 0x0004, 0x8801},
/* 359 */ {0, 0x0005, 0x8800},
/* 361 */ {0, 0x0005, 0x8801},
/* 362 */ {0, 0x0047, 0x8800},
/* 364 */ {0, 0x0006, 0x8801},
/* 365 */ {0, 0x0000, 0x8800},
/* 367 */ {0, 0x0007, 0x8801},
/* 368 */ {0, 0x00c0, 0x8800},
/* 370 */ {0, 0x0008, 0x8801},
/* 371 */ {0, 0x0003, 0x8800},
/* 373 */ {0, 0x000a, 0x8700},
/* 374 */ {0, 0x000e, 0x8801},
/* 375 */ {0, 0x0004, 0x8800},
/* 377 */ {0, 0x0005, 0x8801},
/* 378 */ {0, 0x0047, 0x8800},
/* 380 */ {0, 0x0006, 0x8801},
/* 381 */ {0, 0x0000, 0x8800},
/* 383 */ {0, 0x0007, 0x8801},
/* 384 */ {0, 0x00c0, 0x8800},
/* 386 */ {0, 0x0008, 0x8801},
/* 387 */ {0, 0x0003, 0x8800},
/* 389 */ {0, 0x0013, 0x8801},
/* 390 */ {0, 0x0001, 0x8800},
/* 392 */ {0, 0x0009, 0x8801},
/* 393 */ {0, 0x0000, 0x8800},
/* 395 */ {0, 0x000a, 0x8801},
/* 396 */ {0, 0x0000, 0x8800},
/* 398 */ {0, 0x000b, 0x8801},
/* 399 */ {0, 0x0000, 0x8800},
/* 401 */ {0, 0x000c, 0x8801},
/* 402 */ {0, 0x0000, 0x8800},
/* 404 */ {0, 0x000e, 0x8801},
/* 405 */ {0, 0x0004, 0x8800},
/* 407 */ {0, 0x000f, 0x8801},
/* 408 */ {0, 0x0000, 0x8800},
/* 410 */ {0, 0x0010, 0x8801},
/* 411 */ {0, 0x0006, 0x8800},
/* 413 */ {0, 0x0011, 0x8801},
/* 414 */ {0, 0x0006, 0x8800},
/* 416 */ {0, 0x0012, 0x8801},
/* 417 */ {0, 0x0000, 0x8800},
/* 419 */ {0, 0x0013, 0x8801},
/* 420 */ {0, 0x0001, 0x8800},
/* 422 */ {0, 0x000a, 0x8700},
/* 423 */ {0, 0x0000, 0x8702},
/* 424 */ {0, 0x0000, 0x8703},
/* 425 */ {0, 0x00c2, 0x8704},
/* 426 */ {0, 0x0001, 0x870c},
/* 427 */ {0, 0x0044, 0x8600},
/* 428 */ {0, 0x0002, 0x8606},
/* 429 */ {0, 0x0064, 0x8607},
/* 430 */ {0, 0x003a, 0x8601},
/* 431 */ {0, 0x0008, 0x8602},
/* 432 */ {0, 0x0044, 0x8600},
/* 433 */ {0, 0x0018, 0x8617},
/* 434 */ {0, 0x0008, 0x8618},
/* 435 */ {0, 0x00a1, 0x8656},
/* 436 */ {0, 0x0004, 0x865b},
/* 437 */ {0, 0x0002, 0x865c},
/* 438 */ {0, 0x0058, 0x865d},
/* 439 */ {0, 0x0048, 0x865e},
/* 440 */ {0, 0x0012, 0x8608},
/* 441 */ {0, 0x002c, 0x8609},
/* 442 */ {0, 0x0002, 0x860a},
/* 443 */ {0, 0x002c, 0x860b},
/* 444 */ {0, 0x00db, 0x860c},
/* 445 */ {0, 0x00f9, 0x860d},
/* 446 */ {0, 0x00f1, 0x860e},
/* 447 */ {0, 0x00e3, 0x860f},
/* 448 */ {0, 0x002c, 0x8610},
/* 449 */ {0, 0x006c, 0x8651},
/* 450 */ {0, 0x0041, 0x8652},
/* 451 */ {0, 0x0059, 0x8653},
/* 452 */ {0, 0x0040, 0x8654},
/* 453 */ {0, 0x00fa, 0x8611},
/* 454 */ {0, 0x00ff, 0x8612},
/* 455 */ {0, 0x00f8, 0x8613},
/* 456 */ {0, 0x0000, 0x8614},
/* 457 */ {0, 0x0001, 0x863f},
/* 458 */ {0, 0x0000, 0x8640},
/* 459 */ {0, 0x0026, 0x8641},
/* 460 */ {0, 0x0045, 0x8642},
/* 461 */ {0, 0x0060, 0x8643},
/* 462 */ {0, 0x0075, 0x8644},
/* 463 */ {0, 0x0088, 0x8645},
/* 464 */ {0, 0x009b, 0x8646},
/* 465 */ {0, 0x00b0, 0x8647},
/* 466 */ {0, 0x00c5, 0x8648},
/* 467 */ {0, 0x00d2, 0x8649},
/* 468 */ {0, 0x00dc, 0x864a},
/* 469 */ {0, 0x00e5, 0x864b},
/* 470 */ {0, 0x00eb, 0x864c},
/* 471 */ {0, 0x00f0, 0x864d},
/* 472 */ {0, 0x00f6, 0x864e},
/* 473 */ {0, 0x00fa, 0x864f},
/* 474 */ {0, 0x00ff, 0x8650},
/* 475 */ {0, 0x0060, 0x8657},
/* 476 */ {0, 0x0010, 0x8658},
/* 477 */ {0, 0x0018, 0x8659},
/* 478 */ {0, 0x0005, 0x865a},
/* 479 */ {0, 0x0018, 0x8660},
/* 480 */ {0, 0x0003, 0x8509},
/* 481 */ {0, 0x0011, 0x850a},
/* 482 */ {0, 0x0032, 0x850b},
/* 483 */ {0, 0x0010, 0x850c},
/* 484 */ {0, 0x0021, 0x850d},
/* 485 */ {0, 0x0001, 0x8500},
/* 486 */ {0, 0x0000, 0x8508},

/* 487 */ {0, 0x0012, 0x8608},
/* 488 */ {0, 0x002c, 0x8609},
/* 489 */ {0, 0x0002, 0x860a},
/* 490 */ {0, 0x0039, 0x860b},
/* 491 */ {0, 0x00d0, 0x860c},
/* 492 */ {0, 0x00f7, 0x860d},
/* 493 */ {0, 0x00ed, 0x860e},
/* 494 */ {0, 0x00db, 0x860f},
/* 495 */ {0, 0x0039, 0x8610},
/* 496 */ {0, 0x0012, 0x8657},
/* 497 */ {0, 0x0064, 0x8619},

/* This line starts it all, it is not needed here */
/* since it has been build into the driver*/
    /*590  */ {0, 0x0030, 0x8112},
#endif

    {0, 0, 0}
};

/*
 * Initialization data for Creative Webcam Vista
 */
static __u16 spca508_vista_init_data[][3] = {
    {0, 0x0008, 0x8200},	/* Clear register */
    {0, 0x0000, 0x870b},	/* Reset CTL3 */
    {0, 0x0020, 0x8112},	/* Video Drop packet enable */
    {0, 0x0003, 0x8111},	/* Soft Reset compression, memory, TG & CDSP */
    {0, 0x0000, 0x8110},	/* Disable everything */
    {0, 0x0000, 0x8114},	/* Software GPIO output data */
    {0, 0x0000, 0x8114},

    {0, 0x0003, 0x8111},
    {0, 0x0000, 0x8111},
    {0, 0x0090, 0x8110},	/* Enable: SSI output, External 2X clock output */
    {0, 0x0020, 0x8112},
    {0, 0x0000, 0x8114},
    {0, 0x0001, 0x8114},
    {0, 0x0001, 0x8114},
    {0, 0x0001, 0x8114},
    {0, 0x0003, 0x8114},

    {0, 0x000f, 0x8402},	/* Memory bank Address */
    {0, 0x0000, 0x8403},	/* Memory bank Address */
    {0, 0x00ba, 0x8804},	/* SSI Slave address */
    {0, 0x0010, 0x8802},	/* 93.75kHz SSI Clock Two DataByte */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},	/* Will write 2 bytes (DATA1+DATA2) */
    {0, 0x0020, 0x8801},	/* Register address for SSI read/write */
    {0, 0x0044, 0x8805},	/* DATA2 */
    {0, 0x0004, 0x8800},	/* DATA1 -> write triggered */
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0009, 0x8801},
    {0, 0x0042, 0x8805},
    {0, 0x0001, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x003c, 0x8801},
    {0, 0x0001, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0001, 0x8801},
    {0, 0x000a, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0002, 0x8801},
    {0, 0x0000, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0003, 0x8801},
    {0, 0x0027, 0x8805},
    {0, 0x0001, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0004, 0x8801},
    {0, 0x0065, 0x8805},
    {0, 0x0001, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0005, 0x8801},
    {0, 0x0003, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0006, 0x8801},
    {0, 0x001c, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0007, 0x8801},
    {0, 0x002a, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x000e, 0x8801},
    {0, 0x0000, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0028, 0x8801},
    {0, 0x002e, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0039, 0x8801},
    {0, 0x0013, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x003b, 0x8801},
    {0, 0x000c, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0035, 0x8801},
    {0, 0x0028, 0x8805},
    {0, 0x0000, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */
    /* READ { 0, 0x0001, 0x8802 } ->
       0000: 10  */
    {0, 0x0010, 0x8802},
    {0, 0x0009, 0x8801},
    {0, 0x0042, 0x8805},
    {0, 0x0001, 0x8800},
    /* READ { 0, 0x0001, 0x8803 } ->
       0000: 00  */

    {0, 0x0050, 0x8703},
    {0, 0x0002, 0x8704},	/* External input CKIx1 */
    {0, 0x0001, 0x870C},	/* Select CKOx2 output */
    {0, 0x009A, 0x8600},	/* Line memory Read Counter (L) */
    {0, 0x0001, 0x8606},	/* 1 Line memory Read Counter (H) Result: (d)410 */
    {0, 0x0023, 0x8601},
    {0, 0x0010, 0x8602},
    {0, 0x000A, 0x8603},
    {0, 0x009A, 0x8600},
    {0, 0x0001, 0x865B},	/* 1 Horizontal Offset for Valid Pixel(L) */
    {0, 0x0003, 0x865C},	/* Vertical offset for valid lines (L) */
    {0, 0x0058, 0x865D},	/* Horizontal valid pixels window (L) */
    {0, 0x0048, 0x865E},	/* Vertical valid lines window (L) */
    {0, 0x0000, 0x865F},

    {0, 0x0006, 0x8660},	/* Enable nibble data input, select nibble input order */

    {0, 0x0013, 0x8608},	/* A11 Coeficients for color correction */
    {0, 0x0028, 0x8609},	/* Note: these values are confirmed at the end of array */
    {0, 0x0005, 0x860A},	/* ... */
    {0, 0x0025, 0x860B},
    {0, 0x00E1, 0x860C},
    {0, 0x00FA, 0x860D},
    {0, 0x00F4, 0x860E},
    {0, 0x00E8, 0x860F},
    {0, 0x0025, 0x8610},	/* A33 Coef. */
    {0, 0x00FC, 0x8611},	/* White balance offset: R */
    {0, 0x0001, 0x8612},	/* White balance offset: Gr */
    {0, 0x00FE, 0x8613},	/* White balance offset: B */
    {0, 0x0000, 0x8614},	/* White balance offset: Gb */

    {0, 0x0064, 0x8651},	/* R gain for white balance (L) */
    {0, 0x0040, 0x8652},	/* Gr gain for white balance (L) */
    {0, 0x0066, 0x8653},	/* B gain for white balance (L) */
    {0, 0x0040, 0x8654},	/* Gb gain for white balance (L) */
    {0, 0x0001, 0x863F},	/* Enable fixed gamma correction */

    {0, 0x00A1, 0x8656},	/* Size - Window1: 256x256, Window2: 128x128 */
    /* UV division: UV no change, Enable New edge enhancement */
    {0, 0x0018, 0x8657},	/* Edge gain high threshold */
    {0, 0x0020, 0x8658},	/* Edge gain low threshold */
    {0, 0x000A, 0x8659},	/* Edge bandwidth high threshold */
    {0, 0x0005, 0x865A},	/* Edge bandwidth low threshold */
    {0, 0x0064, 0x8607},	/* UV filter enable */

    {0, 0x0016, 0x8660},
    {0, 0x0000, 0x86B0},	/* Bad pixels compensation address */
    {0, 0x00DC, 0x86B1},	/* X coord for bad pixels compensation (L) */
    {0, 0x0000, 0x86B2},
    {0, 0x0009, 0x86B3},	/* Y coord for bad pixels compensation (L) */
    {0, 0x0000, 0x86B4},

    {0, 0x0001, 0x86B0},
    {0, 0x00F5, 0x86B1},
    {0, 0x0000, 0x86B2},
    {0, 0x00C6, 0x86B3},
    {0, 0x0000, 0x86B4},

    {0, 0x0002, 0x86B0},
    {0, 0x001C, 0x86B1},
    {0, 0x0001, 0x86B2},
    {0, 0x00D7, 0x86B3},
    {0, 0x0000, 0x86B4},

    {0, 0x0003, 0x86B0},
    {0, 0x001C, 0x86B1},
    {0, 0x0001, 0x86B2},
    {0, 0x00D8, 0x86B3},
    {0, 0x0000, 0x86B4},

    {0, 0x0004, 0x86B0},
    {0, 0x001D, 0x86B1},
    {0, 0x0001, 0x86B2},
    {0, 0x00D8, 0x86B3},
    {0, 0x0000, 0x86B4},
    {0, 0x001E, 0x8660},

    /* READ { 0, 0x0000, 0x8608 } ->
       0000: 13  */
    /* READ { 0, 0x0000, 0x8609 } ->
       0000: 28  */
    /* READ { 0, 0x0000, 0x8610 } ->
       0000: 05  */
    /* READ { 0, 0x0000, 0x8611 } ->
       0000: 25  */
    /* READ { 0, 0x0000, 0x8612 } ->
       0000: e1  */
    /* READ { 0, 0x0000, 0x8613 } ->
       0000: fa  */
    /* READ { 0, 0x0000, 0x8614 } ->
       0000: f4  */
    /* READ { 0, 0x0000, 0x8615 } ->
       0000: e8  */
    /* READ { 0, 0x0000, 0x8616 } ->
       0000: 25  */

    {0, 0, 0}
};

static int config_spca508(struct usb_spca50x *spca50x)
{
    struct usb_device *dev = spca50x->dev;
    int data1, data2;

    // Read frm global register the USB product and vendor IDs, just to
    // prove that we can communicate with the device.  This works, which
    // confirms at we are communicating properly and that the device
    // is a 508.
    data1 = spca50x_reg_read(dev, 0, 0x8104, 1);
    if (data1 < 0)
	PDEBUG(1, "Error reading USB Vendor ID from Global register");
    data2 = spca50x_reg_read(dev, 0, 0x8105, 1);
    if (data2 < 0)
	PDEBUG(1, "Error reading USB Vendor ID from Global register");
    PDEBUG(1, "Read from GLOBAL: USB Vendor ID 0x%02x%02x", data2, data1);

    data1 = spca50x_reg_read(dev, 0, 0x8106, 1);
    if (data1 < 0)
	PDEBUG(1, "Error reading USB Product ID from Global register");
    data2 = spca50x_reg_read(dev, 0, 0x8107, 1);
    if (data2 < 0)
	PDEBUG(1, "Error reading USB Product ID from Global register");
    PDEBUG(1, "Read from GLOBAL: USB Product ID 0x%02x%02x", data2, data1);

    data1 = spca50x_reg_read(dev, 0, 0x8621, 1);
    if (data1 < 0)
	PDEBUG(1,
	       "Error reading Window 1 Average Luminance from Global register");
    PDEBUG(1, "Read from GLOBAL: Window 1 average luminance %3d", data1);

    switch (spca50x->desc) {
    case ViewQuestVQ110:
	{
	    if (spca50x_write_vector(spca50x, spca508_init_data))
		return -1;
	    break;
	}
    case MicroInnovationIC200:
    case IntelEasyPCCamera:
	{
	    if (spca50x_write_vector(spca50x, spca508cs110_init_data))
		return -1;
	    break;
	}
    case HamaUSBSightcam:
	{
	    if (spca50x_write_vector(spca50x, spca508_sightcam_init_data))
		return -1;
	    break;
	}
    case HamaUSBSightcam2:
	{
	    if (spca50x_write_vector(spca50x, spca508_sightcam2_init_data))
		return -1;
	    break;
	}
    case CreativeVista:
	{
	    if (spca50x_write_vector(spca50x, spca508_vista_init_data))
		return -1;
	    break;
	}
    default:
	return -1;
    }
    return 0;			// success
}

#endif				/* SPCA508_INIT_H */
