/////////////////////////////////////////////////////////////////////////////
// GliD3D_Buffer.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "GliD3D.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

FX_ENTRY void FX_CALL grBufferClear (GrColor_t color, GrAlpha_t alpha, FxU16 depth)
{
	TRACEFUNCTION ("grBufferClear");

	FlushTriangleVertex();

	DWORD cr = grsubConvColor (color);
	glClearColor (((cr & 0xff0000) >> 16)*f_255,
		((cr & 0xff00) >>  8)*f_255,
		(cr & 0xff)*f_255,
		((cr & 0xff000000) >> 24)*f_255);

	if(g_gr_state.depth_buffer_mode != GR_DEPTHBUFFER_DISABLE){
		glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	}else{
		glClear (GL_COLOR_BUFFER_BIT);
	}
}

FX_ENTRY int FX_CALL grBufferNumPending (void)
{
	TRACEFUNCTION ("grBufferNumPending");

	// First of all return 0.
	return 0;
}

FX_ENTRY void FX_CALL grBufferSwap (int swap_interval)
{
	TRACEFUNCTION ("grBufferSwap");
	FlushTriangleVertex();

	glFlush ();
	//glFinish ();
	SwapBuffers (g_gr_hDC);

#ifdef DEBUGDLL
	GLenum err;
	if((err=glGetError())!= GL_NO_ERROR) {
		char	mbuf[256];
		sprintf(mbuf, "glError : <%d>", err);	//(char*)gluErrorString(err));
		ERROROUT(mbuf);
	}
#endif	//DEBUGDLL
}

FX_ENTRY void FX_CALL grRenderBuffer (GrBuffer_t buffer)
{
	TRACEFUNCTION ("grRenderBuffer");

	if (g_gr_state.render_buffer == buffer)
		return;
	FlushTriangleVertex();

	g_gr_state.render_buffer = buffer;
	switch (buffer)
	{
	case GR_BUFFER_FRONTBUFFER:
		glDrawBuffer (GL_FRONT);
		break;
	case GR_BUFFER_BACKBUFFER:
		glDrawBuffer (GL_BACK);
		break;
	}
	//glFlush ();
}

/////////////////////////////////////////////////////////////////////////////
