/////////////////////////////////////////////////////////////////////////////
// GliD3D_Config_SpecialEffect.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "GliD3D.h"
#include "gl2ideal.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

#define nTmu 0

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

void InitBlendMap(void)
{
	src_blendmap[GR_BLEND_ZERO] = GL_ZERO;
	src_blendmap[GR_BLEND_SRC_ALPHA] = GL_SRC_ALPHA;
	src_blendmap[GR_BLEND_DST_COLOR] = GL_DST_COLOR;
	src_blendmap[GR_BLEND_DST_ALPHA] = GL_DST_ALPHA;
	src_blendmap[GR_BLEND_ONE] = GL_ONE;
	src_blendmap[GR_BLEND_ONE_MINUS_SRC_ALPHA] = GL_ONE_MINUS_SRC_ALPHA;
	src_blendmap[GR_BLEND_ONE_MINUS_DST_COLOR] = GL_ONE_MINUS_DST_COLOR;
	src_blendmap[GR_BLEND_ONE_MINUS_DST_ALPHA] = GL_ONE_MINUS_DST_ALPHA;
	src_blendmap[GR_BLEND_ALPHA_SATURATE] = GL_SRC_ALPHA_SATURATE;

	dst_blendmap[GR_BLEND_ZERO] = GL_ZERO;
	dst_blendmap[GR_BLEND_SRC_ALPHA] = GL_SRC_ALPHA;
	dst_blendmap[GR_BLEND_SRC_COLOR] = GL_SRC_COLOR;
	dst_blendmap[GR_BLEND_DST_ALPHA] = GL_DST_ALPHA;
	dst_blendmap[GR_BLEND_ONE] = GL_ONE;
	dst_blendmap[GR_BLEND_ONE_MINUS_SRC_ALPHA] = GL_ONE_MINUS_SRC_ALPHA;
	dst_blendmap[GR_BLEND_ONE_MINUS_SRC_COLOR] = GL_ONE_MINUS_SRC_COLOR;
	dst_blendmap[GR_BLEND_ONE_MINUS_DST_ALPHA] = GL_ONE_MINUS_DST_ALPHA;
	dst_blendmap[GR_BLEND_PREFOG_COLOR] = GL_SRC_COLOR;
}

FX_ENTRY void FX_CALL grAlphaBlendFunction (GrAlphaBlendFnc_t rgb_sf,
	GrAlphaBlendFnc_t rgb_df, GrAlphaBlendFnc_t alpha_sf, GrAlphaBlendFnc_t alpha_df)
{
	TRACEFUNCTION ("grAlphaBlendFunction");

	g_gr_state.alpha_blend_function_rgb_sf = rgb_sf;
	g_gr_state.alpha_blend_function_rgb_df = rgb_df;
//	g_gr_state.alpha_blend_function_alpha_sf = alpha_sf;
//	g_gr_state.alpha_blend_function_alpha_df = alpha_df;
	
	flushDrawState = 1;
}

FX_ENTRY void FX_CALL grAlphaCombine (GrCombineFunction_t function,
	GrCombineFactor_t factor, GrCombineLocal_t local, GrCombineOther_t other,
	FxBool invert)
{
	TRACEFUNCTION ("grAlphaCombine");

	i_grAlphaCombine(function, factor, local, other, invert);
	flushDrawState = 1;
}

FX_ENTRY void FX_CALL grAlphaControlsITRGBLighting (FxBool enable)
{
	TRACEFUNCTION ("grAlphaControlsITRGBLighting");
}

FX_ENTRY void FX_CALL grAlphaTestFunction (GrCmpFnc_t function)
{
	TRACEFUNCTION ("grAlphaTestFunction");

	g_gr_state.alpha_test_function = function;
	flushDrawState = 1;
}

FX_ENTRY void FX_CALL grAlphaTestReferenceValue (GrAlpha_t value)
{
	TRACEFUNCTION ("grAlphaTestReferenceValue");

	g_gr_state.alpha_test_reference_value = value;
	flushDrawState = 1;
}

FX_ENTRY void FX_CALL grChromakeyMode (GrChromakeyMode_t mode)
{
	TRACEFUNCTION ("grChromakeyMode");

//	g_gr_state.chromakey_mode = mode;
}

FX_ENTRY void FX_CALL grChromakeyValue (GrColor_t value)
{
	TRACEFUNCTION ("grChromakeyValue");

/*	DWORD cr = grsubConvColor (value);
	g_gr_state.chromakey_value = cr;}*/
}

FX_ENTRY void FX_CALL grClipWindow (FxU32 minx, FxU32 miny, FxU32 maxx,
	FxU32 maxy)
{
	TRACEFUNCTION ("grClipWindow");
/*	FlushTriangleVertex();
	g_gr_state.clip_window_minx = minx;
	g_gr_state.clip_window_miny = miny;
	g_gr_state.clip_window_maxx = maxx;
	g_gr_state.clip_window_maxy = maxy;*/

}

FX_ENTRY void FX_CALL grColorCombine (GrCombineFunction_t function,
	GrCombineFactor_t factor, GrCombineLocal_t local, GrCombineOther_t other,
	FxBool invert)
{
	TRACEFUNCTION ("grColorCombine");

	i_grColorCombine(function, factor, local, other, invert);
	flushDrawState = 1;
}

FX_ENTRY void FX_CALL grColorMask (FxBool rgb, FxBool a)
{
	TRACEFUNCTION ("grColorMask");

	if (g_gr_state.color_mask_rgb==rgb && g_gr_state.color_mask_a == a)
		return;
	FlushTriangleVertex();
	g_gr_state.color_mask_rgb = rgb;
	g_gr_state.color_mask_a = a;
	glColorMask (rgb, rgb, rgb, a);

}

FX_ENTRY void FX_CALL grCullMode (GrCullMode_t mode)
{
	TRACEFUNCTION ("grCullMode");

	g_gr_state.cull_mode = mode;
	flushDrawState = 1;
}

FX_ENTRY void FX_CALL grConstantColorValue (GrColor_t value)
{
	TRACEFUNCTION ("grConstantColorValue");

	DWORD cr = grsubConvColor (value);

	g_gr_state.constant_color_value = cr;
	g_gr_state.constant_color.rgb.r = ((cr & 0xff0000) >> 16)*f_255;
	g_gr_state.constant_color.rgb.g = ((cr & 0x00ff00) >> 8)*f_255;
	g_gr_state.constant_color.rgb.b = (cr & 0x0000ff)*f_255;
	g_gr_state.constant_color.a = (cr >> 24)*f_255;

	SetTexEnvColor(g_gr_state.constant_color);

	if(static_color_mode == g_gr_state.color_combine_local){
		static_color = g_gr_state.constant_color;
	}
}

FX_ENTRY void FX_CALL grConstantColorValue4 (float a, float r, float g, float b)
{
	TRACEFUNCTION ("grConstantColorValue4");

	DWORD value = (((DWORD) a & 0xff) << 24) |
		(((DWORD) r & 0xff) << 16) |
		(((DWORD) g & 0xff) << 8) |
		(((DWORD) b & 0xff) << 0);
	DWORD cr = grsubConvColor (value);

	g_gr_state.constant_color_value = cr;
	g_gr_state.constant_color.rgb.r = r;
	g_gr_state.constant_color.rgb.g = g;
	g_gr_state.constant_color.rgb.b = b;
	g_gr_state.constant_color.a = a;

	SetTexEnvColor(g_gr_state.constant_color);

	if(static_color_mode == g_gr_state.color_combine_local){
		static_color = g_gr_state.constant_color;
	}
}

FX_ENTRY void FX_CALL grDepthBiasLevel (FxI16 level)
{
	TRACEFUNCTION ("grDepthBiasLevel");
}

FX_ENTRY void FX_CALL grDepthBufferFunction (GrCmpFnc_t function)
{
	TRACEFUNCTION ("grDepthBufferFunction");

	g_gr_state.depth_buffer_function = function;
	flushDrawState = 1;
}

FX_ENTRY void FX_CALL grDepthBufferMode (GrDepthBufferMode_t mode)
{
	TRACEFUNCTION ("grDepthBufferMode");

	if (g_gr_state.depth_buffer_mode == mode)
		return;
	FlushTriangleVertex();

	g_gr_state.depth_buffer_mode = mode;

	switch (mode)
	{
	case GR_DEPTHBUFFER_DISABLE:
		glDisable (GL_DEPTH_TEST);
		break;
	case GR_DEPTHBUFFER_ZBUFFER:
	case GR_DEPTHBUFFER_WBUFFER:
		glEnable (GL_DEPTH_TEST);
		break;
	default:
		ERROROUT ("COMPARE TO BIAS");
		break;
	}
}

FX_ENTRY void FX_CALL grDepthMask (FxBool mask)
{
	TRACEFUNCTION ("grDepthMask");

#ifndef NO_FLUSH_DEPTHMASK
	g_gr_state.depth_mask = mask;
	flushDrawState = 1;
#else
	if (g_gr_state.depth_mask == mask)
		return;
	FlushTriangleVertex();
	g_gr_state.depth_mask = mask;
	glDepthMask (mask);
#endif	// NO_FLUSH_DEPTHMASK
}

FX_ENTRY void FX_CALL grDisableAllEffects (void)
{
	TRACEFUNCTION ("grDisableAllEffects");

	grAlphaBlendFunction (GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ONE, GR_BLEND_ZERO);
	grAlphaTestFunction (GR_CMP_ALWAYS);
	grDepthBufferMode (GR_DEPTHBUFFER_DISABLE);
	//grChromakeyMode (GR_CHROMAKEY_DISABLE);
	grFogMode (GR_FOG_DISABLE);
}

FX_ENTRY void FX_CALL grDitherMode (GrDitherMode_t mode)
{
	TRACEFUNCTION ("grDitherMode");

//	g_gr_state.dither_mode = mode;
}

FX_ENTRY void FX_CALL grFogColorValue (GrColor_t fogcolor)
{
	TRACEFUNCTION ("grFogColorValue");

	FlushTriangleVertex();

	//g_gr_state.fog_color = fogcolor;
	DWORD	cr = grsubConvColor(fogcolor);
    GLfloat	color[] = {
		f_255*((cr >> 16) & 0xff),
		f_255*((cr >> 8) & 0xff),
		f_255*((cr) & 0xff),
		f_255*((cr >> 24) & 0xff)};
	glFogfv(GL_FOG_COLOR, color);
}

FX_ENTRY void FX_CALL grFogMode (GrFogMode_t mode)
{
	TRACEFUNCTION ("grFogMode");

	if(!g_gr_fogMode)
		return;
	
	FlushTriangleVertex();

	switch(mode){
	case GR_FOG_WITH_TABLE:
		glEnable(GL_FOG);
		break;
	case GR_FOG_DISABLE:
	default:
		glDisable(GL_FOG);
		break;
	};
}

FX_ENTRY void FX_CALL grFogTable (const GrFog_t ft[GR_FOG_TABLE_SIZE])
{
	TRACEFUNCTION ("grFogTable");

	if(!g_gr_fogMode)
		return;
	
	FlushTriangleVertex();
	float	*fp = (float*)(ft+4);
	if(ft[0] == 'L' && 1.0 <= fp[0]){
		if(fp[0] > 65536.0)
			fp[0] = 10.0;		// greater than precisionFix-depth
		glFogi(GL_FOG_MODE, GL_LINEAR);
#ifdef PRJ_PERSPECTIVE
		glFogf(GL_FOG_START, fp[0]);
		glFogf(GL_FOG_END, fp[1] * g_gr_fogFactor / 100);
#else
		glFogf(GL_FOG_START, fp[0] / 65536);
		glFogf(GL_FOG_END, fp[1] * g_gr_fogFactor / 100 / 65536);
#endif // PRJ_PERSPECTIVE
	}else if(ft[0] == 'E'){
		glFogi(GL_FOG_MODE, GL_EXP);
		glFogf(GL_FOG_DENSITY, fp[0] / 65536);
	}else if(ft[0] == 'e'){
		glFogi(GL_FOG_MODE, GL_EXP2);
		glFogf(GL_FOG_DENSITY, fp[0] / 65536);
	}else{
		glDisable(GL_FOG);
	}
}

FX_ENTRY void FX_CALL grGammaCorrectionValue (float value)
{
	TRACEFUNCTION ("grGammaCorrectionValue");
}

FX_ENTRY void FX_CALL grSplash (float x, float y, float width, float height,
	FxU32 frame)
{
	TRACEFUNCTION ("grSplash");
}

/////////////////////////////////////////////////////////////////////////////
