:
# Copyright (c) 1992, Boca Research, Inc.

PATH=/etc:/bin:/usr/bin
LANG=english_us.ascii
export PATH LANG

: ${OK=0} ${FAIL=1} ${TRUE=0} ${FALSE=1}

# Function Definitions
#########################

# ---------- STANDARD ROUTINES -------- These routines are commen to scripts
#					requiring kernel relinking.
# Define traps for critical and non critical code.
set_trap ()  {	
	trap 'echo "\nInterrupted! Exiting ..."; cleanup 1' 1 2 3 15
}

unset_trap ()  {
	trap '' 1 2 3 15
}
 
# Remove temp files and exit with the status passed as argument
cleanup () {
	trap '' 1 2 3 15
	[ "$tmp" ] && rm -f $tmp*
	exit $1
}

# Print an error message
error () {
	echo "\nError: $*" >&2
	return $FAIL
}


# main

set_trap
mkdev bocaboard
unset_trap
exit 0

