/* Copyright (c) 1995 ADVANCED MICRO DEVICES, INC. All Rights Reserved.
** This software is unpblished and contains the trade secrets and
** confidential proprietary information of AMD. Unless otherwise provided
** in the Software Agreement associated herewith, it is licensed in confidence
** "AS IS" and is not to be reproduced in whole or part by any means except
** for backup. Use, duplication, or disclosure by the Government is subject
** to the restrictions in paragraph (b) (3) (B) of the Rights in Technical
** Data and Computer Software clause in DFAR 52.227-7013 (a) (Oct 1988).
** Software owned by Advanced Micro Devices, Inc., 901 Thompson Place,
** Sunnyvale, CA 94088.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <time.h>
#include <direct.h>
#include <errno.h>

extern "C" {
#include <dmiapi.h>
#include "dosins.h"
}

#include "dosinsui.hpp"

TDosInstl::TDosInstl()
{
  iAtrValIndex=0;
  memset(atAtrsToMod,0,sizeof(TAtrVal)*MAXATRS);
}

TDosInstl::~TDosInstl()
{
  register int i;
  for(i=0;i<MAXATRS&&atAtrsToMod[i].pcAtrName!=NULL;i++){
    // Code doesn't allow for a pcAtrName ptr without a pcNewValue ptr.
    delete atAtrsToMod[i].pcAtrName;
    delete atAtrsToMod[i].pcNewValue;
    }
}

TBool TDosInstl::setNextAtrVal(char* pcAttribute,char* pcValue,TType tType)
{
  TBool bRetVal=_false;
  atAtrsToMod[iAtrValIndex].pcAtrName=new char[strlen(pcAttribute)+1];
  if(atAtrsToMod[iAtrValIndex].pcAtrName!=NULL){
    atAtrsToMod[iAtrValIndex].pcNewValue=new char[strlen(pcValue)+1];
    if(atAtrsToMod[iAtrValIndex].pcNewValue!=NULL){
      bRetVal=_true;
      strcpy(atAtrsToMod[iAtrValIndex].pcAtrName,pcAttribute);
      strcpy(atAtrsToMod[iAtrValIndex].pcNewValue,pcValue);
      atAtrsToMod[iAtrValIndex].tType=tType;
      iAtrValIndex+=1;
      }
    else{
      delete atAtrsToMod[iAtrValIndex].pcAtrName;
      atAtrsToMod[iAtrValIndex].pcAtrName=NULL;
      }
    }
  return bRetVal;
}

/*  Set TRUE by the callback function when invoked by the service layer. */
static TBool ConfirmFlag;

/*  Imported functions. */
int ScanInputBfr(char**, char*);

//--------------------------------------------------------------------------

int AtrIndex(char* pcAtrName,TAtrVal* ptAtrNameAndValList)
{
    register int i=0;
    do  {
        if(stricmp(pcAtrName,ptAtrNameAndValList[i].pcAtrName)==0) break;
        }while(ptAtrNameAndValList[++i].pcAtrName);
    return i;
}

//---------------------------------------------------------------------------

TErrCode makePath(char* pcDstPath)
{
  char  bfr[DOSPATHBFRLEN];
  while(1){
    strcpy(bfr,pcDstPath);
    *my_strrchr(bfr,'\\')='\0';
    // Once the specified directory exists, we can exit.
    if(file_exists(bfr))
      return errOk;
    // Scanning backwards, try to create each component of the desired
    // sub-directory in the path.
    while(_mkdir(bfr)) {
      if(errno==EACCES){
        sprintf(bfr,
          "\n"
          "The path is invalid (a portion of the path spec most\n"
          "likely designates an existing file). Please correct the\n"
          "error prior to continuing.");
        messageBox(bfr,ERR_PRESS_KEY);
        return errAccess;
        }
      *my_strrchr(bfr,'\\')='\0';
      }
    }
}

//---------------------------------------------------------------------------

extern "C" TErrCode _cdecl doFileCopy(char*,char*);

TBool TDosInstl::DoInstall(void)
{
  TBool                     bDone=_false;
  TBool                     bRetVal=_false;
  char                      bfr[MISCBFRLEN];
  char                      dmiDir[CHRBFRLEN];
  char                      mifTextFile[CHRBFRLEN];
  DMI_STRING                *string;
  DmiLibInstallData_t _FAR  *installData;
  DmiLibFileData_t          fileData;
  TErrCode                  tErrCode;

  // Append the source and destination file names to their respective
  // paths.
  if(_getcwd(acSrcPath,MAXPATHLEN)==NULL){
    sprintf(bfr,
      "\n"
      "Directory nested too deeply. Copy the installation files\n"
      "to a higher higher level directory and restart the installation\n"
      "from there.");
    messageBox(bfr,ERR_PRESS_KEY,10,7,17,73);
    return _false;
    }
  if(acSrcPath[strlen(acSrcPath)-1]!='\\')
    strcat(acSrcPath,"\\");
  strcpy(acDstPath,acSrcPath);
  strcat(acSrcPath,PCNETMIF_FNBAK);
  strcat(acDstPath,PCNETMIF_FNAME);
  if(file_exists(acDstPath)){
    if(file_exists(acSrcPath)){
      if(unlink(acSrcPath)){
        sprintf(bfr,
          "\n"
          "Unable to delete an old backup copy of the MIF file -- " PCNETMIF_FNBAK ".\n"
          "If installing from floppy, make sure the diskette is not write protected.");
        messageBox(bfr,ERR_PRESS_KEY,10,2,17,78);
        return _false;
        }
      }
    if(rename(acDstPath,acSrcPath)){
      sprintf(bfr,
        "\n"
        "Unable to create a backup copy of the MIF file -- " PCNETMIF_FNAME ".\n"
        "If installing from floppy, make sure the diskette is not write protected.");
      messageBox(bfr,ERR_PRESS_KEY,10,2,17,78);
      return _false;
      } 
    }
  else{
    sprintf(bfr,
      "\n"
      "The installation program and the MIF file (" PCNETMIF_FNAME ") do not reside\n"
      "in the same directory. Please correct this error before continuing.",
      PCNETMIF_FNAME);
    messageBox(bfr,ERR_PRESS_KEY,10,4,17,76);
    return _false;
    }

//  if(acDstPath[strlen(acDstPath)-1]!='\\')  strcat(acDstPath,"\\");
//  strcat(acDstPath,PCNETMIF_FNAME);

  while(!bDone){
    /* Update the MIF file for each of the variables. */
    tErrCode=mifUpdateFile(atAtrsToMod,acSrcPath,acDstPath,getSelectedDriver());
    switch(tErrCode){
      case errNoDir:
        if(makePath(acDstPath)==errAccess)
          bDone=_true;
        break;
      case errSrcOpenFail:
      case errDstOpenFail:
        sprintf(bfr,"\n"
                    "Unable to open %s MIF file.\n"
                    "System returned error number %d\n",
                    tErrCode==errSrcOpenFail?"source":"destination",
                    errno
                    );
        messageBox(bfr,ERR_PRESS_KEY);
        return _false;
        break;
      case errFWrite:
        sprintf(bfr,"\n"
                    "Unable to write the destination MIF file.\n"
                    "System returned error number %d.",
                    errno);
        messageBox(bfr,ERR_PRESS_KEY);
        return _false;
        break;
      case errNoBfr:
        sprintf(bfr,"\n"
                    "Unable to allocate buffer memory. Try\n"
                    "unloading any unnecessary TSRs or try\n"
                    "booting with a minimal configuration.");
        messageBox(bfr,ERR_PRESS_KEY);
        return _false;
        break;
      case errOk:{
        bDone=_true;
        char* pcDstPath=DMI_DOS_ROOT MIF_DIR MIF_BAK_DIR PCNETMIF_FNAME;
        _getcwd(acSrcPath,DOSPATHBFRLEN);
        int iTmp;
        if(acSrcPath[iTmp=(strlen(acSrcPath)-1)]!='\\')
          strcat(acSrcPath,"\\");
        strcat(acSrcPath,PCNETMIF_FNAME);
        if(doFileCopy(pcDstPath,acSrcPath)!=errOk)
          return _false;
        }
        break;
      }
    }

  /* Delete previously installed components in the DMI database that match the
  ** DOS Color example class string. */
  deleteComponent(CLASS_STRING);

  /* Build the file data structure to direct DmiInstall() to install
  ** the MIF file. */
  fileData.iFileType=MifFileName;
  string=(DMI_STRING*)mifTextFile;
//  string->length=strlen(acDstPath);
  string->length=strlen(PCNETMIF_FNAME);
//  strncpy(string->body,acDstPath,(size_t)string->length);
  strncpy(string->body,PCNETMIF_FNAME,(size_t)string->length);
  fileData.pFileData=(DMI_STRING _FAR *)mifTextFile;

  /* Call DmiInstall(). Direct the procedure to install one MIF text file,
  ** use c:\dmi as the root for the DMI directory, and do not modify the
  ** system start up files. */
//  *strrchr(acDstPath,'\\')='\0';
  string=(DMI_STRING*)dmiDir;
//  string->length=strlen(acDstPath);
  string->length=strlen(DMIDIR);
//  strncpy(string->body,acDstPath,(size_t)string->length);
  strncpy(string->body,DMIDIR,(size_t)string->length);

  installData=DmiInstall(1,&fileData,(DMI_STRING _FAR *)dmiDir,DmiLibFalse,0);
  
  switch(installData->iDmiLibStatus){
  
    /* Scenario 1 was successful. */
    case DmiLibDirInstallNoError:
      sprintf(bfr,
        "\n"
        "MIF file copied to MIFs subdirectory.\n"
        "File will be installed the next time\n"
        "the SL is loaded.");
      messageBox(bfr,ERR_PRESS_KEY);
    break;

    /* Scenario 2 was successful. */
    case DmiLibSlInstallNoError:
      sprintf(bfr,
        "\n"
        "Installation via the Service Layer was successful.\n"
        "\n"
        "             Component ID = %lu\n",
        installData->iComponentId);
      messageBox(bfr,OK_PRESS_KEY,10,14,17,66);
      break;

    /* The call to DmiInstall() failed. */
    default:
      if(installData->iDmiLibStatus==0x302){
        messageBox(
          "The DMI service layer could not be started. The"
          "\ninstallation utility will attempt to copy the "
          "\nfile "PCNETMIF_FNAME" to the MIFS subdirectory. The"
          "\nMIF file will be automatically installed the"
          "\nnext time the SL is loaded."
          );
        char* pcDstPath=DMI_DOS_ROOT MIF_DIR PCNETMIF_FNAME;
        _getcwd(acSrcPath,DOSPATHBFRLEN);
        int iTmp;
        if(acSrcPath[iTmp=(strlen(acSrcPath)-1)]!='\\')
          strcat(acSrcPath,"\\");
        strcat(acSrcPath,PCNETMIF_FNAME);
        if(doFileCopy(pcDstPath,acSrcPath)!=errOk)
          messageBox(
            "\nAn error occured while copying the MIF file.",
            ERR_PRESS_KEY
            );
        else
          messageBox("\n      The MIF file was copied succesfully.");
        }
      else{
        sprintf(bfr,"\n"
                    "The installation failed.\n"
                    "DMI Lib Status       = 0x%lx\n"
                    "Service Layer Status = 0x%lx\n",
                    installData->iDmiLibStatus,
                    installData->iSlStatus);
        messageBox(bfr,ERR_PRESS_KEY);
        }
      break;
    }

  if(installData->iDmiLibStatus==DmiLibDirInstallNoError) return _true;
  else return _false;
}

//void main(void)
//{
//  TDosInstl  d;
//  d.DoInstall();
//}

/*  Delete all ocurrences of components in the DMI database that match the
**  specified class string.  In this program, the class string to match is
**  "DMTF|DOS Color Example|1.0".
*/

void deleteComponent(char *classString)
{
  static union {
    struct DmiMgmtCommand       dmiMgmtCommand;
    struct DmiRegisterMgmtReq   dmiRegisterMgmtReq;
    struct DmiListComponentReq  dmiListComponentReq;
    struct DmiCiUninstallData   dmiCiUninstallData;
    char                        requestBuffer[512];
    }                           requestBuffer;

  static union {
    struct DmiRegisterCnf       dmiRegisterCnf;
    struct DmiListComponentCnf  dmiListComponentCnf[1];
    char                        confirmBuffer[1024];
    }                           confirmBuffer;

  TBool        foundComponent;
  DMI_UNSIGNED confirmCount;
  DMI_STRING   *string;
  int          i;

  /* Fill in the DmiMgmtCommand block in the request buffer with information
  ** that is common for all of the Service Layer commands to be processed
  ** here. */
  requestBuffer.dmiMgmtCommand.iLevelCheck = DMI_LEVEL_CHECK;
  requestBuffer.dmiMgmtCommand.iCmdHandle = 1;
  requestBuffer.dmiMgmtCommand.osLanguage = 0;
  requestBuffer.dmiMgmtCommand.oSecurity = 0;
  requestBuffer.dmiMgmtCommand.iCnfBufLen = sizeof(confirmBuffer);
  requestBuffer.dmiMgmtCommand.pCnfBuf = &confirmBuffer;
  requestBuffer.dmiMgmtCommand.iRequestCount = 1;

  /* Register with the Service Layer.  If the Service Layer is not present,
  ** return. */
  requestBuffer.dmiMgmtCommand.iCommand = DmiRegisterMgmtCmd;
  requestBuffer.dmiMgmtCommand.iCmdLen =
    sizeof(requestBuffer.dmiRegisterMgmtReq);
  requestBuffer.dmiRegisterMgmtReq.pConfirmFunc = confirmFunction;
  requestBuffer.dmiRegisterMgmtReq.pIndicationFunc = (void (*)(void *))0;
  if (! slSynchronousExecute(&requestBuffer.dmiMgmtCommand, AllowFailure))
    return;

  /* Fill in the management handle in the DmiMgmtCommand block. */
  requestBuffer.dmiMgmtCommand.iMgmtHandle =
    confirmBuffer.dmiRegisterCnf.iDmiHandle;

  /* Repeat the following loop until the Service Layer fails to find any
  ** components that match.  Each time through the loop the Service Layer may
  ** find one or more matching components. */
  foundComponent = _true;
  while (foundComponent) {
    /* Perform a list component command with class filtering. */
    requestBuffer.dmiMgmtCommand.iCommand = DmiListFirstComponentCmd;
    requestBuffer.dmiMgmtCommand.iCmdLen = sizeof(requestBuffer);
    requestBuffer.dmiListComponentReq.osClassString = 
      sizeof(requestBuffer.dmiListComponentReq);
    requestBuffer.dmiListComponentReq.iGroupKeyCount = 0;
    requestBuffer.dmiListComponentReq.oGroupKeyList = 0;
    string = (DMI_STRING *) (requestBuffer.requestBuffer +
                             sizeof(struct DmiListComponentReq));
    string -> length = strlen(classString);
    memcpy(string -> body, classString, (size_t) string -> length);
    slSynchronousExecute(&requestBuffer.dmiMgmtCommand, AllowFailure);

    /* Extract the number of matching components. */
    if (requestBuffer.dmiMgmtCommand.iStatus == DBERR_COMPONENT_NOT_FOUND)
      confirmCount = 0;
    else
      confirmCount = requestBuffer.dmiMgmtCommand.iCnfCount;
    foundComponent = (confirmCount > 0)?_true:_false;

    /* Delete each of the matching components. */
    for (i = 0; i < (int) confirmCount; ++i) {
      requestBuffer.dmiMgmtCommand.iCommand = DmiCiUninstallCmd;
      requestBuffer.dmiMgmtCommand.iCmdLen =
        sizeof(requestBuffer.dmiCiUninstallData);
      requestBuffer.dmiCiUninstallData.iComponentId =
        confirmBuffer.dmiListComponentCnf[i].iComponentId;
      slExecute(&requestBuffer.dmiMgmtCommand, TerminateWithFailure);
      }
    }

  /* Unregister with the Service Layer. */
  requestBuffer.dmiMgmtCommand.iCommand = DmiUnregisterMgmtCmd;
  requestBuffer.dmiMgmtCommand.iCmdLen = sizeof(requestBuffer.dmiMgmtCommand);
  slSynchronousExecute(&requestBuffer.dmiMgmtCommand, TerminateWithFailure);
}

/*  Call the Service Layer with a DMI command.  Wait for it to complete.  If
**  the command was not processed without an error and the mode is 
**  TerminateWithFailure, then abort this program.
*/

static TBool slSynchronousExecute(struct DmiMgmtCommand *dmiMgmtCommand, SlExecutionMode mode)
{
  ConfirmFlag = _false;

  if (! slExecute(dmiMgmtCommand, mode))
    return _false;

  while (! ConfirmFlag)
    ;

  if ((mode == TerminateWithFailure) &&
      (dmiMgmtCommand -> iStatus != SLERR_NO_ERROR) &&
      (dmiMgmtCommand -> iStatus != SLERR_NO_ERROR_MORE_DATA)){
      slFailure(dmiMgmtCommand);
      return _false;
      }

  return _true;
}

/*  Call the Service Layer with a DMI command.  If the command was not accepted
**  by the Service Layer, and the mode is TerminateWithError, then abort this
**  program.
*/

static TBool slExecute(
  struct DmiMgmtCommand  *dmiMgmtCommand,
  SlExecutionMode         mode)
{
  DMI_UNSIGNED slStatus;

  slStatus = DmiInvoke(dmiMgmtCommand);
  if ((mode == TerminateWithFailure) && (slStatus != SLERR_NO_ERROR)){
    slFailure(dmiMgmtCommand);
    return _false;
    }
  return (slStatus == SLERR_NO_ERROR)?_true:_false;
}

/*  Document a Service Layer failure and abort the program.
*/

static void slFailure(struct DmiMgmtCommand *dmiMgmtCommand)
{
  char  bfr[MISCBFRLEN];
  sprintf(bfr,  "\n"
                "The Service Layer failed:\n"
                "Command = 0x%lx\n"
                "Status  = 0x%lx\n",
                dmiMgmtCommand->iCommand,
                dmiMgmtCommand->iStatus);
  messageBox(bfr,ERR_PRESS_KEY);
//  exit(1);
}

/*  The callback function for the Service Layer.  The only action is to set
**  the ConfirmFlag to TRUE.  This flag is used by the slSynchronousExecute()
**  procedure to wait for the Service Layer to process the command.
*/

void _FAR _cdecl confirmFunction(void _FAR *dmiMgmtCommand)
{
  ConfirmFlag = _true;
}
