/* 2003.09.10
****************************************
**  Copyright  (C)  W.ch  1999-2003   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  DOS for PCI interface chip CH365  **
**  C, TC2.0                          **
****************************************

 PCI߽ӿоƬCH365DOSӿڿ     V1.1
 Ͼߺ޹˾  : W.ch 2003.09
 CH365-DOS  V1.1 ,    Support: IO/MEM/INT
 л: DOS
*/

#include	<dos.h>
#include	<stddef.h>

#include	"CH365DOS.H"


USHORT				dosCH365PciAddr = 0;	/* CH365PCIַ,/豸/ܺ */
mPCH365_IO_REG		dosIoBaseAddr = NULL;	/* CH365˿ڻַ */
ULONG				dosMemBaseAddr = NULL;	/* CH365洢ַ,Եַ */
USHORT				dosIntLine = 0;			/* CH365жϺ */
PINTERRUPT_ROUTINE	dosOldInterrupt = NULL;	/* ԭж */


USHORT			CH365CheckDevice( )  /* CH365豸,⵽CH365򷵻PCIַ,/豸/ܺ,򷵻0 */
{
/*	UCHAR	mByte; */
	X86REG	mReg;
	mReg.x.ax = 0xb102;
	mReg.x.cx = 0x5049;  /* 豸ID */
	mReg.x.dx = 0x4348;  /* ID */
	mReg.x.si = 0;  /* һ */
	int86 ( 0x1a, &mReg, &mReg );  /* PCIBIOS */
	if ( mReg.h.ah == 0 ) {  /* óɹ */
		dosCH365PciAddr = mReg.x.bx;  /* ⵽CH365 */
/*  ͨȡÿռоƬ汾,ʶоƬCH361CH365
		mByte = CH365ReadCfgByte( mOFFSET( mPCI_CONFIG, mPcRevisionId ) );
		if ( mByte == 0 ) 汾Ϊ0CH361;
		else if ( mByte == 0x10 ) 汾Ϊ10CH365;
*/
		return( mReg.x.bx );  /* PCIַ */
	}
	else return( 0 );  /* ûм⵽CH365 */
}

UCHAR			CH365ReadCfgByte(  /* ÿռȡһֽ,ضȡֽ */
	USHORT			iOffset )  /* ָƫƵַ */
{
	X86REG	mReg;
	mReg.x.bx = dosCH365PciAddr;
	mReg.x.ax = 0xb108;
	mReg.x.di = iOffset;
	int86 ( 0x1a, &mReg, &mReg );  /* PCIBIOS */
	return( mReg.h.cl );  /*  */
}

VOID			CH365WriteCfgByte(  /* ÿռдһֽ */
	USHORT			iOffset,  /* ָƫƵַ */
	UCHAR			iByte )  /* дֽ */
{
	X86REG	mReg;
	mReg.x.bx = dosCH365PciAddr;
	mReg.x.ax = 0xb10b;
	mReg.x.di = iOffset;
	mReg.h.cl = iByte;
	int86 ( 0x1a, &mReg, &mReg );  /* PCIBIOS */
}

USHORT			CH365ReadCfgWord(  /* ÿռȡһ,ضȡ */
	USHORT			iOffset )  /* ָƫƵַ */
{
	X86REG	mReg;
	mReg.x.bx = dosCH365PciAddr;
	mReg.x.ax = 0xb109;
	mReg.x.di = iOffset;
	int86 ( 0x1a, &mReg, &mReg );  /* PCIBIOS */
	return( mReg.x.cx );  /*  */
}

VOID			CH365WriteCfgWord(  /* ÿռдһ */
	USHORT			iOffset,  /* ָƫƵַ */
	USHORT			iWord )  /* д */
{
	X86REG	mReg;
	mReg.x.bx = dosCH365PciAddr;
	mReg.x.ax = 0xb10c;
	mReg.x.di = iOffset;
	mReg.x.cx = iWord;
	int86 ( 0x1a, &mReg, &mReg );  /* PCIBIOS */
}

mPCH365_IO_REG	CH365GetIoBaseAddr( )  /* ȡI/O˿ڵĻַ,I/O˿ڻַ */
{
	USHORT	mWord;
	mWord = CH365ReadCfgWord( mOFFSET( mPCI_CONFIG, mPcBaseAddr0 ) );  /* ȡÿռ */
	dosIoBaseAddr = (mPCH365_IO_REG) ( mWord & 0xfffe );
	return( dosIoBaseAddr );  /*  */
}

BOOL			CH365SetIoBaseAddr(  /* 趨I/O˿ڵĻַ */
	mPCH365_IO_REG	iIoBaseAddr )  /* ָI/O˿ڻַ */
{
	CH365WriteCfgWord( mOFFSET( mPCI_CONFIG, mPcBaseAddr0 ), (USHORT)iIoBaseAddr );  /* дÿռ */
	if ( CH365GetIoBaseAddr( ) == iIoBaseAddr ) return( TRUE );  /* ضȽȷ */
	else return( FALSE );
}

ULONG			CH365GetMemBaseAddr( )  /* ȡ洢Ļַ,ش洢ַ */
{
	USHORT	mWord;
	ULONG	mDword;
	mDword = CH365ReadCfgWord( mOFFSET( mPCI_CONFIG, mPcBaseAddr1 ) );  /* ȡÿռ */
	mWord = CH365ReadCfgWord( mOFFSET( mPCI_CONFIG, mPcBaseAddr1 ) + sizeof( USHORT ) );  /* ȡÿռ */
	mDword |= (ULONG)mWord << 16;
	dosMemBaseAddr = mDword & 0xfffffff0;
	return( dosMemBaseAddr );  /*  */
}

BOOL			CH365SetMemBaseAddr(  /* 趨洢Ļַ */
	ULONG			iMemBaseAddr )  /* ָ洢ַ,Ϊ0رմ洢,Ϊ-1Զ趨 */
{
	USHORT		mSeg, i;
	USHORT	far	*mpWord;
	if ( iMemBaseAddr == 0 ) {  /* ַΪ0رմ洢 */
		dosMemBaseAddr = 0;  /* ӳַ */
		CH365WriteCfgWord( mOFFSET( mPCI_CONFIG, mPcBaseAddr1 ), 0 );  /* дÿռ */
		CH365WriteCfgWord( mOFFSET( mPCI_CONFIG, mPcBaseAddr1 ) + sizeof( USHORT ), 0 );  /* дÿռ */
		return( TRUE );
	}
	else if ( iMemBaseAddr == mCH365_MEM_BASE_AUTO ) {  /* ַΪֵԶô洢ַ */
		for ( mSeg = 0xd000; mSeg < 0xe000; mSeg += 0x0800 ) {  /* չROMַ/洢ַ */
			mpWord = MK_FP( mSeg, 0 );
			for ( i = 0; i < 0x8000 / sizeof( USHORT ); ++i, ++mpWord )  /* ַ */
				if ( *mpWord != 0xffff ) break;  /* 鵱ǰڴַǷѾռ */
			if ( i >= 0x8000 / sizeof( USHORT ) ) break;  /* ҵһδռõڴַ */
		}
		if ( mSeg < 0xe000 ) dosMemBaseAddr = (ULONG)mSeg << 4;  /* ڴַ,εַתΪԵַ */
		else {  /* ûҵеڴַ */
			dosMemBaseAddr = 0;
			return( FALSE );  /* ʧ */
		}
	}
	else dosMemBaseAddr = iMemBaseAddr;  /* ָ洢ַ */
	dosMemBaseAddr++;  /* ʹROMռ */
	CH365WriteCfgWord( mOFFSET( mPCI_CONFIG, mPcBaseAddr1 ) + sizeof( USHORT ), (USHORT)( dosMemBaseAddr >> 16 ) );  /* дÿռ */
	CH365WriteCfgWord( mOFFSET( mPCI_CONFIG, mPcBaseAddr1 ), (USHORT)dosMemBaseAddr );  /* дÿռ */
	dosMemBaseAddr--;
	if ( dosMemBaseAddr == CH365GetMemBaseAddr( ) ) return( TRUE );  /* ضȽȷ */
	else return( FALSE );
}

USHORT			CH365GetIntLine( )  /* ȡжϺ,жϺ,Ϊ0Ч */
{
	UCHAR	mByte;
	mByte = CH365ReadCfgByte( mOFFSET( mPCI_CONFIG, mPcInterPin ) );  /* ȡÿռ */
	if ( mByte == 0 ) return( 0 );  /* жϹδ */
	dosIntLine = CH365ReadCfgByte( mOFFSET( mPCI_CONFIG, mPcInterLine ) );  /* ȡÿռ */
	return( dosIntLine );
}

BOOL			CH365SetIntLine(  /* 趨жϺ */
	USHORT			iIntLine )  /* ָжϺ,Ϊ0رж,Ϊ-1ԶⲢ趨 */
{
	UCHAR	mIntMask;
	USHORT	mIntPort;
	X86REG	mReg;
	X86SREG	mSegReg;
	if ( iIntLine == 0 ) {  /* жϺΪ0رж */
		if ( dosIntLine && dosOldInterrupt ) {  /* жѱ */
			setvect( mHARDWARE_INTERRUPT( dosIntLine ), dosOldInterrupt );  /* ж,ָԭж */
			dosIntLine = 0;  /* жϺ */
			dosOldInterrupt = NULL;
		}
		return( TRUE );
	}
	else if ( iIntLine == mCH365_INT_LINE_AUTO ) {  /* жϺΪֵԶжϺ */
		dosIntLine = CH365GetIntLine( );  /* ȡжϺ */
		if ( dosIntLine == 0 ) return( FALSE );  /* زʧϢ */
	}
	else {  /* ָжϺ */
		mSegReg.ds = 0xf000;
		mReg.x.bx = dosCH365PciAddr;
		mReg.x.ax = 0xb10f;   /* 趨ӲжIRQ */
		mReg.h.cl = 0x0a;  /* INTA */
		mReg.h.ch = iIntLine;  /* ָжϺţֵ015 */
		int86x ( 0x1a, &mReg, &mReg, &mSegReg );  /* PCIBIOS */
		if ( mReg.h.ah == 0 ) {  /* óɹ */
			CH365WriteCfgByte( mOFFSET( mPCI_CONFIG, mPcInterLine ), iIntLine );  /* дÿռ */
			dosIntLine = iIntLine;  /* ָжϺ */
		}
		else return( FALSE );  /* ʧ */
	}
/* ³8259жλ */
	mIntPort = dosIntLine < 8 ? 0x21 : 0xa1;  /* жö˿ */
	mIntMask = inportb( mIntPort );  /* ԭжֽ */
	outportb( mIntPort, mIntMask & ~ ( 0x01 << ( dosIntLine & 0x07 ) ) );  /* ж */
	dosOldInterrupt = getvect( mHARDWARE_INTERRUPT( dosIntLine ) );  /* ԭж */
	return( TRUE );
}

BOOL			CH365SetIntRoutine(  /* 趨жϷ */
	PINTERRUPT_ROUTINE	iIntRoutine )  /* ָжϷ,ΪNULLȡжϷ,жʱøó */
{
	UCHAR	mIntMask;
	USHORT	mIntPort;
	if ( iIntRoutine ) {  /* 趨жϷ */
		if ( dosIntLine == 0 ) if ( CH365SetIntLine( mCH365_MEM_BASE_AUTO ) == FALSE ) return( FALSE );  /* δжϺԶ,ʧ򷵻 */
		if ( dosOldInterrupt == NULL ) getvect( mHARDWARE_INTERRUPT( dosIntLine ) );  /* ԭж */
		setvect( mHARDWARE_INTERRUPT( dosIntLine ), iIntRoutine );  /* 趨µж */
		mIntPort = dosIntLine < 8 ? 0x21 : 0xa1;  /* жö˿ */
		mIntMask = inportb( mIntPort );  /* ԭжֽ */
		outportb( mIntPort, mIntMask & ~ ( 0x01 << ( dosIntLine & 0x07 ) ) );  /* ж */
		return( TRUE );
	}
	else {  /* ȡжϷ */
		if ( dosIntLine && dosOldInterrupt ) {  /* жѱ */
			setvect( mHARDWARE_INTERRUPT( dosIntLine ), dosOldInterrupt );  /* ж,ָԭж */
			dosIntLine = 0;  /* жϺ */
			dosOldInterrupt = NULL;
		}
		return( TRUE );
	}
}

UCHAR			CH365ReadI2C(  /* I2Cӿڶȡһֽ,ضȡֽ */
	UCHAR			iDevice,  /* 7λָI2C豸ַ */
	UCHAR			iAddr )  /* ָݵԪĵַ */
{
	UCHAR	mByte;
	int		i;
	outportb( (USHORT) & dosIoBaseAddr -> mCh365I2cDev, iDevice << 1 | 0x01 );  /* 豸ַ */
	outportb( (USHORT) & dosIoBaseAddr -> mCh365I2cAddr, iAddr );  /* 趨ַ */
	mByte = inportb( (USHORT) & dosIoBaseAddr -> mCh365I2cCtrl );  /* ȡƺ״̬ */
	mByte |= 0x01;  /* λ01 */
	outportb( (USHORT) & dosIoBaseAddr -> mCh365I2cCtrl, mByte );  /* ʼ */
	while( mByte & 0x01 ) mByte = inportb( (USHORT) & dosIoBaseAddr -> mCh365I2cCtrl );  /* ȴ */
	mByte = inportb( (USHORT) & dosIoBaseAddr -> mCh365I2cData );  /* ȡI2CĽ */
	CH365DelayUS( 4 );  /* ʱ4uSΪI2Cļ */
	return( mByte );  /* ضȡ */
}

VOID			CH365WriteI2C(  /* I2Cӿдһֽ */
	UCHAR			iDevice,  /* 7λָI2C豸ַ */
	UCHAR			iAddr,  /* ָݵԪĵַ */
	UCHAR			iByte )  /* дֽ */
{
	UCHAR	mByte;
	outportb( (USHORT) & dosIoBaseAddr -> mCh365I2cDev, iDevice << 1 | 0x00 );  /* 豸ַ */
	outportb( (USHORT) & dosIoBaseAddr -> mCh365I2cAddr, iAddr );  /* 趨ַ */
	outportb( (USHORT) & dosIoBaseAddr -> mCh365I2cData, iByte );  /* д */
	mByte = inportb( (USHORT) & dosIoBaseAddr -> mCh365I2cCtrl );  /* ȡƺ״̬ */
	mByte |= 0x01;  /* λ01 */
	outportb( (USHORT) & dosIoBaseAddr -> mCh365I2cCtrl, mByte );  /* ʼд */
	while( mByte & 0x01 ) mByte = inportb( (USHORT) & dosIoBaseAddr -> mCh365I2cCtrl );  /* ȴд */
	CH365DelayUS( 4 );  /* ʱ4uSΪI2Cļ */
}

VOID			CH365DelayUS(  /* ʱָ΢ */
	ULONG			iDelay )  /* ָҪʱ΢,ʱС10ϴ */
{
	UCHAR	mTime;
	USHORT	ms, us;
	ms = iDelay / 983;  /* Ӳʱ, 983.04uS, 1 */
	us = iDelay % 983;  /* ʣ΢ */
	while ( ms -- ) {  /* CH365Ӳѭ */
		mTime = inportb( (USHORT) & dosIoBaseAddr -> mCh365IoTime );  /* ȡӲѭĴ */
		while ( inportb( (USHORT) & dosIoBaseAddr -> mCh365IoTime ) == mTime );  /* ȴʼ */
		while ( inportb( (USHORT) & dosIoBaseAddr -> mCh365IoTime ) != mTime );  /* ȴһ */
	}
	if ( us > 10 ) {  /* ʣ΢10 */
		mTime = ( us * 50 ) / ( 3.84 * 50 );  /* Ӳʱ, 3.84uS */
		mTime += inportb( (USHORT) & dosIoBaseAddr -> mCh365IoTime );  /* ʼֵΪֵ */
		while ( inportb( (USHORT) & dosIoBaseAddr -> mCh365IoTime ) != mTime );  /* ȴ */
	}
	else {  /* ʣ΢С10 */
		while ( us -- ) {  /* ÿڽ1uS */
			inportb( (USHORT) & dosIoBaseAddr -> mCh365IoTime );  /* ȡӲѭĴ */
			inportb( (USHORT) & dosIoBaseAddr -> mCh365IoTime );
			inportb( (USHORT) & dosIoBaseAddr -> mCh365IoTime );
		}
	}
}
