//****************************************************************************
//  File              : CVXFMSY.H    
//  Date              : January 10, 1992
//  Description       : Header file for the FM synthesizer libraries.
//                    
//  Last update       : March 11, 1992
//  Additional Notes  :
//*****************************************************************************
//             Copyright (c) 1992,  Covox, Inc.  All Rights Reserved          
//*****************************************************************************

#ifndef  _CVXFMSY_DEFINED
#define  _CVXFMSY_DEFINED

#include "cvxdefs.h"

//*****************************************************************************
//   If compiled with Borland C, the header file CVXBRLND.H will be 
//   automatically included.
//*****************************************************************************
#if defined(__TURBOC__)
#include "cvxbrlnd.h"
#endif

//*****************************************************************************
// Structure definition for main header in .BNK files
typedef struct
{
   WORD   fileVersion;           // File version lsb/msb.
   BYTE   ADLIB[ 6 ];            // Signature "ADLIB-".
   WORD   entriesUsed;           // Number of list entries used.
   WORD   entriesInFile;         // Number of list entries in file.
   LONG   nameListOffset;        // Absolute file offset of the name list.
   LONG   instrumentDataOffset;  // Absolute file offset of instrument data.
   BYTE   filler[ 8 ];           // Filler( set to 0 ).
} _BNK_HEADER;

// Structure definition for instrument headers in .BNK files
typedef struct
{
   WORD   instrumentDataIndex;   // Index of instrument into data section
   BYTE   recordUsed;            // Record used flag ( 0 - used, 1 - not used )
   BYTE   instrumentName[ 9 ];   // Instrument Name
} _BNK_INSTRUMENT_NAME;

// Structure definition for .BNK modulator/carrier parameters
typedef struct
{
   BYTE   mode;                  // Mode ( 0 - melodic, 1 - percussive ).
   BYTE   voiceNumber;           // Voice number( if percussive ).
   BYTE   modKSL;                // Key scaling level.
   BYTE   modFreqMultiplier;     // Frequency Multiplier.
   BYTE   modFeedbackLevel;      // Feedback Level.
   BYTE   modAttack;             // Attack Rate.
   BYTE   modSustain;            // Sustain Level.
   BYTE   modSustainStatus;      // Sustaining Sound Status
                                 //     ( 0 - diminishing, 1 - continuing ).
   BYTE   modDecay;              // Decay Rate.
   BYTE   modRelease;            // Release Rate.
   BYTE   modOutputLevel;        // Output Level.
   BYTE   modAmplitudeVibrato;   // Amplitude Vibrato.
   BYTE   modFrequencyVibrato;   // Frequency Vibrato.
   BYTE   modKSR;                // Key Scale Rate.
   BYTE   modConnection;         // Connection( 1 - parallel, 0 - cascading ).
   BYTE   carKSL;                // Key scaling level.
   BYTE   carFreqMultiplier;     // Frequency Multiplier.
   BYTE   carFeedbackLevel;      // Feedback Level.
   BYTE   carAttack;             // Attack Rate.
   BYTE   carSustain;            // Sustain Level.
   BYTE   carSustainStatus;      // Sustaining Sound Status
                                 // ( 0 - diminishing, 1 - continuing ).
   BYTE   carDecay;              // Decay Rate.
   BYTE   carRelease;            // Release Rate.
   BYTE   carOutputLevel;        // Output Level.
   BYTE   carAmplitudeVibrato;   // Amplitude Vibrato.
   BYTE   carFrequencyVibrato;   // Frequency Vibrato.
   BYTE   carKSR;                // Frequency Vibrato.
   BYTE   unused;                // Unused.
   BYTE   modWaveform;           // Unused.
   BYTE   carWaveform;           // Wave form for carrier.
} _BNK_INSTRUMENT;

// Structure for the initialization data to be passed to fmInit function 
typedef struct
{
   WORD   port;                  // Variable for the port of the Yamaha chip.
} _FM_INIT_DATA;

// Structure for the global parameters
typedef struct
{
   WORD   port;                  // Variable for the port of the Yamaha chip.
   BYTE   systemInitialized;     // System initialized flag.
   BYTE   mode;                  // Variable for the mode
                                 // ( 0 -Melodic, 0x30 - Percussive )
} _FM_GLOBAL_DATA;

// Defines for modulator and carrier
enum
{
     _MODULATOR,
     _CARRIER
};

// Defines for percussion instrument
enum
{
     _BASS_DRUM      =  0x06,
     _SNARE_DRUM,
     _TOM,
     _CYMBAL,
     _HIGH_HAT
};

#define _FM_PORT_A         0x388 // The valid FM synthesizer ports on the
#define _FM_PORT_B         0x380 // Sound Master II.

#define _TEST              0x01  // The FM synthesizer control registers.
#define _AM_MULTI          0x20  //
#define _KSL_TL            0x40  //
#define _AR_DR             0x60  //
#define _SL_RR             0x80  //
#define _FNUM_L            0xA0  //
#define _KON_FNUM_H        0xB0  //
#define _PERC              0xBd  //
#define _FB_C              0xC0  //
#define _WS                0xE0  //

#define _WAVE_SELECT_OFF   0x00  // Mask to enable/disable wave select.
#define _WAVE_SELECT_ON    0x20  //

#define _SLOTS             0x10  // Number of slots per register.

#define _MEL_VOICES        0x09  // The number of melodic voices.

#define _PERC_VOICES       0x0B  // The number of percussive voices

#define _VOICES            0x0B  // The total number of voices 

#define _PERCUSSIVE        0x20  // For percussive and melodic mode
#define _MELODIC           0x00  //    

#define _PERC_CLEAR        0xC0  // Mask to clear percussive mode.

#define _RESET_DEPTH       0x00  // Mask to clear the depth register

#define _RESET_KON         0xDF  // Mask to reset the kon bits

#define _TOT_VOICES        0x0B  // The total number of voices on the chip.

#define _KON               0x20  // The bit position of the kon bits.

// Enumeration for all of the available midi notes
enum
{                      
   C0, CS0, D0, DS0, E0, F0, FS0, G0, GS0, A0, AS0, B0,
   C1, CS1, D1, DS1, E1, F1, FS1, G1, GS1, A1, AS1, B1,
   C2, CS2, D2, DS2, E2, F2, FS2, G2, GS2, A2, AS2, B2,
   C3, CS3, D3, DS3, E3, F3, FS3, G3, GS3, A3, AS3, B3,
   C4, CS4, D4, DS4, E4, F4, FS4, G4, GS4, A4, AS4, B4,
   C5, CS5, D5, DS5, E5, F5, FS5, G5, GS5, A5, AS5, B5,
   C6, CS6, D6, DS6, E6, F6, FS6, G6, GS6, A6, AS6, B6,
   C7, CS7, D7, DS7, E7, F7, FS7, G7, GS7, A7, AS7, B7,
   C8, CS8, D8, DS8, E8, F8, FS8
}; 

// external data references between modules
extern  WORD               _fmPort;
extern  BYTE               _fmKSRMULTIReg          [];
extern  BYTE               _fmKSLTLReg             [];
extern  BYTE               _fmARDRReg              [];
extern  BYTE               _fmSLRRReg              [];
extern  BYTE               _fmFNUMReg              [];
extern  BYTE               _fmKONBLOCKReg          [];
extern  BYTE               _fmFBCReg               [];
extern  BYTE               _fmWSReg                [];
extern  BYTE               _fmInstrumentSet        [];
extern  BYTE               _fmNoteOn               [];
extern  BYTE               _fmPercussionRegister;
extern  BYTE               _fmMelodicSlots         [ _MEL_VOICES ][ 2 ];
extern  BYTE               _fmPercussiveSlots      [ _PERC_VOICES ][ 2 ];
extern  WORD               _fmMidiScale            [];  
extern  _FM_GLOBAL_DATA    _fmGlobalParameters;

// error definitions
#undef  _ERROR_NONE
#define _ERROR_NONE  0

//****************************************************************************
// Error codes for FM libraries
//*****************************************************************************
// NOTE : Starting offset for all FM library errors is 7000.
enum
{
   _ERROR_INVALID_PORT = 7000,      // Invalid FM port sent to fmInit
   _ERROR_SYSTEM_NOT_INITIALIZED,   // System has not been initialized.
   _ERROR_INVALID_VOICE_FOR_MODE,   // An invalid voice was specified.
   _ERROR_INVALID_INSTRUMENT,       // An invalid instrument was specified.
   _ERROR_INSTRUMENT_NOT_DEFINED,   // Specified instrument was not defined.
   _ERROR_VOICE_NOT_ACTIVATED,      // Specified voice not turned on.
   _ERROR_INVALID_VOICE,            // Specified voice does not exist.
   _ERROR_VOICE_OUT_OF_RANGE        // Voice out of range for current mode.
};

// function prototypes
#ifdef __cplusplus
extern "C" {
#endif

extern  VOID  fmSetRegister ( BYTE, BYTE );

WORD    fmInit              ( _FM_INIT_DATA * );
WORD    fmUninit            ( VOID );
WORD    fmSetMode           ( BYTE );
WORD    fmSetInstrument     ( _BNK_INSTRUMENT far *, BYTE );
WORD    fmReset             ( VOID );
WORD    fmNoteOn            ( BYTE, WORD ); 
WORD    fmNoteOff           ( BYTE );
WORD    fmSetFrequency      ( BYTE, WORD );

#ifdef __cplusplus
}
#endif

#endif
//*****************************************************************************
//  end         CVXFMSY.H
//*****************************************************************************
