
;===========================================================================;
; Konzept        : DATA BECKERs Sound Blaster Superbuch                     ;
; Prog. CallIntr : Ein Beispielprogramm zum Aufruf der Interrupts (DOS-     ;
;                  Interrupt 21h)                                           ;
;===========================================================================;
; Autor          : Arthur Burda                                             ;
; Dateiname      : CALLINTR.ASM                                             ;
; entwickelt am  : 20.07.1993                                               ;
; letztes Update : 01.09.1993                                               ;
; Version        : 1.01                                                     ;
; Compiler       : Turbo Assembler 1.0 und hher bzw. Macro Assembler       ;
;===========================================================================;

.MODEL SMALL
.CODE

Start:         JMP   Main                ; Sprung zum Hauptprogramm

;===========================================================================;
; ClrScr: Lscht den Bildschirm mit Hilfe der BIOS-Funktion 06h (Textzeilen ;
;         nach oben schieben).                                              ;
;===========================================================================;
; Eingabe: keine                                                            ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

ClrScr         PROC
               PUSH  AX                  ; AX-Register auf dem Stack sichern
               PUSH  BX
               PUSH  CX
               PUSH  DX
               MOV   AH,06h              ; Nummer der Funktion in AH-Register
                                         ; laden
               MOV   AL,00h              ; 0 Textzeilen nach oben verschieben
                                         ; bedeutet Lschen des Bildschirms
               MOV   CH,00h              ; Zeile der oberen linken Bild-
                                         ; schirmecke
               MOV   CL,00h              ; Spalte der oberen linken Bild-
                                         ; schirmecke
               MOV   DH,18h              ; Zeile der unteren rechten Bild-
                                         ; schirmecke
               MOV   DL,4Fh              ; Spalte der unteren rechten Bild-
                                         ; schirmecke
               MOV   BH,07h              ; Textattribut hellgrau auf schwarz
               INT   10h                 ; BIOS-Interrupt auslsen
               POP   DX                  ; DX-Register restaurieren
               POP   CX
               POP   BX
               POP   AX
               RET                       ; Rcksprung
ClrScr         ENDP

;===========================================================================;
; CursorUp: Positioniert den Cursor in der oberen linken Bildschirmecke.    ;
;===========================================================================;
; Eingabe: keine                                                            ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

CursorUp       PROC
               PUSH  AX                  ; AX-Register auf dem Stack sichern
               PUSH  BX
               PUSH  DX
               MOV   AH,02h              ; Nummer der Funktion in AH-Register
                                         ; laden
               MOV   BH,00h              ; Bildschirmseite 0
               MOV   DH,00h              ; Bildschirmzeile 0
               MOV   DL,00h              ; Bildschirmspalte 0
               INT   10h                 ; String-Ausgabe via BIOS
               POP   DX                  ; DX-Register vom Stack holen
               POP   BX
               POP   AX
               RET                       ; Rcksprung
CursorUp       ENDP

;===========================================================================;
; WaitToPressed: Wartet solange, bis eine Taste gedrckt wird               ;
;===========================================================================;
; Eingabe: keine                                                            ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

WaitToPressed  PROC
               PUSH  AX                  ; Inhalt des AX-Registers sichern
               MOV   AH,00h              ; Funktion: Zeichen auslesen
               INT   16h                 ; Tastatur-Interrupt aufrufen
               POP   AX                  ; AX-Register restaurieren
               RET                       ; Rcksprung
WaitToPressed  ENDP

;---------------------------------------------------------------------------;
; Hauptprogramm                                                             ;
;---------------------------------------------------------------------------;

Main:          CALL  ClrScr              ; Bildschirm lschen
               CALL  CursorUp            ; Cursor in die obere linke Ecke
                                         ; des Bildschirms setzen
               MOV   AH,09h              ; Funktion des DOS-Interrupts laden
               MOV   DX,SEG Message      ; Segment-Adresse des Strings
               MOV   DS,DX               ; in DS-Register laden
               MOV   DX,OFFSET Message   ; Offset-Adresse bestimmen
               INT   21h                 ; Interrupt-Aufruf
               CALL  WaitToPressed       ; auf Taste warten
               MOV   AH,4Ch              ; Funktion zum Beenden des Programms
               INT   21h                 ; DOS-Interrupt auslsen und das
                                         ; Programm beenden

;---------------------------------------------------------------------------;
; Daten-Segment                                                             ;
;---------------------------------------------------------------------------;

Message        DB 'DATA BECKERs Sound Blaster Superbuch$'

END
