
/*=========================================================================*/
/* Konzept        : DATA BECKERs Sound Blaster Superbuch                   */
/* Header SBDSP   : Enthlt Konstanten (in erster Linie DSP-Kommandos) und */
/*                  Typdefinitionen sowie Typschemas der im Modul SBDSP.C  */
/*                  implementierten Funktionen.                            */
/*=========================================================================*/
/* Autor          : Arthur Burda                                           */
/* Dateiname      : SBDSP.H                                                */
/* entwickelt am  : 04.07.1993                                             */
/* letztes Update : 01.09.1993                                             */
/* Version        : 1.06                                                   */
/* Compiler       : Turbo C, Turbo C++, Borland C++                        */
/*=========================================================================*/

/*-------------------------------------------------------------------------*/
/* Basis-I/O-Adresse und DMA-Kanal der Sound-Blaster-Karte (Standard-Ein-  */
/* stellung)                                                               */
/*-------------------------------------------------------------------------*/

#define SB_BaseAddress 0x220
#define SB_DMAChannel  1

/*-------------------------------------------------------------------------*/
/* Wahrheitswerte                                                          */
/*-------------------------------------------------------------------------*/

#define TRUE  1
#define FALSE 0

/*-------------------------------------------------------------------------*/
/* DSP-Kommandos                                                           */
/*-------------------------------------------------------------------------*/

/* direkte Ausgabe ungepackter Daten */

#define dsp_WriteDirectUnpack 0x10

/* DMA-Ausgabe ungepackter Daten mit Referenzbyte */

#define dsp_WriteDMAUnpackRef 0x14

/* DMA-Ausgabe 2-Bits-gepackter Daten ohne Referenzbyte */

#define dsp_WriteDMA2BitPackNoRef 0x16

/* DMA-Ausgabe 2-Bits-gepackter Daten mit Referenzbyte */

#define dsp_WriteDMA2BitPackRef 0x17

/* DMA-Ausgabe 4-Bits-gepackter Daten ohne Referenzbyte */

#define dsp_WriteDMA4BitPackNoRef 0x74

/* DMA-Ausgabe 4-Bits-gepackter Daten mit Referenzbyte */

#define dsp_WriteDMA4BitPackRef 0x75

/* DMA-Ausgabe 2,6-Bits-gepackter Daten ohne Referenzbyte */

#define dsp_WriteDMA26BitPackNoRef 0x76

/* DMA-Ausgabe 2,6-Bits-gepackter Daten mit Referenzbyte */

#define dsp_WriteDMA26BitPackRef 0x77

/* direkte Eingabe ungepackter Daten */

#define dsp_ReadDirectUnpack 0x20

/* DMA-Eingabe ungepackter Daten */

#define dsp_ReadDMAUnpack 0x24

/* Setzen der sog. Zeitkonstante (TC = TIME CONSTANT), */
/* wodurch die Sample-Frequenz bestimmt wird           */

#define dsp_SetTC 0x40

/* Programmieren einer Ruheperiode */

#define dsp_SetSilence 0x80

/* Unterbrechung der DMA-bertragung */

#define dsp_HaltDMATransfer 0xD0

/* Einschalten des Lautsprechers */

#define dsp_SpeakerOn 0xD1

/* Ausschalten des Lautsprechers */

#define dsp_SpeakerOff 0xD3

/* Lesen des Lautsprecher-Status    */
/* 00h = Lautsprecher ausgeschaltet */
/* FFh = Lautsprecher eingeschaltet */

#define dsp_SpeakerStatus 0xD8

/* Fortsetzung der DMA-bertragung */

#define dsp_ContinueDMATransfer 0xD4

/* Programmierung der Sound Blaster Pro Erweiterungen */
/* (sehr schnelle Soundausgabe und -eingabe)          */

#define dsp_SBProExtensions 0x48

/* sehr schnelle 8-Bits-Soundausgabe (nur SB Pro) */

#define dps_HighSpeedDMAWrite 0x91

/* sehr schnelle 8-Bits-Soundeingabe (nur SB Pro) */

#define dsp_HighSpeedDMARead 0x99

/*-------------------------------------------------------------------------*/
/* Typdefinitionen                                                         */
/*-------------------------------------------------------------------------*/

typedef unsigned char Byte;
typedef unsigned int  Word;
typedef long          LongInt;

/*-------------------------------------------------------------------------*/
/* Typschemas der im Modul SBDSP.C implementierten Funktionen              */
/*-------------------------------------------------------------------------*/

void InitDSP(void);
void SetTimerFreq(Word);
void SetOrigFreq(void);
Byte ReadDSP(void);
void WriteDSP(Byte);
void WriteDirect(Byte);
void Speaker_On(void);
void Speaker_Off(void);
void PlayDirect(Byte *, Word, Word, int);
void Mixer(int, int);
