
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Unit SBTalker  : Stellt Routinen fr die Sprachausgabe (Text-To-Speech)   }
{                  mit der Sound-Blaster-Karte zur Verfgung.               }
{                                                                           }
{                  WICHTIG: Um die Routinen aus dieser Unit benutzen zu     }
{                           knnen, mu vorher der residente Sprachtreiber  }
{                           SBTALKER folgendermaen installiert werden:     }
{                                                                           }
{                           SBTALKER /dBLASTER                              }
{                                                                           }
{                           Um den Treiber erfolgreich zu installieren,     }
{                           brauchen Sie auer der Datei SBTALKER.EXE noch  }
{                           den eigentlichen Treiber BLASTER.DRV.           }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : SBTALKER.PAS                                             }
{ entwickelt am  : 12.07.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.02                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

UNIT SBTalker;

{---------------------------------------------------------------------------}
{ Compiler-Schalter                                                         }
{---------------------------------------------------------------------------}

{$B-}                         { Kurzschluverfahren fr boolesche Ausdrcke }
{$D-}                                        { keine Debugger-Informationen }
{$F+}                                                { FAR-Aufrufe erlauben }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$O+}                                            { Unit overlayfhig machen }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

INTERFACE

CONST

  { Gibt an, ob der Sprachtreiber installiert ist oder nicht }

  TalkerInstalled : Boolean = FALSE;

TYPE

  {=========================================================================}
  { PTalkerParam: Zeiger auf TTalkerParam                                   }
  {=========================================================================}
  { TTalkerParam: Record-Typ mit Parametern fr die Sprachausgabe           }
  {=========================================================================}

  PTalkerParam = ^TTalkerParam;
  TTalkerParam = RECORD
    TextToTalk : String;                 { Text, der gesprochen werden soll }
    Phoneme    : String;                                          { Phoneme }
    Gender     : Word;            { Geschlecht (0 = mnnlich, 1 = weiblich) }
    Tone       : Word;                     { Stimmlage (0 = tief, 1 = hoch) }
    Volume     : Word;                                         { Lautstrke }
    Pitch      : Word;                                            { Tonhhe }
    Speed      : Word;                                    { Geschwindigkeit }
  END;

VAR
  TalkerPtr : Pointer;           { Zeiger auf die Treiber-Einsprungsadresse }
  ParamPtr  : ^PTalkerParam; { Zeiger auf den Parameter-Set fr den Treiber }

{===========================================================================}
{ Prozedur InitTalker: Initialisiert den Sprachtreiber fr die Sprachaus-   }
{                      gabe. Die Variable TalkerInstalled wird auf TRUE ge- }
{                      setzt, wenn der Treiber im Speicher gefunden wurde   }
{                      und der Initialisierungsvorgang erfolgreich abge-    }
{                      schlossen wurde.                                     }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE InitTalker;

{===========================================================================}
{ Funktion DoneTalker: Deinstalliert den Sprachtreiber. Er wird nicht aus   }
{                      dem Speicher entfernt, sondern nur deaktiviert, so   }
{                      da keine Sprachausgabe mehr erfolgen kann, bevor er }
{                      nicht wieder initialisiert wird.                     }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: TRUE, wenn der Deaktivierungsvorgang erfolgreich abgeschlossen   }
{          wurde, sonst FALSE                                               }
{---------------------------------------------------------------------------}

FUNCTION DoneTalker : Boolean;

{===========================================================================}
{ Prozedur TextToSpeech: bergibt den angegebenen Text an den Treiber und   }
{                        veranlat die Sprachausgabe.                       }
{===========================================================================}
{ Eingabe: Text = Text, der gesprochen werden soll                          }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE TextToSpeech(Text : String);

{===========================================================================}
{ Prozedur TalkerSettings: Ermglicht die Einstellung der fnf verschiede-  }
{                          nen Parameter, d.h. Geschlecht, Stimmlage, Laut- }
{                          strke, Tonhhe und Geschwindigkeit fr die      }
{                          Sprachausgabe.                                   }
{===========================================================================}
{ Eingabe: Gender = Geschlecht (0 = mnnlich, 1 = weiblich)                 }
{          Tone   = Stimmlage (0 = tief, 1 = hoch)                          }
{          Volume = Laustrke (0-9, Standardwert ist 5)                     }
{          Pitch  = Tonhhe (0-9, Standardwert ist 5)                       }
{          Speed  = Geschwindigkeit (0-9, Standardwert ist 5)               }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE TalkerSettings(Gender, Tone, Volume, Pitch, Speed : Word);

IMPLEMENTATION

PROCEDURE InitTalker; ASSEMBLER;

ASM

  { Vektor des Multiplex-Interrupts 2Fh auslesen }

  MOV   AH,35h                       { Funktionsnummer in AH-Register laden }
  MOV   AL,2Fh       { Nummer des Multiplex-Interrupts in AL-Register laden }
  INT   21h                                        { DOS-Interrupt auslsen }
  MOV   AX,ES  { Segment-Adresse der Interrupt-Routine von ES nach AX laden }
  OR    AX,AX
  JZ    @End_                                             { Routine beenden }

  { berprfen, ob der Sprachtreiber installiert ist }

  MOV   AH,0FBh
  MOV   AL,0FBh
  INT   2Fh                                  { Multiplex-Interrupt auslsen }
  OR    AX,AX                                                     { AX = 0? }
  JNE   @End_      { nein, Routine beenden (kein Sprachtreiber im Speicher) }

  { Zeiger initialisieren }

  MOV   AX,ES:[BX+4]
  MOV   DX,ES:[BX+6]
  MOV   WORD PTR [TalkerPtr],AX                 { Treiber-Einsprungsadresse }
  MOV   WORD PTR [TalkerPtr+2],DX
  ADD   BX,20h
  MOV   WORD PTR [ParamPtr],BX                              { Parameter-Set }
  MOV   WORD PTR [ParamPtr+2],DX

  { Parameter (Geschlecht, Stimmlage, Lautstrke, Tonhhe, }
  { Geschwindigkeit) setzen                                }

  LES   DI,[ParamPtr]
  ADD   DI,TTalkerParam.Gender
  CLD
  SUB   AX,AX                                 { Wert 0 in AX-Register laden }
  STOSW                                         { Geschlecht = 0 (mnnlich) }
  STOSW                                              { Stimmlage = 0 (tief) }
  MOV   AX,5                                  { Wert 5 in AX-Register laden }
  STOSW                                                    { Lautstrke = 5 }
  STOSW                                                       { Tonhhe = 5 }
  STOSW                                               { Geschwindigkeit = 5 }
  MOV   AL,2                                            { Funktionsnummer 2 }
  CALL  [TalkerPtr]                                { Sprachtreiber aufrufen }
  MOV   [TalkerInstalled],TRUE              { Sprachtreiber ist installiert }

@End_:
END;

FUNCTION DoneTalker : Boolean; ASSEMBLER;

ASM
  MOV   AX,FALSE                               { FALSE in AX-Register laden }
  CMP   [TalkerInstalled],FALSE          { Sprachtreiber nicht installiert? }
  JE    @End_                                               { nein, beenden }
  MOV   AH,0FBh               { Sprachtreiber ist installiert, deaktivieren }
  MOV   AL,0FFh
  INT   2Fh                                  { Multiplex-Interrupt auslsen }
@End_:
END;

PROCEDURE TextToSpeech(Text : String); ASSEMBLER;

ASM
  CMP   [TalkerInstalled],FALSE          { Sprachtreiber nicht installiert? }
  JE    @End_                                       { nein, Routine beenden }
  LES   DI,[ParamPtr]                                 { Parameter-Set holen }
  PUSH  DS                              { DS-Register auf dem Stack sichern }

  { Sprachausgabe }

  LDS   SI,Text                           { Zeiger auf den Text in SI laden }
  CLD                                              { Direction-Flag lschen }
  LODSB                                            { String-Operanden laden }
  STOSB                                             { Stringdaten speichern }
  XOR   CH,CH
  MOV   CL,AL
  REP   MOVSB                    { wiederholen bis Ende des Textes erreicht }
  POP   DS                                       { DS-Register restaurieren }
  MOV   AL,7
  CALL  [TalkerPtr]                                { Sprachtreiber aufrufen }

@End_:
END;

PROCEDURE TalkerSettings(Gender, Tone, Volume, Pitch, Speed : Word);
ASSEMBLER;

ASM
  CMP   [TalkerInstalled],FALSE          { Sprachtreiber nicht installiert? }
  JE    @End_                                       { nein, Routine beenden }
  LES   DI,[ParamPtr]                                 { Parameter-Set holen }
  CLD                                              { Direction-Flag lschen }
  ADD   DI,TTalkerParam.Gender                   { beim Geschlecht beginnen }
  MOV   AX,Gender                             { Geschlecht-Parameter setzen }
  STOSW                                                   { ein Wort weiter }
  MOV   AX,Tone                                          { Stimmlage setzen }
  STOSW
  MOV   AX,Volume                                       { Lautstrke setzen }
  STOSW
  MOV   AX,Pitch                                           { Tonhhe setzen }
  STOSW
  MOV   AX,Speed                               { Geschwindigkeit einstellen }
  STOSW
  MOV   AL,2                       { Funktion 2 des Sprachtreibers benutzen }
  CALL  [TalkerPtr]                                { Sprachtreiber aufrufen }
@End_:
END;

{---------------------------------------------------------------------------}
{ Startcode der Unit                                                        }
{---------------------------------------------------------------------------}

BEGIN
  InitTalker;                                { Sprachtreiber initialisieren }
END.
