/* DIGI.H */
/****************************************************************************/
/*                                                                          */
/*  Abstract: Digispeech Driver library literals.                           */
/*                                                                          */
/*  Language: Microsoft C, v6.00a  Model: LARGE    Machine type: IBM PC     */
/*                                                                          */
/*  DSP SOLUTIONS, INC. PROPRIETARY INFORMATION.  The following contains    */
/*  information proprietary to DSP SOLUTIONS, INC., and may not be copied   */
/*  nor disclosed except upon written agreement by DSP SOLUTIONS, INC.      */
/*                                                                          */
/*  COPYRIGHT 1993, DSP SOLUTIONS, INC.   ALL RIGHTS RESERVED.              */
/****************************************************************************/
/*

 REV  DATE       AUTHOR          DESCRIPTION
 1.0  04-15-92   Lee Mulcahy     Initial version.
 1.1  04-02-93   Lee Mulcahy     Reorganized DF_xx values.
 1.2  07-19-93   Lee Mulcahy     Added CAPS_CALLIDLE
                                 Added DID_301XM, E_SYNTH
 ---  08-13-93   Lee Mulcahy     Latest change.

*/

#ifndef _DIGI
#define _DIGI


/****************************************************************************/
/*                                                                          */
/*  DIGI.H - Miscellaneous                                                  */
/*                                                                          */
/****************************************************************************/

#ifndef TRUE
#define TRUE    1
#endif
#ifndef FALSE
#define FALSE   0
#endif

#ifndef BYTE
typedef unsigned char   BYTE;
typedef unsigned int    WORD;
typedef unsigned long   DWORD;
#endif

    /* DSQuery flag word definitions.   */

#ifndef CAPS_EPCM
#define CAPS_EPCM       0x0001      // DS201A Extended PCM features
#define CAPS_LPC        0x0002      // Driver plays LPC data
#define CAPS_TONE       0x0004      // Supports PCJr 3-voice tone generator
#define CAPS_201A       0x0008      // Unit is DS201A (or compatible)
#define CAPS_ADPCM      0x0010      // Driver plays OKI ADPCM
#define CAPS_CALLB      0x0020      // Driver supports bank switch callback
#define CAPS_LPCVOC     0x0040      // Driver contains LPC vocabulary.
#define CAPS_PCMREC     0x0080      // Driver supports PCM recording
#define CAPS_DRIVERID   0x0100      // DSQuery returns Driver ID in upper 16 bits.
#define CAPS_301        0x0200      // If this bit is set, the following are valid:
#define CAPS_DIGI       0x0400      // Driver supports Digispeech\CVSD\LPC formats
#define CAPS_MIDI       0x0800      // Driver contains MIDI interpreter.
#define CAPS_CALLIDLE   0x1000      // Driver supports Idle callback

    /* The upper 16 bits of the flag word contain the driver ID code.   */

#define DID_UNK         0           // Unknown driver (early version)
#define DID_201         1           // LWDIGI DS201 driver (new version)
#define DID_201A        2           // LWDIGI DS201A driver (new version)
#define DID_301         3           // PDIGI Digital Audio only
#define DID_301M        4           // PDIGI Digital Audio / MIDI Synthesizer
#define DID_301V        5           // PDIGI Digital Audio / LPC Vocabulary
#define DID_301MV       6           // PDIGI All features
#define DID_301TD       7           // PDIGI Digispeech format only.
#define DID_301E        8           // PDIGI Educational LPC Emulator
#define DID_301XM       9           // Miles Design XMI Driver support
#endif

/****************************************************************************/
/*                                                                          */
/*  DIGI.H - Driver Status Codes                                            */
/*                                                                          */
/****************************************************************************/

#ifndef E_OK
#define E_OK            0x0000      // Everything is OK.
#define E_UNDEFINED     0x0001      // Undefined command.
#define E_BUF0          0x0002      // Current buffer is 0.
#define E_BUF1          0x0102      // Current buffer is 1.
#define E_MUSIC         0x0202      // Driver is in 3-tone gen mode.
#define E_COM           0x0003      // Communication error.
#define E_LPC           0x0004      // LPC index out of range.
#define E_CVSDSPEED     0x0005      // CVSD speed is invalid.
#define E_TIMEOUT       0x0006      // Audio Unit not responding.
#define E_ERR           0x0007      // Audio Unit reported an error.

#define E_PAUSE         0x1002      // DS201 is paused.
#define E_GAIN          0x2001      // Invalid gain index.
#define E_INDEX         0x3001      // Buffer index is invalid.
#define E_LENGTH        0x4001      // Buffer length is invalid.
#define E_NOBUFFER      0x5001      // No buffers were defined.
#define E_IGNORED       0x6001      // Command ignored.
#define E_INVALID       0x6002      // Bad tone index specified.
#define E_BUSY          0x6003      // Driver or device is busy
#define E_SYNTH         0x6004      // Driver is playing synth

#define E_ARGUMENT      0x7001      // Invalid API call argument(s).
#define E_RATE          0x7001      // Invalid RATE argument.
#define E_FORMAT        0x7002      // Invalid FORMAT argument.
#define E_MODE          0x7003      // Invalid MODE argument (REC/PLAY).
#define E_VXD           0x7004      // VxD Request error.
#define E_CHANNELS      0x7005      // Invalid channel count.

#endif

/****************************************************************************/
/*                                                                          */
/*  Miscellaneous                                                           */
/*                                                                          */
/****************************************************************************/

#define H_ADPCM         0x11
#define H_PCMDVI        0x12
#define H_MSADPCM       0x13
#define H_SB4           0x14
#define H_SB3           0x15
#define H_SB2           0x16

#define H_DIGICVSD      0x44
#define H_PCMA          0x55
#define H_DIGISTD       0x77
#define H_DIGIFIX       0x78
#define H_DIGIREAL      0x79
#define H_PCMRAW        0x80
#define H_PCMRAW16      0xFE
#define H_PCMMU         0xFF

    /* Codes for data format parameter. */

#define DF_PCM8         0
#define DF_PCMMU        1
#define DF_PCMA         2
#define DF_PCM16        3
#define DF_SB2          4
#define DF_SB3          5
#define DF_SB4          6
#define DF_OKI4         7
#define DF_DVI4         8

#define DF_DIGIREAL     9
#define DF_DIGISTD      10
#define DF_DIGIFIX      11
#define DF_LPC          12
#define DF_MSADPCM      13
#define DF_CVSD         14

#define DF_BAD          -2
#define DF_UNKNOWN      -1

    /* PlayTone() command parameters.   */

#define TONE_ENABLE     0
#define TONE_DISABLE    1
#define TONE_LEVEL      2
#define TONE_FREQ       3

#define TONE_FREQ_MIN   175
#define TONE_FREQ_MAX   3000

    /* Codes for Synthesizer Emulator function parameter.   */

#define SYNTH_INIT      0
#define SYNTH_READ      1
#define SYNTH_WRITE     2
#define SYNTH_RESET     3


/****************************************************************************/
/*                                                                          */
/*  Driver Low Level Prototypes                                             */
/*                                                                          */
/****************************************************************************/

int  DSReset(void);
int  DSLPCStatus(void);
int  DSFPlayLPC(int  index);
int  DSFPlayULPC(char  _far *buf,int len);
int  DSBPlayLPC(int  index);
int  DSBPlayULPC( char _far *buf,int len);
int  DSFRecCVSD( char _far *buf, WORD rate, WORD len );
int  DSFPlayCVSD( char _far *buf, WORD rate, WORD len );
int  DSFRecUCVSD( char _far *buf, int  speed, WORD len);
int  DSFPlayUCVSD( char _far *buf, int speed, WORD len);
int  DSGetStatus(void);
WORD DSGetByteCount( DWORD _far *total );
int  DSSetBuffer( int buffer, int len, char _far *buf);
int  DSSetGain( int gain );
int  DSPause(void);
int  DSResume(void);
int  DSSetCallback(void (_far *routine)() );
int  DSSetCallIdle(void (_far *routine)() );
int  DSBPlayCVSD( int rate, DWORD len );
int  DSBRecCVSD( int rate, DWORD len );
int  DSFPlayDigi( char _far *buf, WORD len );
int  DSBPlayDigi( DWORD len );
int  DSFPlayPCM( char _far *buf, WORD len );
int  DSBPlay( int format, WORD freq, DWORD len );
int  DSBPlayStereo( int pcmType, WORD freq, DWORD len );
int  DSBPlayOKI( int pole, WORD freq, DWORD len );
int  DSBRec( int format, WORD freq, DWORD len );
int  DSToneStart(void);
int  DSToneCmd( BYTE command);
int  DSToneStop(void);
int  DSUninstall(void);
int  DSQuery( WORD _far *majorID, WORD _far *minorID, DWORD _far *caps );
int  DSSetMixer(int  mix);
int  (_far *DSGetEntry(void))(int, BYTE, BYTE );
int  DriverInstalled(void);


/****************************************************************************/
/*                                                                          */
/* Music Driver Prototypes                                                  */
/*                                                                          */
/****************************************************************************/

char  _far *DSSetStatusAddress(char  _far *addr);
int  DSInitSynthesizer(int  mode);
int  DSSetPatchTable(char  _far *lpInstPtr,int  count);
int  DSMusicPlay(char  _far *lpMusicPtr);
int  DSMusicStop(void);
int  DSTranspose(int  cTranspose);
int  DSMIDINoteOn( BYTE thisChannel, BYTE pitch, BYTE velocity );
int  DSMIDINoteOff( BYTE thisChannel, BYTE pitch );
int  DSMIDIPgmChange( BYTE thisChannel, BYTE newInstrument );
int  DSMIDIPitchBend( BYTE thisChannel, BYTE newInstrument );
BYTE _far *DSMIDIGetChannelsPtr(void);
int  DSSetMusicRate(int  ticksPerSecond);
int  DSMusicStatus(void);
int  DSMusicOpen(int  mode);
int  DSMusicClose(void);


/****************************************************************************/
/*                                                                          */
/* Driver High Level Prototypes                                             */
/*                                                                          */
/****************************************************************************/

void _Wait( unsigned int  milliSeconds );
int  Tone( int command, int tone, WORD freq);
int  PlayOneTone( WORD freq, int duration);
int  PlayThreeTone( WORD freq1, WORD freq2, WORD freq3, int duration);
int  StartPlay( int format, WORD rate, int channels, DWORD len );
int  StartRecord( int format, WORD rate, int channels, DWORD len );

#endif

