;---------------------------------------------------------------------------;
;                                                                           ;
;               Simple Terminal program to be used with PCDT                ;
;                       Written  12/21/86                                   ;
;                       Randy Fischer ... FCS                               ;
;                                                                           ;
;---------------------------------------------------------------------------;
main    segment  
;
lf      equ     10
cr      equ     13
comchan equ     03f8h                   ;Com1:
comval  equ     [00]                    ;Com1:  [01] for Com2:
;
        assume  cs:main,ds:main
;
start:  mov     ax,cs                   ;make sure code segment and
        mov     ds,ax                   ;data segment are the same.
        mov     dx,offset hello
        mov     ah,09h                  ;Type message
        int     21h
        mov     ah,00h                  ;set up to init 
        mov     dx,comval               ;COM channal
        mov     al,11100111b            ;9600,n,2,8
        int     14h
Kbstat: mov     ah,01h                  ;get keyboard status
        int     16h
        jz      cstat                   ;no charactor check com channal
pchar:  mov     ah,00h                  
        int     16h                     ;Get the charactor
        cmp     al,03h                  ;Is this a Control-C
        je      quit                    ;YES then quit
comout: mov     dx,comchan              ;Select Com channal
        out     dx,al
cstat:  mov     ah,03h                  
        mov     dx,comval               ;Select COM channal
        int     14h                     ;Get com port status
        and     ah,01h
        jz      kbstat
comchr: mov     bx,offset buffer
        mov     al,"$"
        mov     [bx],al
more:   mov     cx,[200]
wait:   mov     ah,03h
        mov     dx,comval               ;Select COM channal
        int     14h                     ;Check status of COM channal
        and     ah,01h                  ;Is there a char waiting
        jnz     getch                   ;Get the charactor into buffer
        loop    wait                    ;Don't Wait to long for status
;
Type:   mov     al,"$"                  ;Timed out dump buffer
        mov     [bx],al                 ;Mark the end of the buffer
        mov     dx,offset buffer        
        mov     ah,09h
        int     21h
        jmp     kbstat
;
getch:  mov     dx,comchan
        in      al,dx                   ;Get the charactor
        mov     [bx],al                 ;Save the charactor
        inc     bx
        jmp     more
;
quit:   mov     ah,4Ch
        int     21h
;
hello:  db      CR,LF,"TERM version 1.1  Copyright (c) 1986",CR,LF
        db      "Fischer Computer Systems, Angwin, CA",CR,LF,LF,"$"
;
Buffer: db      "Buffered input data goes here ...."
;
main    ends
end     start




