/*****************************************************************************
 * Copyright (C) 1979-1993   Xactware, Inc.  
 * ALL RIGHTS RESERVED.  Proprietary and Confidential
 * 313 East 1200 South  Suite 101
 * Orem,  Utah  84058              (801) 226-2251
 *
 * Comments:
 *
 * $Log$	
 ****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <appmgr.h>
#include <app.h>
#include <menu.h>
#include <frame.h>
#include <field.h>
#include "method.h"
#include "flagpoll.h"

typedef struct INSTANCE_DATA
{
	U32 spare;
} INSTANCE_DATA, *P_INSTANCE_DATA;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Constants								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

static TK_TABLE_ENTRY FlagPollTable[] = {
	{0, 0, 0, 0, tkTableVertical, clsTkTable},
		{"Flag", 0, 0, 0, tkLabelBold, clsLabel},
		{"", 2, 2, tagFlagPollFlag, 0, clsField},
		{"", 2, 2, tagFlagPollFlag+1, 0, clsField},
		{"", 2, 2, tagFlagPollFlag+2, 0, clsField},
		{"", 2, 2, tagFlagPollFlag+3, 0, clsField},
		{"", 2, 2, tagFlagPollFlag+4, 0, clsField},
		{pNull},
	{0, 0, 0, 0, tkTableVertical, clsTkTable},
		{"Value", 0, 0, 0, tkLabelBold, clsLabel},
		{"", 8, 8, tagFlagPollValue, 0, clsField},
		{"", 8, 8, tagFlagPollValue+1, 0, clsField},
		{"", 8, 8, tagFlagPollValue+2, 0, clsField},
		{"", 8, 8, tagFlagPollValue+3, 0, clsField},
		{"", 8, 8, tagFlagPollValue+4, 0, clsField},
		{pNull},
	{pNull}
};

static TK_TABLE_ENTRY FlagPollMenuBar[] = {
	{"Get", msgFlagPollGet, 0, 0, tkLabelBold},
	{"Set", msgFlagPollSet, 0, 0, tkLabelBold},
	{pNull}
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Utilities								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************
 * Function Name:  
 *		TrimLeftSpaces -- Remove left spaces from a string
 * Input:         
 *		CHAR *string;			String to trim
 * Output:  
 *		CHAR *string;			String trimmed (same as string passed in)
 ****************************************************************************/
CHAR *TrimLeftSpaces(CHAR *buffer)
{
	int i, len;

	len = strlen(buffer);
	for (i = 0; i < len; i++)
		if (buffer[i] != ' ')
			break;
	memmove(buffer, buffer + i, len - i + 1);
	return buffer;
} /* TrimLeftSpaces */

/*****************************************************************************
 * Function Name:  
 *		IsValidHex -- Check if a string is a valid hexidecimal number
 * Input:         
 *		CHAR *string;			String to check
 * Output:  
 *		1				        Valid hex number
 *		0				        Invalid hex number
 ****************************************************************************/
IsValidHex(CHAR *buffer)
{
	CHAR c;
	int i;

	i = 0;
	while ((c = buffer[i++]) != '\0')
	{
		if (((c >= '0' && c <= '9') ||
			 (c >= 'a' && c <= 'f') ||
			 (c >= 'A' && c <= 'F')) == 0)
			return 0;
	}

	return 1;
} /* IsValidHex */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          	Methods			  						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************
 * Method Name:  
 *		FlagPollOpen -- Open the flag poll application
 * Message:
 *		msgAppOpen
 * Input:         
 * Output:  
 *		stsOK					Everything went well
 ****************************************************************************/
MsgHandlerWithTypes(FlagPollOpen, P_ARGS, P_INSTANCE_DATA)
{
	APP_METRICS am;
	MENU_NEW mn;
	TK_TABLE_NEW ttn;
	BORDER_STYLE bs;
	int i;
	FIELD field;
	FIELD_STYLE fs;
	XTM_ARGS xtm;
	STATUS s;

	Dbgw20(Debugf("FlagPollOpen"));

	// Get app metrics.
	ObjCallRet(msgAppGetMetrics, self, &am, s);

	// Create and add menu bar.
	ObjCallRet(msgNewDefaults, clsMenu, &mn, s);
	mn.tkTable.client = self;
	mn.tkTable.pEntries = FlagPollMenuBar;
	ObjCallRet(msgNew, clsMenu, &mn, s);

	ObjCallRet(msgAppCreateMenuBar, self, &mn.object.uid, s);
	ObjCallRet(msgBorderGetStyle, mn.object.uid, &bs, s);
	bs.bottomMargin = 2;
	ObjCallRet(msgBorderSetStyle, mn.object.uid, &bs, s);
	ObjCallRet(msgFrameSetMenuBar, am.mainWin, mn.object.uid, s);

	// Create the tk table to get & set debug flags
	ObjCallWarn(msgNewDefaults, clsTkTable, &ttn);
	ttn.tableLayout.style.tblXAlignment = tlAlignCenter;
	ttn.tableLayout.style.tblYAlignment = tlAlignCenter;
	ttn.tableLayout.style.childXAlignment = tlAlignCenter;
	ttn.tableLayout.style.growChildWidth = false;
	ttn.tableLayout.style.growChildHeight = false;
	ttn.tableLayout.rowHeight.constraint = tlGroupMax;
	ttn.tableLayout.colWidth.constraint = tlGroupMax;
	ttn.tkTable.pEntries = FlagPollTable;
	ObjCallRet(msgNew, clsTkTable, &ttn, s);

	// Make field overwrites & set translators
	xtm.xtmType = xtmTypeCharList;
	xtm.pXtmData = "0123456789abcdefABCDEF";
	for (i=0; i<5; i++)
	{
		field = (WIN)ObjectCall(msgWinFindTag,
								ttn.object.uid, (P_ARGS)(tagFlagPollFlag+i));
		ObjCallRet(msgFieldGetStyle, field, &fs, s);
		fs.editType = fstOverWrite;
		ObjCallRet(msgFieldSetStyle, field, &fs, s);
		ObjCallRet(msgBorderGetStyle, field, &bs, s);
 		bs.edge = bsEdgeNone;
		ObjCallRet(msgBorderSetStyle, field, &bs, s);
		field = (WIN)ObjectCall(msgWinFindTag,
								ttn.object.uid, (P_ARGS)(tagFlagPollValue+i));
		ObjCallRet(msgFieldGetStyle, field, &fs, s);
		fs.editType = fstOverWrite;
		fs.xlateType = fstXlateTemplate;
		ObjCallRet(msgFieldSetStyle, field, &fs, s);
		ObjCallRet(msgFieldSetXlate, field, &xtm, s);
		ObjCallRet(msgBorderGetStyle, field, &bs, s);
 		bs.edge = bsEdgeNone;
		ObjCallRet(msgBorderSetStyle, field, &bs, s);
	}

	// Set the tk table as the clientWin.
	ObjCallRet(msgFrameSetClientWin, am.mainWin, ttn.object.uid, s);

	return stsOK;
	MsgHandlerParametersNoWarning;
} /* FlagPollOpen */

/*****************************************************************************
 * Method Name:  
 *		FlagPollClose -- Close the Flag Poll application
 * Message:
 *		msgAppClose
 * Input:         
 * Output:  
 *		stsOK					Everything went well
 ****************************************************************************/
MsgHandler(FlagPollClose)
{
	APP_METRICS am;
	WIN win;
	STATUS s;

	Dbgw20(Debugf("FlagPollClose"));

	// Free the menu bar & main window
	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameDestroyMenuBar, am.mainWin, pNull, s);
	ObjCallRet(msgFrameGetClientWin, am.mainWin, &win, s);
	ObjCallRet(msgDestroy, win, pNull, s);

	return stsOK;
	MsgHandlerParametersNoWarning;
} /* FlagPollClose */

/*****************************************************************************
 * Method Name:  
 *		FlagPollGet -- Get the value of the debug flag
 * Message:
 *		msgFlagPollGet
 * Input:         
 * Output:  
 *		stsOK					Everything went well
 ****************************************************************************/
MsgHandler(FlagPollGet)
{
	int i;
	FIELD flag, value;
	CONTROL_STRING cs;
	CHAR flagBuf[3], valueBuf[9];
	U16 flagNumber;
	U32 flagValue;
	STATUS s;

	Dbgw20(Debugf("FlagPollGet"));

	for (i=0; i<5; i++)
	{
		flag = (WIN)ObjectCall(msgWinFindTag,
								theRootWindow, (P_ARGS)(tagFlagPollFlag+i));
		value = (WIN)ObjectCall(msgWinFindTag,
								theRootWindow, (P_ARGS)(tagFlagPollValue+i));
		cs.pString = flagBuf;
		cs.len = 3;
		ObjCallRet(msgLabelGetString, flag, &cs, s);

		// If the flag is not set then blank out value
		if (strlen(flagBuf) == 0)
		{
			ObjCallRet(msgLabelSetString, value, "", s);
			continue;
		}

		// If the length is only 1 assume the flag is a character flag
		TrimLeftSpaces(flagBuf);
		if (strlen(flagBuf) == 1)
		{
			flagValue = DbgFlagGet(flagBuf[0], 0xFFFFFFFF);
			sprintf(valueBuf, "%08lx", flagValue);
			ObjCallRet(msgLabelSetString, value, valueBuf, s);
		}
		else
		{
			if (IsValidHex(flagBuf) == 0)
			{
				ObjCallRet(msgLabelSetString, value, "********", s);
				continue;
			}
			sscanf(flagBuf, "%hx", &flagNumber);
			flagValue = DbgFlagGet(flagNumber, 0xFFFFFFFF);
			sprintf(valueBuf, "%08lx", flagValue);
			ObjCallRet(msgLabelSetString, value, valueBuf, s);
		}
	}

	return stsOK;
	MsgHandlerParametersNoWarning;
} /* FlagPollGet */

/*****************************************************************************
 * Method Name:  
 *		FlagPollSet -- Close the Flag Poll application
 * Message:
 *		msgFlagPollSet
 * Input:         
 * Output:  
 *		stsOK					Everything went well
 ****************************************************************************/
MsgHandler(FlagPollSet)
{
	int i;
	FIELD flag, value;
	CONTROL_STRING cs;
	CHAR flagBuf[3], valueBuf[9];
	U16 flagNumber;
	U32 flagValue;
	STATUS s;

	Dbgw20(Debugf("FlagPollSet"));

	for (i=0; i<5; i++)
	{
		flag = (WIN)ObjectCall(msgWinFindTag,
								theRootWindow, (P_ARGS)(tagFlagPollFlag+i));
		value = (WIN)ObjectCall(msgWinFindTag,
								theRootWindow, (P_ARGS)(tagFlagPollValue+i));
		cs.pString = flagBuf;
		cs.len = 3;
		ObjCallRet(msgLabelGetString, flag, &cs, s);
		cs.pString = valueBuf;
		cs.len = 9;
		ObjCallRet(msgLabelGetString, value, &cs, s);

		// If the flag is not set then ignore it
		if (strlen(flagBuf) == 0)
			continue;

		// Remove initial spaces & check that the value is a valid hex number
		TrimLeftSpaces(valueBuf);
		if (IsValidHex(valueBuf) == 0)
		{
			ObjCallRet(msgLabelSetString, flag, "**", s);
			continue;
		}

		// If the length is only 1 assume the flag is a character flag
		TrimLeftSpaces(flagBuf);
		if (strlen(flagBuf) == 1)
		{
			sscanf(valueBuf, "%lx", &flagValue);
			DbgFlagSet(flagBuf[0], flagValue);
		}
		else
		{
			sscanf(flagBuf, "%hx", &flagNumber);
			sscanf(valueBuf, "%lx", &flagValue);
			DbgFlagSet(flagNumber, flagValue);
		}
	}

	return stsOK;
	MsgHandlerParametersNoWarning;
} /* FlagPollSet */

/*****************************************************************************
 * Function Name:  
 *		ClsFlagPollInit -- Install the Flag Poll application
 * Input:         
 * Output:  
 *		stsOK					Everything went well
 ****************************************************************************/
STATUS ClsFlagPollInit (void)
{
	APP_MGR_NEW	new;
	STATUS s;

	Dbgw20(Debugf("ClsFlagPollInit"));

	// Install the application class.
	ObjCallWarn(msgNewDefaults, clsAppMgr, &new);
	new.object.uid				= clsFlagPoll;
	new.object.key				= objWKNKey;
	new.cls.pMsg			  	= clsFlagPollTable;
	new.cls.ancestor		  	= clsApp;
	new.cls.size				= SizeOf(INSTANCE_DATA);
	// This class has no msgNew arguments of its own.
	new.cls.newArgsSize			= SizeOf(APP_NEW);
	new.appMgr.flags.stationery	= false;
	new.appMgr.flags.accessory	= true;
	strcpy(new.appMgr.company, "Xactware, Inc.");
	strcpy(new.appMgr.defaultDocName, "Flag Poll");
	strcpy(new.appMgr.name, "Flag Poll");
	strcpy(new.appMgr.version, "July 16, 1993");
	new.appMgr.copyright = "1993 Xactware, Inc.  All Rights Reserved.";
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	return stsOK;
} /* ClsFlagPollInit */

/*****************************************************************************
 * Method Name:  
 * Message:
 *		msgBeingHandled
 * Input:         
 *		int argc;			// In: number of command-line arguments
 *		char * argv[];		// In: the argument strings 
 *		U16 processCount;	// In: count of times this process invoked
 * Output:  
 *		stsOK					Everything went well
 ****************************************************************************/
void CDECL main (
	int			argc,
	char *		argv[],
	U16			processCount)
{
	Dbgw20(Debugf("main: starting flagpoll.exe[%d]", processCount));

	if (processCount == 0)
	{
		// Create global classes.
		StsWarn(ClsFlagPollInit());

		// Invoke app monitor to install this application.
		AppMonitorMain(clsFlagPoll, objNull);

	} else
	{
		// Create private classes.

		// Create an application instance and dispatch messages.
		AppMain();
	}
	Unused(argc); Unused(argv);
} /* main */
