/****************************************************************************
 File: LBDemo.c

 Copyright 1992 GO Corporation. All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.4  $ 
   $Author:   cbazzare  $
     $Date:   02 Apr 1992 11:21:12  $

***************************************************************************/

/* The included files */
#ifndef STDIO_INCLUDED
#include <stdio.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>				// for debugging statements.
#endif

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>				// for O-OP support.
#endif

#ifndef APP_INCLUDED
#include <app.h>				// for application messages
#endif

#ifndef APPMGR_INCLUDED
#include <appmgr.h>				// for AppMgr startup stuff
#endif

#ifndef STRING_INCLUDED
#include <string.h>				// for strcpy().
#endif

#ifndef LABEL_INCLUDED
#include <label.h>				// for label.
#endif

#ifndef FRAME_INCLUDED
#include <frame.h>				// for frame metrics (and clayout.h)
#endif

#ifndef OSHEAP_INCLUDED
#include <osheap.h>
#endif

#ifndef MENU_INCLUDED
#include <menu.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef BUTTON_INCLUDED
#include <button.h>
#endif

#ifndef TTABLE_INCLUDED
#include <ttable.h>
#endif

#ifndef COUNTER_INCLUDED
#include <counter.h>
#endif

#ifndef LISTBOX_INCLUDED
#include <listbox.h>
#endif

#ifndef XGESTURE_INCLUDED
#include <xgesture.h>
#endif

#ifndef SEL_INCLUDED
#include <sel.h>
#endif

#ifndef LBDEMO_INCLUDED
#include "lbdemo.h"
#endif

#ifndef LBLIST_INCLUDED
#include "lblist.h"
#endif

#include <methods.h>			// method function prototypes generated by MT

#define clsLBDemo				MakeWKN(3510,1,wknGlobal)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Local Types and Constants                                              *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define spaceBetweenRows      5 	 		// absolute logical units
#define spaceBetweenButtons   0  			// absolute logical units
#define topAndBottomMargin	  5     		// absolute logical units
#define leftAndRightMargin	  5 			// absolute logical units

static const TK_TABLE_ENTRY menus[] = {
	{"Misc",			0, 0, 0, tkMenuPullDown},
		{"Clear"},
      	{pNull},
	{"Sort", 		0, 0, 0, tkMenuPullDown},
      {0, 0, 0, 0, 0, clsChoice},      
   		{"Numerically",			0, 0, 0, tkButtonOn},
   		{"Alphabetically",		0, 1},
        {pNull},
	  {pNull},
   	{pNull}
};

// Labels for the header of my table
static const TK_TABLE_ENTRY tableHeader[] = {
	{"To Do",  0, 0, 0, tkBorderMarginNone | tkLabelBold, clsLabel },
	{"Begin",  0, 0, 0, tkBorderMarginNone | tkLabelBold, clsLabel },
	{"End",    0, 0, 0, tkBorderMarginNone | tkLabelBold, clsLabel },
	{pNull}
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Local Functions and Macros                                             *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 LayoutComponents  
 ***************************************************************************/
STATIC STATUS
LayoutComponents(
	P_LBDEMO_APP_DATA 	pInst)
{
	CSTM_LAYOUT_CHILD_SPEC		cs;
	STATUS						s;

	// Specify how the custom layout window should position the header table.
	CstmLayoutSpecInit(&(cs.metrics));
	cs.child = pInst->headerWin;
	cs.metrics.x.constraint = ClAlign(clMinEdge, clSameAs, clMinEdge);
	cs.metrics.y.constraint = ClAlign(clMaxEdge, clSameAs, clMaxEdge);
	cs.metrics.w.constraint	= clSameAs;
//	cs.metrics.h.constraint	= clAsIs;
	cs.metrics.h.constraint = clAbsolute;
	cs.metrics.h.value		= 12;
	ObjCallRet(msgCstmLayoutSetChildSpec, pInst->lbdemoWin, &cs, s);

	// Specify how the CstmLayout window should position the Scroll window.
	CstmLayoutSpecInit(&(cs.metrics));
	cs.child = pInst->swWin;
	cs.metrics.x.constraint = ClAlign(clMinEdge, clSameAs, clMinEdge);
	cs.metrics.y.constraint = clSameAs;
	cs.metrics.w.constraint	= clSameAs;
	cs.metrics.h.relWin		= pInst->headerWin;
	cs.metrics.h.constraint	= ClExtend(clSameAs, clMinEdge);
	ObjCallRet(msgCstmLayoutSetChildSpec, pInst->lbdemoWin, &cs, s);

	return stsOK;

} /* LayoutComponents */

/****************************************************************************
 CreateScrollWin  
 ***************************************************************************/
STATIC STATUS
CreateScrollWin(
	OBJECT 			   	self,
	P_LBDEMO_APP_DATA 	pInst)
{
	LB_LIST_NEW					lbn;
	STATUS						s;

	// list box was created by msgInit since it has state that must 
	// be filed when closing the window.
	// this routine just inserts the list box into the custom layout
	lbn.listBox.client = self;
	lbn.object.uid = pInst->swWin;

	// reset internal selection mechanism
	pInst->deselect     = false;
	
	// insert the list box into the custom layout window
	lbn.win.parent  = pInst->lbdemoWin; 
	lbn.win.options = wsPosTop;
	ObjCallRet(msgWinInsert, lbn.object.uid, &lbn.win, s);

	return stsOK;

} /* CreateScrollWin	*/

/****************************************************************************
 CreateHeader 
 ***************************************************************************/
STATIC STATUS
CreateHeader(
	OBJECT 				self,
	P_LBDEMO_APP_DATA 	pInst)
{
	TK_TABLE_NEW				header;
	STATUS						s;

	//Create the header table 
	ObjCallWarn(msgNewDefaults, clsTkTable, &header);
	header.border.style.edge				= bsEdgeNone;

	//	Set the appearance of the tkTable.
	header.tableLayout.style.growChildWidth		= true;
	header.tableLayout.style.growChildHeight	= true;
	header.tableLayout.numRows.constraint  		= tlAbsolute;
	header.tableLayout.numRows.value	   		= 1;
	header.tableLayout.numCols.constraint  		= tlAbsolute;
	header.tableLayout.numCols.value	   		= 3;
	header.tableLayout.rowHeight.constraint		= tlMaxFit;
	header.tableLayout.rowHeight.gap	   		= spaceBetweenButtons;
	header.tableLayout.colWidth.constraint 		= tlMaxFit;
	header.tableLayout.colWidth.gap				= spaceBetweenRows;
	header.tkTable.client						= self;
	header.tkTable.pEntries 					= tableHeader;

	ObjCallRet(msgNew, clsTkTable, &header, s);
	pInst->headerWin = header.object.uid;

	// insert the header table into the custom layout window
	header.win.parent = pInst->lbdemoWin; 
	header.win.options = wsPosTop; 
	ObjCallRet(msgWinInsert, header.object.uid, &header.win, s);


	return stsOK;

} /* CreateHeader	*/

/****************************************************************************
 CreateLBWindow
 ***************************************************************************/
STATIC STATUS
CreateLBWindow (
	OBJECT 				self,
	P_LBDEMO_APP_DATA 	pInst)
{
	STATUS				s;
	CSTM_LAYOUT_NEW	cn;

	// Create a custom layout window to manage my 2 UI components
	ObjCallWarn(msgNewDefaults, clsCustomLayout, &cn);
	cn.border.style.leftMargin = cn.border.style.rightMargin = bsMarginSmall;
	cn.border.style.topMargin = cn.border.style.bottomMargin = bsMarginSmall;
	cn.win.flags.style |= wsShrinkWrapHeight;

	if (DbgFlagGet('F', 0x40L))
	{
		cn.border.style.join				= bsJoinRound;
		cn.border.style.edge				= bsEdgeAll;
		cn.border.style.backgroundInk	= bsInkGray33;
	}

	ObjCallRet(msgNew, clsCustomLayout, &cn, s);

	pInst->lbdemoWin = cn.object.uid;
	
	StsRet( CreateHeader(self, pInst), s);
	StsRet( CreateScrollWin(self, pInst), s);
	StsRet( LayoutComponents(pInst), s);

	return stsOK;

} /* CreateLBWindow */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                         		Methods		  				 		   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	LBCreateMenuBar
	
	Respond to msgAppCreateMenuBar.
****************************************************************************/
MsgHandlerWithTypes(LBCreateMenuBar, P_OBJECT, PP_LBDEMO_APP_DATA)
{
	MENU_NEW	   	mn;
	STATUS		   	s;

	// Create the menu bar here...
	ObjectCall(msgNewDefaults, clsMenu, &mn);
	mn.win.flags.style	&= ~wsSendFile;
	mn.tkTable.pEntries	= menus;
	mn.tkTable.client		= self;
	ObjCallRet(msgNew, clsMenu, &mn, s);
	*pArgs = mn.object.uid;

	ObjCallAncestorRet(msg, self, pArgs, ctx, s);

	// set instance data
	(*pData)->menuBar = mn.object.uid;

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// LBCreateMenuBar


/****************************************************************************
 LBFree
	
 free the instance data storage.
****************************************************************************/
MsgHandlerWithTypes(LBFree, P_ARGS, PP_LBDEMO_APP_DATA)
{
	OBJ_KEY			key = objWKNKey;
	STATUS 			s;

	// destroy scroll list box
	ObjCallRet(msgDestroy, (*pData)->swWin, &key, s);

	// free instance data
	StsWarn(OSHeapBlockFree((*pData)));

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* LBFree */

/****************************************************************************
 LBInit
	
 Respond to msgInit. Allocate the List Box demo instance data.
****************************************************************************/
MsgHandlerWithTypes(LBInit, P_APP_NEW, PP_LBDEMO_APP_DATA)
{
	STATUS						s;
	P_LBDEMO_APP_DATA		 	pInst;
	LB_LIST_NEW					lbn;

	// Allocate the instance data storage
	StsRet(OSHeapBlockAlloc(osProcessHeapId, SizeOf(LBDEMO_APP_DATA), \
			&pInst), s);

	StsRet( ObjectWrite(self, ctx, &pInst), s);

	// Create a list box to manage the index of titles
	ObjCallRet(msgNewDefaults, clsLBList , &lbn, s);
	lbn.listBox.client = self;
	lbn.listBox.nEntries = 0;
	lbn.lbList.data = *pData;
	ObjCallRet(msgNew, clsLBList, &lbn, s);

	(*pData)->swWin = lbn.object.uid;

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* LBInit */

/****************************************************************************
	LBOpen
	
	Respond to msgAppOpen.
****************************************************************************/
MsgHandlerWithTypes(LBOpen, P_OBJECT, PP_LBDEMO_APP_DATA)
{
	APP_METRICS					am;
	OBJECT						menuBar;
	STATUS						s;

	Dbg(Debugf("List Box demo: Create the client Win");)

	// Create the List Box demo window.
	StsRet( CreateLBWindow(self, (*pData)), s);

	// trace the scroll window messages
//	ObjCallWarn(msgTrace, (*pData)->swWin, (P_ARGS)true);
//	ObjCallWarn(msgTrace, self, (P_ARGS)true);

	// Create the menu Bar.
	menuBar = objNull;
	ObjCallRet(msgAppCreateMenuBar, self, &menuBar, s);

	// Get the main application window.
	ObjCallRet(msgAppGetMetrics, self, &am, s);

	// Make the application border thicker and gray
	{
		WIN_METRICS		winMetrics;
		BORDER_STYLE	borderStyle;

		// border window is the child of the frame
		ObjCallRet(msgWinGetMetrics, am.mainWin, &winMetrics, s);

		ObjCallRet(msgBorderGetStyle, winMetrics.child, &borderStyle, s);
		borderStyle.backgroundInk	= bsInkGray33;
		borderStyle.edge				= bsEdgeAll;
		borderStyle.shadow			= bsShadowThickGray;
		borderStyle.shadowGap 		= bsGapWhite;
		borderStyle.join				= bsJoinSquare;
		borderStyle.leftMargin		= bsMarginMedium;
		borderStyle.rightMargin		= bsMarginMedium;
		borderStyle.topMargin		= bsMarginMedium;
		borderStyle.bottomMargin  	= bsMarginMedium;
		ObjCallRet(msgBorderSetStyle, winMetrics.child, &borderStyle, s);
	}

	// Insert the List Box demo window as the frame client win.
	ObjCallRet(msgFrameSetClientWin, am.mainWin,  \
                             			(P_ARGS) (*pData)->lbdemoWin, s );

	// Insert the menu bar.
	ObjCallRet(msgFrameSetMenuBar, am.mainWin, 	\
												(P_ARGS) (*pData)->menuBar, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* LBOpen */

/****************************************************************************
	LBClose
	
	Respond to msgAppClose by destroying the client window.
	The ancestor has already taken us off-screen.
****************************************************************************/
MsgHandlerWithTypes(LBClose, P_OBJECT, PP_LBDEMO_APP_DATA)
{
	APP_METRICS		am;
	WIN				win;
	OBJ_KEY			key = objWKNKey;
	STATUS			s;

	// release the selection
	ObjCallRet(msgSelSetOwner, theSelectionManager, pNull, s);

	// Get the client window.
	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameGetClientWin, am.mainWin, (P_ARGS)&win, s);

	// Destroy the MenuBar
	ObjCallRet(msgFrameDestroyMenuBar, am.mainWin, pNull, s);

	// extract the scroll list before destroying client window.
	// since I need to file the data embedded in the list box.
	ObjCallRet(msgWinExtract, (*pData)->swWin, pNull, s);

	// Destroy client window.
	ObjCallRet(msgDestroy, win, &key, s);
	Dbg(Debugf("List Box demo: back from freeing client Win");)

	return stsOK;
	MsgHandlerParametersNoWarning;
} /* LBClose */

/****************************************************************************
	LBSave
	
	Save self to a file.
****************************************************************************/
MsgHandlerWithTypes(LBSave, P_OBJ_SAVE, PP_LBDEMO_APP_DATA)
{
	STATUS 			s;

	Dbg(Debugf("List Box demo: App Save");)

	// tell list box to save its data (list)
	ObjCallRet(msgListSave, (*pData)->swWin, pArgs, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* LBSave */


/****************************************************************************
	LBRestore
	
	Restore self from a file.

	Note: clsmgr has already initialized instance data to zeros.
****************************************************************************/
MsgHandlerWithTypes(LBRestore, P_OBJ_RESTORE, PP_LBDEMO_APP_DATA)
{
	STATUS 				s;

	Dbg(Debugf("List Box demo: App Restore");)

	// tell list box to restore its data (list)
	ObjCallRet(msgListRestore, (*pData)->swWin, pArgs, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* LBRestore */

/****************************************************************************
	ClsLBAppInit
	
	Install the List Box demo application.
****************************************************************************/
STATUS ClsLBAppInit (void)
{
	APP_MGR_NEW	new;
	STATUS		s;

	// Install the class.
	ObjCallWarn(msgNewDefaults, clsAppMgr, &new);
	new.object.uid					= clsLBDemo;
	new.object.key 		  			= (OBJ_KEY)clsLBTable;
	new.cls.pMsg			  		= clsLBTable;
	new.cls.ancestor		  		= clsApp;
	new.cls.size			  		= SizeOf(P_LBDEMO_APP_DATA);
	new.cls.newArgsSize				= SizeOf(APP_NEW);
	new.appMgr.flags.stationery		= true;
	new.appMgr.flags.accessory		= true;
	new.appMgr.flags.allowEmbedding	= false;
	new.appMgr.flags.hotMode		= false;
	new.appMgr.defaultRect.size.w	= 240;
	new.appMgr.defaultRect.size.h	= 300;
	strcpy(new.appMgr.company, "GO Corporation");
	strcpy(new.appMgr.defaultDocName, "List Box demo");
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	if (DbgFlagGet('F', 0x20L)) 
	{
		Dbg(Debugf("Turning on message tracing for clsLBDemo (toolkit)");)
		(void)ObjCallWarn(msgTrace, clsLBDemo, (P_ARGS) true);
	}

	return stsOK;

} /* ClsLBAppInit */

/****************************************************************************
	main
	
	Main application entry point.
****************************************************************************/
void CDECL main (
	int			argc,
	char *		argv[],
	U16			processCount)
{
	Dbg(Debugf("main: starting ListBoxDemo.exe[%d]", processCount);)

	if (processCount == 0) 
	{
		// Initialize the application.
		ClsLBAppInit();

		// Invoke app monitor to install this application.
		AppMonitorMain(clsLBDemo, objNull);
	} 
	else 
	{
		// Initialize LBList.
		ClsLBListInit();

		// Start the application.
		AppMain();
	}
	Unused(argc);  Unused(argv);	// Suppress compiler warnings
} /* main */
