/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  LBXfer.c
  (C) Copyright 1992 by Go Corporation, All Rights Reserved.

 $Revision:   1.3  $
   $Author:   cbazzare  $
     $Date:   18 Mar 1992 14:00:46  $

  Implementing Move/Copy
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef STDIO_INCLUDED
#include <stdio.h>
#endif

#ifndef GO_INCLUDED
#include <go.h>
#endif

#ifndef XFER_INCLUDED
#include <xfer.h>
#endif

#ifndef OSHEAP_INCLUDED
#include <osheap.h>
#endif

#ifndef EMBEDWIN_INCLUDED
#include <embedwin.h>
#endif

#ifndef PEN_INCLUDED
#include <pen.h>
#endif

#ifndef SEL_INCLUDED
#include <sel.h>
#endif

#ifndef LIST_INCLUDED
#include <list.h>
#endif

#ifndef LABEL_INCLUDED
#include <label.h>				
#endif

#ifndef XGESTURE_INCLUDED
#include <xgesture.h>
#endif

#ifndef STRING_INCLUDED
#include <string.h>				
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef TENCODE_INCLUDED
#include <tencode.h>
#endif

#ifndef LISTBOX_INCLUDED
#include <listbox.h>
#endif

#ifndef LIMITS_INCLUDED
#include <limits.h>
#endif

#ifndef LBDEMO_INCLUDED
#include "lbdemo.h"
#endif

#ifndef LBLIST_INCLUDED
#include "lblist.h"
#endif

#include <methods.h>	  	// method function prototypes generated by MT

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Local Types and Constants                                              *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define APPEND		0
#define INSERT		1

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Local Functions and Macros                                             *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                         		Methods								   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * The next 2 methods are used by the selection mechanism    			   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
	LBSelSelect

	 msgSelSelect.
****************************************************************************/
MsgHandlerWithTypes(LBSelSelect, P_ARGS, PP_LBDEMO_APP_DATA)
{
	STATUS		s;
	WIN			lb = (*pData)->swWin;


	Dbg(Debugf("List Box demo: Gaining the selection");)

	// 
	// If the view is not selected, force it to repaint.
	// (This code is needed for the move/copy protocol; otherwise,
	// tapping or press-tapping on a row does not highlight
	// the selection properly).
	//
	
	s = ObjectCall(msgSelIsSelected, self, pNull);

	if (s == stsNoMatch) 
	{
		ObjCallWarn(msgWinDirtyRect, lb, pNull);
	}

	return stsOK;
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	Following messages are for the Move/Copy protocol support
****************************************************************************/

/****************************************************************************
	LBSelBeginMoveAndCopy

	 msgSelBeginMove and msgSelBeginCopy.
****************************************************************************/
MsgHandlerWithTypes(LBSelBeginMoveAndCopy, P_XY32, PP_LBDEMO_APP_DATA)
{
	WIN_METRICS							wm;
	OBJECT								w = pNull;
	OBJECT								parent;

	EMBEDDED_WIN_BEGIN_MOVE_COPY		ew;
	STATUS								s;

	// Get Selection Bounds	in the root window coordinate system
	w = (*pData)->previousSelWin;
	ObjCallRet(msgWinGetMetrics, w, &wm, s);
	parent = wm.parent;
	wm.parent = (*pData)->lbdemoWin;
	ObjCallRet(msgWinTransformBounds, parent, &wm, s);
	ew.bounds = wm.bounds;
	
	if (pArgs) 
		ew.xy = *pArgs;
	else 
		ew.xy = ew.bounds.origin;

	if (s >= stsOK) 
		return ObjCallWarn(msg == msgSelBeginCopy ? msgEmbeddedWinBeginCopy :\
					msgEmbeddedWinBeginMove, wm.parent, &ew);
	else 
		return ObjectCallAncestor(msg, wm.parent, pArgs, ctx);
	
	MsgHandlerParametersNoWarning;	
}

TAG	sourceFormats[] = {xferString};
#define N_SOURCE_FORMATS (SizeOf(sourceFormats) / SizeOf(sourceFormats[0]))
/****************************************************************************
	LBXferList

	 msgXferList.
****************************************************************************/
MsgHandlerWithTypes(LBXferList, OBJECT, PP_LBDEMO_APP_DATA)
{
	STATUS		s;

	// Don't let ancestor add types.  We aren't interested in 
	// moving/copying the window, which is the only type the
	// ancestor supports.
	StsRet(XferAddIds(pArgs, sourceFormats, N_SOURCE_FORMATS), s);

	return stsOK;
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	LBXferGet

	 msgXferGet.
****************************************************************************/
MsgHandlerWithTypes(LBXferGet, P_XFER_FIXED_BUF, PP_LBDEMO_APP_DATA)
{
	STATUS		s;

	if (pArgs->id == xferString) 
	{
		CONTROL_STRING		cntrString;
		
		// get string size
		cntrString.len = 0;
		ObjCallRet(msgLabelGetString, (*pData)->previousSelWin, 
													&cntrString, s);

		// get string for the label
		pArgs->len = cntrString.len;
		cntrString.pString = pArgs->buf;
		ObjCallRet(msgLabelGetString, (*pData)->previousSelWin, 
													&cntrString, s);

		// set end of string, null terminated
		pArgs->buf[ cntrString.len ] = '\0';
		
		s = stsOK;
	} 
	else 
		s = ObjectCallAncestorCtx(ctx);

	return s;
	MsgHandlerParametersNoWarning;	
}

TAG receiverFormats[] = {xferString};
#define N_RECEIVER_FORMATS (SizeOf(receiverFormats) / SizeOf(receiverFormats[0]))
/****************************************************************************
	LBSelMoveAndSelCopy

	 msgSelMoveSelection and msgSelCopySelection.
****************************************************************************/
MsgHandlerWithTypes(LBSelMoveAndSelCopy, P_XY32, PP_LBDEMO_APP_DATA)
{
	TAG 			transferType;
	OBJECT			owner;
	XFER_LIST_NEW	listNew;
	STATUS			s;

	// Initialize for error recovery
	listNew.object.uid = NULL;

	// Get source of move/copy.
	ObjCallJmp(msgSelOwner, theSelectionManager, &owner, s, Error);
	if (! owner) 
	{
		Dbg(Debugf("no owner!");)
		s = stsFailed;
		goto Error;
	}

	// Get list of available types.  
	ObjCallJmp(msgNewDefaults, clsXferList, &listNew, s, Error);
	ObjCallJmp(msgNew, clsXferList, &listNew, s, Error);
	ObjCallJmp(msgXferList, owner, listNew.object.uid, s, Error);
	StsJmp(XferListSearch(listNew.object.uid, receiverFormats,
  			N_RECEIVER_FORMATS, &transferType), s, Error);

	// This only handles one transfer type now, but we expect to handle
	// more in the future.  So code it in that style.
	if (transferType == xferString) 
	{
		// determine the proper position in the list box to insert
		// this new entry.

		XFER_FIXED_BUF 				xfer;
		LIST_BOX_POSITION_XY		listPosition;
		LIST_BOX_ENTRY				listEntry;
		
		WIN_METRICS	  				wm;
		OBJECT		  				clientWin;

		LIST_BOX_METRICS			lbm;
		BOOLEAN						mode;

		// get the label string from the source
		xfer.id = xferString;
		ObjSendUpdateJmp(msgXferGet, owner, &xfer, SizeOf(xfer), s, Error);


		// If this was a move, delete the source.
		// this must be done before inserting because if you insert 
		// before the previous selection, the previous selection moves 
		// down and you end up deleting the wrong row
		if (MsgEqual(msgSelMoveSelection, msg))
		{
			ObjSendU32Jmp(msgListBoxRemoveSel, owner, pNull, s,
					Error);
		} 


		ObjCallRet(msgScrollWinGetClientWin, self, &clientWin, s);	
		// XYToPosition requires the coordinate to be in the listbox inner win 
		// coordinate
		wm.parent = clientWin;
		wm.bounds.origin = *pArgs;
		ObjCallRet(msgWinTransformBounds, self, &wm, s);

		// find destination window in the list box
		listPosition.place = wm.bounds.origin;
		s = ObjectCall(msgListBoxXYToPosition, self,  &listPosition);

		if (s == stsNoMatch) 
		{
			s = stsOK;

			// append entry at the end

			// get number of elements in the list box */
			ObjCallRet(msgListBoxGetMetrics, self, &lbm, s);

			listEntry.position 	= lbm.nEntries - 1;
			mode = APPEND;
		}
		else
		{
			listEntry.position 	= listPosition.position;
			mode = INSERT;
		}

		// insert entry into list box
	  	listEntry.win	 	= objNull;
		listEntry.listBox 	= self;

		// Allocate label string data
		StsRet(OSHeapBlockAlloc(osProcessHeapId, xfer.len,	&listEntry.data), s);

		// copy xfer.buf to listEntry.data
		memcpy(listEntry.data, xfer.buf, xfer.len);

		if ( mode == APPEND )
			ObjCallWarn(msgListBoxAppendEntry, self, &listEntry);
		else
			ObjCallWarn(msgListBoxInsertEntry, self, &listEntry);

		s = stsOK;
	} 
	else 
		goto Error;


	ObjCallWarn(msgDestroy, listNew.object.uid, pNull);
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	if (listNew.object.uid)
	{
		ObjCallWarn(msgDestroy, listNew.object.uid, pNull);
	}
	return s;

}

