/***************************************************************************
 File: sxip.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you do not resell 
 the code and that this notice (including the above copyright notice) is 
 reproduced on all copies.  THIS SAMPLE CODE IS PROVIDED "AS IS", WITHOUT 
 WARRANTY OF ANY KIND, AND GO CORPORATION EXPRESSLY DISCLAIMS ALL IMPLIED 
 WARRANTIES, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL GO 
 CORPORATION BE LIABLE TO YOU FOR ANY CONSEQUENTIAL,INCIDENTAL, OR INDIRECT 
 DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THIS SAMPLE CODE.
			  
 $Revision:   1.0  $
   $Author:   aloomis  $
     $Date:   13 Aug 1992 12:14:22  $

 This file contains the methods for clsIP messages.

****************************************************************************/
#ifndef STROBJ_INCLUDED
#include <strobj.h>
#endif

#ifndef TK_INCLUDED
#include <tk.h>
#endif

#ifndef INSERT_INCLUDED
#include <insert.h>
#endif

#ifndef INTL_INCLUDED
#include <intl.h>
#endif

#ifndef SXAPP_INCLUDED
#include "sxapp.h"
#endif
#include "methods.h"

/*
 * Respond to msgIPDataAvailable.
 *
 * Even though I use my own command bar (and message), terminating data entry
 * with a CR, will cause a msgIPDataAvailable message to be send. SXIPCommand,
 * the method for the command bar buttons will self send msgIPDataAvailable
 * when the user taps the 'Send' button.
 */
MsgHandlerWithTypes(SXIPDataAvailable, OBJECT, PP_SX_APP_DATA)
{
	IP_STRING ipstring;
	STATUS s;

	Dbg(Debugf(U_L("SXIPDataAvailable >>"));)

	ipstring.len = maxU16;
	ipstring.pString = objNull;

	ObjCallRet(msgIPGetXlateString, pArgs, &ipstring, s);
	ObjCallWarn(msgSXSendSerial, self, ipstring.pString);

	StsWarn(OSHeapBlockFree(ipstring.pString));

	Dbg(Debugf(U_L("<< SXIPDataAvailable"));)
	return(stsOK);

	MsgHandlerParametersNoWarning;
} /* IPDataAvailable */

/*
 * Respond to msgSXIPCommand.
 *
 * Handles Send & Clear buttons in the custom commandbar of the IP.
 */
MsgHandlerWithTypes(SXIPCommand, P_ARGS, PP_SX_APP_DATA)
{

	Dbg(Debugf(U_L("SXIPCommand >>"));)

	/* Nothing fancy, self send msgIPDataAvailable for the send button,
	 * msgIPClear for the clear button.
	 */
	switch ((U32)pArgs) {
		case 0: /* Send */
			ObjCallWarn(msgIPDataAvailable, self, (P_ARGS)(*pData)->sxIPWin);
			break;
		case 1: /* Clear */
			ObjCallWarn(msgIPClear, (*pData)->sxIPWin, (P_ARGS)pNull);
			break;
	}

	Dbg(Debugf(U_L("<< SXIPCommand"));)

	return(stsOK);

	MsgHandlerParametersNoWarning;
} /* SXIPCommand */
