
/* 
acpa low-level driver 
This file Copyright 1997 by David J. Weis

djweis - started oct 1996

supported modes pcm adpcm mulaw alaw
*/

#define DEBUG

#include "../sound_config.h"

#include <linux/mca.h>
#include "acpa.h"

int acpa_base = 0;
int acpa_range = 8;
int acpa_irq = 0;

int acpa_bases[4] = { 0xfdc0, 0xfdc8, 0xfdd0, 0xfdd8 };
int acpa_irqs[8] = { 3, 4, 5, 6, 9, 10, 11, 12 };


static int acpa_sample_rate = 0;
static unsigned int acpa_bits_per_sample = 0;
static short acpa_channels = 0;

/* following vars are for onboard dsp, the memory on card */
/* TODO : this comes from some arrays in the ibm source code */
static int pbufstart = 0x0e70; /* beginning of play data buffers */
static int pblocksize = 280; /* size of play block */
static int numblocks = 8; /* number of data blocks */

static int volatile acpa_qlen = 0;

static unsigned char commandval = 0;       /* not sure what this is yet :-) */

int mailbox = MAILBOX1;
int trackcb = TRACK1CB;
int pcmcb = PCMCB1;
int mastercb = MASTERCB;


static int acpa_audio_open(int dev, int mode)
{
  int retval;

  if (mode & OPEN_READ) {
    printk("acpa_audio_open - recording not allowed\n");
    return -EPERM;
  }

  printk("acpa_audio_open dev %d mode %d\n", dev, mode);

  /*
  retval = sound_open_dma(1, "ACPA pseudo-DMA");
  printk("sound_open_dma returned %d\n", retval);
  */

  if ( mode == OPEN_WRITE ) {
    load_pcm_play();
  } else {
    load_pcm_record();
  }


  /*
    need to stop passthru and load appropriate dsp module here
   */
  return(0);
}


static void acpa_audio_close(int dev)
{
  int retval;

  /*
  sound_close_dma(1);
  */

  /*
    load passthru module back on 
    */
  passthru(0x108);
}


static void acpa_set_output_parms(int dev, unsigned long buf, int count,
				  int intrflag, int restart_dma)
{
  printk("acpa_set_output_parms\n");


}


static void acpa_set_input_parms(int dev, unsigned long buf, int count,
				 int intrflag, int restart_dma)
{
  printk("acpa_set_input_parms\n");

}


static int acpa_audio_ioctl(int dev, unsigned int cmd, caddr_t arg, int local)
{
  printk("acpa_audio_ioctl\n");
  return -EINVAL;
}


static int acpa_audio_prepare_for_input(int dev, int bsize, int bcount)
{
  printk("acpa_audio_prepare_for_input\n");

  return(0);
}


static int acpa_audio_prepare_for_output(int dev, int bsize, int bcount)
{
  printk("acpa_audio_prepare_for_output\n");

  return(0);
}


static void acpa_audio_reset(int dev)
{
  printk("acpa_audio_reset\n");

}


static void acpa_audio_halt_xfer(int dev)
{
  printk("acpa_audio_halt_xfer\n");

}


static int acpa_local_qlen(int dev)
{
  printk("acpa_local_qlen\n");
  return(acpa_qlen);
}


void acpa_copy_from_user(int dev, char * localbuf, int localoffs,
			 const char * userbuff, int useroffs, int len)
{
  printk("acpa_copy_from_user %d bytes\n", len);

  memcpy_fromfs(&localbuf[localoffs], &userbuff[useroffs], len);

  printk("in acpa_copy_from_user char 1 is %c\n", localbuf[localoffs]);

  DMAbuf_inputintr(dev);
}


static void acpa_audio_trigger(int dev, int bits)
{
  printk("acpa_audio_trigger\n");

}


static int acpa_audio_set_speed(int dev, int speed)
{
  printk("acpa_audio_set_speed %d\n", speed);

  acpa_sample_rate = speed;

  return(acpa_sample_rate);
}


static unsigned int acpa_audio_set_bits(int dev, unsigned int bits)
{
  printk("acpa_audio_set_bits %d\n", bits);

  acpa_bits_per_sample = bits;

  return(acpa_bits_per_sample);
}


static short acpa_audio_set_channels(int dev, short channels)
{
  printk("acpa_audio_set_channels %d\n", channels);

  acpa_channels = channels;

  return(acpa_channels);
}


void acpa_irq_handler(int irq, void * dev_id, struct pt_regs * dummy)
{
  int at_mail = acpa_in(mailbox + 2);
  int tms_buffer_count = acpa_in(mailbox + 4);
  int tms_curr_buffer = acpa_in(mailbox + 1);
  int at_curr_buffer = acpa_in(mailbox + 3);

  printk("acpa_irq_handler\n");

  /* TODO - this is most certainly wrong. i'm making part of it up */
  if (tms_buffer_count > 32020) {
    tms_buffer_count -= 32000 + numblocks;
    acpa_out(mailbox + 4, tms_buffer_count);
    acpa_out(trackcb + 6, tms_buffer_count);
  }

  /* TODO - skipping record section, assume op is play */



  acpa_command(commandval & 0xfd); /* clear irq from acpa */
}


static struct audio_driver acpa_audio_driver = {
  acpa_audio_open,
  acpa_audio_close,
  acpa_set_output_parms,
  acpa_set_input_parms,
  acpa_audio_ioctl,
  acpa_audio_prepare_for_input,
  acpa_audio_prepare_for_output,
  acpa_audio_reset,
  acpa_audio_halt_xfer,
  acpa_local_qlen,
  acpa_copy_from_user,
  NULL,
  NULL,
  acpa_audio_trigger,
  acpa_audio_set_speed,
  acpa_audio_set_bits,
  acpa_audio_set_channels
};



int attach_acpa(void)
{
  int slot;
  unsigned char reg2;

  int retval;

  int format_mask = AFMT_U8;
  int audio_flags = 0;

  printk("attach_acpa - hello!\n");

  slot = mca_find_adapter(ACPA_ID, 0);
  if (slot == MCA_NOTFOUND) {
    printk("ACPA not found, dying\n");
    return(1);
  } else {
    reg2 = mca_read_stored_pos(slot,2);
    acpa_irq = acpa_irqs[(reg2 >>3) & 7];
    acpa_base = acpa_bases[(reg2 >> 1) & 3];

    printk("ACPA: IRQ %i, IO base 0x%x\n", acpa_irq, acpa_base); 
    /*    request_irq(acpa_irq, acpa_irq_handler, 0, "M-ACPA/A", NULL); */

    if (snd_set_irq_handler(acpa_irq, acpa_irq_handler, "M-ACPA/A", NULL) < 0)
      printk("sorry, irq taken\n");

    request_region(acpa_base, acpa_range, "M-ACPA/A");

    acpa_command(0);
    passthru(0x108);

    retval = sound_install_audiodrv(AUDIO_DRIVER_VERSION,
				    "M-ACPA/A",
				    &acpa_audio_driver,
				    sizeof(struct audio_driver),
				    audio_flags,
				    format_mask,
				    NULL,
				    1,
				    1);

    printk("sound_install_audiodrv returned %d\n", retval);
    sound_alloc_dma(1, "ACPA pseudo-DMA");
    /*    sound_close_dma(1); */

  }

  return(0);
}


void unload_acpa(void)
{

  acpa_command(0);  /* shut off dsp */

  release_region(acpa_base, acpa_range);
  free_irq(acpa_irq, NULL);

  sound_free_dma(1);

  printk("acpa_remove - goodbye!\n");
}


static void acpa_out(unsigned int addr, unsigned int data)
{
  DEB(printk("acpa_out addr %d data %d\n", addr, data));

  cli();        /* we (IBM) don't want interrupts during this */
  outw(addr, acpa_base + ADDREGLOW);
  outw(data, acpa_base + DATAREGLOW);
  sti();
}


static unsigned int acpa_in(unsigned int addr)
{
  int data;

  DEB(printk("acpa_in addr %d ", addr));

  cli();     /* IBM doesn't want interrupts here either */
  outw(addr, acpa_base + ADDREGLOW);
  data = inw(acpa_base + DATAREGLOW);
  sti();

  DEB(printk("returned %d\n", data));

  return data;

}


static void acpa_command(char command)
{

  DEB(printk("acpa_command %c\n", command));

  commandval = command;
  outb(command, acpa_base + 6);
}


static void acpa_clear_block(unsigned int address, unsigned int length,
			     unsigned int data)
{
  int i;

  printk("acpa_clear_block ad %d len %d dat %d\n", address, length, data);
  cli();

  outw(address, acpa_base + 4);  /* set address */
  for ( i = 0; i < length; i++)
    outw(data, acpa_base + DATAREGLOW);

  sti();
}


static void dsp_run(void)
{
  int input_count = 0;
  int tms_mail = 0;

  printk("dsp_run - made it!!\n");

  /* dsp is already running something, passthru at beginning */
  acpa_out(mailbox, 0x55aa);
  acpa_command(SPKREN+TMSINT+HINTENA+TMSRES);  /* enables acpa */
  while (acpa_in(mailbox) == 0x55aa) {
    input_count++;
  }
  printk("dsp_run waiting on mailbox 0, input_count = %d\n", input_count);

  acpa_out(trackcb + 5, 0); /* adpcm mode not used ?? */
  acpa_out(mailbox + 4, 0); /* buffer count  = 0 */

  acpa_out(pcmcb + 1, 0); /* TODO this is pcm only, normal pcm */

  acpa_out(pcmcb + 2, acpa_sample_rate); /* sample rate in hz */

  acpa_out(pcmcb + 3, 33); /* dither rate */

  acpa_out(pcmcb + 4, acpa_bits_per_sample); /* bits per sample - 8 or 16 */

  acpa_out(pcmcb + 5, 0);  /* byte swapping off */

  acpa_out(pcmcb + 8, acpa_channels);  /* num channels */

  acpa_out(pcmcb + 11, 0);  /* mix off */

  /* TODO need to figure out what no sound == , ie 0x00 or 0x80 */
  /* going with 0x00 for now :-)  */
  acpa_clear_block( pbufstart, pblocksize * numblocks, 0x00);

  /*   TODO  -- fix with read write support
  if (mode == RECORD)
    tms_mail = 1;
  else
  */
  tms_mail = 5;   /* mailbox used to communicate with dsp */

  /* TODO set volume */


  acpa_out(mailbox, tms_mail);  /* start the acpa up */

}


static void passthru(int inpsel)
{
  int i;

  outw(0x08, acpa_base + HOSTCOMREG);   /* reset dsp, disable ints */
  outw(0x08, acpa_base + CLEARACCESSERR); /* clear acc_err ?? */

  printk("passthru checkpoint 1\n");

  outw(0, acpa_base + ADDREGLOW);   /* set address to code space */
      /* !should! autoincrement the address pointer */

  for ( i = 0; i < NELEMS(passthru_code); i++ ) {
    outw(passthru_code[i], acpa_base);
  } /* for */

  printk("last words 0x%4.4x 0x%4.4x\n", 
	 passthru_code[i-2], passthru_code[i-1]);
  printk("passthru checkpoint2, words code 0x%x, i is 0x%x\n", 
	 NELEMS(passthru_code), i);
 
  outw(0x1ffc, acpa_base + ADDREGLOW);  /* put input in this reg. */
  outw(inpsel, acpa_base + DATAREGLOW);

  outw(0x09, acpa_base + HOSTCOMREG);  /* remove reset bit 0, ints disabled */
  outw(0x09, acpa_base + CLEARACCESSERR);

  outw(0x1fff, acpa_base + ADDREGLOW);  /* check if dsp responds */
  for ( i = 0; i < RETRY_COUNT; i++) {
    if (inw(acpa_base + DATAREGLOW) == 0x55aa) {
      printk("got dsp response in %i tries\n", i);
      break;
    } /* if */
  } /* for loop */

  outw(0x03, acpa_base + HOSTCOMREG);  /* verify dsp response to host int */
  for ( i = 0; i < RETRY_COUNT; i++) {
    if (inw(acpa_base + DATAREGLOW) == 0x5a5a) {
      printk("got int response in %i tries\n", i);
      break;
    } /* if */
  } /* for */
} /* passthru */


static int load_pcm_play(void)
{

	int i;

	cli();  /* don't want ints, may not be possible to disable this long */

	acpa_command(0);  /* shut it down */

	/*
	outw(0x08, acpa_base + HOSTCOMREG);
	outw(0x08, acpa_base + CLEARACCESSERR);

	outw(0, acpa_base + ADDREGLOW);
	*/

	for ( i = 0; i < NELEMS(ibmpcmp_code); i++) {
		outw(ibmpcmp_code[i], acpa_base);
	}

	for ( i = 0; i < 8; i++) {
	  acpa_out(mastercb + i, 0x0000);
	}

	dsp_run();

	return(0);
}

static int load_pcm_record(void)
{
  return(0);
}
