/**********************************************************************/
/*                         AVC103_Strategy_c                          */
/*                                                                    */
/* This function is the strategy routine for the AVC 1.03             */
/* Compatibility Mode.                                                */
/*                                                                    */
/*  IOCTLs:                                                           */
/*       Function catagory 0x8d, function code 0x40                   */
/*       data -> int request ID                                       */
/*                 0 = ADPCM init:  data -> struct {                  */
/*                                     +0 = int request id            */
/*                                     +2 = int Process ID            */
/*                                     +4 = long semaphore ID         */
/*                                     +8 = int ACPA base I/O addr    */
/*                                     +10 = int interrupt level      */
/*                                     +12 = char far *ctrlval        */
/*                 1 = ADPCM close:  free semaphore                   */
/*                 2 = Return open count in *data + 4 (long)          */
/*                 3 = MIDI initialize                                */
/*                 4 = MIDI Track Volume                              */
/*                           *data+2   Volume (0 - 7FFF)              */
/*                           *data+4   Duration in .1 secs (0-7FFF)   */
/*                 5 = MIDI Track Balance                             */
/*                           *data+2   Balance (0=left, 7FFF=right)   */
/*                           *data+4   duration in .1 secs (0-7FFF)   */
/*                 6 = MIDI Master Volume                             */
/*                           *data+2   Volume (0-7FFF)                */
/*                 7 = Query queue status                             */
/*                           *data+2 = output queue size              */
/*                           *data+4 = # bytes in output queue        */
/*                           *data+6 = input queue size               */
/*                           *data+8 = # bytes in input queue         */
/*                                                                    */
/* 10/15/91 BRR102 - Init trackcb for MIDI mode.                      */
/* 10/28/91 BRR160 - Set dsp_loaded to -1 in open for compatibility   */
/* 10/28/91 BRR164 - Mark both tracks as being used when open         */
/* 11/08/91 BRR181 - Don't display message if OS/2 2.0                */
/* 11/25/91 BRR198 - Use trk_array instead of OPENCOUNT to determine  */
/*                   card usage.                                      */
/* 01/23/92 BRR236 - Add duration to DevMstVolume                     */
/* 02/06/92 BRR259 - Set avc103_mode before calling strategy_c on     */
/*                   OPEN call so all inits that used to be done in   */
/*                   the open but moved to AUDIO_INIT with BRR177 can */
/*                   still be done at OPEN for avc                    */
/* 04/15/92 BRR383 - Set operation = PLAY instead of PLAY_AND_RECORD  */
/* 04/30/92 BRR438 - Set device not ready instead of write_protect bit*/
/* 04/30/92 BRR426 - Init PSPDATALOC for AVC MIDI                     */
/* 05/15/92 BRR456 - Add OS/2 K12 Support                             */
/**********************************************************************/

#if IS_OS2
#define  INCL_DOS
#include <os2.h>
#endif
#include "audiodd.h"
#include "auddef.h"
#include "audproto.h"
#include "audiodd2.h"
#include "audmsg.h"

#define MIDITRK 1
#define MIDICB  0xe08

/* Host Command Reg equates */
#define  TMSRES         1              /* 0 = Reset C25 (1 = C25 running)  */
#define  HREQACK        2              /* 0 = Clear int from C25           */
#define  HINTENA        4              /* 1 = Enable ints to host from C25 */
#define  TMSINT         8              /* 0 = interrupt C25                */
#define  SPKREN         0x10           /* 1 = Enable Speaker               */

#define STDOUT          1
#define MAXMSGLEN       256

#define AUDS_PSPDATALOC 0x1400                 /* Voice data location  */

/* AVC 1.03 General IOCTL Category & Function ID's */
#define  GIOCAT    0x8d
#define  GIOCOD    0x40

/* Structure of an General IOCTL data area for inital call */
struct  GIX0pkt {
int     reqid;                  /* request ID            (INPUT)        */
int     procid;                 /* process ID of caller  (INPUT)        */
long    syssem;                 /* id of system semaphore (INPUT)       */
unsigned iobase;                /* IO base for audio card (INPUT)       */
int     intlev;                 /* interrupt level        (INPUT)       */
char far *ctrlval;              /* addr of ctrl value     (OUTPUT)      */
};
typedef struct GIX0pkt far *GIX0;


/* External function prototypes */
void Strategy_c(struct Packet far *rb, int trk);
void avc103_init(struct Packet far *rb);
void acpa_command(char newctrlval);
#if NOT_K12
void init_midi(void);
void SetVoice(int inst, int type, int id);
void relink(void);
void midi_cb_init(void);
#endif

HSEM     SemHndl1 = 0;                 /* semaphore handle for track 1     */
unsigned int miscflags = 0;            /* MIDI_ACTIVE, SEM_ACTIVE          */

unsigned char    a_nszMsgBuff [MAXMSGLEN];
unsigned char    a_nszMsgFile [] = "AUDIODD.MSG\0";
unsigned char    a_nszMsgNum[] = "0\0";
unsigned char    a_MsgId[] = "AUD";
unsigned long    a_IvTable;
unsigned short   a_MsgLen = 0;

extern int mode[];
extern unsigned long operation[];
extern trackcb[2];
#if NOT_K12
extern unsigned short pspdataloc;
#endif

void AVC103_strategy_c(rb)
struct Packet far *rb;
{
   extern int avc103_mode;
   extern char ctrlval;             /* common byte between caller/dev driver*/
   extern int  opencounter;         /* incremented each open                */
   extern int trk_array[];          /* trk_array holding sysfilenumbers */
   extern int dsp_use_count;
   extern int irqnum;
   long lock_handle;         /* Lock handle during IOCTL             */
   extern struct vscb xmitio[],recio[];
   extern unsigned int initflags[];
   extern int revtrk;
   extern int dsp_loaded;           /* Set with dsp load module ID      */
   extern int dsp_to_load;          /* Mode ID, 0x4000=Record,0x2000=HQ */

   struct GIX0pkt far *GIODptr;        /* Pointer to IOCTL data               */
   unsigned far *GIOtptr;              /* Temp pointer during IOCTL           */

   switch(rb->PktHdr.PktCmd){
   default:                                     /* BAD COMMAND ID             */
      rb->PktHdr.PktStatus = done + unknown_command;
      break;

   case 0:                                      /* INIT                       */
      avc103_init(rb);
      /* Determine if this is OS/2 Version 2.0+ */
      break;

   case 4:                                      /* READ                       */
#if NOT_K12
      if(!(miscflags & MIDI_ACTIVE)){           /* Has MIDI been init'd?      */
         init_midi();                           /*  If not, go do it          */
         initflags[MIDITRK] = INITED;                 /*    set INIT'ed flag        */
         SetClock(MIDITRK);
         acpa_command(SPKREN+TMSINT+HINTENA+TMSRES); /* Enable ACPA              */
      }
#endif
      Strategy_c(rb,MIDITRK);                   /* Pass it to DD              */
      break;

   case 5:                                    /* NONDESTRUCTIVE READ, NO WAIT */
      Strategy_c(rb,MIDITRK);                    /* Pass it to DD              */
      break;

   case 6:                                      /* READ STATUS                */
      Strategy_c(rb,MIDITRK);                    /*  Pass it to DD             */
      break;

   case 7:                                      /* FLUSH INPUT                */
      Strategy_c(rb,MIDITRK);                    /*  Pass it to DD             */
      break;

   case 8:                                      /* WRITE                      */
#if NOT_K12
      if(!(miscflags & MIDI_ACTIVE)){           /* Has MIDI been init'd?      */
         init_midi();                           /*  If not, go do it          */
         initflags[MIDITRK] = INITED;                 /*    set INIT'ed flag        */
         SetClock(MIDITRK);
         acpa_command(SPKREN+TMSINT+HINTENA+TMSRES); /* Enable ACPA              */
      }
#endif
      Strategy_c(rb,MIDITRK);                    /* Pass it to DD              */
      break;

   case 10:                                     /* WRITE STATUS               */
      rb->PktHdr.PktStatus = done + unknown_command;
      break;

   case 11:                                     /* FLUSH OUTPUT               */
      Strategy_c(rb,MIDITRK);                   /* Pass it to DD              */
      break;

   case 13:                                     /* OPEN                       */
      /* if both tracks were empty when we came in - then trk_array would be  */
      /* all 0's - note avc does NOT set up trk_array in Get_Track     */
      if(trk_array[1]!=0 || trk_array[0]!=0){
         rb->PktHdr.PktStatus = done + error + device_not_ready;
         break;
      }
      avc103_mode = 1;
#if NOT_K12
      pspdataloc = AUDS_PSPDATALOC;
#endif
      Strategy_c(rb,MIDITRK);
      revtrk = 0;
      mode[MIDITRK] = ADPCM;
      SemHndl1 = 0;
      miscflags &= 0xffff - MIDI_ACTIVE;        /* Clear MIDI active flag  */

      if(dsp_use_count == 0){
         acpa_command(0);                       /* Make sure ACPA shut down*/
         if(GetDevInt(irqnum)){                 /* Hook Device Interrupt   */
            return;
         }
      }
      dsp_use_count |= (1 << MIDITRK);          /* Set our in-use bit      */
      trk_array[1] = trk_array[0] = 0x5A5A;     // Make both tracks ours
      dsp_loaded = -1;
      dsp_to_load = -1;
#if NOT_K12
      midi_cb_init();
#endif
      break;

   case 14:                                     /* CLOSE                      */
      Strategy_c(rb,MIDITRK);                   /*  Pass it to DD             */
      avc103_mode = 0;                          /* Clear AVC 1.03 Compat mode */
#if NOT_K12
      miscflags &= 0xffff-MIDI_ACTIVE;          /* Clear MIDI active flag     */
      DevAllNotesOff();                         /* Turn off any hung notes    */
#endif
      trk_array[0] = 0;
      trk_array[1] = 0;
      break;

   case 16:                                     /* GENERAL IOCTL              */
      if((((GIO)rb)->GIOcat != GIOCAT)
       ||(((GIO)rb)->GIOcode != GIOCOD)){
         rb->PktHdr.PktStatus = done + unknown_command;
         break;
      }
      GIODptr = ((GIO)rb)->GIOData;             /* Get pointer to IOCTL data  */
      VerifyAccess((char far *)GIODptr,16,1);   /* Verify that its valid    */
      lock_handle = Lock((char far *)GIODptr,0,1); /* Go lock segment         */
      switch(GIODptr->reqid){                   /* Process request's by ID    */
      case 0:                                   /* Pass IOBASE/intlvl to appl */
         miscflags |= SEM_ACTIVE;               /* Set semaphore active flag  */
         GIODptr->ctrlval = PhysToUVirt(VirtToPhys((char far *)&ctrlval),1,4);
         SemHndl1 = SemHandle((HSEM)GIODptr->syssem,1);  /* Flag semaphore In-Use */
         break;
      case 1:                                   /* free semaphore             */
         miscflags &= 0xffff-SEM_ACTIVE;        /* Clear semaphore active flag*/
         SemClear(SemHndl1);                    /* Clr sem before closing     */
         SemHandle(SemHndl1,0);                 /* Set semaphore NOT In-Use   */
         PhysToUVirt(GIODptr->ctrlval,2,4);     /* Free Virtual Address       */
         break;
      case 2:                                   /* Open counter               */
         GIODptr->procid = opencounter;         /* Return # opens             */
         break;
      case 3:                                   /* MIDI Initialize            */
#if NOT_K12
         initflags[MIDITRK] = INITED;                 /*    set INIT'ed flag        */
         init_midi();
#endif
         ((IOB)xmitio[MIDITRK].Virt)->runflags = STARTED;
         acpa_command(SPKREN+TMSINT+HINTENA+TMSRES); /* Enable ACPA              */

         break;

      case 4:                                   /* MIDI Track Volume          */
         DevTrkVolume(GIODptr->procid,(int)GIODptr->syssem,MIDITRK);
         break;
      case 5:                                   /* MIDI Track Balance         */
         DevTrkBalance(GIODptr->procid,(int)GIODptr->syssem,MIDITRK);
         break;
      case 6:                                   /* MIDI Master Volume         */
         DevMstVolume(GIODptr->procid,0,MIDITRK);
         break;
      case 7:                                   /* Query MIDI Input q size    */
         GIOtptr = &(GIODptr->procid);          /*  Set GIOtptr               */
         /* are these backwards??? */
         *GIOtptr++ = (unsigned)((IOB)recio[MIDITRK].Virt)->size;    /* +2 = input buffer size     */
         *GIOtptr++ = (unsigned)((IOB)recio[MIDITRK].Virt)->count;   /* +4 = # bytes in receive q  */
         *GIOtptr++ = (unsigned)((IOB)xmitio[MIDITRK].Virt)->size;   /* +6 = output buffer size    */
         *GIOtptr++ = (unsigned)((IOB)xmitio[MIDITRK].Virt)->count;  /* +8 = # bytes in output q   */
         break;
      default:                                  /* Invalid request ID         */
         rb->PktHdr.PktStatus = done + unknown_command;
         break;
      }/*end inner switch*/
      UnLock(lock_handle);
      rb->PktHdr.PktStatus = done;
      break;

   case 20:                                /* DEINSTALL                  */
      Strategy_c(rb,MIDITRK);
      break;

   }/*end outer switch*/
}

#if NOT_K12
void init_midi()
{
   extern unsigned int tempo[];
   extern int ppqn[],ppqndiv[],ppqncntr[];
   int x;

   miscflags |= MIDI_ACTIVE;               /* Set MIDI Active flag       */

   tempo[MIDITRK] = 1200;                       /* Reset timing data          */
   ppqn[MIDITRK] = 24;
   ppqndiv[MIDITRK] = 1;
   ppqncntr[MIDITRK] = 1;
   SetClock(MIDITRK);

   for(x=0; x<8; x++){                     /* Set all voices == Piano    */
      SetVoice(x,0,64);
   }

   operation[MIDITRK] = PLAY;
   mode[MIDITRK] = MIDI;

   trackcb[MIDITRK] = MIDICB;     /* Init addr of MIDI ctrl blk */

   DevMstVolume(0x7fff,0,MIDITRK);
   DevTrkVolume(0x7fff,0,MIDITRK);
   DevTrkBalance(0x4000,0,MIDITRK);
}
#endif
