/***************************************************************************/
/*                      Waveform_Update                                    */
/*                                                                         */
/* DSP ADPCM variables:                                                    */
/*                                                                         */
/* E00-E07 Track 1 controls         E08-E0F Track 2 controls               */
/*    E00   Master volume              E08 Master volume                   */
/*    E01   Track Volume               E09 Track volume                    */
/*    E02   Volume time                E0A volume time                     */
/*    E03   Track Balance              E0B Track Balance                   */
/*    E04   Balance Time               E0C Balance Time                    */
/*    E05   Audio Type                 E0D Audio Type                      */
/*          (0=music, 1=voice, 2=stereo)                                   */
/*                                                                         */
/* E10-E17 Master controls                                                 */
/*    E10   0=Mic, 1=Line                                                  */
/*    E11   1=Monitor on, 0=Monitor off                                    */
/*    E12   Interrupt source                                               */
/*    E13   Interrupt Inhibit                                              */
/*                                                                         */
/* E18-E1F Track 1 mailbox          E20-E27 Track 2 Mailbox                */
/*    E18   TMS Command from host      E20 TMS command from host           */
/*    E19   TMS buffer ->              E21 TMS buffer ->                   */
/*    E1A   Message to host            E22 Message to host                 */
/*    E1B   Host buffer ->             E23 Host buffer ->                  */
/*    E1C   buffer count               E24 Buffer count                    */
/*    E1D   TMS Status                 E25 TMS Status                      */
/*                                                                         */
/***************************************************************************/

extern int tms_curr_buffer1;
extern int at_curr_buffer1;
extern int buffer_count1;
extern int host_buffer_count1;
extern int numblocks1;
extern int blocksize1;                          /* Data block size in words */
extern int bufstart1;
extern int tms_mail1;
extern int at_mail1;

extern struct OutPacket far *adpcm1_q[9]; /* queue of packets              */
extern int BlockCounter1;
extern unsigned int cur_count1;           /* bytes remaining in cur packet */

extern unsigned int GDTsel1;
extern unsigned char far *GDTptr1;

int   serialize1b = 0;                    /* adpcm1_update lock               */

unsigned int offset1;


int waveform_update()            /* Return 0 if a block written, -1 if not */
{
   int size,x;

   if(++serialize1b != 1){    /* This can only be the interrupt */
      serialize1b--;
      return(-1);
   }

   if(cur_count1==0){
      if(adpcm1_q[0]==NULL){              /* Do we have our next block yet? */
         serialize1b=0;                   /*    if not, return             */
         return(-1);
      }
      cur_count1 = adpcm1_q[0]->OutPktIOcount;
      offset1 = 0;
      if(PhysToGDTSelector(adpcm1_q[0]->OutPktIOpData,cur_count1,GDTsel1)){
int3(0x50,0,0,2);
      }
   }

   /* Are ACPA buffers all full? */
   read_mailbox1();
   if((host_buffer_count1 - buffer_count1) >= numblocks1-1){
      serialize1b=0;
      return(-1);                            /* If so, nothing to do here  */
   }

   size = blocksize1*2;                      /* Size of 1 ACPA buffer      */

   /* Is there enough data in this packet to fill buffer?   */
   if(cur_count1 < size){
int3(0x50,0,0,1);
      if(adpcm1_q[0] == NULL){               /* Is another packet waiting? */
         serialize1b = 0;                    /*   if not, exit             */
         return(-1);
      }

      acpa_wblock(bufstart1+(blocksize1*at_curr_buffer1),GDTptr1+offset1,cur_count1/2);
      size -= cur_count1;

      /* Get next rb */
      for(x=0; x<8; x++){
         adpcm1_q[x] = adpcm1_q[x+1];
      }
      adpcm1_q[8] = NULL;
      BlockCounter1++;
      cur_count1 = adpcm1_q[0]->OutPktIOcount;
      offset1 = 0;
      if(PhysToGDTSelector(adpcm1_q[0]->OutPktIOpData,cur_count1,GDTsel1)){
int3(0x50,0,0,3);
      }
   }

#if 0
   acpa_wblock(bufstart1+(blocksize1*at_curr_buffer1)+(blocksize1-(size/2)),GDTptr1+offset1,size/2);
#else
   for(x=0; x<size-400; x+=400){
      acpa_wblock(bufstart1+(blocksize1*at_curr_buffer1)+(blocksize1-(size/2))+(x/2),GDTptr1+offset1+x,200);
   }
   acpa_wblock(bufstart1+(blocksize1*at_curr_buffer1)+(blocksize1-(size/2))+(x/2),GDTptr1+offset1+x,(size-x)/2);
#endif

   offset1 += size;
   if((cur_count1 -= size)==0){           /* Are we done with this packet? */
      DevDone(adpcm1_q[0]);               /* Flag request done             */
      for(x=0; x<8; x++){                 /* Move all our pointers up 1    */
         adpcm1_q[x] = adpcm1_q[x+1];
      }
      adpcm1_q[8] = NULL;                 /* zero out last pointer         */
      BlockCounter1++;                    /* and inc our block counter     */
   }

read_mailbox1();
   host_buffer_count1++;                        /* Inc our buffer counter  */
   at_curr_buffer1 = ++at_curr_buffer1 % numblocks1;  /* and block pointer */
   acpa_write(0xe1b,at_curr_buffer1);

   serialize1b=0;
   return(0);
}
