/**************************START OF SPECIFICATIONS **************************/
/* SOURCE FILE NAME: AUDMSG.H                                               */
/*                                                                          */
/* DISCRIPTIVE NAME: Multimedia Ring 0 message file                         */
/*                                                                          */
/* FUNCTION:                                                                */
/*                                                                          */
/* NOTE:                                                                    */
/*   DEPENDENCIES: NONE                                                     */
/*   RESTRICTIONS: NONE                                                     */
/*                                                                          */
/* ENTRY POINTS: none                                                       */
/*                                                                          */
/* EXTERNAL REFERENCES: none                                                */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/* DATE      DEVELOPER         DESCR.                                       */
/*                                                                          */
/************************** END OF SPECIFICATIONS ***************************/
/*01/23/92 - CMC01 -Add FOX DD DOS and OS/2 messages                        */
/*01/20/92 - DHH920120 - add error msg for multiple loads of driver         */
/*02/20/92 - BRR186 - Add DOS two track support                             */
/*03/26/92 - BRR327 - Change Copyright to include 1992.                     */
/*                                                                          */
/****************************************************************************/
/*          DOS Messages                                                    */
/****************************************************************************/
#if NOT_OS2
char startmsg1[] = {
"(C) Copyright IBM Corp. 1990, 1991, 1992.  ALL RIGHTS RESERVED.\x0d\x0a\
IBM Ultimedia Systems, Austin.\x0d\x0a\
Version 1.02.00 04/10/92\x0d\x0a"};

char err_msg_1[] = {                                             /* BRR28 */
"Installation of Audio Device Driver Failed.\x0d\x0a\x00\x00" }; /* BRR28 */

char err_msg_2[] = {
"Duplicate Device Name Found.\x0d\x0a\x00\x00"};             /*DHH920120*/
/****************************************************************************/
/*          ACPA Specific Messages                                          */
/****************************************************************************/
   #if IS_ACPA
      #if IS_K12                                                           /*61491*/
         char startmsg0[] = {
         "\x0d\x0aIBM Audio Capture & Playback Adapter Wave-only Device Driver\x0d\x0a"};
      #else
         char startmsg0[] = {
         "\x0d\x0aIBM Audio Capture & Playback Adapter Device Driver\x0d\x0a"};
      #endif
      #if NUM_TRACKS > 1
         char startmsg2[] = {
         "Installing card 0 as devices AUDIO1$ and AUDIO1$ on interrupt level ? .\x0d\x0a\x0d\x0a\x00\x00" };
      #else
         char startmsg2[] = {
         "Installing card 0 as device AUDIO1$ on interrupt level ? .\x0d\x0a\x0d\x0a\x00\x00" };
      #endif

      #define CARD_NUM_POS  16
      #if NUM_TRACKS > 1                                               //BRR186
         #define AUDIO_NUM_POS  34                                     //BRR186
         #define AUDIO_NUM_POS2 46                                     //BRR186
         #define IRQ_NUM_POS    68                                     //BRR186
         #define OLD_POS        74                                     //BRR186
      #else
         #define AUDIO_NUM_POS 33
         #define IRQ_NUM_POS   55
         #define OLD_POS       61                                      //BRR149
      #endif
   #endif
/****************************************************************************/
/*          PS/1 Specific Messages                                          */
/****************************************************************************/
   #if IS_PS1
      #if IS_K12                                                           /*61491*/
         char startmsg0[] = {
         "\x0d\x0aIBM Personal System/1 Wave-only Device Driver\x0d\x0a"};
      #else
         char startmsg0[] = {
         "\x0d\x0aIBM Personal System/1 Device Driver\x0d\x0a"};
      #endif
        char startmsg2[] = {
        "Installed as device AUDIO1$ on interrupt level 7.\x0d\x0a\x0d\x0a\x00\x00" };
   #endif
/****************************************************************************/
/*          Sound Blaster Specific Messages                                 */
/****************************************************************************/
   #if IS_SNDB
      #if IS_K12                                                           /*61491*/
         char startmsg0[] = {
         "\x0d\x0aSound Blaster Adapter Wave-only Device Driver\x0d\x0a"};
      #else
         char startmsg0[] = {
         "\x0d\x0aSound Blaster Adapter Device Driver\x0d\x0a"};
      #endif
      char startmsg2[] = {
        "Installed as device AUDIO1$, interrupt level 7, I/O address 0x220.\x0d\x0a\
\x0d\x0a\x00\x00"
        };
      #define AUDIO_NUM_POS  25
      #define IRQ_NUM_POS    45
      #define IO_ADDRESS_POS 63
   #endif
/****************************************************************************/
/*          IMF Specific Messages                                           */
/****************************************************************************/
   #if IS_IMF
      char startmsg0[] = {
      "\x0d\x0aIBM Music Feature Adapter Device Driver\x0d\x0a"};

      char errormsg[] = {"Error 0. IMF not found.\x0d\x0a\x00\x00"};
      #define ERROR_NUM_POS 6

      char startmsg2[] = {
      "Installing as device AUDIO1$ on interrupt level 3.\x0d\x0a\x0d\x0a\x00\x00"};
      #define AUDIO_NUM_POS 26
      #define IRQ_NUM_POS   48
   #endif
/****************************************************************************/
/*          MPU Specific Messages                                           */
/****************************************************************************/
   #if IS_MPU
      char startmsg0[] = {
      "\x0d\x0aRolund MIDI Processing Unit Adpater Device Driver\x0d\x0a"};

      char startmsg2[] = {
      "Installing as device AUDIO1$ on interrupt level 3.\x0d\x0a\x0d\x0a\x00\x00"};
      #define AUDIO_NUM_POS 26
      #define IRQ_NUM_POS   48
   #endif

/****************************************************************************/ /* CMC01 */
/*          FOX Specific Messages                                           */ /* CMC01 */
/****************************************************************************/ /* CMC01 */
   #if IS_FOX                                                                  /* CMC01 */
      #if IS_K12                                                               /* CMC01 */
         char startmsg0[] = {                                                  /* CMC01 */
         "\x0d\x0aFOX Adapter Wave-only Device Driver\x0d\x0a"};               /* CMC01 */
      #else                                                                    /* CMC01 */
         char startmsg0[] = {                                                  /* CMC01 */
         "\x0d\x0aFOX Adapter Device Driver\x0d\x0a"};                         /* CMC01 */
      #endif                                                                   /* CMC01 */
      char startmsg2[] = {                                                     /* CMC01 */
        "Installed as device AUDIO1$.\x0d\x0a\x0d\x0a\x00\x00"};                       /* CMC01 */
      #define AUDIO_NUM_POS  25                                                /* CMC01 */
   #endif                                                                      /* CMC01 */


#else
/****************************************************************************/
/*          OS/2 Messages                                                   */
/****************************************************************************/

#if IS_ACPA
   #define ACPA_OK_INSTALL_MSG             0
   #define ACPA_FAIL_INSTALL_MSG           1
   #define ACPA_AVC_INSTALL_MSG            2
   #define CARD_NUM_POS  159
   #define AUDIO_NUM_POS 186
   #define IRQ_NUM_POS   208
#endif
#if IS_IMF
   #define IMF_OK_INSTALL_MSG              3
   #define IMF_ERROR_MSG                   4
   #define ERROR_NUM_POS 6
   #define AUDIO_NUM_POS 168
   #define IRQ_NUM_POS   190
#endif
#if IS_SNDB
   #define SNDB_OK_INSTALL_MSG             5
   #define SNDB_FAIL_INSTALL_MSG           6
   #define AUDIO_NUM_POS  164
   #define IRQ_NUM_POS    184
   #define IO_ADDRESS_POS 202
#endif
#if IS_FOX                                                         /* CMC01 */
   #define FOX_OK_INSTALL_MSG              7                       /* CMC01 */
   #define FOX_FAIL_INSTALL_MSG            8                       /* CMC01 */
   #define AUDIO_NUM_POS  148                                      /* CMC01 */
   #define STREAM_COUNT1  156                                      /* CMC01 */
   #define STREAM_COUNT2  157                                      /* CMC01 */
#endif                                                             /* CMC01 */

#endif
