/**************************START OF SPECIFICATIONS *************************
 *
 * SOURCE FILE NAME: AUDPROTO.H
 *
 * DESCRIPTIVE NAME: Prototypes for AUDIODD routines
 *
 * STATUS: OS/2 Release 2.0, 1.3, and DOS 3.3+
 *
 * NOTE:
 *   DEPENDENCIES:
 *   RESTRICTIONS:
 *
 * MODIFICATION HISTORY:
 * DATE      DATE   CHANGE DESCRIPTION
 * 05/29/92  BRR??? - Creation of this file from AUDIODD2.H
 *****************************************************************************/

/* Functions provided in common AUDIO DD files                               */
void           acpa_clr_block       (unsigned addr, unsigned len, unsigned data);
void           acpa_rblock          (unsigned addr, char far *data, unsigned len);
void           acpa_wblock          (unsigned addr, char far *data, unsigned len);
int            aud_control          (int trk);
void           check_if_stopped     (int trk);
unsigned long  check_wrap           (IOB,unsigned long,int,char,char);
void           cli                  (void);
void           clr_control_blocks   (int trk);
void           copyaddrs            (struct addrs_array far *,
                                     struct addrs_array far *);
unsigned long  CurrentPosition      (int trk);
unsigned int   DeInitialize         (int trk);
int            determine_mode       (AIP dptr);
void           DoOutput             (int trk);
void           eoi                  (int irqnum);
int            GetDevInt            (int irqnum);
int            get_mode             (void);
int            GetTimerInt          (void);
void           global_rearm         (int irqnum);
void           FreeDevInt           (void);
int            FreeTimerInt         (void);
int            init                 (struct IPacket far *);
void           init_queue_vars      (int trk);
unsigned int   InitBufferArray      (unsigned int,IOB,char far *,int);
unsigned int   InitIOBuf            (IOB,IOB,char,int);
int            is_running           (int trk);
int            midiread             (int trk);
void           PauseTrk             (int);
void           purge_data           (IOB io);
void           QTimeSX              (int trk);
void           queue_data           (unsigned char *data,int len,int trk);
int            queue_request        (int type,unsigned long pos,
                                     struct audio_change far *changes,int trk);
int            rec_running          (int trk);
int            set_hpi              (IOB,int,int,char);
void           SetGlobalParms       (AIP,int);
void           setup_shadows        (int);
void           sti                  (void);
void           StopTrk              (int);
void           TestMsg              (char *message);
int            xmit_running         (int trk);

#if IS_OS2
int            AddrToGDTselector    (void far *data,unsigned len,int selector);
void           AllocGDTSelector     (char far *array, int count);
char far      *AllocPhys            (long size,int lowflag);
short          AttachDD             (char *ddname, char *ddaddr);
void           Block                (long id,long timelimit,int enbld);
int            DevHlp_Run           (long handle);
int            FindSysFileNum       (unsigned int SysFileNum, int Function);
void           FreeVCB_Hndl         (ULONG vcbhndl);
void far      *GetDOSVar            (short varnumber);
unsigned long  GetHChVDM            (void);
short          GetPageList          (ULONG linaddr, ULONG bytes, ULONG plistaddr);
unsigned long  GetVCB_Hndl          (void(far *cbfunc)(void), ULONG hvdm);
int            LinToGDTSelector     (void far *data,unsigned len,int selector);
unsigned long  LnLock               (ULONG linear_address, ULONG length);
unsigned short LnUnlock             (ULONG lock_handle);
long           Lock                 (char far *addr, int type, int nowait);
int            PhysToGDTSelector    (char far *data,int len,int selector);
char far      *PhysToUVirt          (char far *addr,int type, unsigned count);
char far      *PhysToVirt           (char far *addr, unsigned count);
void           ProtToReal           (void);
void           RealToProt           (void);
int            RegisterStackUsage   (void);    /* DevHlp defined in OS2DD.ASM */
int            SemClear             (HSEM handle);
HSEM           SemHandle            (HSEM key, char usage);
int            SetBuffers           (struct iobuf far *, struct iobuf far *);
void           SetProcessMode       (int trk);
int            UnLock               (long handle);
int            UnLock_mem           (ULONG lock_handle,int trk);
void           UnLockAllBuffers     (IOB,int);
int            UnPhysToVirt         (void);
int            VerifyAccess         (void far *addr, unsigned int size, int rwflag);
void           VirtCallBack         (ULONG vcbhndl, ULONG hvdm);
unsigned long  VirtToLin            (void far *addr);
void far      *VirtToPhys           (void far *addr);
unsigned long  v86toLin             (void far *);
#endif

/* Not DOS K12 Specific Routines                                              */
#if NOT_DOS_K12
void           purge_req_queue      (int trk);
#endif
#if IS_OS2
unsigned long  Get_HVDM             (void);
#endif

/* Functions provided in device specific modules                             */
#if IS_WIN
int            DevInit              (void);
#else
int            DevInit              (char far *parms);
#endif

void           DevAllNotesOff       (void);
void           DevAfterTouch        (char chan, char key, char press);
void           DevChannelPressure   (char chan, char pressure);
int            DevChange            (struct audio_change far *changes,
                                     int *dev_info, char any_dev_info,
                                     int *mode_info, char any_mode_info,int trk);
int            DevClose             (int trk);
void           DevControlChange     (char chan, char cnum, char cval);
void           DevDeInit            (int trk);
void           DevDepSX             (char d1, char d2, char d3);
int            DevInt               (void);
int            DevIOCTLinit         (AIP dptr,int index,int trk);
void           DevIOCTLload         (unsigned char far *buf, unsigned long size,
                                     unsigned long flags,int trk);
void           DevIOCTLread8        (DR8 dptr);
void           DevIOCTLread16       (DR16 dptr);
void           DevIOCTLstatus       (ASP dptr,int trk);
void           DevIOCTLwrite8       (DR8 dptr);
void           DevIOCTLwrite16      (DR16 dptr);
void           DevIOCTLwait         (int trk);
void           DevMstVolume         (unsigned int level, int duration, int trk);
void           DevMstBalance        (int balance, int duration, int trk);
void           DevMTC               (char byte1, char byte2);
void           DevNoteOff           (char chan, char key, char velocity);
void           DevNoteOn            (char chan, char key, char velocity);
char           DevNotify            (unsigned long pos,int trk);
int            DevOpen              (int trk);
void           DevPause             (int trk);
void           DevPitchBend         (char chan,char lsb, char msb);
void           DevProgramChange     (char chan, char prognum);
void           DevQTimbreParm       (long parmid);
void           DevReqTimbreBlk      (int blknum);
void           DevResume            (int trk);
void           DevSetTimbreParm     (long parmid, int parmval);
void           DevStart             (int trk);
void           DevStop              (int trk);
void           DevTrkBalance        (int balance, int duration,int trk);
void           DevTrkVolume         (int level, int duration,int trk);
void           DevVoiceSel          (char inst, char type, char sel);
int            DevWrite             (int data,int trk);
void           DevWriteTimbreBlk    (int blknum, int len, unsigned char *blk);
void           get_next_buf         (IOB,int,char);
void           InitPosition         (unsigned long time, int trk);
unsigned long  PositionNotCountedYet(int trk);
void           SetClock             (int trk);
unsigned long  TimeOfCurrentBuffer  (int trk);
int            TimerInt             (void);

