
/**************************START OF SPECIFICATIONS *************************
 *
 * SOURCE FILE NAME:     MMDDCMDS.H
 *
 * DESCRIPTIVE NAME: IDC handler functions prototypes.
 *
 * STATUS: OS/2 Release 2.0
 *
 * NOTE:
 *   DEPENDENCIES:
 *   RESTRICTIONS:
 *
 * MODIFICATION HISTORY:
 * DATE      DEVELOPER         CHANGE DESCRIPTION
 * 02/07/91  Brian Czako       Original creation
 * 08/02/91  C. Dinallo        Modify protocol table    //MME.05
 * 08/16/91  C. Dinallo        Split file into mme.h    //MME.07
 * 12/18/91  B. Ritthaler      Add CDXA mono modes      //BRR214
 *  1/16/92  B. Ritthaler      Add DDCMDStatus support  //BRR230
 *
 ************************** END OF SPECIFICATIONS **************************/

/****************************************************************************/
/*                         D E F I N E S                                    */
/****************************************************************************/

// Iobuff management

#define     MAXTRACKS                2      // Max # of tracks      MME.02
#define     MINQUEDBUFFS             2      /* Min # full buffs before int */

#define     NPROTOCOLS              33      /* Number in protocol table BRR214*/

#define     STREAM_WAITING_FOR_DATA         1L
#define     STREAM_STREAMING                2L
#define     STREAM_PAUSED                   4L
#define     STREAM_STOPPED                  8L
#define     STREAM_REGISTERED              16L


/* Selector increment value is a constant.  May not even be used.*/

#define     SELINC                          4

/****************************************************************************/
/*                       T Y P E  D E F S                                   */
/****************************************************************************/

typedef struct  _protocol_table {
                        ULONG   ulDataType;
                        ULONG   ulDataSubType;
                        ULONG   ulBufSize;
                        ULONG   ulNumBufs;
                        ULONG   ulSampleRate;
                        USHORT  usChannels;
                        USHORT  usBitsPerSample;
                        }PROTOCOLTABLE;


/****************************************************************************/
/*              F U N C T I O N   P R O T O T Y P E S                       */
/****************************************************************************/

RC      DDCmdSetup( PDDCMDSETUP pSetup );
RC      DDCmdReadWrite( PDDCMDREADWRITE pRead, char op_type );
RC      DDCmdStatus( PDDCMDSTATUS pStatus );
RC      DDCmdControl( PDDCMDCONTROL pControl );
RC      DDCmdRegister( PDDCMDREGISTER pRegister );
RC      DDCmdDeRegister( PDDCMDDEREGISTER pDeRegister );
RC      DDCmdHandleInterrupt( void ) ;
void    MMEInitStreams(int) ;
RC      FindTrackForStream(PDDCMDCOMMON pCommon);
RC      GetStreamEntry(PSTREAM far *ppStream, HSTREAM hStream);
RC      GetStreamBasedOnTrack(PSTREAM far *ppStream, SHORT trk);

void    ClearAllIOBufs(PSTREAM pStream);
void    get_next_buf (IOB,int,char) ;
