
/**************************START OF SPECIFICATIONS *************************
 *
 * SOURCE FILE NAME:     MME.H
 *
 * DESCRIPTIVE NAME: MME
 *
 * STATUS: OS/2 Release 2.0
 *
 * NOTE:
 *   DEPENDENCIES:
 *   RESTRICTIONS:
 *
 * MODIFICATION HISTORY:
 * DATE      DEVELOPER         CHANGE DESCRIPTION
 * 08/18/91  C. Dinallo        Original creation
 * 09/25/91  C. Dinallo        Redo stream struct
 * 01/17/92  B. Ritthaler      Add ulCumTime to the stream table
 * 03/35/92  B. Ritthaler      Change SysFileNum to a short in stream table BRR321
 ************************** END OF SPECIFICATIONS **************************/

/****************************************************************************/
/*                         D E F I N E S                                    */
/****************************************************************************/

#define     MAXIOBUFFS              16      // Max # of iobuffs in stream
#define     MAXTRACKS                2      // Max # of tracks
#define     DEFAULTSTREAMS          15      // If "S:nn" not set in CONFIG.SYS

/****************************************************************************/
/*                       T Y P E  D E F S                                   */
/****************************************************************************/
typedef unsigned long   ULONG;
typedef unsigned int    USHORT;
typedef void far *      PVOID;

typedef ULONG   RC;                     // return code
typedef ULONG   HID;
typedef ULONG   HSTREAM;

typedef struct _stream {
                    HSTREAM         hStream ;
                    USHORT          usSysFileNum;       // MME.07 BRR321
                    ULONG           ulOperation ;       // MME.02
                    ULONG           ulFlags ;
                    PVOID           ADSHEntry ;
                    USHORT          usTrackNum;         // MME.13 stream uses this track num
                    ULONG           ulCumTime;          // BRR224
                    USHORT          usCurrIOBuffIndex;  //index into current iobuff struct
                    USHORT          usNextIOBuffIndex;  //index into next iobuff struct
                    struct iobuf    Iobuff[ MAXIOBUFFS ] ;
                } STREAM ;

typedef STREAM far *PSTREAM;                            // MME.02

typedef struct _acpamme{                                // MME.02
                PSTREAM         paStream;        // array ptr of stream structs
                USHORT          usMaxNumStreams; // max # of streams from argument line
            } ACPAMME;

typedef ACPAMME *PACPAMME;                       // global table -- MME.02
