/************************************************************************/
/*				SAMPLE2.C												*/
/*																		*/
/*	This is the main module for the ACPA Sample2 program.				*/
/*	It is an OS/2 protect mode application.  Optionally,				*/
/*	Bind can be used to allow operation in both protect and				*/
/*	DOS modes.															*/
/*																		*/
/*	It will determine if the ACPA card is installed,					*/
/*	and determine at which base address.								*/
/*																		*/
/*	This program can be compiled using IBM C/2 and the IBM				*/
/*	OS/2 programmers toolkit. 											*/
/*																		*/
/*	Commands used to compile, link, and bind this program:				*/
/*																		*/
/*		cc /AL /W2 /Zp /Ze /G0 sample2;									*/
/*		masm acpa;														*/
/*		link sample2+acpa,samplet.exe,,llibcep,sample2.lnk;				*/
/*		bind samplet.exe c:\toolkt11\lib\api.lib 						*/
			c:\os2\doscalls.lib -o sample2.exe							*/
/*																		*/
/*	(C)Copyright IBM Corp. 1989.  All rights reserved.					*/
/************************************************************************/

#define	INCL_DOSPROCESS
#define	INCL_DOSQUEUES
#define	INCL_DOSDEVICES
#define	INCL_KBD
#include	<os2.h>

#include	<stdio.h>
#include	<stdlib.h>
#include	<conio.h>

/* IOPL function declarations */
unsigned int far pascal acparead(unsigned int);
void far pascal acpawrite(unsigned int,int);
int far pascal acpainit(void);
void far pascal acpaclose(void);


#define	POS_SEL		0x96
#define	POS0		0x100
#define	POS1		0x101
#define	POS2		0x102
#define	Card_ID		0x6e6c

unsigned int poslocs[4] = {	0xfdc0, 0xfdc8, 0xfdd0, 0xfdd8 };

int	is_uchan = 0;			/* 1 if uchannel */

int	posdata;			/* data read from pos2 */

unsigned int	fam1locs[11] = {
	0x310,0x318,0x330,0x338,0x368,
	0x710,0x718,0x730,0x738,0x768,
	0x300 };

char	machinemode = 0;			/* 0 = DOS, 1 = OS/2 */

int	model;					/* PC type	*/
int	submodel;				/* PC subtype	*/

char	progname1[] = { "Audio Capture and Playback Adapter"};
char	progname2[] = { "Sample2 Program" };
char	secnote[] = { "(C) Copyright IBM Corp. 1989.  All rights reserved." };
char	progauth[] = { "Written by Ron Lisle"};

void main(argc,argv)
int		argc;
char	*argv[];
{
	extern int acpabase;	/* Defined in ACPA.ASM */
	int x,y,rc,found;

	printf("\n%s\n%s\n%s\n\n",progname1,progname2,secnote);

	/* Determine Machine mode (DOS or OS/2) */
	rc = DosGetMachineMode(&machinemode);	/* 0 = DOS, 1 = OS/2 */

	/* Determine whether microchannel or LEPB */
	rc = DosDevConfig(&submodel,4,0);
	rc = DosDevConfig(&model,5,0);

	/* Search for card */
	found = 0;
	if((model==0xf8)					/* Mod 70/80	*/
		||(model==0xfc && (submodel==4 || submodel==5))){ /* Mod 50/60 */

		is_uchan = 1;

		/* Do microchannel search */
		for(x=8; x<16 && !found; x++){		/* Search all 8 slots */
			outp(POS_SEL,x);		/* Select a slot */
			y = (inp(POS1)<<8)+inp(POS0);	/* Get high/low ids */
			if(y==Card_ID) found=1;		/* is it 6E6C?		*/
		}
		if(found){
			posdata = inp(POS2);
			acpabase = poslocs[(posdata & 0x06)>>1];
		}
		outp(POS_SEL,0);			/* Restore POS reg */

	}else{		/* Do family1 bus search */
		for(x=0; x<11 && !found; x++){
			if(inp(fam1locs[x]+7)==0x6c){
				found = 1;
				acpabase = fam1locs[x];
			}
		}
	}

	if(found){
		if(rc=acpainit()){
			printf("Error %d\n",rc);
		}
		acpaclose();
	}

	printf("Audio Capture and Playback Adapter ");
	if(found) printf("found at address %x\n",acpabase);
	else printf("not found.\n");
}
