/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import sun.misc.Unsafe;

public abstract class ForkJoinTask<V>
implements Serializable,
Future<V> {
    volatile int status;
    private static final ExceptionNode[] exceptionTable;
    private static final ReentrantLock exceptionTableLock;
    private static final ReferenceQueue<Object> exceptionTableRefQueue;
    private static final Unsafe U;
    private static final long STATUS;

    /*
     * WARNING - void declaration
     */
    private int setCompletion(int completion) {
        void var1_1;
        void var2_3;
        int s2;
        do {
            if ((s2 = this.status) >= 0) continue;
            return s2;
        } while (!U.compareAndSwapInt(this, STATUS, s2, s2 | completion));
        if (var2_3 >>> 16 != false) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                this.notifyAll();
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final int doExec() {
        int n;
        int s2 = this.status;
        if (s2 >= 0) {
            try {
                this.exec();
            }
            catch (Throwable rex) {
                void var1_2;
                void var2_5 = var1_2;
                ForkJoinTask forkJoinTask = this;
                int n2 = forkJoinTask.recordExceptionalCompletion((Throwable)var2_5);
                return n2;
            }
            n = this.setCompletion(-268435456);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    final boolean trySetSignal() {
        void var1_1;
        int s2 = this.status;
        return s2 >= 0 && U.compareAndSwapInt(this, STATUS, s2, (int)(var1_1 | 0x10000));
    }

    /*
     * WARNING - void declaration
     */
    private int externalAwaitDone() {
        void var1_3;
        void var2_1;
        int s22;
        ForkJoinPool.externalHelpJoin(this);
        boolean interrupted = false;
        while ((s22 = this.status) >= 0) {
            if (!U.compareAndSwapInt(this, STATUS, s22, s22 | 0x10000)) continue;
            ForkJoinTask s22 = this;
            synchronized (s22) {
                if (this.status >= 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                } else {
                    this.notifyAll();
                }
            }
        }
        if (var2_1 != false) {
            Thread.currentThread().interrupt();
        }
        return (int)var1_3;
    }

    /*
     * WARNING - void declaration
     */
    private int externalInterruptibleAwaitDone() throws InterruptedException {
        void var1_1;
        int s22;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ForkJoinPool.externalHelpJoin(this);
        while ((s22 = this.status) >= 0) {
            if (!U.compareAndSwapInt(this, STATUS, s22, s22 | 0x10000)) continue;
            ForkJoinTask s22 = this;
            synchronized (s22) {
                if (this.status >= 0) {
                    this.wait();
                } else {
                    this.notifyAll();
                }
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int doJoin() {
        int s2 = this.status;
        if (s2 < 0) {
            return s2;
        }
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            void var3_5;
            void var2_4;
            int n;
            void var1_2;
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)var1_2;
            ForkJoinPool.WorkQueue w = wt.workQueue;
            if (w.tryUnpush(this) && (n = this.doExec()) < 0) {
                return n;
            }
            return var2_4.pool.awaitJoin((ForkJoinPool.WorkQueue)var3_5, this);
        }
        return this.externalAwaitDone();
    }

    /*
     * WARNING - void declaration
     */
    private int recordExceptionalCompletion(Throwable ex) {
        int n;
        int s2 = this.status;
        if (s2 >= 0) {
            int h = System.identityHashCode(this);
            ReentrantLock lock = exceptionTableLock;
            lock.lock();
            try {
                ForkJoinTask.expungeStaleExceptions();
                ExceptionNode[] t = exceptionTable;
                int i = h & 0x1F;
                ExceptionNode e = t[i];
                while (true) {
                    if (e == null) {
                        t[i] = new ExceptionNode(this, ex, t[i]);
                        break;
                    }
                    if (e.get() == this) break;
                    e = e.next;
                }
                lock.unlock();
            }
            catch (Throwable throwable) {
                void var3_4;
                var3_4.unlock();
                throw throwable;
            }
            n = this.setCompletion(Integer.MIN_VALUE);
        }
        return n;
    }

    static final void cancelIgnoringExceptions(ForkJoinTask<?> t) {
        if (t != null && t.status >= 0) {
            try {
                ForkJoinTask<?> forkJoinTask;
                forkJoinTask.cancel(false);
                return;
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    private Throwable getThrowableException() {
        void var1_2;
        Throwable ex;
        ExceptionNode[] exceptionNodeArray;
        if ((this.status & 0xF0000000) != Integer.MIN_VALUE) {
            return null;
        }
        int h = System.identityHashCode(this);
        ReentrantLock lock = exceptionTableLock;
        lock.lock();
        try {
            ForkJoinTask.expungeStaleExceptions();
            exceptionNodeArray = exceptionTable;
            ExceptionNode e = exceptionTable[h & 0x1F];
            while (e != null && e.get() != this) {
                e = e.next;
            }
            lock.unlock();
        }
        catch (Throwable e) {
            void var2_4;
            var2_4.unlock();
            throw e;
        }
        if (e == null || (ex = var1_2.ex) == null) {
            return null;
        }
        return exceptionNodeArray;
    }

    private static void expungeStaleExceptions() {
        Reference<Object> x;
        block0: while ((x = exceptionTableRefQueue.poll()) != null) {
            if (!(x instanceof ExceptionNode)) continue;
            ForkJoinTask key = (ForkJoinTask)((ExceptionNode)x).get();
            ExceptionNode[] t = exceptionTable;
            int i = System.identityHashCode(key) & 0x1F;
            ExceptionNode e = t[i];
            ExceptionNode pred = null;
            while (e != null) {
                ExceptionNode next2 = e.next;
                if (e == x) {
                    if (pred == null) {
                        t[i] = next2;
                        continue block0;
                    }
                    pred.next = next2;
                    continue block0;
                }
                pred = e;
                e = next2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static final void helpExpungeStaleExceptions() {
        ReentrantLock lock = exceptionTableLock;
        if (lock.tryLock()) {
            try {
                ForkJoinTask.expungeStaleExceptions();
                lock.unlock();
                return;
            }
            catch (Throwable throwable) {
                void var0;
                var0.unlock();
                throw throwable;
            }
        }
    }

    static void rethrow(Throwable ex) {
        if (ex != null) {
            Throwable throwable;
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (throwable != null) {
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ForkJoinTask<V> fork() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            void var1_1;
            ((ForkJoinWorkerThread)var1_1).workQueue.push(this);
        } else {
            ForkJoinPool.common.externalPush(this);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final V invoke() {
        int n;
        ForkJoinTask forkJoinTask = this;
        int n2 = forkJoinTask.doExec();
        if (n2 < 0) {
            n = n2;
        } else {
            Thread thread = Thread.currentThread();
            if (thread instanceof ForkJoinWorkerThread) {
                thread = (ForkJoinWorkerThread)thread;
                n = ((ForkJoinWorkerThread)thread).pool.awaitJoin(((ForkJoinWorkerThread)thread).workQueue, forkJoinTask);
            } else {
                n = forkJoinTask.externalAwaitDone();
            }
        }
        int s2 = n & 0xF0000000;
        if (s2 != -268435456) {
            void var1_2;
            n2 = var1_2;
            ForkJoinTask forkJoinTask2 = this;
            if (n2 == -1073741824) {
                throw new CancellationException();
            }
            if (n2 == Integer.MIN_VALUE) {
                ForkJoinTask.rethrow(forkJoinTask2.getThrowableException());
            }
        }
        return this.getRawResult();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return (this.setCompletion(-1073741824) & 0xF0000000) == -1073741824;
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return (this.status & 0xF0000000) == -1073741824;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get() throws InterruptedException, ExecutionException {
        Throwable ex;
        int n = Thread.currentThread() instanceof ForkJoinWorkerThread ? this.doJoin() : this.externalInterruptibleAwaitDone();
        int s2 = n & 0xF0000000;
        if (s2 == -1073741824) {
            throw new CancellationException();
        }
        if (s2 == Integer.MIN_VALUE && (ex = this.getThrowableException()) != null) {
            void var1_2;
            throw new ExecutionException((Throwable)var1_2);
        }
        return this.getRawResult();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        int n;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long ns = unit.toNanos(timeout);
        int s2 = this.status;
        if (s2 >= 0 && ns > 0L) {
            long deadline = System.nanoTime() + ns;
            ForkJoinPool p = null;
            ForkJoinPool.WorkQueue w = null;
            Thread t = Thread.currentThread();
            if (t instanceof ForkJoinWorkerThread) {
                void var1_3;
                ForkJoinWorkerThread wt = (ForkJoinWorkerThread)var1_3;
                p = wt.pool;
                w = wt.workQueue;
                p.helpJoinOnce(w, this);
            } else {
                ForkJoinPool.externalHelpJoin(this);
            }
            boolean canBlock = false;
            boolean interrupted = false;
            try {
                while ((n = this.status) >= 0) {
                    if (w != null && w.qlock < 0) {
                        ForkJoinTask.cancelIgnoringExceptions(this);
                        continue;
                    }
                    if (!canBlock) {
                        if (p != null && !p.tryCompensate()) continue;
                        canBlock = true;
                        continue;
                    }
                    long ms = TimeUnit.NANOSECONDS.toMillis(ns);
                    if (ms > 0L && U.compareAndSwapInt(this, STATUS, n, n | 0x10000)) {
                        ForkJoinTask forkJoinTask = this;
                        synchronized (forkJoinTask) {
                            if (this.status >= 0) {
                                try {
                                    this.wait(ms);
                                }
                                catch (InterruptedException interruptedException) {
                                    if (p == null) {
                                        interrupted = true;
                                    }
                                }
                            } else {
                                this.notifyAll();
                            }
                        }
                    }
                    if ((n = this.status) >= 0 && !interrupted && (ns = deadline - System.nanoTime()) > 0L) continue;
                }
                if (p != null && canBlock) {
                    p.incrementActiveCount();
                }
            }
            catch (Throwable throwable) {
                if (p != null && canBlock) {
                    void var2_11;
                    var2_11.incrementActiveCount();
                }
                throw throwable;
            }
            if (interrupted) {
                throw new InterruptedException();
            }
        }
        if ((n &= 0xF0000000) != -268435456) {
            if (n == -1073741824) {
                throw new CancellationException();
            }
            if (n != Integer.MIN_VALUE) {
                throw new TimeoutException();
            }
            Throwable ex = this.getThrowableException();
            if (ex != null) {
                throw new ExecutionException(ex);
            }
        }
        return this.getRawResult();
    }

    public final void quietlyJoin() {
        this.doJoin();
    }

    public abstract V getRawResult();

    protected abstract boolean exec();

    /*
     * WARNING - void declaration
     */
    static {
        exceptionTableLock = new ReentrantLock();
        exceptionTableRefQueue = new ReferenceQueue();
        exceptionTable = new ExceptionNode[32];
        try {
            U = scala.concurrent.util.Unsafe.instance;
            Class<ForkJoinTask> k = ForkJoinTask.class;
            STATUS = U.objectFieldOffset(k.getDeclaredField("status"));
            return;
        }
        catch (Exception e) {
            void var0_1;
            throw new Error((Throwable)var0_1);
        }
    }

    static final class AdaptedCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        private Callable<? extends T> callable;
        private T result;

        /*
         * WARNING - void declaration
         */
        AdaptedCallable(Callable<? extends T> callable) {
            void var1_1;
            if (callable == null) {
                throw new NullPointerException();
            }
            this.callable = var1_1;
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean exec() {
            try {
                this.result = this.callable.call();
                return true;
            }
            catch (Error error2) {
                Error error3 = error2;
                throw error2;
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2 = runtimeException;
                throw runtimeException;
            }
            catch (Exception ex) {
                void var1_3;
                throw new RuntimeException((Throwable)var1_3);
            }
        }

        @Override
        public final void run() {
            this.invoke();
        }
    }

    static final class AdaptedRunnableAction
    extends ForkJoinTask<Void>
    implements RunnableFuture<Void> {
        private Runnable runnable;

        /*
         * WARNING - void declaration
         */
        AdaptedRunnableAction(Runnable runnable) {
            void var1_1;
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = var1_1;
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        @Override
        public final void run() {
            this.invoke();
        }
    }

    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        private Runnable runnable;
        private T result;

        /*
         * WARNING - void declaration
         */
        AdaptedRunnable(Runnable runnable, T result2) {
            void var2_2;
            void var1_1;
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = var1_1;
            this.result = var2_2;
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        @Override
        public final void run() {
            this.invoke();
        }
    }

    static final class ExceptionNode
    extends WeakReference<ForkJoinTask<?>> {
        final Throwable ex;
        ExceptionNode next;

        /*
         * WARNING - void declaration
         */
        ExceptionNode(ForkJoinTask<?> task, Throwable ex, ExceptionNode next2) {
            super(var1_1, exceptionTableRefQueue);
            void var3_3;
            void var2_2;
            void var1_1;
            this.ex = var2_2;
            this.next = var3_3;
            Thread.currentThread().getId();
        }
    }
}

