/*
    filename:   ls_v2.h
    Synopsis:   functions prototypes for graphics v2 module
    Date:       March the 19th 1991
  
COPYRIGHT (c) 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_LS_V2_H__
#define __I_LS_V2_H__

/* Need imseries.h for I_UNIX defines */
#ifndef __I_IMSERIES_H__
#include "imseries.h"
#endif /* __I_IMSERIES_H__ */

/* Need i_dll.h for FTYPE */
#ifndef __I_I_DLL_H__
#ifdef I_UNIX
#include <im_series/i_dll.h>
#else
#include "i_dll.h"
#endif /* I_UNIX */
#endif /* __I_I_DLL_H__ */

/* Need def.h for definitions */
#ifndef __I_DEF_H__
#ifdef I_UNIX
#include <im_series/def.h>
#else
#include "def.h"
#endif /* I_UNIX */
#endif /* __I_DEF_H */


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void FTYPE v2araplygn(unsigned short nvert,struct V2coord _I_PTYPE *vertptr);
void FTYPE v2ararplygn(unsigned short ndelt,struct V2coord _I_PTYPE *deltptr);
void FTYPE v2arbfill(unsigned short color_index);
void FTYPE v2arellipse(float a,float b);
void FTYPE v2arepie(short sth,short eth,float a,float b);
void FTYPE v2areseg(short sth,short eth,float a,float b);
void FTYPE v2arffill(void );
void FTYPE v2arrect(float x,float y);
void FTYPE v2arrrect(float deltx,float delty);
void FTYPE v2arwplygn(unsigned short nvert,struct V2coord _I_PTYPE *vertptr);
void FTYPE v2arwrplygn(unsigned short ndelt,struct V2coord _I_PTYPE *deltptr);
void FTYPE v2gpmap(float x,float y);
void FTYPE v2gpmapx(float x);
void FTYPE v2gpmapy(float y);
void FTYPE v2gpsvwp(short xmin,short xmax,short ymin,short ymax);
void FTYPE v2gpswdw(float xmin,float xmax,float ymin,float ymax);
void FTYPE v2gpunmp(short x,short y);
void FTYPE v2olearc(short sth,short eth,float a,float b);
void FTYPE v2olellipse(float a,float b);
void FTYPE v2olepie(short sth,short eth,float a,float b);
void FTYPE v2oleseg(short sth,short eth,float a,float b);
void FTYPE v2olhpearc(float sth,float eth,float a,float b);
void FTYPE v2ollnto(float x,float y);
void FTYPE v2olmvto(float x,float y);
void FTYPE v2olpline(unsigned short nvert,struct V2coord _I_PTYPE *vertptr);
void FTYPE v2olplygn(unsigned short nvert,struct V2coord _I_PTYPE *vertptr);
void FTYPE v2olpt(void );
void FTYPE v2olrect(float x,float y);
void FTYPE v2olrlnto(float deltx,float delty);
void FTYPE v2olrmvto(float deltx,float delty);
void FTYPE v2olrpline(unsigned short ndelt,struct V2coord _I_PTYPE *deltptr);
void FTYPE v2olrplygn(unsigned short ndelt,struct V2coord _I_PTYPE *deltptr);
void FTYPE v2olrrect(float deltx,float delty);
void FTYPE v2olsw(float width);
void FTYPE v2txbstring(float x,float y,unsigned char _I_PTYPE *strptr);
void FTYPE v2txstring(float x,float y,short _I_PTYPE *strptr);

#ifdef  __cplusplus
}
#endif /* __cplusplus */
#endif /* __I_LS_V2_H__ */
