/*
    filename: camera.h
    owner:    aLin

COPYRIGHT (c) 1989,1990  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

/*
 * Mod history:
 *      aLin 89Sep07
 *
 * This structure contains all the parameters necessary for
 *  programming the asd for the current camera
 *
 * H defines are in the file llashead.h and ttkhhl.h .
 *
 * Requires structures SYNCPOL_BE.
 *
 * All horizontal parameters are in pixels, and vertical parameters
 *  in lines, all uncompensated.
 *
 * Note: The size in byte of camera must be of 112 bytes
*
*M      Modification History: (author, date, descr)
*M      
*M      sDem 89Oct26, transfer added.
*M      sDem 89Nov24, in_clk_pol added.
*/

#define NU_LOG_CAM      64
#define CLD_USED        1
#define CLD_NOT_USED    0
#define DEFAULT_LCCAM   63


typedef struct camera
   {
    /* ============================ */
    /* logcam structure begins here */

    unsigned long target_board;  /* address of current digitizer */
    unsigned short hdigcomp;     /* horizontal compensation factor */
    unsigned short scan_mode;    /* H defines : INTERLACED, PROGRESSIVE */
    unsigned short start_field;  /* H defines : STARTNEXTFD, STARTEVENFD, 
                                                STARTODDFD */
    unsigned short pixclk;       /* Digitizer Pixel clock rate in KHz  */
    unsigned short adr_hres;
    unsigned short adr_vres;

    unsigned short vblnkw;       /* bporch + sync width */
    unsigned short hblnkw;
    unsigned short vtotal;
    unsigned short htotal;

    /* logcam structure ends here */
    /* ========================== */

   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetpsgtiming() */

   unsigned short hsync;
   unsigned short psg_htotal;
   unsigned short roi_hmax;
   unsigned short vsync;
   unsigned short psg_vtotal;
   unsigned short roi_vmax;


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetclamp() */

   unsigned short hsclmp;    /* Distance beetween the end of the hsync     */
                             /* and the start of the clamp pulse in pixel. */
   unsigned short clmpwidth; /* The clamp pulse width in pixel. */
   

   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetprogtimer() */

   unsigned short trigger; /* H defines: SOFTTRIG, HARDTRIG, TIMEBASETRIG, 
                                         NOCHANGE */
   unsigned long exposure; /* Exposure time in terms of usec. */
   unsigned long transfer; /* Transfer time in terms of usec. */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetssm() */

   unsigned short monoshot_mode;  /* H defines : NO_MONOSHOT,
                                        LINE_SCAN, FRAME_SCAN */
   unsigned short intl_frame_scan;  /* H defines : INTL_FD_SCAN, INTL_FRAME_SCAN */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetsyncfmt() */

   unsigned short csync_fmt; /* H defines: BLOCKSYNC, SERRTSYNC, SEREQUSYNC,
                                           NOCHANGE */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetsyncpath() */

   unsigned short interface; /* H defines: ANALOGSYINT, TTLSYINT, RS422SYINT,
                                           BBSYINT, NOCHANGE */
   unsigned short int_dir;   /* H defines: INT_IN, INT_OUT, NOCHANGE */
   unsigned short sep_sync;  /* H defines: CSYNC, HVSYNC, NOCHANGE */
   unsigned short sync_chan; /* H defines: CH0SYNC, CH1SYNC, CH2SYNC,
                                           CH3SYNC, NOCHANGE */
   unsigned short psgmode;   /* H defines: PSGINTSYNC, PSGEXTSYNC, NOCHANGE */
   unsigned short psghres;   /* H defines: ENHRES, DISHRES, NOCHANGE */
/*   SYNCPOL_BE sync_pol; */     /* H defines: HISYPOL, LOSYPOL, NOCHANGE */
   unsigned short sync_pol;      /* H defines: HISYPOL, LOSYPOL, NOCHANGE */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetclk() */

   unsigned short clk_src;   /* H defines: PLLCLK, EBICLK, USERCLK, EXTCLK,
                                           NOCHANGE */
   unsigned short div_fact;  /* H defines: DIV1, DIV2, DIV4, DIV8, NOCHANGE */
   unsigned short in_clk;    /* H defines: RS422CLKIN, TTLCLKIN, NOCLKIN, 
                                           NOCHANGE */
   unsigned short out_clk;   /* H defines: RS422CLKOUT, TTLCLKOUT, NOCLKOUT,
                                           NOCHANGE */
   unsigned short in_clk_pol;/* H defines: INCLK_HIGH_EDGE, INCLK_LOW_EDGE */
   

   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetvidsrc() */

   unsigned short data_src; /* H defines: ANALOGDT, RS422DT, TTLDT, COUNTERDT,
                                          NODT, NOCHANGE */
   unsigned short chsrc;    /* H defines: CH0DIG, CH1DIG, CH2DIG, CH3DIG,
                                          NOCHANGE */
   unsigned short buswidth; /* H_defines: W8BITS, W16BITS, NOCHANGE */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetmask() */

   unsigned short mask;     /* 0 to 15 */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetpalette() */

   unsigned short palette;  /* 0 to 31 */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetgain() */

   unsigned short gain;     /* H defines: GN_3_15, GN_2_10, GN_1_40, GN_0_93 */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetadcref() */

   unsigned short refplus0, refminus0;  /* ref+ and ref- for ASD, CLD */
   unsigned short refplus1, refminus1;
   unsigned short refplus2, refminus2;


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetuser1() */

   unsigned short user1; /* 1 or 0 */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassetuser1() */

   unsigned short user2; /* 1 or 0 */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llassethvcnt() */

   unsigned short sethcount;    /* initial PSG hcount value */
   unsigned short setvcount;    /* initial PSG vcount value */

   } CAMERA;

typedef CAMERA *CAMERA_ID[NU_LOG_CAM];





/*
 * Mod history:
 *      bLem 90May22
 *
 * This structure contains all the parameters necessary for
 *  programming the cld for the current camera
 *
 * H defines are in the file llclhead.h, hlclhead, and ttkhhl.h .
 *
 * All horizontal parameters are in pixels, and vertical parameters
 *  in lines, all uncompensated.
 *
 * Note: The size in byte of camera_cld must be of 112 bytes
*
*M      Modification History: (author, date, descr)
*M      
*/

typedef struct camera_cld
   {
   /* ============================ */
   /* logcam structure begins here */

   unsigned long  target_board;/* address of current digitizer */
   unsigned short hdigcomp;    /* horizontal compensation factor */
   unsigned short scan_mode;   /* H defines : INTERLACED, PROGRESSIVE */
   unsigned short start_field; /* H defines : STARTNEXTFD, STARTEVENFD, 
                                              STARTODDFD */
   unsigned short pixclk;      /* Digitizer Pixel clock rate in KHz  */
   unsigned short adr_hres;
   unsigned short adr_vres;

   unsigned short vblnkw;  /* bporch + sync width */
   unsigned short hblnkw;
   unsigned short vtotal;
   unsigned short htotal;

   /* logcam structure ends here */
   /* ========================== */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetpsgtiming() */

   unsigned short hsync;
   unsigned short psg_htotal;       /* old field name was hbporch */
   unsigned short roi_hmax;         /* old field name was hfporch */
   unsigned short vsync;
   unsigned short psg_vtotal;       /* old field name was vbporch */
   unsigned short roi_vmax;         /* old foeld name was vfporch */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsethcnt() */

   unsigned short sethcount;    /* initial PSG hcount value */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetvcnt() */

   unsigned short setvcount;    /* initial PSG vcount value */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetclamp() */
                             /* Distance beetween the end of the hsync     */
   unsigned short hsclmp;    /* and the start of the clamp pulse in pixel. */
   unsigned short clmpwidth; /* The clamp pulse width in pixel. */
   

   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetssm() */

   unsigned short monoshot_mode;    /* H defines : NO_MONOSHOT, 
                                                   NO_MONOSHOT_NIL, LINE_SCAN, 
                                                   FRAME_SCAN */
   unsigned short intl_frame_scan;  /* H defines : INTL_FD_SCAN, 
                                                   INTL_FRAME_SCAN */

   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetsyncfmt() */

   unsigned short csync_fmt; /* H defines: BLOCKSYNC, SERRTSYNC, SEREQUSYNC,
                                           NOCHANGE */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetsyncpath() */

   unsigned short hsync_src; /* H defines: VHREFEXTSYNC, VHREFINTSYNCBB,
                                           VHREFINTSYNCDIGIT, NOCHANGE */
   unsigned short psgmode;   /* H defines: PSGINTSYNC, PSGEXTSYNC, NOCHANGE */
   unsigned short sync_chan; /* H defines: SYNCCH0, SYNCCH1, SYNCCH2, SYNCCH3,
                                           SYNCCH3DIRECT, SYNCYC, SYNCVIDEOIN, 
                                           NOCHANGE */
   unsigned short trigger;   /* H defines: TRIGGER_ON, TRIGGER_OFF, NOCHANGE */
   unsigned short sync_pol;  /* H defines: HISYPOL, LOSYPOL, NOCHANGE */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetclk() */

   unsigned short clk_src;   /* H defines: PLLCLK, EBICLK, NOCHANGE */
   unsigned short div_fact;  /* H defines: DIV1, DIV2, DIV4, DIV8, NOCHANGE */
   unsigned short in_clk_pol;/* H defines: INCLK_HIGH_EDGE, INCLK_LOW_EDGE */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetvidsrc() */

   unsigned short data_src; /* H defines: DIGRGB, DIGNTSC_PAL, DIGYC, 
                                          NOCHANGE */
   unsigned short chsrc;    /* H defines: DIGCH0, DIGCH1, DIGCH2, DIGCH3, 
                                          NOCHANGE */

   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llcldacdecoder() */

   unsigned short brightness;    /* >63 for default val, 0 to 63 for new val */
   unsigned short saturation;    /* >63 for default val, 0 to 63 for new val */
   unsigned short contrast;      /* >63 for default val, 0 to 63 for new val */
   unsigned short hue;           /* >63 for default val, 0 to 63 for new val */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetadcref() */

   unsigned short refrwht;       /* >63 for default val, 0 to 63 for new val */
   unsigned short refrblk;       /* >63 for default val, 0 to 63 for new val */
   unsigned short refgwht;       /* >63 for default val, 0 to 63 for new val */
   unsigned short refgblk;       /* >63 for default val, 0 to 63 for new val */
   unsigned short refbwht;       /* >63 for default val, 0 to 63 for new val */
   unsigned short refbblk;       /* >63 for default val, 0 to 63 for new val */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclbt253colsel() */

   unsigned short colsel;   /* H defines : TRUE_COLOR_24_BIT, TRUE_COLOR_15_BIT,
                                  TRUE_COLOR_8_BIT, PSEUDO_COLOR_8_BIT */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclentrap() */

   unsigned short pal_trap;   /* H defines : EN_CHROMA_NOTCH, DI_CHROMA_NOTCH */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetcscdynrange() */

   unsigned short dyn_range;  /* H defines : M7_0_CSC, M8_1_CSC, M9_2_CSC, 
                                    M10_3_CSC, M11_4_CSC, BYPASS_CSC */
							  /* To use default value defined by the */
							  /* matrix_id set dyn_range to 99       */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetcscinrange() */

   unsigned short in_range;   /* H defines : UNS_NOMUX_NOINT_CSC, 
                                    ANA_NOMUX_NOINT_CSC, ANA_NOMUX_INT_CSC, 
                                    ANA_MUX_INT_CSC, COMP_NOMUX_NOINT_CSC, 
                                    COMP_NOMUX_INT_CSC, COMP_MUX_INT_CSC, 
                                    PSEUDO_COLOR_CSC */
							  /* To use default value defined by the */
							  /* matrix_id set in_range to 99        */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetcscoutrange() */

   unsigned short out_range;  /* H defines : UNS_NOMUX_NODEC_CSC, 
                                    ANA_NOMUX_NODEC_CSC, ANA_MUX_DEC_CSC, 
                                    COMP_NOMUX_NODEC_CSC, COMP_MUX_DEC_CSC */
							  /* To use default value defined by the */
							  /* matrix_id set out_range to 99       */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetcscmatrix() */

   unsigned short matrix_id;  /* H defines : TRANS_CSC, RGB_TO_YRYBY, 
                                    RGB_TO_YUV, RGB_TO_YIQ, YRYBY_TO_RGB, 
                                    YUV_TO_RGB, YIQ_TO_RGB, YIQ2_TO_RGB,
                                    OUT_ON_LOW_BYTE,  OUT_ON_MED_BYTE, 
                                    OUT_ON_HIGH_BYTE, RGB555_CSC, 
                                    FLIP_TRANS_CSC, RGB_TO_HIS */
                              /* Factors of matrix will always be the   */
                              /* default ones. Override those values by */
                              /* using distcscmat()                     */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llcldblscanen() */

   unsigned short double_scan;	/* H defines : DI_DOUBLE_SCAN, EN_DOUBLE_SCAN */


   /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
   /* llclsetburst() */
                                 /* HORIZONTAL:                         */
   unsigned short start_hburst;  /* To use default value of burst set   */
   unsigned short end_hburst;    /* start_hburst and end_hburst to 0    */

                                 /* VERTICAL:                           */
   unsigned short start_vburst;  /* To use default value of burst set   */
   unsigned short end_vburst;    /* start_vburst and end_vburst to 0    */

   } CAMERA_CLD;



/*
 * Mod history:
 *      sDem 91Aug21
 *
 * This structure contains all the parameters necessary for
 *  programming the IMAGE-LC for the current camera
 *
 * H defines are in the file llashead.h.
 *
 * Note: The size in byte of camera must be of 112 bytes
*
*M      Modification History: (author, date, descr)
*M      
*/
   
typedef struct camera_lc
   {

/* ------------------------ BASIC INFORMATION ----------------------------*/

   unsigned char target_board;
   unsigned char scan_mode;
   unsigned char start_field;
   unsigned char adr_res;

   /* 4 */

/*--------------------------- TIMING SECTION ------------------------------*/

   unsigned short vblnkw;
   unsigned short out_vblnkw;
   unsigned short hblnkw;
   unsigned short out_hblnkw;
   unsigned short vtotal;
   unsigned short htotal;
   unsigned short hsync;
   unsigned short psg_htotal;
   unsigned short roi_hmax;
   unsigned short vsync;
   unsigned short psg_vtotal;
   unsigned short roi_vmax;
   unsigned short sethcount;
   unsigned short setvcount;

   /* 32 */

/*--------------------  CLAMPING TIMING SECTION ---------------------------*/

   unsigned short hsclmp;
   unsigned short clmpwidth;

   /* 36 */

/*-------------------- PROGRAMMABLE TIMER SECTION -------------------------*/

   unsigned short trigger;
   unsigned long exposure;
   unsigned long transfer;

   /* 46 */

/*-------------------------- ASD MODE SECTION -----------------------------*/

   unsigned char monoshot_mode;
   unsigned char intl_frame_scan;
   unsigned char captmode;
   unsigned char fieldreset;
   unsigned char sghrstsel;

   /* 51 */

/*-------------------- BT261 PROGRAMMING SECTION --------------------------*/

   unsigned char cmd_reg_0;
   unsigned char cmd_reg_1;
   unsigned char cmd_reg_2;
   unsigned char cmd_reg_3;
   unsigned char vsync_sample;
   unsigned short osc_cnt;
   unsigned short hsync_start;
   unsigned short hsync_stop;
   unsigned short clamp_start;
   unsigned short clamp_stop;
   unsigned short zero_start;
   unsigned short zero_stop;
   unsigned short field_start;
   unsigned short field_stop;
   unsigned short noise_start;
   unsigned short noise_stop;
   unsigned short hcount;       

   /* 80 */

/*----------------- SYNCHRONISATION INTERFACE SECTION ---------------------*/

   unsigned char csync_fmt;
   unsigned char vsyncsel;
   unsigned short interface;
   unsigned char int_dir;
   unsigned char sep_sync;
   unsigned char sync_chan;
   unsigned char psgmode;
   unsigned char psghres;
   unsigned char synclevel;
   unsigned short sync_pol;

   /* 92 */

/*--------------------------- CLOCK SECTION -------------------------------*/

   unsigned short clk_src;  
   unsigned char div_fact;  
   unsigned char in_clk;    
   unsigned char out_clk;   
   unsigned char in_clk_pol;
   
   /* 98 */

/*------------------------- DATA PATH SECTION -----------------------------*/
   
   unsigned short data_src;
   unsigned char chsrc;    
   
   /* 101 */

/*----------------------- GAIN, REFERENCES SECTION ------------------------*/
   
   unsigned char gain;     
   unsigned short refplus0;
   unsigned short refminus0;

   /* 106 */
   
/*--------------------------- OTHER SECTION -------------------------------*/

   unsigned char userbiten;
   unsigned char user1;
   unsigned char user2;

   unsigned char spare1;
   
   unsigned short pixclk;

   /* total of 112 bytes */

   } CAMERA_LC;

/* Defines for the logical camera type */

#define ASD_NORMAL            0x80     /* IM-ASD normal     */
#define ASD_H                 0x81     /* IM-ASD/H          */
#define CLD_NTSC              0x82     /* IM-CLD/AS         */
#define CLD_PAL               0x83     /* IM-CLD/ES         */
#define LC_NORMAL             0x84     /* IM-LC normal      */
#define LC_H                  0x85     /* IM-LC/H           */

/* Defines for pcsllogcam() command error */

#define UNKNOWN_FMT              0xFF     
#define INVALID_NUMBER           0xFE     
#define NUMBER_OUT_OF_RANGE      0xFD     
#define INCOMPATIBLE_LOGCAM      0xFC
#define INCOMPATIBLE_VARIATION   0xFB
