/*
 *  filename: MEGAPLUS.C
 *
 *  COPYRIGHT (c) 1991  Matrox Electronic Systems Ltd.
 *  All Rights Reserved
 *
 * *************************************************************************
 *
 *  Description: This code does continuous grabbing from the Kodak
 *               MegaPlus in 1280 x 1024 resolution until the user
 *               strikes a key.
 *
 * Requirements: Image-1280 Baseboard, IM-ASD, Kodak MegaPlus Camera
 *               with appropriate cable (Matrox P/N IM-DICBL/VID-M+
 *               for ASD).
 *
 *  Updates:     Updated on January 27 1994, by Claudio Filiberti.
 *               The program supports the Image-LC with the
 *               appropriate cable (Matrox P/N IM-LCDIG/VID-M+).
 *               For practical reasons only, the ROI size is reduced
 *               to 1024 in the horizontal direction. The prgarm also
 *               supports the Kodak Megaplus 1.6.
 *
 */

/**********************/
/* standard C headers */
/**********************/
#include "malloc.h"
#include "stdlib.h"
#include "stdio.h"
#include "conio.h"
/*****************************/
/* IMAGE series header files */
/*****************************/
#include "imseries.h"
#include "i_head.h"
#include "proto.h"

/***********************/
/* function Prototypes */
/***********************/
void close_image(void);
void init_image(void);
void megaplus(void);

/********************/
/* global variables */
/********************/
short im_handle;
unsigned long exptime = 50000L, xfertime = 183300L;
long strap[4] ={ I_LOUT_AOUT_LOW, I_LOUT_AIN_LOW,
                 I_LIN_AOUT_LOW,  I_LIN_AIN_LOW  };
unsigned short	bd_type, opt_mem;

/*************************/
/* Miscellaneous defines */
/*************************/
#define	IM1280	1
#define	IM640	2
#define	IMLC	3

/****************/
/* main program */
/****************/

void main(argc, argv)
int argc;
char **argv;
{
short i;

   if( argc > 3 ) 
	{
	printf("\nMEGAPLUS\n\n");
        printf("Usage: MEGAPLUS [exptime in usec.] [xfertime in usec.]\n");
        printf("where,\n");
        printf("\n      exptime:  50000 usec. minimum (default = %6lu usec.)", exptime );
        printf("\n     xfertime: 183300 usec. minimum (default = %6lu usec.)\n", xfertime );
        exit(0);
	}

   printf("\nMEGAPLUS\n");
   printf("Please make sure the Kodak MEGAPLUS Camera Control Unit is set to\n");
   printf("'Control' mode and that the 'Shutter' switch is ON.\n");

   switch( argc )
	{
	case 3:	xfertime = max( atol( argv[2] ), 145000L );
	case 2:	exptime  = max( atol( argv[1] ), 2L );
	break;
	}

   i = 0;
   while( ((im_handle = ioopdevice( strap[i], 0 )) == -1) && (i < 4) )
	{
	i++;
	}
   if( i == 4 )
	{
	printf( "Error - cannot open the Image-Series. Exiting Program.\n");
	exit(0);
	}

   init_image();
   megaplus();
   close_image();
}

void init_image(void)
{
   iosldevice( im_handle);
   ioslmemdevice( im_handle);
	
   pcstfborg( I_FB4X1KX1KX8);
   krhwslcsurf( I_OVL_SURF);
   krhwsclr( 0);
   krhwslcsurf( I_FB_SURF3);
   krhwsclr( 0);
   krhwslcsurf( I_FB_SURF2);
   krhwsclr( 0);
   krhwslcsurf( I_FB_SURF1);
   krhwsclr( 0);
   krhwslcsurf( I_FB_SURF0);
   krhwsclr( 0);

   utlmgnlut( 0L, I_LUT_OUTL_MONO, 256L, I_PHYRAMP );
}

void megaplus(void)                                                    
{
unsigned short	grab_destination;

   /* Find out which board we have */
   pciqsys( I_IQ_BOARD_TYPE, &bd_type );
   bd_type &= 0x00ff;   
   
   switch( bd_type ) {
	case IM1280:
		pcstfborg( I_FB1X2KX1KX16 );
   		lsdcstdmode( I_FB13_2K_1K_16 );
   		pcstroisiz( 1280, 1024 );
   		dislboard( (long) I_ASD, 0L );
		grab_destination = I_FB01 + I_ROI0;
	break;
	case IM640:
		pciqsys( I_IQ_OPT_MEM, &opt_mem );
		if( !opt_mem )
			{
			pcstfborg( I_FB1X2KX1KX16 );	
	   		lsdcstdmode( I_FB13_2K_1K_16);
	   		pcstroisiz( 1280, 1024);
			}
		else
			{
			pcstfborg( I_FB1X2KX1KX16 );	
	   		lsdcstdmode( I_FB13_2K_512_16);
	   		pcstroisiz( 1280, 1024);
			}
   		dislboard( (long) I_ASD, 0L);
		grab_destination = I_FB01 + I_ROI0;
	break;
	case IMLC:
		pcstfborg( I_FB1X2KX1KX16 );
	   	lsdcstdmode( I_FB2_1K_1K_8 );
	   	pcstroisiz( 1024, 1024);	
		grab_destination = I_FB2 + I_ROI0;
	break;				
	default:
		printf( "Unsupported Image board.  This program requires an IMAGE-1280,\n" );
		printf( "an IMAGE-640 or an Image-LC board.\n" );
		close_image();
		exit( -1 );
	} 
	
   pcstroipos( I_ROI0, 0, 0 );
   pcsllogcam( 31);
   pcslsync( I_PROC_CAMERA);
   pcstformat(I_UNSIGNED_16, I_UNSIGNED_16, I_UNSIGNED_16);
   distexposure( (long) I_TIMEBASETRIG, exptime, xfertime);
   pcstcond( 0, I_FOREVER, 0 );
   pcstdstmsk(0xffff);        
      
   didograb( I_DIG_16 + I_ROI0, grab_destination  );
     
   printf("Doing continuous grabbing from Kodak MegaPlus camera.\n");
   printf("Exposure time = %lu usec, Transfer time = %lu usec\n",
          exptime, xfertime);
   printf("Press a key to stop acquiring...");
   getch();
   printf( "stopped !\n\n" );
   pchlprocess();    
   pcslsync( I_PROC_ALONE);
   distexposure( (long) I_HARDTRIG, exptime, xfertime);
   pcstcond( 0, I_FOR, 1);
}

void close_image(void)
{
   pcstfborg( I_FB4X1KX1KX8);
   iorlmemdevice( im_handle);
   iocldevice( im_handle);
}  




