/**********************************************************************
 *
 * MCIEXT.H
 *
 * Copyright (C) 1994 Matrox Electronic Systems. All rights reserved.
 *
 * This file contains the definitions of the additionnal structures
 * needed to take advantage of the extended Matrox DVMCI command set.
 *
 * This header file is used for the Matrox Marvel II DVMCI driver.
 *
 **********************************************************************/


#ifndef _INC_MMSYSTEM
#include <mmsystem.h>
#endif

#ifndef _INC_DIGITALV
#include "digitalv.h"
#endif

#ifndef _INC_MCIMPEG
#include "mcimpeg.h"
#endif


#define MCI_MTX_BASE                      (MCI_USER_MESSAGES)


/* additional constants for the dwItem field of MCI_DGV_SETAUDIO_PARMS */
#define MCI_MTX_SETAUDIO_MODE             0x00008000L

/* additional constants for the dwTo field of MCI_DGV_SETAUDIO_PARMS */
#define MCI_MTX_SETAUDIO_MODE_LINEAR      0x00008000L
#define MCI_MTX_SETAUDIO_MODE_SPATIAL     0x00008001L
#define MCI_MTX_SETAUDIO_MODE_PSEUDO      0x00008002L
#define MCI_MTX_SETAUDIO_MODE_MONO        0x00008003L
                                          

/* additional constants for the dwItem field of MCI_DGV_SETVIDEO_PARMS */
#define MCI_MTX_SETVIDEO_TYPE             0x00008000L


/* additional constants for the dwTo field of MCI_DGV_SETVIDEO_PARMS */
#define MCI_MTX_SETVIDEO_SRC_COMPOSITE    0x00008000L


/* additional values for the dwItem field of MCI_DGV_STATUS_PARMS */
#define MCI_MTX_STATUS_AUDIO_MODE         0x00008000L
#define MCI_MTX_STATUS_VIDEO_TYPE         0x00008001L



/* --- new command: MCI_MTX_RESTOREDC --- */
#define MCI_MTX_RESTOREDC                 (MCI_MTX_BASE+0)
#define MCI_MTX_RESTOREDC_HDC             0x80000000L
#define MCI_MTX_RESTOREDC_FROM            0x40000000L
#define MCI_MTX_RESTOREDC_AT              0x20000000L
typedef struct
{
   DWORD dwCallback;
   HDC   hDC;              // Video DC handle
#ifndef WIN32
   WORD  wReserved0;
#endif
   LPSTR lpstrFileName;    // Ptr to filename
   RECT  rc;               // Rectangle to load image in
                           // (x, y, width, height) format (client coord.)
} MCI_MTX_RESTOREDC_PARMS;
typedef MCI_MTX_RESTOREDC_PARMS FAR * LPMCI_MTX_RESTOREDC_PARMS;


/* --- error codes from MCI_OPEN --- */
/* The DOS device driver is not installed properly */
#define MCIERR_MTX_DOS_DRIVER_MISSING     (MCIERR_CUSTOM_DRIVER_BASE+101)

/* Wrong version of DOS device driver */
#define MCIERR_MTX_DOS_DRIVER_VERSION     (MCIERR_CUSTOM_DRIVER_BASE+102)

/* Current resolution not supported */
#define MCIERR_MTX_RES_NOT_SUPPORTED      (MCIERR_CUSTOM_DRIVER_BASE+103)

/* Windows library already in use by another application */
#define MCIERR_MTX_LIBRARY_OPENED         (MCIERR_CUSTOM_DRIVER_BASE+104)

/* A reference file is required */
#define MCIERR_MTX_NO_REFERENCE_FILE      (MCIERR_CUSTOM_DRIVER_BASE+105)

/* Audio output is already in use by another application */
#define MCIERR_MTX_AUDIOPROCESSOR_IN_USE  (MCIERR_CUSTOM_DRIVER_BASE+106)



/****************************************************************************
   Function prototypes
****************************************************************************/

/****************************************************************************

   Function: Mrv2DVMCIWindowProc()

   This function processes the Windows messages for custom windows. The
   MCI driver must have been opened successfully PRIOR to calling this
   function. Child windows are NOT supported!

   To use this function, add the following line to your DEF file in the
   IMPORTS section:

      MCIM2.Mrv2DVMCIWindowProc


   Parameters:
      wDeviceID : Device ID of the MCI device
      hWnd      : Handle to the window
      wMessage  : Message being sent to the window
      wParam    : defined separately for each message
      lParam    : defined separately for each message

   Returns: Error code (NULL if successful).

 ***************************************************************************/

extern long FAR PASCAL Mrv2DVMCIWindowProc(UINT wDeviceID,
                                           HWND hWnd,
                                           UINT wMessage,
                                           WPARAM wParam,
                                           LPARAM lParam);
