	REM		------------------------
	REM		 S  T  A  R  T  R  E  K
	REM		------------------------

	REM--->DISTRIBUTION/MODIFICATION HISTORY:
	REM
	REM	01/31/84	J. RUSSELL MAY (913)-236-4984
	REM	Added short prompt capability, reworked the 'Region Name' map,
	REM	modified the ending sequence and interface to instructions,
	REM	set up for Osborne 1 (52 column) screen or Televideo terminal,
	REM	shortened some routines, and fixed some bugs. Game now works
	REM	about the same when compiled and run with CBASIC, but slower.
	REM
	REM	01/18/78	JOHN R. PIERCE (408)-649-3896
	REM
	REM	ORIGINALLY OBTAINED FROM CP/M USERS GROUP
	REM		VOLUME 3, NO SPECIFIC CREDITS
	REM
	REM
	REM	TO BE COMPILED WITH BASIC-E VER 2.1,
	REM	  AND EXECUTED WITH RUN-E VER 2.3 (or K2.0  --jrm)
	REM

	MAX.BADDY = 4

	DIM GALAXY(8,8), GALAXY$(8,8), C(9,2), BADDY(MAX.BADDY,3), GMAP(8,8) 
	DIM DAMAGE(8), QUAD.NAME$(16), SEGMENT$(4), DAM$(8)

	ESC$ =CHR$(27)
	BELL$=CHR$(7)

	REM Cursor and screen controls for Osborne 1 or Televideo 920:
	REM CLR.SCREEN$=CHR$(26)	REM Clear screen
	REM MOVE.UP$=CHR$(11)	REM Move cursor up one line
	REM ERA.LINE$=ESC$+CHR$(82)	REM Erase line
	REM IVB$ =ESC$+CHR$(41)	REM Inverse w/Blink = half intensity
	REM BLNK$=ESC$+CHR$(41)	REM Normal  w/Blink = half intensity
	REM INVR$=ESC$+CHR$(41)	REM Inverse wo/Blink= half intensity
	REM NORM$=ESC$+CHR$(40)	REM Restore normal video

	REM Cursor and screen controls for IBM PC with ANSI.SYS installed:
	CLR.SCREEN$	=ESC$+"[2J"	REM Clear screen
	MOVE.UP$	=ESC$+"[1A"	REM Move cursor up one line
	ERA.LINE$	=ESC$+"[k"	REM Erase line
	IVB$		=ESC$+"[0;5;7m"	REM Inverse w/Blink = half intensity
	BLNK$		=ESC$+"[0;5m"	REM Normal  w/Blink = half intensity
	INVR$		=ESC$+"[0;7m"	REM Inverse wo/Blink= half intensity
	NORM$		=ESC$+"[0m"	REM Restore normal video

	EMPTY$="."
	BASE$="B"
	ENTERPRISE$="E"
	STAR$="*"
	CRUD$="?"
	NUM.GAMES = 0
	DASH$="---------------"
	SPOCK$="Mr. Spock: "
	SCOTT$="Engineering Officer Scott: "
	DAMAGED$=" Damaged"

	REM------F U N C T I O N S
	DEF FN8=INT(RND*8+1)
	DEF FNROUND(D)=INT(D+.5)
	DEF FND=SQR((ABS(BADDY(I,1)-SX))^2+(ABS(BADDY(I,2)-SY))^2)
	DEF FNGALAXY=BAD.GUYS*100+BASES*10+STARS
	DEF FNDELTA(D)=C(INT(COURSE),D)\
		+(C(INT(COURSE)+1,D)-C(INT(COURSE),D))*(COURSE-INT(COURSE))

240	PRINT CLR.SCREEN$;NORM$
	PRINT TAB(15);"S  T  A  R  T  R  E  K";TAB(72);"JRM184"
	PRINT
	NUM.GAMES = NUM.GAMES + 1
	IF NUM.GAMES > 1 THEN \
		PRINT "GAME NUMBER ";NUM.GAMES;
	PRINT:PRINT
	INPUT "        Enter your name, Captain "; CAPTAIN$
	CAPTAIN2$="Captain "+CAPTAIN$
	PRINT
	PRINT "Welcome aboard ";CAPTAIN2$
	PRINT TAB(15);"Do you want instructions";
	INPUT ANS$
	RANDOMIZE
	PRINT CLR.SCREEN$
	IF LEFT$(ANS$,1)="Y" OR LEFT$(ANS$,1) = "y" THEN GOSUB 999999

	PRINT SPOCK$;"STAND BY"
	T=INT(RND*20+20)*100
	T0=T
	T9=26+FN8
	FIRST.TIME.FLAG=1

	ON INT(RND^2*3)+1  GOTO 400, 410, 420
400		ENEMY$="Klingon"
		ENEMYC$="KLINGON"
		GOTO 500
410		ENEMY$="Romulan"
		ENEMYC$="ROMULAN"
		GOTO 500
420		ENEMY$="Tholian"
		ENEMYC$="THOLIAN"
500	REM
	BAD.GUY$=LEFT$(ENEMY$,1)

	DOCKED=0
	ENERGY.NORMAL=3000
	ENERGY=ENERGY.NORMAL
	TORPS=10
	TORPS.NORMAL=TORPS
	SHIELD.NORMAL=200
	SHIELDS=SHIELD.NORMAL * 2
	FOR I=1 TO 8
		FOR J=1 TO 8
			GALAXY$(I,J)=EMPTY$
		NEXT J
	NEXT I
	
	REM   ***  INITIALIZE ENTERPRISE'S POSITION

	QX=FN8
	QY=FN8
	EX=FN8
	EY=FN8
	SX=EX
	SY=EY
	C(3,1)=-1
	C(2,1)=-1
	C(4,1)=-1
	C(4,2)=-1
	C(5,2)=-1
	C(6,2)=-1
	C(1,2)=1
	C(2,2)=1
	C(6,1)=1
	C(7,1)=1
	C(8,1)=1
	C(8,2)=1
	C(9,2)=1
	FOR I=1 TO 8
		DAMAGE(I)=0.1*INT(RND*30+1)
	NEXT I
	DAM$(1)="Warp Engines"
	DAM$(2)="Short Range Sensors"
	DAM$(3)="Long Range Sensors"
	DAM$(4)="Phaser Control"
	DAM$(5)="Photon Torpedo Tubes"
	DAM$(6)="Damage Control"
	DAM$(7)="Shield Control"
	DAM$(8)="Computer"

	QUAD.NAME$(01)="ANTARES"
	QUAD.NAME$(02)="SIRIUS"
	QUAD.NAME$(03)="RIGEL"
	QUAD.NAME$(04)="DENEB"
	QUAD.NAME$(05)="PROCYON"
	QUAD.NAME$(06)="CAPELLA"
	QUAD.NAME$(07)="VEGA"
	QUAD.NAME$(08)="BETELGEUSE"
	QUAD.NAME$(09)="CANOPUS"
	QUAD.NAME$(10)="ALDEBARAN"
	QUAD.NAME$(11)="ALTAIR"
	QUAD.NAME$(12)="REGULUS"
	QUAD.NAME$(13)="SAGITTARIUS"
	QUAD.NAME$(14)="ARCTURUS"
	QUAD.NAME$(15)="POLLUX"
	QUAD.NAME$(16)="SPICA"
	SEGMENT$(1)=" I"
	SEGMENT$(2)=" II"
	SEGMENT$(3)=" III"
	SEGMENT$(4)=" IV"

	TOT.BASES=0
	TOT.BAD.GUYS=0
	
	REM   ***  SET UP WHAT EXISTS IN GALAXY.

	FOR I=1 TO 8
		FOR J=1 TO 8
			R1=RND
			BAD.GUYS=0
			IF R1>.85  THEN BAD.GUYS=1
			IF R1>.93  THEN BAD.GUYS=2
			IF R1>.98  THEN BAD.GUYS=3
			IF R1>.993 THEN BAD.GUYS=4
			TOT.BAD.GUYS=TOT.BAD.GUYS+BAD.GUYS
			IF RND>.94 THEN BASES=1 ELSE BASES=0
			TOT.BASES=TOT.BASES+BASES
			STARS=FN8
			GALAXY(I,J)=FNGALAXY
			GMAP(I,J)=0
		NEXT J
	NEXT I
	K7=TOT.BAD.GUYS
	IF TOT.BASES THEN 1200
	X=FN8
	Y=FN8
	GALAXY(X,Y)=GALAXY(X,Y)+10
	BASES=1
	TOT.BASES=BASES
1200	REM
	IF TOT.BASES=1 THEN \
		A$=" is " :\
		B$="" :\
	ELSE \
		A$=" are " :\
		B$="s"
PRINT "Your orders are as follows:"
PRINT "Destroy the ";TOT.BAD.GUYS;ENEMY$;" Warships which have"
PRINT "invaded the Galaxy before they can attack Federation"
PRINT "Headquarters on StarDate ";T0+T9;". This is in ";T9;"days."
PRINT "There";A$;TOT.BASES;"StarBase";B$;" in the Galaxy for resupplying"
PRINT "your ship."
	PRINT
	PRINT "     Type 'GO' when you are ready to assume command."
	INPUT ANS$
	IF ANS$ = "free" OR ANS$ = "FREE" THEN \
		PRINT "Free storage = ";FRE;"Bytes"
 
1320	REM------ENTER NEW QUADRANT
	FOR J=1 TO 8
		FOR I=1 TO 8
			GALAXY$(I,J)=EMPTY$
			IF RND > .985 THEN \
			GALAXY$(I,J) = CRUD$
		NEXT I
	NEXT J
	BAD.GUYS=0
	BASES=0
	STARS=0
	GALAXY$(EX,EY)=ENTERPRISE$
	G5=0
	GOSUB 9030		REM GET QUADRANT NAME
	PRINT
	IF FIRST.TIME.FLAG THEN \
		FIRST.TIME.FLAG=0 :\
		PRINT "Your mission begins with your Starship located" :\
		PRINT "in the Galactic Quadrant: ";QUADRANT$; :\
	ELSE \
		PRINT "Now entering Quadrant:  ";QUADRANT$
1500	PRINT
	X=GALAXY(QX,QY)*.01
	BAD.GUYS=INT(X)
	BASES=INT((X-BAD.GUYS)*10)
	STARS=GALAXY(QX,QY)-INT(GALAXY(QX,QY)*.1)*10
	IF BAD.GUYS>0 THEN \
		PRINT "COMBAT AREA    ";BLNK$;ENEMYC$;" ALERT";NORM$
	IF SHIELDS<=SHIELD.NORMAL THEN \
		PRINT "Warning: LOW SHIELDS"
	FOR X=1 TO MAX.BADDY
		FOR Y=1 TO 3
			BADDY(X,Y)=0
		NEXT Y
	NEXT X
1600	REM
	IF BAD.GUYS=0 THEN \
		GOTO 1705
	FOR X=1 TO BAD.GUYS
		GOSUB 9500		REM FIND EMPTY SECTOR
		GALAXY$(SX,SY)=BAD.GUY$ 
		BADDY(X,1)=SX
		BADDY(X,2)=SY
		BADDY(X,3)=SHIELD.NORMAL
	NEXT X
1705	REM
	IF BASES=0 THEN \
		GOTO 1710
	FOR X=1 TO BASES
		GOSUB 9500		REM FIND EMPTY SECTOR
		GALAXY$(SX,SY)=BASE$
		BX=SX
		BY=SY
	NEXT X
1710	REM
	IF STARS<=0 THEN \
		GOTO 1980
	FOR X=1 TO STARS
		GOSUB 9500		REM FIND EMPTY SECTOR
		GALAXY$(SX,SY)=STAR$ 
	NEXT X
1980	GOSUB 6430			REM SHORT RANGE SENSOR RTN
1990	IF SHIELDS+ENERGY<=10 OR (DAMAGE(7)<0 AND ENERGY<=10) THEN  \
		PRINT BELL$;IVB$;"	**FATAL ERROR**";NORM$ :\
		PRINT "You've just stranded your ship in space !!!" :\
		PRINT "You have insufficient maneuvering energy and" :\
		PRINT "Shield Control is presently incapable of Cross-" :\
		PRINT "Circuiting to the Engine Room!" :\
		GOTO 6260
	REM WAS	IF SHIELDS < 0 THEN 6150

2060	REM------C O M M A N D
	IF T>T0+T9 THEN 6220
	PRINT CAPTAIN$;":  ";
	INPUT ANS$
	CMD$ = LEFT$(ANS$,1)
	GOSUB 2080
2070	D.REPORT=0
	IF CMD$="N" OR CMD$="n" THEN 2300
	IF CMD$="S" OR CMD$="s" THEN 1980
	IF CMD$="L" OR CMD$="l" THEN 4000
	IF CMD$="P" OR CMD$="p" THEN 4260
	IF CMD$="T" OR CMD$="t" THEN 4700
	IF CMD$="E" OR CMD$="e" THEN 5530
	IF CMD$="D" OR CMD$="d" THEN 5690
	IF CMD$="C" OR CMD$="c" THEN 7290
	IF CMD$="Q" OR CMD$="q" THEN 6270
	PRINT "Enter one of the following:"
	PRINT "N-avigate"
	PRINT "S-hort Range Scan"
	PRINT "L-ong Range Scan"
	PRINT "P-hasers"
	PRINT "T-orpedos"
	PRINT "E-ngineering"
	PRINT "D-amage Control"
	PRINT "C-omputer"
	PRINT "Q-uit"
	PRINT
	GOTO 2060

2080	REM------SET UP FOR SHORT PROMPTS

	J=LEN(ANS$)
	K=1
	KUM1=0
	KUM2=0
	FOR I=1 TO J
		I$=MID$(ANS$,I,1)
		X=(I$="." OR (I$>="0" AND I$<="9"))
		IF K=1 AND X THEN K=2:\
			KUM1=1:\
			NUM1=VAL(RIGHT$(ANS$,J-I+1))
		IF K=2 AND NOT X THEN K=3
		IF K=3 AND     X THEN K=4:\
			KUM2=1:\
			NUM2=VAL(RIGHT$(ANS$,J-I+1))
	NEXT I
	RETURN

	REM**********> COURSE CONTROL BEGINS HERE.

2300	IF KUM1 THEN COURSE=NUM1:KUM1=0:GOTO 2320
	PRINT "Course (1-9) ";
	INPUT ANS$
	GOSUB 2080
	IF KUM1=0 THEN 1990
	COURSE=NUM1:KUM1=0
2320	IF COURSE>=1 AND COURSE<=9 THEN  2350
	PRINT "Lt. Sulu:   Incorrect course data, Sir." 
	PRINT
	PRINT "4  5  6"
	PRINT "  \|/  "
	PRINT "3--*--7"
	PRINT "  /|\  "
	PRINT "2  1  8"
	PRINT
	GOOF1=GOOF1+.1
	IF RND+GOOF1>.85 THEN \
		PRINT "MISSION ADVISORY: ";CAPTAIN2$;"," :\
		PRINT " I strongly suggest you get your act together":\
		PRINT " before the ";ENEMY$;"s blast your ass."
	IF COURSE THEN 2300
	GOTO 1990
2350	REM------COURSE IS OK
	IF KUM2 THEN WARP=NUM2:KUM2=0:GOTO 2370
	IF COURSE=9 THEN COURSE=1
	PRINT "Warp Factor (0-8) ";
	INPUT WARP
2370	IF WARP=0 THEN \
		GOTO 1990
	IF WARP>=0 AND WARP<=8 THEN \
		GOTO 2450		REM WARP OK
	PRINT SCOTT$
	PRINT " The engines won't take Warp ";WARP;"!"
	GOOF2=GOOF2+.1
	IF RND+GOOF2>.85 THEN \
		PRINT SPOCK$;"Warp ";WARP;"!  What a Galactic Jackass!"
	GOTO 2350
2450	REM
	IF DAMAGE(1)>=0 THEN \
		GOTO 2490
	PRINT DAM$(1);" DAMAGED"
	IF WARP>.25 THEN \
		PRINT "Maximum Warp:  0.25" :\
		GOTO 2350
2490	REM
	E.NEEDED=FNROUND(WARP*8)
	IF ENERGY-E.NEEDED>=0 THEN 2590
	PRINT SCOTT$;"Not enough energy left!"
	IF DAMAGE(7)<0 OR SHIELDS<E.NEEDED-ENERGY THEN \
		GOTO 2350		REM ASK FOR NEW WARP
	PRINT "Shield Control Room reports ";SHIELDS;"units"
	PRINT "of energy presently deployed to Shields."
	GOTO 5530			REM SHIELD CONTROL

2590	REM ***** SEE IF TIME FOR A COMMERCIAL.
	GOSUB 9600

	REM*******> BAD.GUYS MOVE/FIRE ON MOVING STARSHIP . . 
	IF BAD.GUYS=0 THEN \
		GOTO 2750
	FOR I=1 TO MAX.BADDY
		IF BADDY(I,3) > 0 THEN  :\
			GALAXY$(BADDY(I,1),BADDY(I,2))=EMPTY$  :\
			GOSUB 9500  :\
			BADDY(I,1)=SX  :\
			BADDY(I,2)=SY  :\
			GALAXY$(SX,SY)=BAD.GUY$
	NEXT I
2750	REM
	GOSUB 6000			REM BAD.GUYS SHOOT
	D6=INT(WARP*10)/10
	REM****> MAKE REPAIRS TO THE SHIP.
	FOR R1=1 TO 8
		IF DAMAGE(R1)>=0.5 THEN 2880
		DAMAGE(R1)=DAMAGE(R1)+D6
		IF DAMAGE(R1)<0 THEN 2880
		IF D.REPORT=0 THEN GOSUB 2890
		GOSUB 2892
		PRINT "functional"
2880	NEXT R1
	REM--------> DAMAGE/IMPROVEMENT DURING SOME MOVES
	IF RND>.2 THEN 3070
	R1=FN8
	IF D.REPORT=0 THEN GOSUB 2890
	GOSUB 2892
	IF RND>=.5 THEN 3000
	DAMAGE(R1)=DAMAGE(R1)-INT((RND*5+1)*10)/10
	GOSUB 2894
	GOTO 3070

2890	PRINT "Damage Control report:"
	D.REPORT=1
	RETURN

2892	PRINT TAB(8);DAM$(R1);TAB(29);
	RETURN

2894	IF DAMAGE(R1)<0 THEN \
		PRINT BLNK$;BELL$;"DAMAGED";NORM$ \
	ELSE \
		PRINT "deteriorating"
	RETURN

3000	REM
	DAMAGE(R1)=DAMAGE(R1)+INT((RND*3+1)*10)/10
	PRINT "state of repair improved"

3070	REM------BEGIN MOVING STARSHIP
	GALAXY$(EX,EY)=EMPTY$
	DELTA.X=FNDELTA(1)
	DELTA.Y=FNDELTA(2)
	X=EX
	Y=EY
	OLD.QX=QX
	OLD.QY=QY
	FOR I=1 TO E.NEEDED
		X=X+DELTA.X
		Y=Y+DELTA.Y
		EX=FNROUND(X)
		EY=FNROUND(Y)
		IF EX<1 OR EX>8 OR EY<1 OR EY>8 THEN \
			GOTO 3500
		IF GALAXY$(EX,EY)=EMPTY$ THEN \
			LAST.X=0 :\
			LAST.Y=0 :\
			GOTO 3360
		OBJECT$=GALAXY$(EX,EY)
		IF OBJECT$=BAD.GUY$ THEN OBJECT$=ENEMY$
		IF OBJECT$=STAR$ THEN OBJECT$="Star"
		IF OBJECT$=BASE$ THEN OBJECT$="StarBase"
		IF OBJECT$=CRUD$ THEN OBJECT$="Spacecrud"
		EX=FNROUND(X-DELTA.X)
		EY=FNROUND(Y-DELTA.Y)
		PRINT BELL$;"Lt. Sulu:";
		PRINT " Emergency Stop!"
		PRINT SPOCK$
		PRINT " We almost rammed into that ";OBJECT$;" at";
		PRINT " Warp ";WARP;"!!"
		IF OBJECT$=ENEMY$ THEN \
			PRINT " Captain, don't you think that is "; :\
			PRINT "rather dangerous??" : PRINT :\
			GOTO 3370
		GOOF3=GOOF3+.1
		IF RND+GOOF3>.75 THEN \
		  PRINT CAPTAIN2$;", don't you think it's time" :\
		  PRINT " you reconsider that desk job at Federation HQ??"
		GOTO 3370
3360	NEXT I
3370	REM------PUT THE ENTERPRISE IN ITS NEW PLACE
	GALAXY$(EX,EY)=ENTERPRISE$
	GOSUB 3910		REM SUBTRACT THE ENERGY NEEDED
	T8=1
	IF WARP<1 THEN \
		T8=.1*INT(10*WARP)
	T=T+T8
	IF T>T0+T9 THEN 6220
	GOTO 1980		REM SEE IF DOCKED THEN GET COMMAND

3500	REM------EXCEEDED QUADRANT LIMITS
	X=8*QX+X+(E.NEEDED-I)*DELTA.X
	Y=8*QY+Y+(E.NEEDED-I)*DELTA.Y
	QX=INT(X/8)
	QY=INT(Y/8)
	EX=INT(X-QX*8)
	EY=INT(Y-QY*8)
	PERIMETER.FLAG=0
	IF EX=0 THEN \
		QX=QX-1 :\
		EX=8
	IF EY=0 THEN \
		QY=QY-1 :\
		EY=8
	IF QX<1 THEN \
		QX=1:EX=1 :\
		PERIMETER.FLAG=1
	IF QX>8 THEN \
		QX=8:EX=8 :\
		PERIMETER.FLAG=1
	IF QY<1 THEN \
		QY=1:EY=1 :\
		PERIMETER.FLAG=1
	IF QY>8 THEN \
		QY=8:EY=8 :\
		PERIMETER.FLAG=1
	IF PERIMETER.FLAG=0 THEN \
		GOTO 3860
	PRINT "Lt. Uhura:"
	PRINT " StarFleet Command reports:"
	PRINT " 'PERMISSION TO CROSS GALACTIC PERIMETER"
	PRINT " IS ";BLNK$;"*DENIED*";NORM$;".  SHUT DOWN YOUR ENGINES.'"
	PRINT SCOTT$;"WARP ENGINES SHUT DOWN"
	PRINT " at Sector ";EX;EY;" of Quadrant ";QX;QY;"."
	IF T>T0+T9 THEN 6220
3860	REM
	IF QX=OLD.QX AND QY=OLD.QY THEN \
		GOTO 3370
	T=T+1
	GOSUB 3910			REM SUBTRACT THE NEEDED ENERGY
	GOTO 1320			REM ANNOUNCE THE NEW QUADRANT

3910	REM---------> MANEUVER ENERGY S/R
	ENERGY=ENERGY-E.NEEDED-10
	IF ENERGY>=0 THEN 3980
	PRINT "Shield Control supplied energy to complete maneuver."
	IF RND>.6 THEN 3911
	PRINT SPOCK$;CAPTAIN2$;","
	IF RND>.5 THEN  \
		PRINT " That was extremely close even for the Enterprise" :\
	ELSE PRINT " We will need those Shields before long, you know."
3911	REM
	SHIELDS=SHIELDS+ENERGY
	ENERGY=0
	IF SHIELDS<0 THEN \
		SHIELDS=0
3980	RETURN

4000	REM-----------> LONG RANGE SENSOR SCAN CODE
	IF DAMAGE(3)<0 THEN \
		PRINT DAM$(3);DAMAGED$ :\
		GOTO 1990
	PRINT DAM$(3);" Scan for Quadrant ";QX;QY
	PRINT
	FOR J=QY-1 TO QY+1
		Q=0
		FOR I=QX-1 TO QX+1
			Q=Q+6
			IF I<1 OR I>8 OR J<1 OR J>8 THEN \
				PRINT TAB(Q); "***";:\
				GOTO 4040
			GM =GALAXY(I,J)
			YYY=0
			IF GM<100 THEN YYY=1
			IF GM<10  THEN YYY=2
			PRINT TAB(Q+YYY);STR$(GM);
			GMAP(I,J)=GM
4040		NEXT I
		PRINT : PRINT
	NEXT J
	GOTO 1990

4260	REM----------> PHASER CONTROL BEGINS HERE
	SX=EX
	SY=EY
	IF BAD.GUYS=0 THEN \
		OBJECT$="enemy ship":\
		GOTO 8550
	IF DAMAGE(4)<0 THEN \
		PRINT DAM$(4);DAMAGED$ :\
		GOTO 1990
	IF DAMAGE(8)<0 THEN \
		PRINT DAM$(8);" Malfunction reduces accuracy" 
	IF KUM1 THEN RATE.OF.FIRE=NUM1:KUM1=0:GOTO 4370
	PRINT "Phasers locked on target; "
4360	PRINT "Energy available = ";ENERGY
	PRINT "Number of units to fire: ";
	INPUT RATE.OF.FIRE
4370	IF RATE.OF.FIRE<=0 THEN 1990
	IF RATE.OF.FIRE>ENERGY THEN 4360
	IF DOCKED <> 1 THEN \
		ENERGY=ENERGY-RATE.OF.FIRE
	GOSUB 6000			REM   BAD.GUYS SHOOT
	IF DAMAGE(8)<0 OR DAMAGE(4)<1 THEN \
		DRAIN=RND/2+.5 :\
		RATE.OF.FIRE=RATE.OF.FIRE*DRAIN :\
		DRAIN=INT((1-DRAIN)*100) :\
		PRINT SPOCK$ :\
		PRINT " ";DRAIN;"% of Phaser power";:\
		PRINT " was diverted to Damage Control"
	TOTAL.HIT=INT(RATE.OF.FIRE/BAD.GUYS)
	FOR I=1 TO MAX.BADDY
		IF BADDY(I,3)<=0 THEN 4670
		HIT=INT((TOTAL.HIT/FND)*(RND+1.5))
		IF HIT<.15*BADDY(I,3) THEN \
			PRINT "Sensors show no damage "; :\
			PRINT "to enemy at ";BADDY(I,1);STR$(BADDY(I,2)) :\
			GOTO 4670
		BADDY(I,3)=BADDY(I,3)-HIT*(RND+.3)
		PRINT HIT;"unit hit on ";ENEMY$;" at Sector ";
		PRINT BADDY(I,1);STR$(BADDY(I,2))
		IF BADDY(I,3)<=0 THEN 4580
		IF RND>.5 THEN \
			PRINT "Sensors show ";BADDY(I,3);"units remaining" 
		GOTO 4670
4580		PRINT TAB(8);BELL$;BLNK$;" << ";ENEMYC$;" DESTROYED >>";NORM$
		BAD.GUYS=BAD.GUYS-1
		TOT.BAD.GUYS=TOT.BAD.GUYS-1
		GALAXY$(BADDY(I,1),BADDY(I,2))=EMPTY$
		GALAXY(QX,QY)=FNGALAXY
		IF GMAP(QX,QY)<>0 THEN \
			GMAP(QX,QY)=GALAXY(QX,QY)
		IF TOT.BAD.GUYS <=0 THEN 6370
4670	NEXT I
	GOTO 1990

4700	REM---------> PHOTON TORPEDO CODE BEGINS
	SX=EX
	SY=EY
	IF DAMAGE(5)<0 THEN \
		PRINT DAM$(5);DAMAGED$ :\
		GOTO 1990
	IF TORPS<=0 THEN \
		PRINT "All Photon Torpedoes expended" :\
		GOTO 1990
	GOSUB 6000		REM BAD.GUYS SHOOT
	IF KUM1 THEN COURSE=NUM1:KUM1=0:GOTO 4770
4760	PRINT "Torpedo Course (1-9) ";
	INPUT COURSE
4770	IF COURSE<1 OR COURSE>9 THEN \
		PRINT "Ensign Chekov:"; :\
		PRINT "Incorrect course data, Sir!" :\
		ON FNROUND(RND)+1 GOTO 1990, 4760
	IF COURSE=9 THEN COURSE=1
	DELTA.X=FNDELTA(1)
	DELTA.Y=FNDELTA(2)
	ENERGY=ENERGY-2
	X=SX
	Y=SY
	TORPS=TORPS-1
	PRINT "TORPEDO TRACK---> ";
4920	X=X+DELTA.X
	Y=Y+DELTA.Y
	ROUND.X=FNROUND(X)
	ROUND.Y=FNROUND(Y)
	IF ROUND.X<1 OR \
		ROUND.X>8 OR \
		ROUND.Y<1 OR \
		ROUND.Y>8 THEN \
			PRINT:PRINT TAB(8);"Torpedo missed" :\
			GOTO 5500
	PRINT " ";ROUND.X;STR$(ROUND.Y);
	OBJECT$=GALAXY$(ROUND.X,ROUND.Y)
	IF OBJECT$=EMPTY$ THEN 4920
	PRINT:PRINT TAB(8);
	IF OBJECT$=STAR$ THEN OBJECT$="Star":GOTO 5210
	IF OBJECT$=CRUD$ THEN OBJECT$="Spacecrud":GOTO 5210
	IF OBJECT$=BASE$ THEN 5280
	REM	MUST BE A BAD.GUY

5100	REM------HIT A BAD.GUY
	PRINT BELL$;BLNK$;"<< ";ENEMYC$;" DESTROYED >>";NORM$
	ON FN8 GOTO 5177, 5177, 5177, 5177, 5177, 5176, 5178, 5178
5176	REM
	PRINT "Excellent work with the Torpedoes, Captain."
	GOTO 5177
5178	REM
	PRINT SPOCK$;
	PRINT " Very good shooting, ";CAPTAIN2$
5177	REM
	GALAXY$(X,Y)=EMPTY$
	BAD.GUYS=BAD.GUYS-1
	TOT.BAD.GUYS=TOT.BAD.GUYS-1
	IF TOT.BAD.GUYS<=0 THEN 6370
	FOR I=1 TO MAX.BADDY
		IF BADDY(I,3) >0 AND  \
		   ROUND.X = BADDY(I,1) AND  \
		   ROUND.Y = BADDY(I,2) THEN \
			BADDY(I,3)=0:\
			GOTO 5430
5180	NEXT I
	GOTO 5430		REM - DEFENSIVE PROGRAMMING

5210	REM------HIT A STAR OR CRUD
	PRINT OBJECT$;" at ";ROUND.X;STR$(ROUND.Y);" absorbed Torpedo energy"
	IF RND<=.7 THEN  :\
		PRINT "Command Inquiry: ";  :\
		PRINT " Was it you intention to waste a "  :\
		PRINT " valuable Torpedo on that ";OBJECT$;", Captain?"
	GOTO 5500

5280	REM------HIT A STARBASE
	PRINT BELL$;IVB$;">> STARBASE DESTROYED << ";NORM$
	BASES=BASES-1
	TOT.BASES=TOT.BASES-1
	GALAXY$(X,Y)=EMPTY$
	IF TOT.BASES <= 0 THEN  :\
		PRINT SPOCK$;CAPTAIN2$;","  :\
		PRINT " I'm afraid that you have blown it"  :\
		GOTO 6260
	PRINT " StarFleet Command is reviewing your record"
	PRINT " to consider a General Court-Martial."
	DOCKED=0
5430	REM-------END OF ENTERPRISE SHOOTING
	GALAXY(QX,QY)=FNGALAXY
	IF GMAP(QX,QY) THEN \
		GMAP(QX,QY)=GALAXY(QX,QY)
5500	REM
	IF RND>.7 THEN \
		GOSUB 6000	REM BAD.GUYS MAY SHOOT AGAIN
	GOTO 1990

5530	REM------SHIELD CONTROL STARTS HERE
	IF DAMAGE(7)<0 THEN \
		PRINT DAM$(7);DAMAGED$ :\
		GOTO 1990
	IF DOCKED THEN \
		PRINT SPOCK$:\
		PRINT " You can't deploy shields this close to a StarBase!!":\
		GOTO 1990
	IF KUM1 THEN DIVERTED=NUM1:KUM1=0:GOTO 5570
5560	PRINT "Energy available=";ENERGY+SHIELDS
	PRINT "Divert to Shields ";
	INPUT DIVERTED
5570	IF DIVERTED<0 OR DIVERTED=SHIELDS THEN \
		PRINT "Shields unchanged" :\
		GOTO 1990
	IF DIVERTED>SHIELDS+ENERGY THEN \
		PRINT "Can't divert" :\
		GOTO 5560
	ENERGY=ENERGY+SHIELDS-DIVERTED
	SHIELDS=DIVERTED
	PRINT "Deflector Control Room report: ";
	PRINT "Shields now at ";SHIELDS
	GOTO 1990

5690	REM------DAMAGE CONTROL STARTS HERE
	IF DOCKED THEN 5710
	IF DAMAGE(6)<0 THEN \
		PRINT DAM$(6);DAMAGED$ :\
		GOTO 1990
	GOSUB 5910		REM PRINT DAMAGE RPT
	GOTO 1990

5710	REM------D O C K E D
	GOSUB 5910		REM PRINT DAMAGE REPORT
	D3=0
	FOR I=1 TO 8
		IF DAMAGE(I)<.7 THEN D3=D3+.5
5760	NEXT I
	IF D3=0 THEN 1990
	D3=D3+(.5*RND)
	IF D3>1 THEN \
		D3=RND
	REM
	PRINT "Techs standing by to repair the Ship."
	PRINT "Estimated time: ";D3;"StarDates"
	PRINT "Authorize (Y/N) ";
	INPUT A$
	IF LEFT$(A$,1)<>"Y" AND LEFT$(A$,1)<>"y" THEN 1990
	FOR I=1 TO 8
5815		REM
		IF DAMAGE(I)<=.7 THEN \
			DAMAGE(I)=DAMAGE(I)+1 :\
			GOTO 5815
	NEXT I
	T=T+D3+.1
	GOSUB 5910		REM PRINT DAMAGE RPT
	GOTO 1990

5910	REM------PRINT DAMAGE RPT
	PRINT
	PRINT "   Device";TAB(27);"Condition"
	FOR X=1 TO 8
		PRINT DAM$(X);TAB(29);DAMAGE(X)
	NEXT X
	RETURN

6000	REM------BAD.GUYS SHOOTING ROUTINE
	SX=EX
	SY=EY
	IF BAD.GUYS<=0 THEN RETURN
	IF DOCKED THEN \
		PRINT "StarBase Shields protect the Enterprise" :\
		RETURN
	FOR I=1 TO MAX.BADDY
		IF BADDY(I,3)<=0 THEN  :\
			GOTO 6200
		HIT=INT((BADDY(I,3)/FND)*(2+RND))
		SHIELDS=SHIELDS-INT(HIT*RND)
		PRINT BELL$;"---> ";HIT;"unit hit on Enterprise from Sector ";
		PRINT BADDY(I,1);BADDY(I,2)
		GOOF4=GOOF4+.1
		IF RND+GOOF4>.7 THEN \
			PRINT TAB(8);"Shields down to ";SHIELDS;"units"
		IF HIT<20 OR HIT/SHIELDS<.02 THEN \
			GOTO 6190
6100		REM------DAMAGE TO ENTERPRISE
		TEMP=SHIELDS
		IF SHIELDS<=0 THEN TEMP=1
		R1=FN8
		DAMAGE(R1)=DAMAGE(R1)-INT((HIT/TEMP+.5*RND)*10)/10
		GOSUB 2890
		GOSUB 2892
		GOSUB 2894
6190		IF SHIELDS<0 THEN 6150
6200	NEXT I
	RETURN

6150	PRINT:PRINT
	PRINT SPOCK$;IVB$;"THE END IS NEAR !!";NORM$
	GOSUB 9950
	J=51:GOSUB 9650
	PRINT "*****  E ~ N ~ T ~ E ~ R ~ P ~ R ~ I ~ S ~ E  *****"
	PRINT "*****    D ~ E ~ S ~ T ~ R ~ O ~ Y ~ E ~ D    *****"
	GOSUB 9650
	PRINT:PRINT:PRINT:PRINT
	GOTO 6260
6220	PRINT
	PRINT "  Time for your mission has expired."
6260	PRINT
	PRINT "  The Federation will be conquered."
6270	PRINT
	PRINT "It is StarDate ";T
	PRINT "There were ";TOT.BAD.GUYS;ENEMY$;" Battle Cruisers left"
	PRINT "  at the end of your mission."
6290	PRINT
	PRINT
	PRINT "The Federation needs a new StarShip Commander"
	PRINT "for a similar Mission -- If there is a volunteer,"
	PRINT "let him step forward, and enter 'AYE'.";
	INPUT A$
	IF LEFT$(A$,1)="A" OR LEFT$(A$,1)="a" THEN 240
	PRINT
	PRINT "StarBase to Enterprise:"
	PRINT " We are terminating communications"
	STOP
6370	PRINT
	PRINT "CONGRATULATIONS, Captain!  The last ";ENEMY$;" Battle"
	PRINT "Cruiser menacing the Federation has been Destroyed."
	PRINT
	IF T=T0 THEN 6290
	EFF=(K7/(T-T0))*1000
	PRINT "Your efficiency rating is ";EFF
	PRINT 
	IF EFF < RND*100+900 THEN 6290
	PRINT SPOCK$
	PRINT "Confidentially speaking, ";CAPTAIN2$;","
	PRINT "I beleive that the performance you have just given"
	PRINT "on the field of battle has been so commendable as to"
	PRINT "assure that your name will come up on the Federation"
	PRINT "Navy promotion list quite soon.  Even though I am an"
	PRINT "unemotional Vulcan, I was profoundly stirred by your"
	PRINT "demonstration of skill and judgment"
	PRINT
	GOTO 6290

6430	REM------SHORT RANGE SENSOR AND STARTUP SUBRTN.
	SX=EX
	SY=EY
	FOR J=SY-1 TO SY+1
		FOR I=SX-1 TO SX+1
			IF I<1 OR I>8 OR J<1 OR J>8 THEN \
				GOTO 6540
			IF GALAXY$(I,J)=BASE$ THEN \
				GOTO 6580
6540		NEXT I
	NEXT J
	DOCKED=0
	GOTO 6650
6580	DOCKED=1
	CONDITION$="Docked"
	IF LAST.X=EX AND LAST.Y=EY THEN \
		GOTO 6720
	LAST.X=EX
	LAST.Y=EY
	TEMP=ENERGY.NORMAL-333+100*FN8
	IF TEMP>ENERGY THEN \
		ENERGY=TEMP
	TEMP=TORPS.NORMAL-3+FN8
	IF TEMP>TORPS THEN \
		TORPS=TEMP
	PRINT SPOCK$;CAPTAIN2$;","
	PRINT " We have dropped our shields for docking"
	PRINT " We are reloading ";TORPS;" Torpedoes"
	PRINT " Our energy is being replenished to ";ENERGY;"units"
	SHIELDS=0
	GOTO 6720
6650	REM------GET CONDITION CODE
	CONDITION$="Green"
	IF ENERGY<ENERGY.NORMAL/10 THEN \
		CONDITION$=BLNK$+"Yellow"+NORM$
	IF BAD.GUYS=1 THEN \
		CONDITION$=INVR$+"Orange "+NORM$
	IF BAD.GUYS>1 THEN \
		CONDITION$=IVB$+"* R E D * "+NORM$
6720	REM------SENSOR OK?
	IF DAMAGE(2)<0 THEN \
		PRINT  :\
		PRINT DAM$(2);" DAMAGED !!!  <---"  :\
		PRINT
6770	REM
	PRINT DASH$
	J=1
	GOSUB 6800
	PRINT
	J=2
	GOSUB 6800
	PRINT TAB(20);"StarDate";TAB(40);T
	J=3
	GOSUB 6800
	PRINT TAB(20);"Condition";TAB(40);CONDITION$
	J=4
	GOSUB 6800
	PRINT TAB(20);"Quadrant";TAB(40);QX;STR$(QY)
	J=5
	GOSUB 6800
	PRINT TAB(20);"Sector";TAB(40);EX;STR$(EY)
	J=6
	GOSUB 6800
	PRINT TAB(20);"Total energy";TAB(40);ENERGY+SHIELDS
	J=7
	GOSUB 6800
	PRINT TAB(20);"Photon Torpedoes";TAB(40);TORPS
	J=8
	GOSUB 6800
	PRINT TAB(20);"Shields";TAB(40);SHIELDS
	PRINT DASH$
	RETURN

6800	REM------PRINT A LINE OF THE QUADRANT
	IF DAMAGE(2) < 0 THEN  :\
		GOTO 6805
	FOR I=1 TO 8
		PRINT GALAXY$(I,J);" "; 
	NEXT I
	RETURN
6805	FOR I=1 TO 8
		IF GALAXY$(I,J)=ENTERPRISE$ THEN  :\
			PRINT "E ";  :\
		ELSE  :\
			PRINT "? ";
		NEXT
	RETURN

7290	REM------LIBRARY COMPUTER CODE BEGINS HERE
	IF DAMAGE(8)<0 THEN \
		PRINT DAM$(8);DAMAGED$ :\
		GOTO 1990
7320	REM
	IF KUM1 THEN COMPUTER.CODE=NUM1:KUM1=0:GOTO 7340
	INPUT "Enter Computer code: "; COMPUTER.CODE
7340	IF COMPUTER.CODE>=1 AND COMPUTER.CODE<=6 THEN\
		ON COMPUTER.CODE GOTO 7400, 7900, 8070, 8500, 8150, 7350
	PRINT "Functions available from Library Computer:"
	PRINT "   1 - Cumulative Galactic Record"
	PRINT "   2 - Status Report"
	PRINT "   3 - Photon Torpedo data"
	PRINT "   4 - StarBase Navigation data"
	PRINT "   5 - Direction/Distance Calculator"
	PRINT "   6 - Galaxy 'Region Name'"
	IF COMPUTER.CODE THEN 7320
	GOTO 1990

7350	GOSUB 9030
	PRINT QUADRANT$ : PRINT
	GOTO 1990

7400	REM ------- CUMULATIVE GALACTIC RECORD CODE BEGINS.
	PRINT TAB(14);"T H E    G A L A X Y"
	FOR X=1 TO 8
		PRINT TAB(X*6+1); X;
	NEXT X
	PRINT
	PRINT
	FOR J=1 TO 8
		PRINT J;
		FOR I=1 TO 8
			GM = GMAP(I,J)
			IF GM = 0 THEN  :\
				PRINT TAB(I*6); "???";  :\
				GOTO 7420
			YYY=0
			IF GM<100 THEN YYY=1
			IF GM<10  THEN YYY=2
			PRINT TAB(I*6+YYY);STR$(GM);
			IF QX=I AND QY=J THEN \
				PRINT "<";
7420		NEXT I
		PRINT
	NEXT J
	GOTO 1990

7900	REM ---------- STATUS REPORT RTN
	PRINT
	PRINT TAB(15);"STATUS REPORT"
	X$=""
	IF TOT.BAD.GUYS=1 THEN 7940
	X$="s"
7940	PRINT TOT.BAD.GUYS;ENEMY$;X$;" left"
	PRINT "Mission must be completed in ";(T0+T9)-T;" StarDates"
	IF TOT.BASES=0 THEN PRINT "No StarBases left" : GOTO 7941
	IF TOT.BASES=1 THEN PRINT "1 StarBase left" : GOTO 7941
		PRINT TOT.BASES;" StarBases left"
7941	IF T>T0 THEN \
		PRINT "Current efficiency rating: ";:\
		PRINT ((K7-TOT.BAD.GUYS)/(T-T0))*1000
	GOTO 1990

8070	REM------  TORPEDO DIR/DIST CALCULATOR
	H8=0
	FOR I=1 TO MAX.BADDY
		IF BADDY(I,3)<=0 THEN 8480
		W1=BADDY(I,1)
		X=BADDY(I,2)
		GOSUB 8210
		H8=1
8480	NEXT I
	IF H8 THEN 1990
	OBJECT$=ENEMY$:\
	GOTO 8550

8150	REM------  GENERAL DIR/DIST CALCULATOR
	PRINT "Direction/Distance Calculator:"
	PRINT "  You are at Quadrant (";QX;QY;") Sector (";SX;SY;")"
	PRINT "  Please enter --->"
	PRINT "  Initial Coordinates (x,y) ";
	INPUT C1,A
	IF C1*A=0 THEN 1990
	PRINT "  Final Coordinates   (x,y) ";
	INPUT W1,X
	GOSUB 8220
	GOTO 1990

	REM------  COMMON D/D CALCULATOR
8210	C1=SX
	A=SY
8220	X=X-A
	A=C1-W1
	IF X<0 THEN 8350
	IF A<0 THEN C1=7:GOTO 8420
	IF X>0 OR A>0 THEN C1=1 ELSE C1=5
8290	IF ABS(A)<=ABS(X) THEN C2=ABS(A/X) ELSE C2=2-ABS(X/A)
	GOTO 8450
8350	IF A>0 THEN C1=3 ELSE C1=5:GOTO 8290
8420	IF ABS(A)>=ABS(X) THEN C2=ABS(X/A) ELSE C2=2-ABS(A/X)
8450	PRINT TAB(8);"Direction  =  ";C1+C2
8460	PRINT TAB(8);"Distance   =  ";SQR(X*X+A*A)
	RETURN

8500	REM------  STARBASE DIR/DIST CALCULATOR
	IF BASES THEN\
		PRINT "From Enterprise to StarBase:":\
		W1=BX:\
		X=BY :\
		GOSUB 8210 :\
		GOTO 1990
	OBJECT$="Starbase"
8550	PRINT SPOCK$
	PRINT " Sensors show no ";OBJECT$;"s in this Quadrant."
	GOTO 1990

9030	REM------FIND QUADRANT NAME$
	 REM WAS QUAD=INT((QX-1)/4)+2*QX-1
	 REM WAS QUAD.REM=QX
	 REM WAS IF QUAD.REM>4 THEN \
	 REM WAS		QUAD.REM=QUAD.REM-4
	 REM WAS QUADRANT$=QUAD.NAME$(QUAD)+SEGMENT$(QUAD.REM)
	QN=INT((QX+1)/2)+4*INT((QY-1)/2)
	SN=4-(QX-2*INT(QX/2))-2*(QY-2*INT(QY/2))
	QUADRANT$=QUAD.NAME$(QN)+SEGMENT$(SN)
	RETURN

9250	STOP

999999	REM------PRINT THE INSTRUCTIONS
	INST$="TREKINST"
	IF END #1 THEN 9300
	FILE INST$
9290	FOR I=1 TO 22
	READ #1;INSTRUC$
	IF I<4 OR MID$(INSTRUC$,2,1)<>"-" THEN\
		PRINT INSTRUC$:\
		NEXT I:\
		I=1
	INPUT "   MORE ?";ANS$
	PRINT MOVE.UP$;ERA.LINE$;
	IF LEFT$(ANS$,1)="N" OR LEFT$(ANS$,1)="n" THEN 9300
	IF I>1 THEN PRINT INSTRUC$
	GOTO 9290
9300	CLOSE (1)
	PRINT:PRINT:PRINT
	RETURN


9500	REM------FIND EMPTY SECTOR
	SX=FN8
	SY=FN8
	IF GALAXY$(SX,SY)=EMPTY$ THEN \
		RETURN
	GOTO 9500

9600	REM------COMMERCIALS
	IF RND>.1 THEN RETURN	REM - ONLY 10% CHANCE OF ANY COMMERCIAL
	J=52
	PRINT CLR.SCREEN$
	PRINT "$$$$$$$ AND NOW --- A WORD FROM OUR SPONSOR! $$$$$$$"
	ON INT(RND*3)+1 GOSUB 9700, 9800, 9900
	PRINT:PRINT
	RETURN

9650	FOR I=1 TO J:PRINT "*";:NEXT I:PRINT:RETURN

9660	PRINT "*";TAB(52);"*":RETURN

9700	GOSUB 9650
	GOSUB 9660
	GOSUB 9660
	PRINT "*       IIIIIIII   BBBBBB    MMM     MMM";TAB(52);"*"
	PRINT "*          II       BB  BB    MMM   MMM";TAB(52);"*"
	PRINT "*          II       BB  BB    MM M M MM";TAB(52);"*"
	PRINT "*          II       BBBBB     MM  M  MM";TAB(52);"*"
	PRINT "*          II       BB  BB    MM     MM";TAB(52);"*"
	PRINT "*          II       BB   BB   MM     MM";TAB(52);"*"
	PRINT "*          II       BB  BB    MM     MM";TAB(52);"*"
	PRINT "*       IIIIIIII   BBBBBB    MMMM   MMMM";TAB(52);"*"
	GOSUB 9660
	GOSUB 9660
	PRINT "*            This episode of S T A R T R E K";TAB(52);"*"
	PRINT "*              is brought to you by IBM";TAB(52);"*"
	GOSUB 9660
	GOSUB 9660
	PRINT"*                 Not just DATA  --";TAB(52);"*"
	PRINT"*                  But REALITY!";TAB(52);"*"
	GOSUB 9660
	GOSUB 9650
		
	GOTO 9950		REM - DELAY

9800	GOSUB 9650
	GOSUB 9660
	PRINT "*      StarTrek is brought to you by . . . .       *"
	GOSUB 9660
	PRINT "*  ==========";TAB(52);"*"
	PRINT "*  !++++++++!     TTTTT    A     N  N    GGG       *"
	PRINT "*  ==========       T   	 A A    NN N   G          *"
	PRINT "*  !        !       T    AAAAA   N NN   G  G       *"
	PRINT "*  !--------!       T   A     A  N  N    GGG       *"
	PRINT "*  !  TANG  !";TAB(52);"*"
	PRINT "*  !  TANG  !    Spock:  Spock to Captain Kirk.    *"
	PRINT "*  !  TANG  !       ";ENEMY$;" Battle cruisers        *"
	PRINT "*  !        !       sighted. Condition RED.        *"
	PRINT "*  ! Orange !       Appearance on bridge requested *"
	PRINT "*  ! flavor !";TAB(52);"*"
	PRINT "*  !--------!    Kirk:   Not now, Spock.           *"
	PRINT "*  \________/       I'm drinking my TANG!          *"
	GOSUB 9660
	PRINT "*      Drink TANG *****  Captain Kirk does. ****   *"
	GOSUB 9660
	GOSUB 9650

	GOTO 9950		REM DELAY

9900	GOSUB 9650
	GOSUB 9660
	PRINT "*     STARTREK is brought to you by:";TAB(52);"*"
	GOSUB 9660
	PRINT "*          ----         FFFF   OO   RRR   DDD      *"
	PRINT "*         +    +        F     O  O  R  R  D  D     *"
	PRINT "*        +      +       FFF   O  O  RRR   D  D     *"
	PRINT "*       +        +      F      OO   R  R  DDD      *"
	PRINT "*      +   QQQQ   +     F";TAB(52);"*"
	PRINT "*      +   !  !   +";TAB(52);"*"
	PRINT "*      +   !  !   +";TAB(52);"*"
	PRINT "*       +  !  !  +";TAB(52);"*"
	PRINT "*        + !  ! +";TAB(52);"*"
	PRINT "*         +!  !+";TAB(52);"*"
	PRINT "*          +--+";TAB(52);"*"
	PRINT "*          !//!   FORD has a Better Idea.          *"
	PRINT "*          !//!";TAB(52);"*"
	PRINT "*          -++-            (FORD of Parma, Ohio)   *"
	PRINT "*           --";TAB(52);"*"
	GOSUB 9660
	GOSUB 9650

	REM	FALL THROUGH TO 9950

9950	REM --------- TIME DELAY
	FOR I=1 TO 1200
	NEXT I
9960	PRINT CLR.SCREEN$
	PRINT:PRINT:PRINT:PRINT
	RETURN

	END
                                                                                                                                                                                                                               