/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

public class Debug {
    public static Debug out = new Debug();
    public static final int DEBUG = 1;
    public static final int RELEASE = 2;
    public static int MODE;
    private static final char[] kHexChars;

    private Debug() {
        MODE = 2;
    }

    public boolean isInDebugMode() {
        return MODE == 1;
    }

    public void print(Object e) {
        if (MODE == 1) {
            System.out.print(e);
        }
    }

    public void println(Object e) {
        if (MODE == 1) {
            System.out.println(e);
        }
    }

    public void dump(byte[] buffer) {
        if (MODE == 1) {
            this.dump(buffer, buffer.length);
        }
    }

    public void dump(byte[] buffer, int length) {
        if (MODE == 1) {
            this.dump(buffer, 0, length);
        }
    }

    public void dump(byte[] buffer, int offset, int length) {
        if (MODE == 1) {
            if (buffer.length - offset < length) {
                System.out.println("Invalid buffer");
                return;
            }
            StringBuffer hexString = new StringBuffer(2 * length);
            for (int i = offset; i < offset + length; ++i) {
                Debug.appendHexPair(buffer[i], hexString);
            }
            for (int j = 0; j < hexString.length(); j += 60) {
                int end = j + 60;
                if (end > hexString.length()) {
                    end = hexString.length();
                }
                System.out.println(hexString.substring(j, end));
            }
        }
    }

    public static void appendHexPair(byte b, StringBuffer hexString) {
        char highNibble = kHexChars[(b & 0xF0) >> 4];
        char lowNibble = kHexChars[b & 0xF];
        hexString.append(highNibble);
        hexString.append(lowNibble);
        hexString.append(' ');
    }

    static {
        kHexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

