/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.video;

import java.awt.image.IndexColorModel;

public class ColorTable {
    public static IndexColorModel get7BitDirectIndexColorModel() {
        byte[] decode7_5 = new byte[]{0, 64, -128, -64, -1};
        int num_of_colors_used = 125;
        int num_of_bits = 7;
        byte[] red = new byte[num_of_colors_used];
        byte[] green = new byte[num_of_colors_used];
        byte[] blue = new byte[num_of_colors_used];
        for (int i = 0; i < num_of_colors_used; ++i) {
            red[i] = decode7_5[i / 25];
            green[i] = decode7_5[i / 5 % 5];
            blue[i] = decode7_5[i % 5];
        }
        return new IndexColorModel(num_of_bits, num_of_colors_used, red, green, blue);
    }

    public static IndexColorModel get4BitPaletteIndexColorModel() {
        byte[][] c16table = new byte[][]{{0, 0, 0}, {0, 0, 127}, {0, 127, 0}, {0, 127, 127}, {127, 0, 0}, {127, 0, 127}, {127, 127, 0}, {127, 127, 127}, {-64, -64, -64}, {0, 0, -1}, {0, -1, 0}, {0, -1, -1}, {-1, 0, 0}, {-1, 0, -1}, {-1, -1, 0}, {-1, -1, -1}};
        int num_of_colors_used = 16;
        int num_of_bits = 4;
        byte[] red = new byte[num_of_colors_used];
        byte[] green = new byte[num_of_colors_used];
        byte[] blue = new byte[num_of_colors_used];
        for (int i = 0; i < num_of_colors_used; ++i) {
            red[i] = c16table[i][2];
            green[i] = c16table[i][1];
            blue[i] = c16table[i][0];
        }
        return new IndexColorModel(num_of_bits, num_of_colors_used, red, green, blue);
    }

    public static IndexColorModel get4BitGreyIndexColorModel() {
        int num_of_colors_used = 16;
        int num_of_bits = 4;
        byte[] red = new byte[num_of_colors_used];
        byte[] green = new byte[num_of_colors_used];
        byte[] blue = new byte[num_of_colors_used];
        for (int i = 0; i < num_of_colors_used; ++i) {
            byte color;
            red[i] = color = (byte)(i * 17);
            green[i] = color;
            blue[i] = color;
        }
        return new IndexColorModel(num_of_bits, num_of_colors_used, red, green, blue);
    }

    public static IndexColorModel get3BitGreyIndexColorModel() {
        int num_of_colors_used = 8;
        int num_of_bits = 3;
        byte[] red = new byte[num_of_colors_used];
        byte[] green = new byte[num_of_colors_used];
        byte[] blue = new byte[num_of_colors_used];
        for (int i = 0; i < num_of_colors_used; ++i) {
            byte color;
            red[i] = color = (byte)(i * 73 / 2);
            green[i] = color;
            blue[i] = color;
        }
        return new IndexColorModel(num_of_bits, num_of_colors_used, red, green, blue);
    }
}

