/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.CRC8;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Calendar;

public class IPMIDCMOEMCommand
extends IPMICommand {
    Progress progress;
    public static final byte[] INTEL_MANUFACTURERS_ID = new byte[]{87, 1, 0};
    public static final byte SMCIPMITOOL_POLICY_ID = 32;
    public static final int SMCIPMITOOL_CORRECTION_TIME = 60000;
    public static final long MANIFEST_HDR = 1312902436L;
    public static final long DEFAULT_VENDOR = 32902L;
    public static final long DEFAULT_HEADER_TYPE = 4L;
    public static final long MANIFEST_VER_1_0 = 65536L;
    public static final long MANIFEST_MODULE_HDR = 1162693924L;
    public static final long MODULE_STRUCT_ID = 1146047780L;
    public static final long MODULE_STRUCT_VER = 0L;
    public static final byte CCODE_SUCCESS = 0;
    public static final byte CCODE_OPERATION_REFUSED = -128;
    public static final byte CCODE_FLASH_ERROR = -127;
    public static final byte CCODE_OPERATION_IN_PROGRESS = -126;
    public static final byte CCODE_INVALID_FIELD = -51;

    public IPMIDCMOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void FLASH_CMD____________() {
    }

    public IPMIMessage ouPrepareForUpdateCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouOpenAreaCommand(byte areaType) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{areaType, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-95, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouWriteAreaCommand(byte seq, byte[] areaData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + areaData.length];
        data[0] = seq;
        System.arraycopy(areaData, 0, data, 1, areaData.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-94, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouCloseAreaCommand(byte[] areaSize, byte[] areaChecksum) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[areaSize.length + areaChecksum.length];
        System.arraycopy(areaSize, 0, data, 0, areaSize.length);
        System.arraycopy(areaChecksum, 0, data, areaSize.length, areaChecksum.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-93, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouRegisterUpdateCommand(byte updateType, byte flags) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{updateType, flags};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-92, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouGetStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-90, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouGetCapabilitiesCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-89, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void dropForceMEResetCommand(byte command) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{command};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-33, data);
        this.ipmiInterface.send(ipmiMessage);
    }

    private void OEM_CMD____________() {
    }

    public IPMIMessage enableDisableNodeManagerPolicyControlCommand(byte flag, byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = flag;
        data[4] = domainId;
        data[5] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-64, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeManagerPolicyCommand(byte domainId, byte policyId, byte policyConfig, byte policyException, byte[] powerLimit, byte[] correcctionTimeLimit, byte[] policyTriggerLimit, byte[] statisticsPeriod) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[17];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        data[5] = policyConfig;
        data[6] = policyException;
        data[7] = powerLimit[0];
        data[8] = powerLimit[1];
        data[9] = correcctionTimeLimit[0];
        data[10] = correcctionTimeLimit[1];
        data[11] = correcctionTimeLimit[2];
        data[12] = correcctionTimeLimit[3];
        data[13] = policyTriggerLimit[0];
        data[14] = policyTriggerLimit[1];
        data[15] = statisticsPeriod[0];
        data[16] = statisticsPeriod[1];
        ipmiMessage.setCommandAndData((byte)-72, (byte)-63, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerPolicyCommand(byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-62, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeManagerAlertThresholdsCommand(byte domainId, byte policyId, byte numberOfAlertThresholds, byte[] alertThresholdArray) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6 + alertThresholdArray.length];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        data[5] = numberOfAlertThresholds;
        System.arraycopy(alertThresholdArray, 0, data, 6, alertThresholdArray.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)-61, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerAlertThresholdsCommand(byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-60, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeManagerPolicySuspendPeriodsCommand(byte domainId, byte policyId, byte numberOfPolicySuspendPeriods, byte[] policySuspendPeriodsArray) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6 + policySuspendPeriodsArray.length];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        data[5] = numberOfPolicySuspendPeriods;
        System.arraycopy(policySuspendPeriodsArray, 0, data, 6, policySuspendPeriodsArray.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)-59, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerPolicySuspendPeriodsCommand(byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-58, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage resetNodeManagerStatisticsCommand(byte mode, byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = mode;
        data[4] = domainId;
        data[5] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-57, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerStatisticsCommand(byte mode, byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = mode;
        data[4] = domainId;
        data[5] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-56, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerCapabilitiesCommand(byte domainId, byte policyType) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyType;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerVersionCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)-54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeManagerPowerDrawRangeCommand(byte domainId, byte[] minPowerDraw, byte[] maxPowerDraw) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[8];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = minPowerDraw[0];
        data[5] = minPowerDraw[1];
        data[6] = maxPowerDraw[0];
        data[7] = maxPowerDraw[1];
        ipmiMessage.setCommandAndData((byte)-72, (byte)-53, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeManagerAlertDestinationCommand(byte channelNumber, byte destionationInfo, byte alertStringSelector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = channelNumber;
        data[4] = destionationInfo;
        data[5] = alertStringSelector;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerAlertDestinationCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)-49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setTotalPowerBudgetRequestCommand(byte domainId, byte[] budget) {
        return null;
    }

    public IPMIMessage getTotalPowerBudgetRequestCommand(byte domainId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-47, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setMaxAllowedCPU_P_T_StateCommand(byte domainId, byte pState, byte tState) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = pState;
        data[5] = tState;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-46, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMaxAllowedCPU_P_T_StateCommand(byte domainId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-45, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNumberOf_P_T_StateRequestCommand(byte domainId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-44, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setHostCPUDataCommand() {
        return null;
    }

    public IPMIMessage setPSUConfigurationRequestCommand() {
        return null;
    }

    public IPMIMessage getPSUConfigurationRequestCommand() {
        return null;
    }

    private void FLASH_API____________() {
    }

    public void ouPrepareForUpdate() throws Exception {
        IPMIMessage resMessage = this.ouPrepareForUpdateCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call OUPrepareForUpdateCommand failed");
    }

    public void ouOpenArea(byte areaType) throws Exception {
        IPMIMessage resMessage = this.ouOpenAreaCommand(areaType);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call OUOpenAreaCommand failed");
    }

    public void ouOpenOperationCodeArea() throws Exception {
        this.ouOpenArea((byte)1);
    }

    public void ouWriteArea(byte seq, byte[] areaData) throws Exception {
        IPMIMessage resMessage = this.ouWriteAreaCommand(seq, areaData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call OUWriteAreaCommand failed");
    }

    public void ouCloseArea(byte[] areaSize, byte[] areaChecksum) throws Exception {
        IPMIMessage resMessage = this.ouCloseAreaCommand(areaSize, areaChecksum);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call OUCloseAreaCommand failed");
    }

    public void ouRegisterUpdate(byte updateType, byte flags) throws Exception {
        IPMIMessage resMessage = this.ouRegisterUpdateCommand(updateType, flags);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call OURegisterUpdateCommand failed");
    }

    public void ouRegisterNormalUpdate() throws Exception {
        this.ouRegisterUpdate((byte)1, (byte)0);
    }

    public void ouRegisterManualRollbackUpdate() throws Exception {
        this.ouRegisterUpdate((byte)3, (byte)0);
    }

    public void ouRegisterAbortUpdate() throws Exception {
        this.ouRegisterUpdate((byte)4, (byte)0);
    }

    public OUStatus ouGetStatus() throws Exception {
        IPMIMessage resMessage = this.ouGetStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                OUStatus ouStatus = new OUStatus();
                ouStatus.imageStatus = resMessage.data[0];
                ouStatus.updateSatatus = resMessage.data[1];
                ouStatus.updateAttemptStatus = resMessage.data[2];
                ouStatus.rollbackAttemptStatus = resMessage.data[3];
                ouStatus.updateType = resMessage.data[4];
                ouStatus.dependentFlags = resMessage.data[5];
                System.arraycopy(resMessage.data, 6, ouStatus.freeAreaSize, 0, 3);
                return ouStatus;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call ouGetStatusCommand failed");
    }

    public OUCapabilities ouGetCapabilities() throws Exception {
        IPMIMessage resMessage = this.ouGetCapabilitiesCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                OUCapabilities outCapabilities = new OUCapabilities();
                outCapabilities.areasSupported = resMessage.data[0];
                outCapabilities.specialCapabilities = resMessage.data[1];
                return outCapabilities;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call ouGetCapabilitiesCommand failed");
    }

    public void dropForceMEReset(byte command) throws Exception {
        this.dropForceMEResetCommand(command);
    }

    public void dropForceMEResetToRecoveryMode() throws Exception {
        this.dropForceMEResetCommand((byte)1);
    }

    private void OEM_API____________() {
    }

    public NodeManagerVersion getNodeManagerVersion() throws Exception {
        IPMIMessage resMessage = this.getNodeManagerVersionCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeManagerVersion nodeManagerVersion = new NodeManagerVersion();
                nodeManagerVersion.fromRaw(resMessage.data);
                return nodeManagerVersion;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call getNodeManagerVersionCommand failed");
    }

    public NodeManagerStatistics getNodeManagerStatistics(byte mode, byte domainId, byte policyId) throws Exception {
        IPMIMessage resMessage = this.getNodeManagerStatisticsCommand(mode, domainId, policyId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeManagerStatistics statistics = new NodeManagerStatistics();
                statistics.fromRaw(resMessage.data);
                return statistics;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException("Invalid Policy Id");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException("Invalid Domain Id");
            }
            if (resMessage.completionCode == -120) {
                throw new IPMIException("Invalid mode");
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call getNodeManagerStatisticsCommand failed");
    }

    public void resetNodeManagerStatistics(byte mode, byte domainId, byte policyId) throws Exception {
        IPMIMessage resMessage = this.resetNodeManagerStatisticsCommand(mode, domainId, policyId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException("Invalid Policy Id");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException("Invalid Domain Id");
            }
            if (resMessage.completionCode == -120) {
                throw new IPMIException("Invalid mode");
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call resetNodeManagerStatisticsCommand failed");
    }

    public void enableDisableNodeManagerPolicyControl(byte flag, byte domainId, byte policyId) throws Exception {
        IPMIMessage resMessage = this.enableDisableNodeManagerPolicyControlCommand(flag, domainId, policyId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException("Invalid Policy Id");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException("Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call enableDisableNodeManagerPolicyControlCommand failed");
    }

    public NodeManagerCapabilities getNodeManagerCapabilities(byte domainId, byte policyType) throws Exception {
        IPMIMessage resMessage = this.getNodeManagerCapabilitiesCommand(domainId, policyType);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeManagerCapabilities cap = new NodeManagerCapabilities();
                cap.fromRaw(resMessage.data);
                return cap;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call getNodeManagerCapabilitiesCommand failed");
    }

    public void setNodeManagerPolicy(NodeManagerPolicySetting policy) throws Exception {
        IPMIMessage resMessage = this.setNodeManagerPolicyCommand(policy.domainID, policy.policyID, policy.policyConfig, policy.PolicyException, policy.powerLimit, policy.correctionTimeLimit, policy.policyTriggerLimit, policy.statisticsReportingPeriod);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException("Invalid Policy Id");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException("Invalid Domain Id");
            }
            if (resMessage.completionCode == -126) {
                throw new IPMIException("unknown or unsupported Policy Trigger type");
            }
            if (resMessage.completionCode == -125) {
                throw new IPMIException("unknown or unsupported Policy Configuration Action");
            }
            if (resMessage.completionCode == -124) {
                throw new IPMIException("Power limit out of range");
            }
            if (resMessage.completionCode == -123) {
                throw new IPMIException("Correction Time out of range");
            }
            if (resMessage.completionCode == -122) {
                throw new IPMIException("Policy Trigger value out of range");
            }
            if (resMessage.completionCode == -119) {
                throw new IPMIException("Statistics Reporting Period out of range");
            }
            if (resMessage.completionCode == -43) {
                throw new IPMIException("Policy could not be updated since PolicyId already exists and is enabled");
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call setNodeManagerPolicyCommand failed");
    }

    public NodeManagerPolicy getNodeManagerPolicy(byte domainId, byte policyId) throws Exception {
        IPMIMessage resMessage = this.getNodeManagerPolicyCommand(domainId, policyId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeManagerPolicy policy = new NodeManagerPolicy();
                policy.fromRaw(resMessage.data);
                return policy;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException("Invalid Policy Id");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException("Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call getNodeManagerPolicyCommand failed");
    }

    public void setMaxAllowedCPU_P_T_State(byte domainId, byte pState, byte tState) throws Exception {
        IPMIMessage resMessage = this.setMaxAllowedCPU_P_T_StateCommand(domainId, pState, tState);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -118) {
                throw new IPMIException("P-State or T-State out of range");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException("Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call setMaxAllowedCPU_P_T_StateCommand failed");
    }

    public byte[] getMaxAllowedCPU_P_T_State(byte domainId) throws Exception {
        IPMIMessage resMessage = this.getMaxAllowedCPU_P_T_StateCommand(domainId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] state = new byte[]{resMessage.data[3], resMessage.data[4]};
                return state;
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException("Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call getMaxAllowedCPU_P_T_StateCommand failed");
    }

    public byte[] getNumberOf_P_T_StateRequest(byte domainId) throws Exception {
        IPMIMessage resMessage = this.getNumberOf_P_T_StateRequestCommand(domainId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] state = new byte[]{resMessage.data[3], resMessage.data[4]};
                return state;
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException("Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call getNumberOf_P_T_StateRequestCommand failed");
    }

    public NodeManagerAlertDestination getNodeManagerAlertDestination() throws Exception {
        IPMIMessage resMessage = this.getNodeManagerAlertDestinationCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeManagerAlertDestination dest = new NodeManagerAlertDestination();
                dest.fromRaw(resMessage.data);
                return dest;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call getNodeManagerAlertDestinationCommand failed");
    }

    public void setNodeManagerAlertDestination(NodeManagerAlertDestination dest) throws Exception {
        IPMIMessage resMessage = this.setNodeManagerAlertDestinationCommand(dest.channelNumber, dest.destinationSelector, dest.alertStringSelector);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage.completionCode);
        }
        throw new IPMIException("Call setNodeManagerAlertDestinationCommand failed");
    }

    public NodeManagerPolicySetting createNodeManagerPolicySetting() {
        return new NodeManagerPolicySetting();
    }

    public NodeManagerAlertDestination createNodeManagerAlertDestination() {
        return new NodeManagerAlertDestination();
    }

    private void FW_HEADER____________() {
    }

    private void ENTITY____________() {
    }

    public FirmwareFile createFirmwareFile(String filename) {
        return new FirmwareFile(filename);
    }

    public void test() throws Exception {
        FirmwareFile firmwareFile = new FirmwareFile("c:\\SPSOperational.bin");
        firmwareFile.getAllHeader();
        NodeManagerVersion nodeManagerVersion = this.getNodeManagerVersion();
        System.out.println(nodeManagerVersion.toString());
    }

    private void FUNC____________() {
    }

    private void setValue(int value) {
        if (this.progress != null) {
            this.progress.setValue(value);
        }
    }

    private void message(String message) {
        if (this.progress != null) {
            this.progress.message(message);
        }
    }

    private void left(long value) {
        if (this.progress != null) {
            this.progress.left(value);
        }
    }

    public void flashFlow(String filename) throws Exception {
        int totalTimeSpentCount;
        int totalTimeSpentCountBak = totalTimeSpentCount = 5;
        long[] timeSpent = new long[totalTimeSpentCount];
        long avgTimeSpent = 0L;
        FirmwareFile firmwareFile = null;
        int chunkSize = 16;
        int upgradedBytes = 0;
        byte writeSeq = 0;
        firmwareFile = new FirmwareFile(filename);
        RandomAccessFile raf = new RandomAccessFile(firmwareFile.firmware, "r");
        firmwareFile.getAllHeader();
        this.message("Firmware File verified");
        this.printVersion(firmwareFile);
        this.message("Entering Recovery mode");
        this.dropForceMEResetToRecoveryMode();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        OUStatus status = this.ouGetStatus();
        this.ouPrepareForUpdate();
        status = this.ouGetStatus();
        this.ouOpenArea((byte)1);
        status = this.ouGetStatus();
        this.message("Flashing started");
        while ((long)upgradedBytes < firmwareFile.fileSize()) {
            Calendar chuckStartTime = Calendar.getInstance();
            byte[] buffer = new byte[chunkSize];
            raf.seek(upgradedBytes);
            raf.read(buffer);
            this.ouWriteArea(writeSeq, buffer);
            this.setValue((int)((long)(upgradedBytes * 100) / firmwareFile.fileSize()));
            upgradedBytes += chunkSize;
            writeSeq = (byte)(writeSeq + 1);
            Calendar chuckEndTime = Calendar.getInstance();
            long leftTime = 0L;
            if (--totalTimeSpentCount >= 0) {
                timeSpent[totalTimeSpentCount] = chuckEndTime.getTime().getTime() - chuckStartTime.getTime().getTime();
                if (totalTimeSpentCount != 0) continue;
                for (int i = 0; i < totalTimeSpentCountBak; ++i) {
                    avgTimeSpent += timeSpent[i];
                }
                avgTimeSpent /= (long)totalTimeSpentCountBak;
                continue;
            }
            long leftChunks = (firmwareFile.fileSize() - (long)upgradedBytes) / (long)chunkSize;
            leftTime = avgTimeSpent * leftChunks;
            if (this.progress == null) continue;
            this.progress.left(leftTime);
        }
        raf.close();
        byte[] fileSize = new byte[4];
        ByteUtility.intTo4Bytes(fileSize, 0, (int)firmwareFile.fileSize());
        byte[] byte56 = new byte[2];
        byte56[0] = firmwareFile.getCRC8();
        this.ouCloseArea(fileSize, byte56);
        status = this.ouGetStatus();
        this.ouRegisterNormalUpdate();
        status = this.ouGetStatus();
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiInterface);
        ipmiGlobalCommand.coldReset();
        this.message("Done");
    }

    public void printVersion(FirmwareFile firmwareFile) throws Exception {
        NodeManagerVersion nodeManagerVersion = null;
        try {
            nodeManagerVersion = this.getNodeManagerVersion();
            this.message("ME Version : " + nodeManagerVersion.majorFirmwareRevision + "." + ByteUtility.byteToHex(nodeManagerVersion.minorFirmwareRevision));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.message("Image File Version : " + firmwareFile.moduleEntryTypes[0].majorVersion[0] + "." + ByteUtility.byteToHex((byte)((firmwareFile.moduleEntryTypes[0].minorVersion[0] << 4) + firmwareFile.moduleEntryTypes[0].hotfix[0])) + " Build: " + ByteUtility.byteToHex(firmwareFile.moduleEntryTypes[0].build[1]) + ByteUtility.byteToHex(firmwareFile.moduleEntryTypes[0].build[0]));
    }

    public void printVersionTest(FirmwareFile firmwareFile) throws Exception {
        NodeManagerVersion nodeManagerVersion = null;
        try {
            nodeManagerVersion = this.getNodeManagerVersion();
            System.out.println("ME version : " + nodeManagerVersion.majorFirmwareRevision + "." + nodeManagerVersion.minorFirmwareRevision);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Image version : " + firmwareFile.moduleEntryTypes[0].majorVersion[0] + "." + firmwareFile.moduleEntryTypes[0].hotfix[0]);
        System.out.println(ByteUtility.bytesToHex(firmwareFile.mfmHeader.headerVersion));
        System.out.println(ByteUtility.bytesToHex(firmwareFile.moduleHeader.majorVersion));
        System.out.println(ByteUtility.bytesToHex(firmwareFile.moduleHeader.minorVersion));
    }

    private Exception ccode2Exception(byte ccode) {
        switch (ccode) {
            case -128: {
                return new Exception("Operation refused");
            }
            case -127: {
                return new Exception("Flash error");
            }
            case -126: {
                return new Exception("Opertation in progress (flash erase)");
            }
            case -51: {
                return new Exception("Invalid field");
            }
        }
        String str = GlobalDefine.getCompletionCodeString(ccode);
        return new Exception(str);
    }

    private void MAIN____________() {
    }

    public static void main_org(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.213");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIDCMOEMCommand ipmiDCMOEMCommand = new IPMIDCMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiDCMOEMCommand);
        if (sessionController == null) {
            return;
        }
        try {
            ipmiDCMOEMCommand.ouPrepareForUpdate();
            OUStatus status = ipmiDCMOEMCommand.ouGetStatus();
            System.out.println("" + status.toString());
            OUCapabilities capabilities = ipmiDCMOEMCommand.ouGetCapabilities();
            System.out.println("capabilities.areasSupported =" + capabilities.areasSupported);
            System.out.println("capabilities.specialCapabilities =" + capabilities.specialCapabilities);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sessionController.closeSession();
    }

    public static void main_IPMB(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.213");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        IPMIDCMOEMCommand ipmiDCMOEMCommand = new IPMIDCMOEMCommand(null);
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiLanCommand);
        if (sessionController == null) {
            return;
        }
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmiOEMCommand.setIPMIInterface(ipmb);
        ipmiGlobalCommand.setIPMIInterface(ipmb);
        ipmiDCMOEMCommand.setIPMIInterface(ipmb);
        ipmiChassisCommand.setIPMIInterface(ipmb);
        ipmb.setAddress((byte)-120);
        ipmb.setChannel((byte)0);
        try {
            DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
            System.out.println("deviceInfo = \n" + deviceInfo.toString());
            ipmiDCMOEMCommand.test();
            for (int i = 0; i < 1; ++i) {
                System.out.println("i = " + i);
                ipmiDCMOEMCommand.flashFlow("c:\\SPSOperational.bin");
                System.out.println("wait for 20 seconds");
                try {
                    Thread.sleep(20000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        boolean b = sessionController.closeSession();
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.11");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIDCMOEMCommand ipmiDCMOEMCommand = new IPMIDCMOEMCommand(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiDCMOEMCommand);
        if (sessionController == null) {
            return;
        }
        IPMB ipmb = new IPMB(ipmiDCMOEMCommand.getIPMIInterface());
        ipmiDCMOEMCommand.setIPMIInterface(ipmb);
        ipmiGlobalCommand.setIPMIInterface(ipmb);
        ipmb.setAddress((byte)-120);
        ipmb.setChannel((byte)0);
        try {
            NodeManagerVersion nodeManagerVersion = ipmiDCMOEMCommand.getNodeManagerVersion();
            System.out.println(nodeManagerVersion.toString());
            FirmwareFile firmwareFile = ipmiDCMOEMCommand.createFirmwareFile("c:\\SPSOperational_1.5.bin");
            firmwareFile.getAllHeader();
            ipmiDCMOEMCommand.printVersionTest(firmwareFile);
            ipmiDCMOEMCommand.getNodeManagerStatistics((byte)1, (byte)0, (byte)0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        boolean b = sessionController.closeSession();
    }

    public Progress getProgress() {
        return this.progress;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public class NodeManagerAlertDestination {
        public byte[] manufacturersID = new byte[3];
        public byte channelNumber;
        public byte destinationSelector;
        public byte alertStringSelector;

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.channelNumber = raw[3];
            this.destinationSelector = raw[4];
            this.alertStringSelector = raw[5];
        }
    }

    public class NodeManagerCapabilities {
        public byte[] manufacturersID = new byte[3];
        public byte maxCurrentSettings;
        public byte[] maxValue = new byte[2];
        public byte[] minValue = new byte[2];
        public byte[] minCorrectionTime = new byte[4];
        public byte[] maxCorrectionTime = new byte[4];
        public byte[] minStatisticsReportingPeriod = new byte[2];
        public byte[] maxStatisticsReportingPeriod = new byte[2];
        public byte domainLimitingScope;

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.maxCurrentSettings = raw[3];
            this.maxValue[0] = raw[4];
            this.maxValue[1] = raw[5];
            this.minValue[0] = raw[6];
            this.minValue[1] = raw[7];
            this.minCorrectionTime[0] = raw[8];
            this.minCorrectionTime[1] = raw[9];
            this.minCorrectionTime[2] = raw[10];
            this.minCorrectionTime[3] = raw[11];
            this.maxCorrectionTime[0] = raw[12];
            this.maxCorrectionTime[1] = raw[13];
            this.maxCorrectionTime[2] = raw[14];
            this.maxCorrectionTime[3] = raw[15];
            this.minStatisticsReportingPeriod[0] = raw[16];
            this.minStatisticsReportingPeriod[1] = raw[17];
            this.maxStatisticsReportingPeriod[0] = raw[18];
            this.maxStatisticsReportingPeriod[1] = raw[19];
            this.domainLimitingScope = raw[20];
        }
    }

    public class NodeManagerStatistics {
        public byte[] manufacturersID = new byte[3];
        public byte[] current = new byte[2];
        public byte[] minimum = new byte[2];
        public byte[] maximum = new byte[2];
        public byte[] average = new byte[2];
        public byte[] timeStamp = new byte[4];
        public byte[] statisticsReportingPeriod = new byte[4];
        public byte domainIdAndPolicyState;

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.current[0] = raw[3];
            this.current[1] = raw[4];
            this.minimum[0] = raw[5];
            this.minimum[1] = raw[6];
            this.maximum[0] = raw[7];
            this.maximum[1] = raw[8];
            this.average[0] = raw[9];
            this.average[1] = raw[10];
            this.timeStamp[0] = raw[11];
            this.timeStamp[1] = raw[12];
            this.timeStamp[2] = raw[13];
            this.timeStamp[3] = raw[14];
            this.statisticsReportingPeriod[0] = raw[15];
            this.statisticsReportingPeriod[1] = raw[16];
            this.statisticsReportingPeriod[2] = raw[17];
            this.statisticsReportingPeriod[3] = raw[18];
            this.domainIdAndPolicyState = raw[19];
        }
    }

    public class NodeManagerSuspendPerioid {
        public byte startTime;
        public byte stopTime;
        public byte pattern;
    }

    public class NodeManagerSuspendPerioids {
        public byte[] manufacturersID = new byte[3];
        public byte policyID;
        public byte periodLength;
        public NodeManagerSuspendPerioid[] periods;
        byte domainID;

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.policyID = raw[3];
            this.periodLength = raw[4];
            this.periods = new NodeManagerSuspendPerioid[this.periodLength];
            for (int i = 0; i < this.periods.length; ++i) {
                this.periods[i].startTime = raw[i * 3 + 5];
                this.periods[i].stopTime = raw[i * 3 + 6];
                this.periods[i].pattern = raw[i * 3 + 7];
            }
        }

        public byte[] toRaw() {
            byte[] raw = new byte[6 + this.periodLength * 3];
            raw[0] = this.manufacturersID[0];
            raw[1] = this.manufacturersID[1];
            raw[2] = this.manufacturersID[2];
            raw[3] = this.domainID;
            raw[4] = this.policyID;
            raw[5] = this.periodLength;
            for (int i = 0; i < this.periods.length; ++i) {
                raw[i * 3 + 6] = this.periods[i].startTime;
                raw[i * 3 + 7] = this.periods[i].stopTime;
                raw[i * 3 + 8] = this.periods[i].pattern;
            }
            return raw;
        }
    }

    public class NodeManagerPolicy {
        public byte[] manufacturersID = new byte[3];
        public byte domainIDAndPolicyState;
        public byte policyAndTriggerType;
        public byte policyException;
        public byte[] powerLimit = new byte[2];
        public byte[] correctionTimeLimit = new byte[4];
        public byte[] policyTriggerLimit = new byte[2];
        public byte[] statisticsReportingPeriod = new byte[2];
        public byte[] raw;

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.domainIDAndPolicyState = raw[3];
            this.policyAndTriggerType = raw[4];
            this.policyException = raw[5];
            this.powerLimit[0] = raw[6];
            this.powerLimit[1] = raw[7];
            this.correctionTimeLimit[0] = raw[8];
            this.correctionTimeLimit[1] = raw[9];
            this.correctionTimeLimit[2] = raw[10];
            this.correctionTimeLimit[3] = raw[11];
            this.policyTriggerLimit[0] = raw[12];
            this.policyTriggerLimit[1] = raw[13];
            this.statisticsReportingPeriod[0] = raw[14];
            this.statisticsReportingPeriod[1] = raw[15];
            this.raw = raw;
        }
    }

    public class NodeManagerPolicySetting {
        public byte[] manufacturersID = new byte[3];
        public byte domainID;
        public byte policyID;
        public byte policyConfig;
        public byte PolicyException;
        public byte[] powerLimit = new byte[2];
        public byte[] correctionTimeLimit = new byte[4];
        public byte[] policyTriggerLimit = new byte[2];
        public byte[] statisticsReportingPeriod = new byte[2];

        public byte[] toRaw() {
            byte[] raw = new byte[]{INTEL_MANUFACTURERS_ID[0], INTEL_MANUFACTURERS_ID[1], INTEL_MANUFACTURERS_ID[2], this.domainID, this.policyID, this.policyConfig, this.PolicyException, this.powerLimit[0], this.powerLimit[1], this.correctionTimeLimit[0], this.correctionTimeLimit[1], this.correctionTimeLimit[2], this.correctionTimeLimit[3], this.policyTriggerLimit[0], this.policyTriggerLimit[1], this.statisticsReportingPeriod[0], this.statisticsReportingPeriod[1]};
            return raw;
        }
    }

    public class NodeManagerVersion {
        public byte[] manufacturersID = new byte[3];
        public byte nodeManagerVersion;
        public byte ipmiInterfaceVersion;
        public byte patchVersion;
        public byte majorFirmwareRevision;
        public byte minorFirmwareRevision;

        public void fromRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.manufacturersID, 0, this.manufacturersID.length);
            this.nodeManagerVersion = raw[index += this.manufacturersID.length];
            this.ipmiInterfaceVersion = raw[++index];
            this.patchVersion = raw[++index];
            this.majorFirmwareRevision = raw[++index];
            this.minorFirmwareRevision = raw[++index];
            ++index;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "manufacturersID = " + ByteUtility.bytesToHex(this.manufacturersID) + "\n";
            retStr = retStr + "ipmiInterfaceVersion = " + ByteUtility.byteToHex(this.ipmiInterfaceVersion) + "\n";
            retStr = retStr + "patchVersion = " + ByteUtility.byteToHex(this.patchVersion) + "\n";
            retStr = retStr + "majorFirmwareRevision = " + ByteUtility.byteToHex(this.majorFirmwareRevision) + "\n";
            retStr = retStr + "minorFirmwareRevision = " + ByteUtility.byteToHex(this.minorFirmwareRevision) + "\n";
            return retStr;
        }
    }

    public static interface Progress {
        public void setValue(int var1);

        public void message(String var1);

        public void left(long var1);
    }

    public class FirmwareFile {
        String filename;
        File firmware;
        MfmHeader mfmHeader;
        ModuleHeader moduleHeader;
        public ModuleEntryType[] moduleEntryTypes;

        public FirmwareFile(String filename) {
            this.filename = filename;
            this.firmware = new File(this.filename);
        }

        public FirmwareFile() {
        }

        public long fileSize() {
            return this.firmware.length();
        }

        public void getAllHeader() throws Exception {
            RandomAccessFile raf = new RandomAccessFile(this.firmware, "r");
            byte[] headerBytes = new byte[128];
            raf.seek(0L);
            int count = raf.read(headerBytes);
            if (count != headerBytes.length) {
                throw new Exception("File error");
            }
            this.mfmHeader = new MfmHeader();
            this.mfmHeader.fromRaw(headerBytes);
            if (!this.verifyMfMHeader(this.mfmHeader)) {
                throw new Exception("Image currupted. MfMHeader error !");
            }
            byte[] moduleHeaderBytes = new byte[80];
            raf.seek(ByteUtility.fourBytesToLongByLSBFirst(this.mfmHeader.size) * 4L);
            raf.read(moduleHeaderBytes);
            this.moduleHeader = new ModuleHeader();
            this.moduleHeader.fromRaw(moduleHeaderBytes);
            if (!this.verifyModuleHeader(this.moduleHeader)) {
                throw new Exception("Image currupted. Module Header error !");
            }
            long numOfModuleEntiries = ByteUtility.fourBytesToLongByLSBFirst(this.mfmHeader.numModuleEntiries);
            this.moduleEntryTypes = new ModuleEntryType[(int)numOfModuleEntiries];
            for (int i = 0; i < (int)numOfModuleEntiries; ++i) {
                byte[] moduleEntryTypeBytes = new byte[80];
                raf.seek(656 + i * moduleEntryTypeBytes.length);
                raf.read(moduleEntryTypeBytes);
                this.moduleEntryTypes[i] = new ModuleEntryType();
                this.moduleEntryTypes[i].fromRaw(moduleEntryTypeBytes);
                if (this.verifyModuleEntryType(this.moduleEntryTypes[i])) continue;
                throw new Exception("Image currupted. Module Entry type error !");
            }
            raf.close();
        }

        private boolean verifyMfMHeader(MfmHeader mfmHeader) {
            return ByteUtility.fourBytesToLongByLSBFirst(mfmHeader.headerID) == 1312902436L && ByteUtility.fourBytesToLongByLSBFirst(mfmHeader.manifestVendor) == 32902L && ByteUtility.fourBytesToLongByLSBFirst(mfmHeader.headerType) == 4L && ByteUtility.fourBytesToLongByLSBFirst(mfmHeader.headerVersion) == 65536L;
        }

        private boolean verifyModuleHeader(ModuleHeader moduleHeader) {
            return ByteUtility.fourBytesToLongByLSBFirst(moduleHeader.structId) == 1146047780L && ByteUtility.fourBytesToLongByLSBFirst(moduleHeader.structVer) == 0L;
        }

        private boolean verifyModuleEntryType(ModuleEntryType moduleEntryType) {
            if (ByteUtility.fourBytesToLongByLSBFirst(moduleEntryType.header) != 1162693924L) {
                return false;
            }
            String moduleName = new String(moduleEntryType.name);
            return moduleName.indexOf("Recovery") == -1;
        }

        public byte getCRC8() throws Exception {
            CRC8 crc8 = new CRC8();
            RandomAccessFile raf = new RandomAccessFile(this.firmware, "r");
            byte[] chunk = new byte[(int)this.firmware.length()];
            raf.seek(0L);
            int count = raf.read(chunk);
            if (count != (int)this.firmware.length()) {
                throw new Exception("File read error");
            }
            byte crcCode = CRC8.crc8(chunk);
            return crcCode;
        }

        public void openFileTest() throws Exception {
            RandomAccessFile raf = new RandomAccessFile(this.firmware, "r");
            int chunkSize = 16;
            int i = 0;
            while ((long)i < this.firmware.length()) {
                byte[] chunk = new byte[chunkSize];
                raf.seek(i);
                int count = raf.read(chunk);
                if (count != chunkSize) {
                    throw new Exception("File read error");
                }
                System.out.println(ByteUtility.bytesToHex(chunk));
                i += chunkSize;
            }
        }
    }

    public class OUCapabilities {
        byte areasSupported;
        byte specialCapabilities;
    }

    public class OUStatus {
        byte imageStatus;
        byte updateSatatus;
        byte updateAttemptStatus;
        byte rollbackAttemptStatus;
        byte updateType;
        byte dependentFlags;
        byte[] freeAreaSize = new byte[3];

        public String toString() {
            String retStr = "";
            retStr = retStr + "imageStatus = " + ByteUtility.byteToHex(this.imageStatus) + "\n";
            retStr = retStr + "updateSatatus = " + ByteUtility.byteToHex(this.updateSatatus) + "\n";
            retStr = retStr + "updateAttemptStatus = " + ByteUtility.byteToHex(this.updateAttemptStatus) + "\n";
            retStr = retStr + "rollbackAttemptStatus = " + ByteUtility.byteToHex(this.rollbackAttemptStatus) + "\n";
            retStr = retStr + "updateType = " + ByteUtility.byteToHex(this.updateType) + "\n";
            retStr = retStr + "dependentFlags = " + ByteUtility.byteToHex(this.dependentFlags) + "\n";
            retStr = retStr + "freeAreaSize = " + ByteUtility.bytesToHex(this.freeAreaSize) + "\n";
            return retStr;
        }

        public String getStatusInfo() {
            String runningArea = null;
            String updateStatus = null;
            if ((this.imageStatus & 0x18) == 0) {
                runningArea = "CODE (Recovery mode)";
            } else if ((this.imageStatus & 0x18) == 8) {
                runningArea = "COD1";
            } else if ((this.imageStatus & 0x18) == 16) {
                runningArea = "COD2";
            }
            switch (this.updateSatatus) {
                case 0: {
                    updateStatus = "Idle";
                    break;
                }
                case 1: {
                    updateStatus = "update requested";
                    break;
                }
                case 2: {
                    updateStatus = "update in progress";
                    break;
                }
                case 3: {
                    updateStatus = "update success";
                    break;
                }
                case 4: {
                    updateStatus = "update failed";
                    break;
                }
                case 5: {
                    updateStatus = "update rolled back";
                    break;
                }
                case 6: {
                    updateStatus = "update aborted";
                    break;
                }
                case 7: {
                    updateStatus = "update initialization failed";
                    break;
                }
            }
            return "Running Area = " + runningArea + ", UpdateStatus = " + updateStatus;
        }

        public void printStatusInfo() {
            System.out.println(this.getStatusInfo());
        }
    }

    public class ModuleEntryType {
        byte[] header = new byte[4];
        byte[] reserved = new byte[16];
        public byte[] majorVersion = new byte[2];
        public byte[] minorVersion = new byte[2];
        byte[] hotfix = new byte[2];
        byte[] build = new byte[2];
        byte[] name = new byte[16];
        byte[] hash = new byte[20];
        byte[] moduleLen = new byte[4];
        byte[] moduleFlags = new byte[4];

        public void fromRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.header, 0, this.header.length);
            System.arraycopy(raw, index += this.header.length, this.reserved, 0, this.reserved.length);
            System.arraycopy(raw, index += this.reserved.length, this.majorVersion, 0, this.majorVersion.length);
            System.arraycopy(raw, index += this.majorVersion.length, this.minorVersion, 0, this.minorVersion.length);
            System.arraycopy(raw, index += this.minorVersion.length, this.hotfix, 0, this.hotfix.length);
            System.arraycopy(raw, index += this.hotfix.length, this.build, 0, this.build.length);
            System.arraycopy(raw, index += this.build.length, this.name, 0, this.name.length);
            System.arraycopy(raw, index += this.name.length, this.hash, 0, this.hash.length);
            System.arraycopy(raw, index += this.hash.length, this.moduleLen, 0, this.moduleLen.length);
            System.arraycopy(raw, index += this.moduleLen.length, this.moduleFlags, 0, this.moduleFlags.length);
            index += this.moduleFlags.length;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "header = " + ByteUtility.bytesToHex(this.header) + "\n";
            retStr = retStr + "reserved = " + ByteUtility.bytesToHex(this.reserved) + "\n";
            retStr = retStr + "majorVersion = " + ByteUtility.bytesToHex(this.majorVersion) + "\n";
            retStr = retStr + "minorVersion = " + ByteUtility.bytesToHex(this.minorVersion) + "\n";
            retStr = retStr + "hotfix = " + ByteUtility.bytesToHex(this.hotfix) + "\n";
            retStr = retStr + "build = " + ByteUtility.bytesToHex(this.build) + "\n";
            retStr = retStr + "name = " + ByteUtility.bytesToHex(this.name) + "(" + new String(this.name) + ")\n";
            retStr = retStr + "hash = " + ByteUtility.bytesToHex(this.hash) + "\n";
            retStr = retStr + "moduleLen = " + ByteUtility.bytesToHex(this.moduleLen) + "\n";
            retStr = retStr + "moduleFlags = " + ByteUtility.bytesToHex(this.moduleFlags) + "\n";
            return retStr;
        }
    }

    public class ModuleHeader {
        byte[] structId = new byte[4];
        byte[] structVer = new byte[4];
        byte[] flags = new byte[4];
        byte[] majorVersion = new byte[2];
        byte[] minorVersion = new byte[2];
        byte[] hotfix = new byte[2];
        byte[] build = new byte[2];
        byte[] reserved = new byte[4];
        byte[] size = new byte[4];
        byte[] reserved2 = new byte[20];
        byte[] name = new byte[16];
        byte[] reserved3 = new byte[16];

        public void fromRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.structId, 0, this.structId.length);
            System.arraycopy(raw, index += this.structId.length, this.structVer, 0, this.structVer.length);
            System.arraycopy(raw, index += this.structVer.length, this.flags, 0, this.flags.length);
            System.arraycopy(raw, index += this.flags.length, this.majorVersion, 0, this.majorVersion.length);
            System.arraycopy(raw, index += this.majorVersion.length, this.minorVersion, 0, this.minorVersion.length);
            System.arraycopy(raw, index += this.minorVersion.length, this.hotfix, 0, this.hotfix.length);
            System.arraycopy(raw, index += this.hotfix.length, this.build, 0, this.build.length);
            System.arraycopy(raw, index += this.build.length, this.reserved, 0, this.reserved.length);
            System.arraycopy(raw, index += this.reserved.length, this.size, 0, this.size.length);
            System.arraycopy(raw, index += this.size.length, this.reserved2, 0, this.reserved2.length);
            System.arraycopy(raw, index += this.reserved2.length, this.name, 0, this.name.length);
            System.arraycopy(raw, index += this.name.length, this.reserved3, 0, this.reserved3.length);
            index += this.reserved3.length;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "structId = " + ByteUtility.bytesToHex(this.structId) + "\n";
            retStr = retStr + "structVer = " + ByteUtility.bytesToHex(this.structVer) + "\n";
            retStr = retStr + "flags = " + ByteUtility.bytesToHex(this.flags) + "\n";
            retStr = retStr + "majorVersion = " + ByteUtility.bytesToHex(this.majorVersion) + "\n";
            retStr = retStr + "minorVersion = " + ByteUtility.bytesToHex(this.minorVersion) + "\n";
            retStr = retStr + "hotfix = " + ByteUtility.bytesToHex(this.hotfix) + "\n";
            retStr = retStr + "build = " + ByteUtility.bytesToHex(this.build) + "\n";
            retStr = retStr + "reserved = " + ByteUtility.bytesToHex(this.reserved) + "\n";
            retStr = retStr + "size = " + ByteUtility.bytesToHex(this.size) + "\n";
            retStr = retStr + "reserved2 = " + ByteUtility.bytesToHex(this.reserved2) + "\n";
            retStr = retStr + "name = " + ByteUtility.bytesToHex(this.name) + "(" + new String(this.name) + ")\n";
            retStr = retStr + "reserved3 = " + ByteUtility.bytesToHex(this.reserved3) + "\n";
            return retStr;
        }
    }

    public class MfmHeader {
        byte[] headerType = new byte[4];
        byte[] headerLen = new byte[4];
        byte[] headerVersion = new byte[4];
        byte[] reserved1 = new byte[4];
        byte[] manifestVendor = new byte[4];
        byte[] reserved2 = new byte[4];
        byte[] size = new byte[4];
        byte[] headerID = new byte[4];
        byte[] numModuleEntiries = new byte[4];
        byte[] reserved3 = new byte[92];

        public void fromRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.headerType, 0, this.headerType.length);
            System.arraycopy(raw, index += this.headerType.length, this.headerLen, 0, this.headerLen.length);
            System.arraycopy(raw, index += this.headerLen.length, this.headerVersion, 0, this.headerVersion.length);
            System.arraycopy(raw, index += this.headerVersion.length, this.reserved1, 0, this.reserved1.length);
            System.arraycopy(raw, index += this.reserved1.length, this.manifestVendor, 0, this.manifestVendor.length);
            System.arraycopy(raw, index += this.manifestVendor.length, this.reserved2, 0, this.reserved2.length);
            System.arraycopy(raw, index += this.reserved2.length, this.size, 0, this.size.length);
            System.arraycopy(raw, index += this.size.length, this.headerID, 0, this.headerID.length);
            System.arraycopy(raw, index += this.headerID.length, this.numModuleEntiries, 0, this.numModuleEntiries.length);
            System.arraycopy(raw, index += this.numModuleEntiries.length, this.reserved3, 0, this.reserved3.length);
            index += this.reserved3.length;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "headerType = " + ByteUtility.bytesToHex(this.headerType) + "\n";
            retStr = retStr + "headerLen = " + ByteUtility.bytesToHex(this.headerLen) + "\n";
            retStr = retStr + "headerVersion = " + ByteUtility.bytesToHex(this.headerVersion) + "\n";
            retStr = retStr + "reserved1 = " + ByteUtility.bytesToHex(this.reserved1) + "\n";
            retStr = retStr + "manifestVendor = " + ByteUtility.bytesToHex(this.manifestVendor) + "\n";
            retStr = retStr + "reserved2 = " + ByteUtility.bytesToHex(this.reserved2) + "\n";
            retStr = retStr + "size = " + ByteUtility.bytesToHex(this.size) + "\n";
            retStr = retStr + "headerID = " + ByteUtility.bytesToHex(this.headerID) + "\n";
            retStr = retStr + "numModuleEntiries = " + ByteUtility.bytesToHex(this.numModuleEntiries) + "\n";
            retStr = retStr + "reserved3 = " + ByteUtility.bytesToHex(this.reserved3) + "\n";
            return retStr;
        }
    }
}

