/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.CRC8;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.SessionControllerFactory;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Calendar;

public class IPMINM20Command
extends IPMICommand {
    Progress progress;
    public static final byte[] INTEL_MANUFACTURERS_ID = new byte[]{87, 1, 0};
    public static final byte SMCIPMITOOL_POLICY_ID = 32;
    public static final int SMCIPMITOOL_CORRECTION_TIME = 60000;
    public static final long MANIFEST_HDR = 1312902436L;
    public static final long DEFAULT_VENDOR = 32902L;
    public static final long DEFAULT_HEADER_TYPE = 4L;
    public static final long MANIFEST_VER_1_0 = 65536L;
    public static final long MANIFEST_MODULE_HDR = 1162693924L;
    public static final long MODULE_STRUCT_ID = 1146047780L;
    public static final long MODULE_STRUCT_VER = 0L;
    public static final byte CCODE_SUCCESS = 0;
    public static final byte CCODE_OPERATION_REFUSED = -128;
    public static final byte CCODE_FLASH_ERROR = -127;
    public static final byte CCODE_OPERATION_IN_PROGRESS = -126;
    public static final byte CCODE_INVALID_FIELD = -51;

    public IPMINM20Command(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void NM_1_5_FLASH_CMD____________() {
    }

    public IPMIMessage ouPrepareForUpdateCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouOpenAreaCommand(byte areaType) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{areaType, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-95, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouWriteAreaCommand(byte seq, byte[] areaData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + areaData.length];
        data[0] = seq;
        System.arraycopy(areaData, 0, data, 1, areaData.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-94, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouCloseAreaCommand(byte[] areaSize, byte[] areaChecksum) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[areaSize.length + areaChecksum.length];
        System.arraycopy(areaSize, 0, data, 0, areaSize.length);
        System.arraycopy(areaChecksum, 0, data, areaSize.length, areaChecksum.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-93, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouRegisterUpdateCommand(byte updateType, byte flags) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{updateType, flags};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-92, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouGetStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-90, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ouGetCapabilitiesCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-89, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void dropForceMEResetCommand(byte command) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{command};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-33, data);
        this.ipmiInterface.send(ipmiMessage);
    }

    private void NM_SEL_DEVICE_CMD____________() {
    }

    public IPMIMessage getSELTimeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)40, (byte)72, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void NM_SEL_DEVICE_API____________() {
    }

    public String getSELTime() throws IPMIException {
        IPMIMessage resMessage = this.getSELTimeCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] timeStamp = new byte[4];
                System.arraycopy(resMessage.data, 0, timeStamp, 0, 4);
                String timeString = ByteUtility.fourByteToDateFormat2(timeStamp);
                return timeString;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSELTimeCommand failed");
    }

    private void NM_IPMI_DEVICE_GLOBAL_CMD____________() {
    }

    public IPMIMessage coldResetCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)2, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDeviceIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)1, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSelfTestResultsCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSensorReadingCommand(byte sensor) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{sensor};
        ipmiMessage.setCommandAndData((byte)16, (byte)45, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void NM_IPMI_DEVICE_GLOBAL_API____________() {
    }

    public void coldReset() throws IPMIException {
        IPMIMessage resMessage = this.coldResetCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call coldResetCommand failed");
    }

    public DeviceInfo getDeviceID() throws IPMIException {
        IPMIMessage resMessage = this.getDeviceIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return DeviceInfo.fromRaw(resMessage.data);
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getDeviceIDCommand failed");
    }

    public byte[] getSelfTestResults() throws IPMIException {
        IPMIMessage resMessage = this.getSelfTestResultsCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSelfTestResultsCommand failed");
    }

    public String selfTestResultToString(byte[] result) {
        String reusltString = "";
        String subResultString = "";
        switch (result[0]) {
            case 85: {
                reusltString = "No error";
                break;
            }
            case 86: {
                reusltString = "Self Test function not implemented in this controller";
                break;
            }
            case 87: {
                reusltString = "Corrupted or inaccessible data or devices";
                if ((result[1] & 2) == 2) {
                    subResultString = subResultString + " [Firmware boot error]";
                }
                if ((result[1] & 4) == 4) {
                    subResultString = subResultString + " [SDR repository empty]";
                }
                if ((result[1] & 8) == 8) {
                    subResultString = subResultString + " [PIA access error]";
                }
                if ((result[1] & 0x10) == 16) {
                    subResultString = subResultString + " [SEL access error]";
                }
                if ((result[1] & 0x20) == 32) {
                    subResultString = subResultString + " [FRU access error]";
                }
                if ((result[1] & 0x40) == 64) {
                    subResultString = subResultString + " [SDR access error]";
                }
                if ((result[1] & 0x80) != 128) break;
                subResultString = subResultString + " [Factory Presets checksum error]";
                break;
            }
            case 88: {
                reusltString = "Fatal hardware error";
                break;
            }
            case -128: {
                reusltString = "PSU Monitoring service error";
                subResultString = subResultString + " [Error bit " + ByteUtility.byteToHex(result[1]) + "]";
                break;
            }
            case -127: {
                reusltString = "Firmware entered Recovery boot-loader mode";
                if (result[1] == 0) {
                    subResultString = subResultString + " [Recovery entered due to recovery jumper being asseted]";
                }
                if (result[1] == 1) {
                    subResultString = subResultString + " [Recovery entered due to Security strap override jumper being asseted]";
                }
                if (result[1] == 2) {
                    subResultString = subResultString + " [Recovery entered by IPMI command \"Force ME Recovery\"]";
                }
                if (result[1] == 3) {
                    subResultString = subResultString + " [Invalid flash configuration]";
                }
                if (result[1] != 4) break;
                subResultString = subResultString + " [ME internal error. ME could not start operational mode]";
                break;
            }
            case -126: {
                reusltString = "HSC Monitoring service error";
                subResultString = subResultString + "[Error bit " + ByteUtility.byteToHex(result[1]) + "]";
                break;
            }
            default: {
                reusltString = "Unknown error";
            }
        }
        return reusltString + subResultString + " ( " + ByteUtility.bytesToHex(result) + ")";
    }

    public byte getSensorReading(byte sensor) throws IPMIException {
        IPMIMessage resMessage = this.getSensorReadingCommand(sensor);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSensorReading(04 2d **) failed");
    }

    private void NM_IPMI_OEM_DEVICE_CMD____________() {
    }

    public IPMIMessage setMEPowerStateCommand(byte flag) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = flag;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-36, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage forceMERecoveryCommand(byte flag) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = flag;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-33, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void NM_IPMI_OEM_DEVICE_API____________() {
    }

    public void setMEPowerState(byte flag) throws IPMIException {
        IPMIMessage resMessage = this.setMEPowerStateCommand(flag);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setMEPowerStateCommand failed");
    }

    public void enterToUpdateMode() throws IPMIException {
        IPMIMessage resMessage = this.forceMERecoveryCommand((byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call forceMERecoveryCommand failed");
    }

    public void resetToDefault() throws IPMIException {
        IPMIMessage resMessage = this.forceMERecoveryCommand((byte)2);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call forceMERecoveryCommand failed");
    }

    private void NM_IPMI_OEM_IMAGE_INVENTORY_CMD____________() {
    }

    public IPMIMessage getImageInventoryCommand(byte imageID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = imageID;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-88, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void NM_IPMI_OEM_IMAGE_INVENTORY_API____________() {
    }

    public ImageInventory getImageInventory(byte imageID) throws IPMIException {
        IPMIMessage resMessage = this.getImageInventoryCommand(imageID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                ImageInventory i = new ImageInventory();
                i.fromRaw(resMessage.data);
                return i;
            }
            if ((resMessage.completionCode & 0xFF) == 128) {
                ImageInventory i = new ImageInventory();
                i.isCreateFail = true;
                i.setFailString("Operation refused (too many requests)");
                return i;
            }
            if ((resMessage.completionCode & 0xFF) == 129) {
                ImageInventory i = new ImageInventory();
                i.isCreateFail = true;
                i.setFailString("Flash error)");
                return i;
            }
            if ((resMessage.completionCode & 0xFF) == 130) {
                ImageInventory i = new ImageInventory();
                i.isCreateFail = true;
                i.setFailString("Operation in progress (flash erase)");
                return i;
            }
            if ((resMessage.completionCode & 0xFF) == 131) {
                ImageInventory i = new ImageInventory();
                i.isCreateFail = true;
                i.setFailString("Operation not supported for specific Image ID");
                return i;
            }
            if ((resMessage.completionCode & 0xFF) == 132) {
                ImageInventory i = new ImageInventory();
                i.isCreateFail = true;
                i.setFailString("Area not present");
                return i;
            }
            if ((resMessage.completionCode & 0xFF) == 201) {
                ImageInventory i = new ImageInventory();
                i.isCreateFail = true;
                i.setFailString("Parameter out of range. Image ID out of range");
                return i;
            }
            ImageInventory i = new ImageInventory();
            i.isCreateFail = true;
            i.setFailString("Unknown error");
            return i;
        }
        throw new IPMIException("Call getImageInventoryCommand failed");
    }

    private void OEM_FOR_ME_CMD____________() {
    }

    public IPMIMessage oemGetReadingCommand(byte type) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{type, 0, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-30, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void OEM_FOR_ME_API____________() {
    }

    public int oemGetPowerConsumption() throws IPMIException {
        IPMIMessage resMessage = this.oemGetReadingCommand((byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] value = new byte[]{resMessage.data[1], resMessage.data[2]};
                return ByteUtility.twoBytesToInt(value);
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call oemGetReadingCommand failed");
    }

    public int oemGetInletTemperature() throws IPMIException {
        IPMIMessage resMessage = this.oemGetReadingCommand((byte)16);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] value = new byte[]{resMessage.data[1], resMessage.data[2]};
                return ByteUtility.twoBytesToInt(value);
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call oemGetReadingCommand failed");
    }

    private void NM_POLICY_IPMI_CMD____________() {
    }

    public IPMIMessage enableDisableNodeManagerPolicyControlCommand(byte flag, byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = flag;
        data[4] = domainId;
        data[5] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-64, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeManagerPolicyCommand(byte domainId, byte policyId, byte policyConfig, byte policyException, byte[] powerLimit, byte[] correcctionTimeLimit, byte[] policyTriggerLimit, byte[] statisticsPeriod) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[17];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        data[5] = policyConfig;
        data[6] = policyException;
        data[7] = powerLimit[0];
        data[8] = powerLimit[1];
        data[9] = correcctionTimeLimit[0];
        data[10] = correcctionTimeLimit[1];
        data[11] = correcctionTimeLimit[2];
        data[12] = correcctionTimeLimit[3];
        data[13] = policyTriggerLimit[0];
        data[14] = policyTriggerLimit[1];
        data[15] = statisticsPeriod[0];
        data[16] = statisticsPeriod[1];
        ipmiMessage.setCommandAndData((byte)-72, (byte)-63, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerPolicyCommand(byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-62, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeManagerAlertThresholdsCommand(byte domainId, byte policyId, byte numberOfAlertThresholds, byte[] alertThresholdArray) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6 + alertThresholdArray.length];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        data[5] = numberOfAlertThresholds;
        System.arraycopy(alertThresholdArray, 0, data, 6, alertThresholdArray.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)-61, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerAlertThresholdsCommand(byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-60, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeManagerPolicySuspendPeriodsCommand(byte domainId, byte policyId, byte numberOfPolicySuspendPeriods, byte[] policySuspendPeriodsArray) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6 + policySuspendPeriodsArray.length];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        data[5] = numberOfPolicySuspendPeriods;
        System.arraycopy(policySuspendPeriodsArray, 0, data, 6, policySuspendPeriodsArray.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)-59, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerPolicySuspendPeriodsCommand(byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-58, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage resetNodeManagerStatisticsCommand(byte mode, byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = mode;
        data[4] = domainId;
        data[5] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-57, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerStatisticsCommand(byte mode, byte domainId, byte policyId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = mode;
        data[4] = domainId;
        data[5] = policyId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-56, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerCapabilitiesCommand(byte domainId, byte policyType) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = policyType;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerVersionCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)-54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeManagerPowerDrawRangeCommand(byte domainId, byte[] minPowerDraw, byte[] maxPowerDraw) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[8];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = minPowerDraw[0];
        data[5] = minPowerDraw[1];
        data[6] = maxPowerDraw[0];
        data[7] = maxPowerDraw[1];
        ipmiMessage.setCommandAndData((byte)-72, (byte)-53, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeManagerAlertDestinationCommand(byte channelNumber, byte destionationInfo, byte alertStringSelector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = channelNumber;
        data[4] = destionationInfo;
        data[5] = alertStringSelector;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeManagerAlertDestinationCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)-49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void NM_CONTROL_IPMI_CMD____________() {
    }

    public IPMIMessage setTotalPowerBudgetRequestCommand(byte domainId, byte[] budget) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = budget[0];
        data[5] = budget[1];
        ipmiMessage.setCommandAndData((byte)-72, (byte)-48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getTotalPowerBudgetRequestCommand(byte domainId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-47, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setMaxAllowedCPU_P_T_StateCommand(byte domainId, byte pState, byte tState) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        data[4] = pState;
        data[5] = tState;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-46, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setMaxAllowedCPUCoresStateCommand(byte domainId, byte[] cores) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = (byte)(domainId | 0x10);
        data[4] = cores[0];
        data[5] = cores[1];
        ipmiMessage.setCommandAndData((byte)-72, (byte)-46, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMaxAllowedCPU_P_T_StateCommand(byte domainId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-45, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMaxAllowedCPUCoresCommand(byte domainId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = (byte)(domainId | 0x10);
        ipmiMessage.setCommandAndData((byte)-72, (byte)-45, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNumberOf_P_T_StateRequestCommand(byte domainId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-44, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setHostCPUDataCommand() {
        return null;
    }

    public IPMIMessage setPSUConfigurationRequestCommand() {
        return null;
    }

    public IPMIMessage getPSUConfigurationRequestCommand() {
        return null;
    }

    public IPMIMessage sendRawPMBUSCommand() {
        return null;
    }

    public IPMIMessage getHostCPUDataCommand(byte domainId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = domainId;
        ipmiMessage.setCommandAndData((byte)-72, (byte)-22, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void NM_DCMI_IPMI_CMD____________() {
    }

    public IPMIMessage getDCMICapabilityInfoCommand() {
        return null;
    }

    public IPMIMessage getPowerReadingCommand() {
        return null;
    }

    public IPMIMessage getPowerLimitCommand() {
        return null;
    }

    public IPMIMessage setPowerLimitCommand() {
        return null;
    }

    public IPMIMessage activateOrDeactivatePowerLimitCommand() {
        return null;
    }

    private void NM30_CUPS_IPMI_CMD____________() {
    }

    public IPMIMessage getCUPSCapabilitiesCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)100, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCUPSDataCommand(byte param) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = param;
        ipmiMessage.setCommandAndData((byte)-72, (byte)101, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setCUPSConfigCommand(byte enableCUPS, byte loadFactorMask, byte setLoadFactor, byte[] coreLoadFactor, byte[] memLoadFactor, byte[] ioLoadFactor) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[12];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = enableCUPS;
        data[4] = loadFactorMask;
        data[5] = setLoadFactor;
        data[6] = coreLoadFactor[0];
        data[7] = coreLoadFactor[1];
        data[8] = memLoadFactor[0];
        data[9] = memLoadFactor[1];
        data[10] = ioLoadFactor[0];
        data[11] = ioLoadFactor[1];
        ipmiMessage.setCommandAndData((byte)-72, (byte)102, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCUPSConfigCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)103, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setCUPSPolicyCommand(byte policyID, byte targetID, byte policyStatus, byte PolicyType, byte policyActions, byte CUPSThreshold, byte[] avgWindow) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[11];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = 0;
        data[4] = (byte)(targetID << 4 | policyID);
        data[5] = policyStatus;
        data[6] = PolicyType;
        data[7] = policyActions;
        data[8] = CUPSThreshold;
        data[9] = avgWindow[0];
        data[10] = avgWindow[1];
        ipmiMessage.setCommandAndData((byte)-72, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCUPSPolicyCommand(byte policyID, byte targetID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = 0;
        data[4] = (byte)(targetID << 4 | policyID);
        ipmiMessage.setCommandAndData((byte)-72, (byte)105, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void FLASH_API____________() {
    }

    public void ouPrepareForUpdate() throws IPMIException {
        IPMIMessage resMessage = this.ouPrepareForUpdateCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call OUPrepareForUpdateCommand failed");
    }

    public void ouOpenArea(byte areaType) throws IPMIException {
        IPMIMessage resMessage = this.ouOpenAreaCommand(areaType);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call OUOpenAreaCommand failed");
    }

    public void ouOpenOperationCodeArea() throws IPMIException {
        this.ouOpenArea((byte)1);
    }

    public void ouWriteArea(byte seq, byte[] areaData) throws IPMIException {
        IPMIMessage resMessage = this.ouWriteAreaCommand(seq, areaData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call OUWriteAreaCommand failed");
    }

    public void ouCloseArea(byte[] areaSize, byte[] areaChecksum) throws IPMIException {
        IPMIMessage resMessage = this.ouCloseAreaCommand(areaSize, areaChecksum);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call OUCloseAreaCommand failed");
    }

    public void ouRegisterUpdate(byte updateType, byte flags) throws IPMIException {
        IPMIMessage resMessage = this.ouRegisterUpdateCommand(updateType, flags);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call OURegisterUpdateCommand failed");
    }

    public void ouRegisterNormalUpdate() throws IPMIException {
        this.ouRegisterUpdate((byte)1, (byte)0);
    }

    public void ouRegisterManualRollbackUpdate() throws IPMIException {
        this.ouRegisterUpdate((byte)3, (byte)0);
    }

    public void ouRegisterAbortUpdate() throws IPMIException {
        this.ouRegisterUpdate((byte)4, (byte)0);
    }

    public OUStatus ouGetStatus() throws IPMIException {
        IPMIMessage resMessage = this.ouGetStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                OUStatus ouStatus = new OUStatus();
                ouStatus.imageStatus = resMessage.data[0];
                ouStatus.updateSatatus = resMessage.data[1];
                ouStatus.updateAttemptStatus = resMessage.data[2];
                ouStatus.rollbackAttemptStatus = resMessage.data[3];
                ouStatus.updateType = resMessage.data[4];
                ouStatus.dependentFlags = resMessage.data[5];
                System.arraycopy(resMessage.data, 6, ouStatus.freeAreaSize, 0, 3);
                return ouStatus;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call ouGetStatusCommand failed");
    }

    public OUCapabilities ouGetCapabilities() throws IPMIException {
        IPMIMessage resMessage = this.ouGetCapabilitiesCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                OUCapabilities outCapabilities = new OUCapabilities();
                outCapabilities.areasSupported = resMessage.data[0];
                outCapabilities.specialCapabilities = resMessage.data[1];
                return outCapabilities;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call ouGetCapabilitiesCommand failed");
    }

    public void dropForceMEReset(byte command) throws IPMIException {
        this.dropForceMEResetCommand(command);
    }

    public void dropForceMEResetToRecoveryMode() throws IPMIException {
        this.dropForceMEResetCommand((byte)1);
    }

    private void NM_POLICY_IPMI_API____________() {
    }

    public NodeManagerVersion getNodeManagerVersion() throws IPMIException {
        IPMIMessage resMessage = this.getNodeManagerVersionCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeManagerVersion nodeManagerVersion = new NodeManagerVersion();
                nodeManagerVersion.fromRaw(resMessage.data);
                return nodeManagerVersion;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeManagerVersionCommand failed");
    }

    public NodeManagerStatistics getNodeManagerStatistics(byte mode, byte domainId, byte policyId) throws IPMIException {
        IPMIMessage resMessage = this.getNodeManagerStatisticsCommand(mode, domainId, policyId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeManagerStatistics statistics = new NodeManagerStatistics();
                statistics.fromRaw(resMessage.data);
                return statistics;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException(resMessage, "Invalid Policy Id");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            if (resMessage.completionCode == -120) {
                throw new IPMIException(resMessage, "Invalid mode");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeManagerStatisticsCommand failed");
    }

    public void resetNodeManagerStatistics(byte mode, byte domainId, byte policyId) throws IPMIException {
        IPMIMessage resMessage = this.resetNodeManagerStatisticsCommand(mode, domainId, policyId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException(resMessage, "Invalid Policy Id");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            if (resMessage.completionCode == -120) {
                throw new IPMIException(resMessage, "Invalid mode");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call resetNodeManagerStatisticsCommand failed");
    }

    public void enableDisableNodeManagerPolicyControl(byte flag, byte domainId, byte policyId) throws IPMIException {
        IPMIMessage resMessage = this.enableDisableNodeManagerPolicyControlCommand(flag, domainId, policyId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException(resMessage, "Invalid Policy Id");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call enableDisableNodeManagerPolicyControlCommand failed");
    }

    public NodeManagerCapabilities getNodeManagerCapabilities(byte domainId, byte policyType) throws IPMIException {
        IPMIMessage resMessage = this.getNodeManagerCapabilitiesCommand(domainId, policyType);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeManagerCapabilities cap = new NodeManagerCapabilities();
                cap.fromRaw(resMessage.data);
                return cap;
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Domain ID Invalid");
            }
            if (resMessage.completionCode == -126) {
                throw new IPMIException(resMessage, "unknown Policy Trigger Type");
            }
            if (resMessage.completionCode == -125) {
                throw new IPMIException(resMessage, "unknown Policy Type");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeManagerCapabilitiesCommand failed");
    }

    public void setNodeManagerPolicy(NodeManagerPolicySetting policy) throws IPMIException {
        IPMIMessage resMessage = this.setNodeManagerPolicyCommand(policy.domainID, policy.policyID, policy.policyConfig, policy.PolicyException, policy.powerLimit, policy.correctionTimeLimit, policy.policyTriggerLimit, policy.statisticsReportingPeriod);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException(resMessage, "Invalid Policy Id");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            if (resMessage.completionCode == -126) {
                throw new IPMIException(resMessage, "unknown or unsupported Policy Trigger type");
            }
            if (resMessage.completionCode == -125) {
                throw new IPMIException(resMessage, "unknown or unsupported Policy Configuration Action");
            }
            if (resMessage.completionCode == -124) {
                throw new IPMIException(resMessage, "Power limit out of range");
            }
            if (resMessage.completionCode == -123) {
                throw new IPMIException(resMessage, "Correction Time out of range");
            }
            if (resMessage.completionCode == -122) {
                throw new IPMIException(resMessage, "Policy Trigger value out of range");
            }
            if (resMessage.completionCode == -119) {
                throw new IPMIException(resMessage, "Statistics Reporting Period out of range");
            }
            if (resMessage.completionCode == -117) {
                throw new IPMIException(resMessage, "Invalid value of Aggressive CPU Power Correction field");
            }
            if (resMessage.completionCode == -44) {
                throw new IPMIException(resMessage, "Insufficient privilege level due wrong responder LUN");
            }
            if (resMessage.completionCode == -43) {
                throw new IPMIException(resMessage, "Policy could not be updated since PolicyId already exists and is enabled");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setNodeManagerPolicyCommand failed");
    }

    public NodeManagerPolicy getNodeManagerPolicy(byte domainId, byte policyId) throws IPMIException {
        IPMIMessage resMessage = this.getNodeManagerPolicyCommand(domainId, policyId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeManagerPolicy policy = new NodeManagerPolicy();
                policy.fromRaw(resMessage.data);
                return policy;
            }
            if (resMessage.completionCode == -128) {
                byte nextID = resMessage.data[3];
                byte available = resMessage.data[4];
                throw new IPMIException(resMessage, "Invalid Policy Id (Next Valid Policy ID = " + nextID + "),Number of Policies = " + available);
            }
            if (resMessage.completionCode == -127) {
                byte nextID = resMessage.data[3];
                byte available = resMessage.data[4];
                throw new IPMIException(resMessage, "Invalid Domain Id (Next Valid Domain ID = " + nextID + "),Number of available domains = " + available);
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeManagerPolicyCommand failed");
    }

    private void NM_CONTROL_IPMI_API____________() {
    }

    public void setTotalPowerBudgetRequest(byte domainId, int totalPower) throws IPMIException {
        byte[] totalPowerBytes = new byte[2];
        ByteUtility.intTo2Bytes(totalPowerBytes, 0, totalPower);
        IPMIMessage resMessage = this.setTotalPowerBudgetRequestCommand(domainId, totalPowerBytes);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -124) {
                throw new IPMIException(resMessage, "Power Budget out of range");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setTotalPowerBudgetRequestCommand failed");
    }

    public int getTotalPowerBudgetRequest(byte domainId) throws IPMIException {
        IPMIMessage resMessage = this.getTotalPowerBudgetRequestCommand(domainId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] values = new byte[]{resMessage.data[3], resMessage.data[4]};
                int totalPower = ByteUtility.twoBytesToInt(values);
                return totalPower;
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getTotalPowerBudgetRequestCommand failed");
    }

    public void setMaxAllowedCPU_P_T_State(byte domainId, byte pState, byte tState) throws IPMIException {
        IPMIMessage resMessage = this.setMaxAllowedCPU_P_T_StateCommand(domainId, pState, tState);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -118) {
                throw new IPMIException(resMessage, "P-State or T-State out of range");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setMaxAllowedCPU_P_T_StateCommand failed");
    }

    public void setMaxAllowedCPUCores(byte domainId, int cores) throws IPMIException {
        byte[] coresBytes = new byte[2];
        ByteUtility.intTo2Bytes(coresBytes, 0, cores);
        IPMIMessage resMessage = this.setMaxAllowedCPUCoresStateCommand(domainId, coresBytes);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -118) {
                throw new IPMIException(resMessage, "P-State,T-State or value out of range");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setMaxAllowedCPUCoresStateCommand failed");
    }

    public byte[] getMaxAllowedCPU_P_T_State(byte domainId) throws IPMIException {
        IPMIMessage resMessage = this.getMaxAllowedCPU_P_T_StateCommand(domainId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] state = new byte[]{resMessage.data[3], resMessage.data[4]};
                return state;
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getMaxAllowedCPU_P_T_StateCommand failed");
    }

    public int getMaxAllowedCPUCores(byte domainId) throws IPMIException {
        IPMIMessage resMessage = this.getMaxAllowedCPUCoresCommand(domainId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] state = new byte[]{resMessage.data[3], resMessage.data[4]};
                int cores = ByteUtility.twoBytesToInt(state);
                return cores;
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getMaxAllowedCPU_P_T_StateCommand failed");
    }

    public byte[] getNumberOf_P_T_StateRequest(byte domainId) throws IPMIException {
        IPMIMessage resMessage = this.getNumberOf_P_T_StateRequestCommand(domainId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] state = new byte[]{resMessage.data[3], resMessage.data[4]};
                return state;
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNumberOf_P_T_StateRequestCommand failed");
    }

    public byte[] getNumberOfCPUCoresRequest(byte domainId) throws IPMIException {
        IPMIMessage resMessage = this.getNumberOf_P_T_StateRequestCommand(domainId = (byte)(domainId | 0x10));
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] state = new byte[]{resMessage.data[3], resMessage.data[4]};
                return state;
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNumberOf_P_T_StateRequestCommand failed");
    }

    public NodeManagerAlertDestination getNodeManagerAlertDestination() throws IPMIException {
        IPMIMessage resMessage = this.getNodeManagerAlertDestinationCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeManagerAlertDestination dest = new NodeManagerAlertDestination();
                dest.fromRaw(resMessage.data);
                return dest;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeManagerAlertDestinationCommand failed");
    }

    public void setNodeManagerAlertDestination(NodeManagerAlertDestination dest) throws IPMIException {
        IPMIMessage resMessage = this.setNodeManagerAlertDestinationCommand(dest.channelNumber, dest.destinationSelector, dest.alertStringSelector);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setNodeManagerAlertDestinationCommand failed");
    }

    public NodeManagerPolicySetting createNodeManagerPolicySetting() {
        return new NodeManagerPolicySetting();
    }

    public NodeManagerAlertDestination createNodeManagerAlertDestination() {
        return new NodeManagerAlertDestination();
    }

    public HostCpuData getHostCPUData(byte domainId) throws IPMIException {
        IPMIMessage resMessage = this.getHostCPUDataCommand(domainId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                HostCpuData cpuData = new HostCpuData();
                cpuData.fromRaw(resMessage.data);
                return cpuData;
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Invalid Domain Id");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getHostCPUDataCommand failed");
    }

    private void NM30_CUPS_IPMI_API____________() {
    }

    public CUPSCapabilities getCUPSCapabilities() throws IPMIException {
        IPMIMessage resMessage = this.getCUPSCapabilitiesCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                CUPSCapabilities cupsCapabilities = new CUPSCapabilities();
                cupsCapabilities.fromRaw(resMessage.data);
                return cupsCapabilities;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeManagerVersionCommand failed");
    }

    public CUPSData getCUPSData(byte parameter) throws IPMIException {
        IPMIMessage resMessage = this.getCUPSDataCommand(parameter);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                CUPSData cupsData = new CUPSData();
                cupsData.setParameter(parameter);
                cupsData.fromRaw(resMessage.data);
                return cupsData;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException(resMessage, "Internal error");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Hardware resources not available");
            }
            if (resMessage.completionCode == -126) {
                throw new IPMIException(resMessage, "Not initialized");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getCUPSDataCommand failed");
    }

    public CUPSConfiguration getCUPSConfig() throws IPMIException {
        IPMIMessage resMessage = this.getCUPSConfigCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                CUPSConfiguration cupsConfiguration = new CUPSConfiguration();
                cupsConfiguration.fromRaw(resMessage.data);
                return cupsConfiguration;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException(resMessage, "Internal error");
            }
            if (resMessage.completionCode == -127) {
                throw new IPMIException(resMessage, "Hardware resources not available");
            }
            if (resMessage.completionCode == -126) {
                throw new IPMIException(resMessage, "Not initialized");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getCUPSConfigCommand failed");
    }

    public CUPSPolicy getCUPSPolicy(byte policyID, byte targetID) throws IPMIException {
        IPMIMessage resMessage = this.getCUPSPolicyCommand(policyID, targetID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                CUPSPolicy cupsPolicy = new CUPSPolicy();
                cupsPolicy.setPolicyID((byte)(targetID << 4 | policyID));
                cupsPolicy.fromRaw(resMessage.data);
                return cupsPolicy;
            }
            if (resMessage.completionCode == -128) {
                throw new IPMIException(resMessage, "Policy ID Invalid");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getCUPSPolicyCommand failed");
    }

    public byte[] getCoreCUPSSensor() throws IPMIException {
        IPMIMessage resMessage = this.getSensorReadingCommand((byte)-66);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSensorReadingCommand failed");
    }

    public byte[] getIOCUPSSensor() throws IPMIException {
        IPMIMessage resMessage = this.getSensorReadingCommand((byte)-65);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSensorReadingCommand failed");
    }

    public byte[] getMemoryCUPSSensor() throws IPMIException {
        IPMIMessage resMessage = this.getSensorReadingCommand((byte)-64);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSensorReadingCommand failed");
    }

    public byte[] getBMCFanSpeed() throws IPMIException {
        IPMIMessage resMessage = this.getSensorReadingCommand((byte)-62);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSensorReadingCommand failed");
    }

    private void NM_PECI_PROXY_CMD____________() {
    }

    public IPMIMessage getCPUandMemoryTemperatureCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[12];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        data[3] = 15;
        data[4] = -1;
        data[5] = -1;
        data[6] = -1;
        data[7] = -1;
        data[8] = -1;
        data[9] = -1;
        data[10] = -1;
        data[11] = -1;
        ipmiMessage.setCommandAndData((byte)-72, (byte)75, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage sendRawPECICommand(byte[] rawPECI) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + rawPECI.length];
        System.arraycopy(INTEL_MANUFACTURERS_ID, 0, data, 0, INTEL_MANUFACTURERS_ID.length);
        System.arraycopy(rawPECI, 0, data, 3, rawPECI.length);
        ipmiMessage.setCommandAndData((byte)-72, (byte)64, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void NM_PECI_PROXY_API____________() {
    }

    public CpuMemoryTemperature getCPUandMemoryTemperature() throws IPMIException {
        IPMIMessage resMessage = this.getCPUandMemoryTemperatureCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                CpuMemoryTemperature temp = new CpuMemoryTemperature();
                temp.fromRaw(resMessage.data);
                return temp;
            }
            if (resMessage.completionCode == -95) {
                throw new IPMIException("Wrong CPU number");
            }
            if (resMessage.completionCode == -43) {
                throw new IPMIException("Platform not in S0/S1 state");
            }
            if (resMessage.completionCode == -1) {
                throw new IPMIException("Other error encountered");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getCPUandMemoryTemperatureCommand failed");
    }

    public byte[] sendRawPECI(byte[] rawPECI) throws IPMIException {
        IPMIMessage resMessage = this.sendRawPECICommand(rawPECI);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call sendRawPECICommand failed");
    }

    private void FW_HEADER____________() {
    }

    private void ENTITY____________() {
    }

    public FirmwareFile createFirmwareFile(String filename) {
        return new FirmwareFile(filename);
    }

    public void test() throws Exception {
        FirmwareFile firmwareFile = new FirmwareFile("c:\\SPSOperational.bin");
        firmwareFile.getAllHeader();
        NodeManagerVersion nodeManagerVersion = this.getNodeManagerVersion();
        System.out.println(nodeManagerVersion.toString());
    }

    private void FUNC____________() {
    }

    private void setValue(int value) {
        if (this.progress != null) {
            this.progress.setValue(value);
        }
    }

    private void message(String message) {
        if (this.progress != null) {
            this.progress.message(message);
        }
    }

    private void left(long value) {
        if (this.progress != null) {
            this.progress.left(value);
        }
    }

    public void flashFlow(String filename) throws Exception {
        int totalTimeSpentCount;
        int totalTimeSpentCountBak = totalTimeSpentCount = 5;
        long[] timeSpent = new long[totalTimeSpentCount];
        long avgTimeSpent = 0L;
        FirmwareFile firmwareFile = null;
        int chunkSize = 16;
        int upgradedBytes = 0;
        byte writeSeq = 0;
        firmwareFile = new FirmwareFile(filename);
        RandomAccessFile raf = new RandomAccessFile(firmwareFile.firmware, "r");
        firmwareFile.getAllHeader();
        this.message("Firmware File verified");
        this.printVersion(firmwareFile);
        this.message("Entering Recovery mode");
        this.dropForceMEResetToRecoveryMode();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        OUStatus status = this.ouGetStatus();
        this.ouPrepareForUpdate();
        status = this.ouGetStatus();
        this.ouOpenArea((byte)1);
        status = this.ouGetStatus();
        this.message("Flashing started");
        while ((long)upgradedBytes < firmwareFile.fileSize()) {
            Calendar chuckStartTime = Calendar.getInstance();
            byte[] buffer = new byte[chunkSize];
            raf.seek(upgradedBytes);
            raf.read(buffer);
            this.ouWriteArea(writeSeq, buffer);
            this.setValue((int)((long)(upgradedBytes * 100) / firmwareFile.fileSize()));
            upgradedBytes += chunkSize;
            writeSeq = (byte)(writeSeq + 1);
            Calendar chuckEndTime = Calendar.getInstance();
            long leftTime = 0L;
            if (--totalTimeSpentCount >= 0) {
                timeSpent[totalTimeSpentCount] = chuckEndTime.getTime().getTime() - chuckStartTime.getTime().getTime();
                if (totalTimeSpentCount != 0) continue;
                for (int i = 0; i < totalTimeSpentCountBak; ++i) {
                    avgTimeSpent += timeSpent[i];
                }
                avgTimeSpent /= (long)totalTimeSpentCountBak;
                continue;
            }
            long leftChunks = (firmwareFile.fileSize() - (long)upgradedBytes) / (long)chunkSize;
            leftTime = avgTimeSpent * leftChunks;
            if (this.progress == null) continue;
            this.progress.left(leftTime);
        }
        raf.close();
        byte[] fileSize = new byte[4];
        ByteUtility.intTo4Bytes(fileSize, 0, (int)firmwareFile.fileSize());
        byte[] byte56 = new byte[2];
        byte56[0] = firmwareFile.getCRC8();
        this.ouCloseArea(fileSize, byte56);
        status = this.ouGetStatus();
        this.ouRegisterNormalUpdate();
        status = this.ouGetStatus();
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiInterface);
        ipmiGlobalCommand.coldReset();
        this.message("Done");
    }

    public void printVersion(FirmwareFile firmwareFile) throws IPMIException {
        NodeManagerVersion nodeManagerVersion = null;
        try {
            nodeManagerVersion = this.getNodeManagerVersion();
            this.message("ME Version : " + nodeManagerVersion.majorFirmwareRevision + "." + ByteUtility.byteToHex(nodeManagerVersion.minorFirmwareRevision));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.message("Image File Version : " + firmwareFile.moduleEntryTypes[0].majorVersion[0] + "." + ByteUtility.byteToHex((byte)((firmwareFile.moduleEntryTypes[0].minorVersion[0] << 4) + firmwareFile.moduleEntryTypes[0].hotfix[0])) + " Build: " + ByteUtility.byteToHex(firmwareFile.moduleEntryTypes[0].build[1]) + ByteUtility.byteToHex(firmwareFile.moduleEntryTypes[0].build[0]));
    }

    public void printVersionTest(FirmwareFile firmwareFile) throws IPMIException {
        NodeManagerVersion nodeManagerVersion = null;
        try {
            nodeManagerVersion = this.getNodeManagerVersion();
            System.out.println("ME version : " + nodeManagerVersion.majorFirmwareRevision + "." + nodeManagerVersion.minorFirmwareRevision);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Image version : " + firmwareFile.moduleEntryTypes[0].majorVersion[0] + "." + firmwareFile.moduleEntryTypes[0].hotfix[0]);
        System.out.println(ByteUtility.bytesToHex(firmwareFile.mfmHeader.headerVersion));
        System.out.println(ByteUtility.bytesToHex(firmwareFile.moduleHeader.majorVersion));
        System.out.println(ByteUtility.bytesToHex(firmwareFile.moduleHeader.minorVersion));
    }

    public Progress getProgress() {
        return this.progress;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    private void MAIN____________() {
    }

    public static void main_nm20_dev(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.133.176.123");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMINM20Command ipmiNM20Command = new IPMINM20Command(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiNM20Command);
        if (sessionController == null) {
            return;
        }
        IPMIInterface rmcp = ipmiNM20Command.getIPMIInterface();
        ipmiSDRCommand.setIPMIInterface(ipmiNM20Command.getIPMIInterface());
        IPMB ipmb = new IPMB(ipmiNM20Command.getIPMIInterface());
        ipmiNM20Command.setIPMIInterface(ipmb);
        ipmiGlobalCommand.setIPMIInterface(ipmb);
        ipmb.setAddress((byte)44);
        ipmb.setChannel((byte)0);
        try {
            IPMINM20Command ipmiNM20CommandRaw = new IPMINM20Command(rmcp);
            System.out.println(ipmiNM20CommandRaw.oemGetPowerConsumption() + " watts");
            System.out.println("NM SDR ==================");
            SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
            System.out.println(nmOEMSDR.toString());
            System.out.println("Get Device ID (Orignal)==================");
            DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
            System.out.println(deviceInfo.toString());
            System.out.println("Get SEL TIME ==================");
            System.out.println("Get Device ID (NM Ver) ==================");
            DeviceInfo deviceID = ipmiNM20Command.getDeviceID();
            System.out.println(deviceID.toNM20ReadableString());
            System.out.println("Get Self Test ==================");
            byte[] result = ipmiNM20Command.getSelfTestResults();
            System.out.println(ipmiNM20Command.selfTestResultToString(result));
            System.out.println("Get Image Inventory ==================");
            ImageInventory i = ipmiNM20Command.getImageInventory((byte)0);
            System.out.println("Recvoery Image:");
            System.out.println(i.toString());
            i = ipmiNM20Command.getImageInventory((byte)1);
            System.out.println("1st opertational Image:");
            System.out.println(i.toString());
            i = ipmiNM20Command.getImageInventory((byte)2);
            System.out.println("2nd opertational Image:");
            System.out.println(i.toString());
            System.out.println(ipmiNM20Command.getCPUandMemoryTemperature().toString());
            System.out.println(ipmiNM20Command.getHostCPUData((byte)0).toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        boolean b = sessionController.closeSession();
    }

    public static void main_nm30_cups(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.133.176.123");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMINM20Command ipmiNM20Command = new IPMINM20Command(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiNM20Command);
        if (sessionController == null) {
            return;
        }
        IPMIInterface rmcp = ipmiNM20Command.getIPMIInterface();
        ipmiSDRCommand.setIPMIInterface(ipmiNM20Command.getIPMIInterface());
        IPMB ipmb = new IPMB(ipmiNM20Command.getIPMIInterface());
        ipmiNM20Command.setIPMIInterface(ipmb);
        ipmiGlobalCommand.setIPMIInterface(ipmb);
        ipmb.setAddress((byte)44);
        ipmb.setChannel((byte)0);
        try {
            System.out.println(ipmiNM20Command.getCUPSCapabilities().toString());
            System.out.println(ipmiNM20Command.getCUPSData((byte)1).toString());
            System.out.println(ipmiNM20Command.getCUPSData((byte)2).toString());
            System.out.println(ipmiNM20Command.getCUPSData((byte)3).toString());
            System.out.println(ipmiNM20Command.getCUPSData((byte)4).toString());
            System.out.println(ipmiNM20Command.getCUPSConfig().toString());
            System.out.println(ipmiNM20Command.getCUPSPolicy((byte)1, (byte)0).toString());
            System.out.println(ipmiNM20Command.getCUPSPolicy((byte)2, (byte)0).toString());
            System.out.println(ipmiNM20Command.getCUPSPolicy((byte)4, (byte)0).toString());
            System.out.println(ipmiNM20Command.getCUPSPolicy((byte)1, (byte)1).toString());
            System.out.println(ipmiNM20Command.getCUPSPolicy((byte)2, (byte)1).toString());
            System.out.println(ipmiNM20Command.getCUPSPolicy((byte)4, (byte)1).toString());
            System.out.println("Core CUPS     : " + ByteUtility.bytesToHex(ipmiNM20Command.getCoreCUPSSensor()));
            System.out.println("IO CUPS       : " + ByteUtility.bytesToHex(ipmiNM20Command.getIOCUPSSensor()));
            System.out.println("Memory CUPS   : " + ByteUtility.bytesToHex(ipmiNM20Command.getMemoryCUPSSensor()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        boolean b = sessionController.closeSession();
    }

    public static void main(String[] args) {
        IPMINM20Command.main_nm30_cups(args);
    }

    public class CUPSPolicy {
        public byte policyID;
        public byte policyStatus;
        public byte policyType;
        public byte policyAction;
        public byte cupsThreshold;
        public byte[] avgWindowInSec;
        public byte[] raw;

        public void setPolicyID(byte policyID) {
            this.policyID = policyID;
        }

        public void fromRaw(byte[] raw) {
            this.avgWindowInSec = new byte[2];
            int index = 3;
            this.policyStatus = raw[index];
            this.policyType = raw[++index];
            this.policyAction = raw[++index];
            this.cupsThreshold = raw[++index];
            this.avgWindowInSec[0] = raw[++index];
            this.avgWindowInSec[1] = raw[++index];
            ++index;
            this.raw = raw;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "CUPS Policy ID           : ";
            retStr = (this.policyID & 1) == 1 ? retStr + "Core Domain\n" : ((this.policyID & 2) == 2 ? retStr + "Memory Domain\n" : ((this.policyID & 4) == 4 ? retStr + "IO Domain\n" : retStr + "Unknown\n"));
            retStr = retStr + "Target identifier        : ";
            retStr = (this.policyID & 0x10) == 16 ? retStr + "Remote Console\n" : retStr + "BMC\n";
            retStr = retStr + "Policy Status            : ";
            retStr = (this.policyStatus & 1) == 1 ? retStr + "Policy Enabled\n" : retStr + "Policy Disabled\n";
            retStr = retStr + "Policy Storage           : ";
            retStr = (this.policyType & 1) == 1 ? retStr + "Volatile memory\n" : retStr + "Persistent storage\n";
            retStr = retStr + "Policy Excursion Actions : ";
            retStr = (this.policyAction & 1) == 1 ? retStr + "Sending of alert enabled\n" : retStr + "Alerting disabled\n";
            retStr = retStr + "CUPS Threshold           : " + this.cupsThreshold + "\n";
            retStr = retStr + "Averaging Window in sec  : " + ByteUtility.twoBytesToInt(this.avgWindowInSec) + "\n";
            return retStr;
        }
    }

    public class CUPSConfiguration {
        public byte CPUSStatus;
        public byte loadFactorConfig;
        public byte[] staticCoreLoadFactor;
        public byte[] staticMemoryLoadFactor;
        public byte[] staticIOLoadFactor;
        public byte[] raw;

        public void fromRaw(byte[] raw) {
            this.staticCoreLoadFactor = new byte[2];
            this.staticMemoryLoadFactor = new byte[2];
            this.staticIOLoadFactor = new byte[2];
            int index = 3;
            this.CPUSStatus = raw[index];
            this.loadFactorConfig = raw[++index];
            this.staticCoreLoadFactor[0] = raw[++index];
            this.staticCoreLoadFactor[1] = raw[++index];
            this.staticMemoryLoadFactor[0] = raw[++index];
            this.staticMemoryLoadFactor[1] = raw[++index];
            this.staticIOLoadFactor[0] = raw[++index];
            this.staticIOLoadFactor[1] = raw[++index];
            ++index;
            this.raw = raw;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "CUPS Feature Enabled Status : ";
            retStr = (this.CPUSStatus & 1) == 1 ? retStr + "CUPS feature is enabled\n" : retStr + "CUPS feature is disabled\n";
            retStr = retStr + "Load Factor Configuration   : ";
            retStr = (this.loadFactorConfig & 1) == 1 ? retStr + "Static\n" : retStr + "Dynamic\n";
            retStr = retStr + "Static Core Load Factor     : " + ByteUtility.twoBytesToInt(this.staticCoreLoadFactor) + "\n";
            retStr = retStr + "Static Memory Load Factor   : " + ByteUtility.twoBytesToInt(this.staticMemoryLoadFactor) + "\n";
            retStr = retStr + "Static IO Load Factor       : " + ByteUtility.twoBytesToInt(this.staticIOLoadFactor) + "\n";
            return retStr;
        }
    }

    public class CUPSData {
        public byte parameter;
        public byte[] data;
        public byte[] raw;

        public void setParameter(byte param) {
            this.parameter = param;
        }

        public void fromRaw(byte[] raw) {
            int index = 3;
            this.data = new byte[raw.length - 3];
            System.arraycopy(raw, index, this.data, 0, this.data.length);
            this.raw = raw;
        }

        public String toString() {
            String retStr = "";
            byte[] byte2 = new byte[2];
            byte[] byte8 = new byte[8];
            switch (this.parameter) {
                case 1: {
                    retStr = retStr + "CUPS Index: ";
                    retStr = retStr + ByteUtility.twoBytesToInt(this.data) + "\n";
                    break;
                }
                case 2: {
                    retStr = retStr + "CUPS Dynamic Load Factors:\n";
                    System.arraycopy(this.data, 0, byte2, 0, 2);
                    retStr = retStr + "  CPU CUPS dynamic Load factor    : " + ByteUtility.twoBytesToInt(byte2) + "\n";
                    System.arraycopy(this.data, 2, byte2, 0, 2);
                    retStr = retStr + "  Memory CUPS dynamic Load factor : " + ByteUtility.twoBytesToInt(byte2) + "\n";
                    System.arraycopy(this.data, 4, byte2, 0, 2);
                    retStr = retStr + "  IO CUPS dynamic Load factor     : " + ByteUtility.twoBytesToInt(byte2) + "\n";
                    break;
                }
                case 3: {
                    retStr = retStr + "Base Utilization:\n";
                    System.arraycopy(this.data, 0, byte8, 0, 8);
                    retStr = retStr + "  Base CPU CUPS utilization value    : " + ByteUtility.bytesToHex(byte8) + "\n";
                    System.arraycopy(this.data, 8, byte8, 0, 8);
                    retStr = retStr + "  Base Memory CUPS utilization value : " + ByteUtility.bytesToHex(byte8) + "\n";
                    System.arraycopy(this.data, 16, byte8, 0, 8);
                    retStr = retStr + "  Base IO CUPS utilization value     : " + ByteUtility.bytesToHex(byte8) + "\n";
                    break;
                }
                case 4: {
                    retStr = retStr + "Aggregate utilization values:\n";
                    System.arraycopy(this.data, 0, byte8, 0, 8);
                    retStr = retStr + "  Aggregate CPU CUPS utilization value    : " + ByteUtility.bytesToHex(byte8) + "\n";
                    System.arraycopy(this.data, 8, byte8, 0, 8);
                    retStr = retStr + "  Aggregate Memory CUPS utilization value : " + ByteUtility.bytesToHex(byte8) + "\n";
                    System.arraycopy(this.data, 16, byte8, 0, 8);
                    retStr = retStr + "  Aggregate IO CUPS utilization value     : " + ByteUtility.bytesToHex(byte8) + "\n";
                    break;
                }
                case 5: {
                    retStr = retStr + "Utilization Average:\n";
                    System.arraycopy(this.data, 0, byte8, 0, 8);
                    retStr = retStr + "  Utilization average for the core domain   : " + ByteUtility.eightBytesToLongByLSBFirst(byte8) + "% (" + ByteUtility.bytesToHex(byte8) + ")\n";
                    System.arraycopy(this.data, 8, byte8, 0, 8);
                    retStr = retStr + "  Utilization average for the memory domain : " + ByteUtility.eightBytesToLongByLSBFirst(byte8) + "% (" + ByteUtility.bytesToHex(byte8) + ")\n";
                    System.arraycopy(this.data, 16, byte8, 0, 8);
                    retStr = retStr + "  Utilization average for the IO domain     : " + ByteUtility.eightBytesToLongByLSBFirst(byte8) + "% (" + ByteUtility.bytesToHex(byte8) + ")\n";
                    break;
                }
            }
            return retStr;
        }
    }

    public class CUPSCapabilities {
        public byte cupsCapabilities;
        public byte cupsPolicy;
        public byte cupsVersion;
        public byte reserved;
        public byte[] raw;

        public void fromRaw(byte[] raw) {
            int index = 3;
            this.cupsCapabilities = raw[index];
            this.cupsPolicy = raw[++index];
            this.cupsVersion = raw[++index];
            this.reserved = raw[++index];
            ++index;
            this.raw = raw;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "CUPS Capabilities: ";
            retStr = (this.cupsCapabilities & 1) == 1 ? retStr + "CUPS feature is enabled\n" : retStr + "CUPS feature is disabled\n";
            retStr = retStr + "CUPS Policy      : ";
            retStr = (this.cupsPolicy & 1) == 1 ? retStr + "CUPS policies configuration available\n" : retStr + "CUPS policies configuration not available\n";
            retStr = retStr + "CUPS version     : " + this.cupsVersion + "\n";
            return retStr;
        }
    }

    public class HostCpuData {
        byte hostCpuData;
        byte numberOfPStates;
        byte numberOfTStates;
        byte numberOfInstalledCPU;
        byte[] processorDiscoveryData = new byte[8];
        byte[] processorDiscoveryData2 = new byte[8];
        byte reserved;

        public void fromRaw(byte[] raw) {
            int index = 3;
            this.hostCpuData = raw[index];
            this.numberOfPStates = raw[++index];
            this.numberOfTStates = raw[++index];
            this.numberOfInstalledCPU = raw[++index];
            System.arraycopy(raw, ++index, this.processorDiscoveryData, 0, this.processorDiscoveryData.length);
            System.arraycopy(raw, index += 8, this.processorDiscoveryData2, 0, this.processorDiscoveryData2.length);
            this.reserved = raw[index += 8];
            ++index;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "Host CPU data:\n";
            retStr = (this.hostCpuData & 0xFFFFFF80) == -128 ? retStr + "End of POST notification was received\n" : retStr + "End of POST notification was NOT received\n";
            if ((this.hostCpuData & 0x10) != 16) {
                retStr = retStr + "Host CPU discovery data is NOT valid\n";
                return retStr;
            }
            retStr = retStr + "Host CPU discovery data is valid\n";
            if ((this.hostCpuData & 8) == 8) {
                retStr = retStr + "Node Manager already activated regular power limiting policies after Host startup\n";
            }
            retStr = retStr + "Number of P-States = " + this.numberOfPStates + "\n";
            if (this.numberOfPStates == 0) {
                retStr = retStr + "(P-states are disabled by the user)\n";
            } else if (this.numberOfPStates == 1) {
                retStr = retStr + "(CPU does not support more P-states)\n";
            }
            retStr = retStr + "Number of T-States = " + this.numberOfTStates + "\n";
            if (this.numberOfTStates == 0) {
                retStr = retStr + "(T-states are disabled by the user)\n";
            }
            retStr = retStr + "Number of installed CPUs/socket = " + this.numberOfInstalledCPU + "\n";
            retStr = retStr + "Processor Discovery Data-1 = " + ByteUtility.bytesToHex(this.processorDiscoveryData) + "\n";
            retStr = retStr + "Processor Discovery Data-2 = " + ByteUtility.bytesToHex(this.processorDiscoveryData2) + "\n";
            return retStr;
        }

        public int getNumberOfInstalledCPU() {
            return this.numberOfInstalledCPU;
        }
    }

    public class CpuMemoryTemperature {
        byte[] cpuTemp = new byte[4];
        byte[] tJmax = new byte[4];
        byte[][][] memoryTemp = new byte[4][4][4];

        public CpuMemoryTemperature() {
            for (int i = 0; i < this.tJmax.length; ++i) {
                this.tJmax[i] = 100;
            }
        }

        public void setTjmaxValue(byte cpu, byte value) {
            this.tJmax[cpu] = value;
        }

        public void setCpuTemp(byte cpu, byte value) {
            this.cpuTemp[cpu] = value;
        }

        public void fromRaw(byte[] raw) {
            int i;
            int index = 3;
            for (i = 0; i < 4; ++i) {
                this.cpuTemp[i] = raw[index];
                ++index;
            }
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        this.memoryTemp[i][j][k] = raw[index];
                        ++index;
                    }
                }
            }
        }

        public String toString() {
            int i;
            String retStr = "";
            boolean index = false;
            boolean flag = false;
            for (i = 0; i < 4; ++i) {
                if (this.cpuTemp[i] == -1) continue;
                String tempStr = " (TJmax = " + this.tJmax[i] + ",DTS = " + this.cpuTemp[i] + ")";
                retStr = retStr + "CPU#" + i + " = " + (this.tJmax[i] - this.cpuTemp[i]) + "(c)" + tempStr + "\n";
                flag = true;
            }
            if (!flag) {
                return "Not available";
            }
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        if (this.memoryTemp[i][j][k] == -1 || this.memoryTemp[i][j][k] == -2 || this.memoryTemp[i][j][k] == -3) continue;
                        retStr = retStr + "[CPU#" + i + "]CHANNEL#" + j + ", DIMM#" + k + " = " + this.memoryTemp[i][j][k] + "(c)\n";
                    }
                }
            }
            return retStr;
        }
    }

    public class ImageInventory {
        public byte[] manufacturersID;
        public byte firmwareRevision1;
        public byte firmwareRevision2;
        public byte[] auxRev;
        public byte[] raw;
        public boolean isCreateFail = false;
        public String failString = new String();

        public ImageInventory() {
            this.manufacturersID = new byte[3];
            this.auxRev = new byte[4];
        }

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.firmwareRevision1 = raw[3];
            this.firmwareRevision2 = raw[4];
            this.auxRev[0] = raw[5];
            this.auxRev[1] = raw[6];
            this.auxRev[2] = raw[7];
            this.auxRev[3] = raw[8];
            this.raw = raw;
        }

        public String toString() {
            String imageRunningString;
            StringBuffer sb = new StringBuffer();
            boolean isImageRunning = false;
            if ((byte)(this.auxRev[3] & 4) == 4) {
                isImageRunning = true;
                imageRunningString = "(This Image is currently running)";
            } else {
                isImageRunning = false;
                imageRunningString = "";
            }
            switch (this.auxRev[3] & 3) {
                case 0: {
                    sb.append("Image Type = recovery image " + imageRunningString + "\n");
                    break;
                }
                case 1: {
                    sb.append("Image Type = operational image 1 " + imageRunningString + "\n");
                    break;
                }
                case 2: {
                    sb.append("Image Type = operational image 2 " + imageRunningString + "\n");
                    break;
                }
                default: {
                    sb.append("Image Type = unspecified \n");
                }
            }
            sb.append("raw  = " + ByteUtility.bytesToHex(this.raw) + "\n");
            if ((byte)(this.firmwareRevision1 & 0x80) == -128) {
                sb.append("\n");
                sb.append("!!! Firmware is in following status !!!\n");
                sb.append("1. Device firmware update or self-initialization in progress \n");
                sb.append("2. Firmware in the recovery boot-loader mode \n");
            }
            return sb.toString();
        }

        public void setFailString(String s) {
            this.failString = s;
        }

        public String getFailString() {
            return this.failString;
        }
    }

    public class NodeManagerAlertDestination {
        public byte[] manufacturersID = new byte[3];
        public byte channelNumber;
        public byte destinationSelector;
        public byte alertStringSelector;

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.channelNumber = raw[3];
            this.destinationSelector = raw[4];
            this.alertStringSelector = raw[5];
        }
    }

    public class NodeManagerCapabilities {
        public byte[] manufacturersID = new byte[3];
        public byte maxCurrentSettings;
        public byte[] maxValue = new byte[2];
        public byte[] minValue = new byte[2];
        public byte[] minCorrectionTime = new byte[4];
        public byte[] maxCorrectionTime = new byte[4];
        public byte[] minStatisticsReportingPeriod = new byte[2];
        public byte[] maxStatisticsReportingPeriod = new byte[2];
        public byte domainLimitingScope;
        public byte[] raw;

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.maxCurrentSettings = raw[3];
            this.maxValue[0] = raw[4];
            this.maxValue[1] = raw[5];
            this.minValue[0] = raw[6];
            this.minValue[1] = raw[7];
            this.minCorrectionTime[0] = raw[8];
            this.minCorrectionTime[1] = raw[9];
            this.minCorrectionTime[2] = raw[10];
            this.minCorrectionTime[3] = raw[11];
            this.maxCorrectionTime[0] = raw[12];
            this.maxCorrectionTime[1] = raw[13];
            this.maxCorrectionTime[2] = raw[14];
            this.maxCorrectionTime[3] = raw[15];
            this.minStatisticsReportingPeriod[0] = raw[16];
            this.minStatisticsReportingPeriod[1] = raw[17];
            this.maxStatisticsReportingPeriod[0] = raw[18];
            this.maxStatisticsReportingPeriod[1] = raw[19];
            this.domainLimitingScope = raw[20];
            this.raw = raw;
        }
    }

    public class NodeManagerStatistics {
        public byte[] manufacturersID = new byte[3];
        public byte[] current = new byte[2];
        public byte[] minimum = new byte[2];
        public byte[] maximum = new byte[2];
        public byte[] average = new byte[2];
        public byte[] timeStamp = new byte[4];
        public byte[] statisticsReportingPeriod = new byte[4];
        public byte domainIdAndPolicyState;
        public byte[] raw;

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.current[0] = raw[3];
            this.current[1] = raw[4];
            this.minimum[0] = raw[5];
            this.minimum[1] = raw[6];
            this.maximum[0] = raw[7];
            this.maximum[1] = raw[8];
            this.average[0] = raw[9];
            this.average[1] = raw[10];
            this.timeStamp[0] = raw[11];
            this.timeStamp[1] = raw[12];
            this.timeStamp[2] = raw[13];
            this.timeStamp[3] = raw[14];
            this.statisticsReportingPeriod[0] = raw[15];
            this.statisticsReportingPeriod[1] = raw[16];
            this.statisticsReportingPeriod[2] = raw[17];
            this.statisticsReportingPeriod[3] = raw[18];
            this.domainIdAndPolicyState = raw[19];
            this.raw = raw;
        }
    }

    public class NodeManagerSuspendPerioid {
        public byte startTime;
        public byte stopTime;
        public byte pattern;
    }

    public class NodeManagerSuspendPerioids {
        public byte[] manufacturersID = new byte[3];
        public byte policyID;
        public byte periodLength;
        public NodeManagerSuspendPerioid[] periods;
        byte domainID;

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.policyID = raw[3];
            this.periodLength = raw[4];
            this.periods = new NodeManagerSuspendPerioid[this.periodLength];
            for (int i = 0; i < this.periods.length; ++i) {
                this.periods[i].startTime = raw[i * 3 + 5];
                this.periods[i].stopTime = raw[i * 3 + 6];
                this.periods[i].pattern = raw[i * 3 + 7];
            }
        }

        public byte[] toRaw() {
            byte[] raw = new byte[6 + this.periodLength * 3];
            raw[0] = this.manufacturersID[0];
            raw[1] = this.manufacturersID[1];
            raw[2] = this.manufacturersID[2];
            raw[3] = this.domainID;
            raw[4] = this.policyID;
            raw[5] = this.periodLength;
            for (int i = 0; i < this.periods.length; ++i) {
                raw[i * 3 + 6] = this.periods[i].startTime;
                raw[i * 3 + 7] = this.periods[i].stopTime;
                raw[i * 3 + 8] = this.periods[i].pattern;
            }
            return raw;
        }
    }

    public class NodeManagerPolicy {
        public byte[] manufacturersID = new byte[3];
        public byte domainIDAndPolicyState;
        public byte policyAndTriggerType;
        public byte policyException;
        public byte[] powerLimit = new byte[2];
        public byte[] correctionTimeLimit = new byte[4];
        public byte[] policyTriggerLimit = new byte[2];
        public byte[] statisticsReportingPeriod = new byte[2];
        public byte[] raw;

        public void fromRaw(byte[] raw) {
            this.manufacturersID[0] = raw[0];
            this.manufacturersID[1] = raw[1];
            this.manufacturersID[2] = raw[2];
            this.domainIDAndPolicyState = raw[3];
            this.policyAndTriggerType = raw[4];
            this.policyException = raw[5];
            this.powerLimit[0] = raw[6];
            this.powerLimit[1] = raw[7];
            this.correctionTimeLimit[0] = raw[8];
            this.correctionTimeLimit[1] = raw[9];
            this.correctionTimeLimit[2] = raw[10];
            this.correctionTimeLimit[3] = raw[11];
            this.policyTriggerLimit[0] = raw[12];
            this.policyTriggerLimit[1] = raw[13];
            this.statisticsReportingPeriod[0] = raw[14];
            this.statisticsReportingPeriod[1] = raw[15];
            this.raw = raw;
        }
    }

    public class NodeManagerPolicySetting {
        public byte[] manufacturersID = new byte[3];
        public byte domainID;
        public byte policyID;
        public byte policyConfig;
        public byte PolicyException;
        public byte[] powerLimit = new byte[2];
        public byte[] correctionTimeLimit = new byte[4];
        public byte[] policyTriggerLimit = new byte[2];
        public byte[] statisticsReportingPeriod = new byte[2];

        public byte[] toRaw() {
            byte[] raw = new byte[]{INTEL_MANUFACTURERS_ID[0], INTEL_MANUFACTURERS_ID[1], INTEL_MANUFACTURERS_ID[2], this.domainID, this.policyID, this.policyConfig, this.PolicyException, this.powerLimit[0], this.powerLimit[1], this.correctionTimeLimit[0], this.correctionTimeLimit[1], this.correctionTimeLimit[2], this.correctionTimeLimit[3], this.policyTriggerLimit[0], this.policyTriggerLimit[1], this.statisticsReportingPeriod[0], this.statisticsReportingPeriod[1]};
            return raw;
        }
    }

    public class NodeManagerVersion {
        public byte[] manufacturersID = new byte[3];
        public byte nodeManagerVersion;
        public byte ipmiInterfaceVersion;
        public byte patchVersion;
        public byte majorFirmwareRevision;
        public byte minorFirmwareRevision;

        public void fromRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.manufacturersID, 0, this.manufacturersID.length);
            this.nodeManagerVersion = raw[index += this.manufacturersID.length];
            this.ipmiInterfaceVersion = raw[++index];
            this.patchVersion = raw[++index];
            this.majorFirmwareRevision = raw[++index];
            this.minorFirmwareRevision = raw[++index];
            ++index;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "manufacturersID = " + ByteUtility.bytesToHex(this.manufacturersID) + "\n";
            retStr = retStr + "ipmiInterfaceVersion = " + ByteUtility.byteToHex(this.ipmiInterfaceVersion) + "\n";
            retStr = retStr + "patchVersion = " + ByteUtility.byteToHex(this.patchVersion) + "\n";
            retStr = retStr + "majorFirmwareRevision = " + ByteUtility.byteToHex(this.majorFirmwareRevision) + "\n";
            retStr = retStr + "minorFirmwareRevision = " + ByteUtility.byteToHex(this.minorFirmwareRevision) + "\n";
            return retStr;
        }
    }

    public static interface Progress {
        public void setValue(int var1);

        public void message(String var1);

        public void left(long var1);
    }

    public class FirmwareFile {
        String filename;
        File firmware;
        MfmHeader mfmHeader;
        ModuleHeader moduleHeader;
        public ModuleEntryType[] moduleEntryTypes;

        public FirmwareFile(String filename) {
            this.filename = filename;
            this.firmware = new File(this.filename);
        }

        public FirmwareFile() {
        }

        public long fileSize() {
            return this.firmware.length();
        }

        public void getAllHeader() throws Exception {
            RandomAccessFile raf = new RandomAccessFile(this.firmware, "r");
            byte[] headerBytes = new byte[128];
            raf.seek(0L);
            int count = raf.read(headerBytes);
            if (count != headerBytes.length) {
                throw new Exception("File error");
            }
            this.mfmHeader = new MfmHeader();
            this.mfmHeader.fromRaw(headerBytes);
            if (!this.verifyMfMHeader(this.mfmHeader)) {
                throw new Exception("Image currupted. MfMHeader error !");
            }
            byte[] moduleHeaderBytes = new byte[80];
            raf.seek(ByteUtility.fourBytesToLongByLSBFirst(this.mfmHeader.size) * 4L);
            raf.read(moduleHeaderBytes);
            this.moduleHeader = new ModuleHeader();
            this.moduleHeader.fromRaw(moduleHeaderBytes);
            if (!this.verifyModuleHeader(this.moduleHeader)) {
                throw new Exception("Image currupted. Module Header error !");
            }
            long numOfModuleEntiries = ByteUtility.fourBytesToLongByLSBFirst(this.mfmHeader.numModuleEntiries);
            this.moduleEntryTypes = new ModuleEntryType[(int)numOfModuleEntiries];
            for (int i = 0; i < (int)numOfModuleEntiries; ++i) {
                byte[] moduleEntryTypeBytes = new byte[80];
                raf.seek(656 + i * moduleEntryTypeBytes.length);
                raf.read(moduleEntryTypeBytes);
                this.moduleEntryTypes[i] = new ModuleEntryType();
                this.moduleEntryTypes[i].fromRaw(moduleEntryTypeBytes);
                if (this.verifyModuleEntryType(this.moduleEntryTypes[i])) continue;
                throw new Exception("Image currupted. Module Entry type error !");
            }
            raf.close();
        }

        private boolean verifyMfMHeader(MfmHeader mfmHeader) {
            return ByteUtility.fourBytesToLongByLSBFirst(mfmHeader.headerID) == 1312902436L && ByteUtility.fourBytesToLongByLSBFirst(mfmHeader.manifestVendor) == 32902L && ByteUtility.fourBytesToLongByLSBFirst(mfmHeader.headerType) == 4L && ByteUtility.fourBytesToLongByLSBFirst(mfmHeader.headerVersion) == 65536L;
        }

        private boolean verifyModuleHeader(ModuleHeader moduleHeader) {
            return ByteUtility.fourBytesToLongByLSBFirst(moduleHeader.structId) == 1146047780L && ByteUtility.fourBytesToLongByLSBFirst(moduleHeader.structVer) == 0L;
        }

        private boolean verifyModuleEntryType(ModuleEntryType moduleEntryType) {
            if (ByteUtility.fourBytesToLongByLSBFirst(moduleEntryType.header) != 1162693924L) {
                return false;
            }
            String moduleName = new String(moduleEntryType.name);
            return moduleName.indexOf("Recovery") == -1;
        }

        public byte getCRC8() throws Exception {
            CRC8 crc8 = new CRC8();
            RandomAccessFile raf = new RandomAccessFile(this.firmware, "r");
            byte[] chunk = new byte[(int)this.firmware.length()];
            raf.seek(0L);
            int count = raf.read(chunk);
            if (count != (int)this.firmware.length()) {
                throw new Exception("File read error");
            }
            byte crcCode = CRC8.crc8(chunk);
            return crcCode;
        }

        public void openFileTest() throws Exception {
            RandomAccessFile raf = new RandomAccessFile(this.firmware, "r");
            int chunkSize = 16;
            int i = 0;
            while ((long)i < this.firmware.length()) {
                byte[] chunk = new byte[chunkSize];
                raf.seek(i);
                int count = raf.read(chunk);
                if (count != chunkSize) {
                    throw new Exception("File read error");
                }
                System.out.println(ByteUtility.bytesToHex(chunk));
                i += chunkSize;
            }
        }
    }

    public class OUCapabilities {
        byte areasSupported;
        byte specialCapabilities;
    }

    public class OUStatus {
        byte imageStatus;
        byte updateSatatus;
        byte updateAttemptStatus;
        byte rollbackAttemptStatus;
        byte updateType;
        byte dependentFlags;
        byte[] freeAreaSize = new byte[3];

        public String toString() {
            String retStr = "";
            retStr = retStr + "imageStatus = " + ByteUtility.byteToHex(this.imageStatus) + "\n";
            retStr = retStr + "updateSatatus = " + ByteUtility.byteToHex(this.updateSatatus) + "\n";
            retStr = retStr + "updateAttemptStatus = " + ByteUtility.byteToHex(this.updateAttemptStatus) + "\n";
            retStr = retStr + "rollbackAttemptStatus = " + ByteUtility.byteToHex(this.rollbackAttemptStatus) + "\n";
            retStr = retStr + "updateType = " + ByteUtility.byteToHex(this.updateType) + "\n";
            retStr = retStr + "dependentFlags = " + ByteUtility.byteToHex(this.dependentFlags) + "\n";
            retStr = retStr + "freeAreaSize = " + ByteUtility.bytesToHex(this.freeAreaSize) + "\n";
            return retStr;
        }

        public String getStatusInfo() {
            String runningArea = null;
            String updateStatus = null;
            if ((this.imageStatus & 0x18) == 0) {
                runningArea = "CODE (Recovery mode)";
            } else if ((this.imageStatus & 0x18) == 8) {
                runningArea = "COD1";
            } else if ((this.imageStatus & 0x18) == 16) {
                runningArea = "COD2";
            }
            switch (this.updateSatatus) {
                case 0: {
                    updateStatus = "Idle";
                    break;
                }
                case 1: {
                    updateStatus = "update requested";
                    break;
                }
                case 2: {
                    updateStatus = "update in progress";
                    break;
                }
                case 3: {
                    updateStatus = "update success";
                    break;
                }
                case 4: {
                    updateStatus = "update failed";
                    break;
                }
                case 5: {
                    updateStatus = "update rolled back";
                    break;
                }
                case 6: {
                    updateStatus = "update aborted";
                    break;
                }
                case 7: {
                    updateStatus = "update initialization failed";
                    break;
                }
            }
            return "Running Area = " + runningArea + ", UpdateStatus = " + updateStatus;
        }

        public void printStatusInfo() {
            System.out.println(this.getStatusInfo());
        }
    }

    public class ModuleEntryType {
        byte[] header = new byte[4];
        byte[] reserved = new byte[16];
        public byte[] majorVersion = new byte[2];
        public byte[] minorVersion = new byte[2];
        byte[] hotfix = new byte[2];
        byte[] build = new byte[2];
        byte[] name = new byte[16];
        byte[] hash = new byte[20];
        byte[] moduleLen = new byte[4];
        byte[] moduleFlags = new byte[4];

        public void fromRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.header, 0, this.header.length);
            System.arraycopy(raw, index += this.header.length, this.reserved, 0, this.reserved.length);
            System.arraycopy(raw, index += this.reserved.length, this.majorVersion, 0, this.majorVersion.length);
            System.arraycopy(raw, index += this.majorVersion.length, this.minorVersion, 0, this.minorVersion.length);
            System.arraycopy(raw, index += this.minorVersion.length, this.hotfix, 0, this.hotfix.length);
            System.arraycopy(raw, index += this.hotfix.length, this.build, 0, this.build.length);
            System.arraycopy(raw, index += this.build.length, this.name, 0, this.name.length);
            System.arraycopy(raw, index += this.name.length, this.hash, 0, this.hash.length);
            System.arraycopy(raw, index += this.hash.length, this.moduleLen, 0, this.moduleLen.length);
            System.arraycopy(raw, index += this.moduleLen.length, this.moduleFlags, 0, this.moduleFlags.length);
            index += this.moduleFlags.length;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "header = " + ByteUtility.bytesToHex(this.header) + "\n";
            retStr = retStr + "reserved = " + ByteUtility.bytesToHex(this.reserved) + "\n";
            retStr = retStr + "majorVersion = " + ByteUtility.bytesToHex(this.majorVersion) + "\n";
            retStr = retStr + "minorVersion = " + ByteUtility.bytesToHex(this.minorVersion) + "\n";
            retStr = retStr + "hotfix = " + ByteUtility.bytesToHex(this.hotfix) + "\n";
            retStr = retStr + "build = " + ByteUtility.bytesToHex(this.build) + "\n";
            retStr = retStr + "name = " + ByteUtility.bytesToHex(this.name) + "(" + new String(this.name) + ")\n";
            retStr = retStr + "hash = " + ByteUtility.bytesToHex(this.hash) + "\n";
            retStr = retStr + "moduleLen = " + ByteUtility.bytesToHex(this.moduleLen) + "\n";
            retStr = retStr + "moduleFlags = " + ByteUtility.bytesToHex(this.moduleFlags) + "\n";
            return retStr;
        }
    }

    public class ModuleHeader {
        byte[] structId = new byte[4];
        byte[] structVer = new byte[4];
        byte[] flags = new byte[4];
        byte[] majorVersion = new byte[2];
        byte[] minorVersion = new byte[2];
        byte[] hotfix = new byte[2];
        byte[] build = new byte[2];
        byte[] reserved = new byte[4];
        byte[] size = new byte[4];
        byte[] reserved2 = new byte[20];
        byte[] name = new byte[16];
        byte[] reserved3 = new byte[16];

        public void fromRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.structId, 0, this.structId.length);
            System.arraycopy(raw, index += this.structId.length, this.structVer, 0, this.structVer.length);
            System.arraycopy(raw, index += this.structVer.length, this.flags, 0, this.flags.length);
            System.arraycopy(raw, index += this.flags.length, this.majorVersion, 0, this.majorVersion.length);
            System.arraycopy(raw, index += this.majorVersion.length, this.minorVersion, 0, this.minorVersion.length);
            System.arraycopy(raw, index += this.minorVersion.length, this.hotfix, 0, this.hotfix.length);
            System.arraycopy(raw, index += this.hotfix.length, this.build, 0, this.build.length);
            System.arraycopy(raw, index += this.build.length, this.reserved, 0, this.reserved.length);
            System.arraycopy(raw, index += this.reserved.length, this.size, 0, this.size.length);
            System.arraycopy(raw, index += this.size.length, this.reserved2, 0, this.reserved2.length);
            System.arraycopy(raw, index += this.reserved2.length, this.name, 0, this.name.length);
            System.arraycopy(raw, index += this.name.length, this.reserved3, 0, this.reserved3.length);
            index += this.reserved3.length;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "structId = " + ByteUtility.bytesToHex(this.structId) + "\n";
            retStr = retStr + "structVer = " + ByteUtility.bytesToHex(this.structVer) + "\n";
            retStr = retStr + "flags = " + ByteUtility.bytesToHex(this.flags) + "\n";
            retStr = retStr + "majorVersion = " + ByteUtility.bytesToHex(this.majorVersion) + "\n";
            retStr = retStr + "minorVersion = " + ByteUtility.bytesToHex(this.minorVersion) + "\n";
            retStr = retStr + "hotfix = " + ByteUtility.bytesToHex(this.hotfix) + "\n";
            retStr = retStr + "build = " + ByteUtility.bytesToHex(this.build) + "\n";
            retStr = retStr + "reserved = " + ByteUtility.bytesToHex(this.reserved) + "\n";
            retStr = retStr + "size = " + ByteUtility.bytesToHex(this.size) + "\n";
            retStr = retStr + "reserved2 = " + ByteUtility.bytesToHex(this.reserved2) + "\n";
            retStr = retStr + "name = " + ByteUtility.bytesToHex(this.name) + "(" + new String(this.name) + ")\n";
            retStr = retStr + "reserved3 = " + ByteUtility.bytesToHex(this.reserved3) + "\n";
            return retStr;
        }
    }

    public class MfmHeader {
        byte[] headerType = new byte[4];
        byte[] headerLen = new byte[4];
        byte[] headerVersion = new byte[4];
        byte[] reserved1 = new byte[4];
        byte[] manifestVendor = new byte[4];
        byte[] reserved2 = new byte[4];
        byte[] size = new byte[4];
        byte[] headerID = new byte[4];
        byte[] numModuleEntiries = new byte[4];
        byte[] reserved3 = new byte[92];

        public void fromRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.headerType, 0, this.headerType.length);
            System.arraycopy(raw, index += this.headerType.length, this.headerLen, 0, this.headerLen.length);
            System.arraycopy(raw, index += this.headerLen.length, this.headerVersion, 0, this.headerVersion.length);
            System.arraycopy(raw, index += this.headerVersion.length, this.reserved1, 0, this.reserved1.length);
            System.arraycopy(raw, index += this.reserved1.length, this.manifestVendor, 0, this.manifestVendor.length);
            System.arraycopy(raw, index += this.manifestVendor.length, this.reserved2, 0, this.reserved2.length);
            System.arraycopy(raw, index += this.reserved2.length, this.size, 0, this.size.length);
            System.arraycopy(raw, index += this.size.length, this.headerID, 0, this.headerID.length);
            System.arraycopy(raw, index += this.headerID.length, this.numModuleEntiries, 0, this.numModuleEntiries.length);
            System.arraycopy(raw, index += this.numModuleEntiries.length, this.reserved3, 0, this.reserved3.length);
            index += this.reserved3.length;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "headerType = " + ByteUtility.bytesToHex(this.headerType) + "\n";
            retStr = retStr + "headerLen = " + ByteUtility.bytesToHex(this.headerLen) + "\n";
            retStr = retStr + "headerVersion = " + ByteUtility.bytesToHex(this.headerVersion) + "\n";
            retStr = retStr + "reserved1 = " + ByteUtility.bytesToHex(this.reserved1) + "\n";
            retStr = retStr + "manifestVendor = " + ByteUtility.bytesToHex(this.manifestVendor) + "\n";
            retStr = retStr + "reserved2 = " + ByteUtility.bytesToHex(this.reserved2) + "\n";
            retStr = retStr + "size = " + ByteUtility.bytesToHex(this.size) + "\n";
            retStr = retStr + "headerID = " + ByteUtility.bytesToHex(this.headerID) + "\n";
            retStr = retStr + "numModuleEntiries = " + ByteUtility.bytesToHex(this.numModuleEntiries) + "\n";
            retStr = retStr + "reserved3 = " + ByteUtility.bytesToHex(this.reserved3) + "\n";
            return retStr;
        }
    }
}

