/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class SDRInfo {
    private byte SDRVersion;
    private int recordCount;
    private int freeSpace;
    private byte[] mostRecentAdditionTimeStamp;
    private byte[] mostRecentEraseTimeStamp;
    private byte operationSupport;
    private byte[] raw;

    public static SDRInfo fromRaw(byte[] raw) {
        SDRInfo sdrInfo = new SDRInfo();
        if (raw.length != 14) {
            return null;
        }
        sdrInfo.SDRVersion = raw[0];
        sdrInfo.recordCount = (raw[1] & 0xFF) + ((raw[2] & 0xFF) << 8);
        sdrInfo.freeSpace = (raw[3] & 0xFF) + ((raw[4] & 0xFF) << 8);
        sdrInfo.mostRecentAdditionTimeStamp = new byte[4];
        System.arraycopy(raw, 5, sdrInfo.mostRecentAdditionTimeStamp, 0, 4);
        sdrInfo.mostRecentEraseTimeStamp = new byte[4];
        System.arraycopy(raw, 9, sdrInfo.mostRecentEraseTimeStamp, 0, 4);
        sdrInfo.operationSupport = raw[13];
        sdrInfo.raw = new byte[14];
        System.arraycopy(raw, 0, sdrInfo.raw, 0, 14);
        return sdrInfo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SDR Version        = " + ByteUtility.byteToHex(this.SDRVersion) + "h \n");
        sb.append("Record count       = " + this.recordCount + "\n");
        sb.append("Free Space         = " + this.freeSpace + "\n");
        sb.append("most Add Time      = " + ByteUtility.fourByteToDateFormat2(this.mostRecentAdditionTimeStamp) + "\n");
        sb.append("most Era Time      = " + ByteUtility.fourByteToDateFormat2(this.mostRecentEraseTimeStamp) + "\n");
        sb.append("Operation Support  = " + ByteUtility.byteToHex(this.operationSupport) + "h \n");
        sb.append("Raw data           = " + ByteUtility.bytesToHex(this.raw) + "\n");
        return sb.toString();
    }

    public void setSDRVersion(byte SDRVersion) {
        this.SDRVersion = SDRVersion;
    }

    public byte getSDRVersion() {
        return this.SDRVersion;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public void setFreeSpace(int freeSpace) {
        this.freeSpace = freeSpace;
    }

    public void setMostRecentAdditionTimeStamp(byte[] mostRecentAdditionTimeStamp) {
        this.mostRecentAdditionTimeStamp = mostRecentAdditionTimeStamp;
    }

    public void setMostRecentEraseTimeStamp(byte[] mostRecentEraseTimeStamp) {
        this.mostRecentEraseTimeStamp = mostRecentEraseTimeStamp;
    }

    public void setOperationSupport(byte operationSupport) {
        this.operationSupport = operationSupport;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int getFreeSpace() {
        return this.freeSpace;
    }

    public byte[] getMostRecentAdditionTimeStamp() {
        return this.mostRecentAdditionTimeStamp;
    }

    public byte[] getMostRecentEraseTimeStamp() {
        return this.mostRecentEraseTimeStamp;
    }

    public byte getOperationSupport() {
        return this.operationSupport;
    }

    public byte[] getRaw() {
        return this.raw;
    }
}

