/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.Debug;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.LogUtil;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.blade.DisconnectListener;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.BladeServerInfo;
import com.supermicro.ipmi.microblade.CMM2CMMInfo;
import com.supermicro.ipmi.microblade.NodeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.microblade.RedundantCMMInfo;
import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.microblade.SystemMiscInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;

public class MicroBladeEntity
extends Observable {
    boolean debug = false;
    public boolean isLoginSuccessful = false;
    public boolean isLogoutSuccessful = false;
    public boolean isQueryBladeRemoteInfo = true;
    public boolean isQueryBladeServerInfo = true;
    public boolean isQueryNodeSensorInfo = true;
    public boolean isQueryNodeStatusInfo = true;
    public boolean isQuerySwitchInfo = true;
    public boolean isQueryPowerSupplyInfo = true;
    public boolean isQuerySystemMiscInfo = true;
    public boolean isQueryCMMInfo = true;
    private BladeRemoteInfo[] bladeRemoteInfos;
    private BladeServerInfo[] bladeServerInfos;
    private NodeSensorInfo[] nodeSensorInfos;
    private NodeStatusInfo[] nodeStatusInfos;
    private SwitchInfo[] switchInfos;
    private PowerSupplyInfo[] powerSupplyInfos;
    private SystemMiscInfo systemMiscInfo;
    private CMM2CMMInfo cmm2cmmInfo;
    private RedundantCMMInfo redundantCMMInfo;
    ArrayList<DisconnectListener> disconnectListeners = new ArrayList();
    private int poolingInterval = 4;
    Timer poolingTimer;
    private ISessionController sessionController;
    private IPMIInterfaceConfig ipmiInterfaceConfig;
    IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand;
    boolean useExistConnection = false;
    public String MiddlePlaneType = GlobalDefine.SixUBlade;
    public int supportedBladeSize = 28;
    public int supportedPowerSupplySize = 8;
    public int supportedGigabitSwitchSize = 4;
    int count = 0;
    SimpleDateFormat f = new SimpleDateFormat("MM/dd HH:mm:ss");
    int countOfGetData = 0;
    int queryCount = 0;

    public MicroBladeEntity(IPMIInterfaceConfig ipmiInterfaceConfig) {
        int i;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ipmiInterfaceConfig.getIp());
        int bladeSize = 10;
        int cmmModuleSize = 2;
        int powerSupplySize = 4;
        int infiniBandSize = 2;
        int gigabitSwitchSize = 2;
        if (guid != null && IPMIMessagingCommand.isCMMGUID(guid)) {
            bladeSize = guid[8];
            cmmModuleSize = guid[9];
            powerSupplySize = guid[10];
            infiniBandSize = guid[11];
            gigabitSwitchSize = guid[12];
        }
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
        this.setByMiddlePlaneType();
        this.bladeRemoteInfos = new BladeRemoteInfo[bladeSize];
        this.bladeServerInfos = new BladeServerInfo[bladeSize];
        this.nodeSensorInfos = new NodeSensorInfo[cmmModuleSize];
        this.nodeStatusInfos = new NodeStatusInfo[gigabitSwitchSize];
        this.switchInfos = new SwitchInfo[infiniBandSize];
        this.powerSupplyInfos = new PowerSupplyInfo[powerSupplySize];
        for (i = 0; i < bladeSize; ++i) {
            this.bladeRemoteInfos[i] = new BladeRemoteInfo();
            this.bladeRemoteInfos[i].setIndex(i + 1);
        }
        for (i = 0; i < bladeSize; ++i) {
            this.bladeServerInfos[i] = new BladeServerInfo();
            this.bladeServerInfos[i].setIndex(i + 1);
        }
        for (i = 0; i < cmmModuleSize; ++i) {
            this.nodeSensorInfos[i] = new NodeSensorInfo();
            this.nodeSensorInfos[i].setIndex(i + 1);
        }
        for (i = 0; i < gigabitSwitchSize; ++i) {
            this.nodeStatusInfos[i] = new NodeStatusInfo();
            this.nodeStatusInfos[i].setIndex(i + 1);
        }
        for (i = 0; i < infiniBandSize; ++i) {
            this.switchInfos[i] = new SwitchInfo();
            this.switchInfos[i].setIndex(i + 1);
        }
        for (i = 0; i < powerSupplySize; ++i) {
            this.powerSupplyInfos[i] = new PowerSupplyInfo();
            this.powerSupplyInfos[i].setIndex(i + 1);
        }
        this.systemMiscInfo = new SystemMiscInfo();
        this.cmm2cmmInfo = new CMM2CMMInfo();
        this.redundantCMMInfo = new RedundantCMMInfo();
    }

    public MicroBladeEntity(IPMIInterfaceConfig ipmiInterfaceConfig, int bladeSize, int cmmModuleSize, int gigabitSwitchSize, int infiniBandSize, int powerSupplySize) {
        int i;
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
        this.setByMiddlePlaneType();
        this.bladeRemoteInfos = new BladeRemoteInfo[bladeSize];
        this.bladeServerInfos = new BladeServerInfo[bladeSize];
        this.nodeSensorInfos = new NodeSensorInfo[cmmModuleSize];
        this.nodeStatusInfos = new NodeStatusInfo[gigabitSwitchSize];
        this.switchInfos = new SwitchInfo[infiniBandSize];
        this.powerSupplyInfos = new PowerSupplyInfo[powerSupplySize];
        for (i = 0; i < bladeSize; ++i) {
            this.bladeRemoteInfos[i] = new BladeRemoteInfo();
            this.bladeRemoteInfos[i].setIndex(i + 1);
        }
        for (i = 0; i < bladeSize; ++i) {
            this.bladeServerInfos[i] = new BladeServerInfo();
            this.bladeServerInfos[i].setIndex(i + 1);
        }
        for (i = 0; i < cmmModuleSize; ++i) {
            this.nodeSensorInfos[i] = new NodeSensorInfo();
            this.nodeSensorInfos[i].setIndex(i + 1);
        }
        for (i = 0; i < gigabitSwitchSize; ++i) {
            this.nodeStatusInfos[i] = new NodeStatusInfo();
            this.nodeStatusInfos[i].setIndex(i + 1);
        }
        for (i = 0; i < infiniBandSize; ++i) {
            this.switchInfos[i] = new SwitchInfo();
            this.switchInfos[i].setIndex(i + 1);
        }
        for (i = 0; i < powerSupplySize; ++i) {
            this.powerSupplyInfos[i] = new PowerSupplyInfo();
            this.powerSupplyInfos[i].setIndex(i + 1);
        }
        this.systemMiscInfo = new SystemMiscInfo();
        this.cmm2cmmInfo = new CMM2CMMInfo();
        this.redundantCMMInfo = new RedundantCMMInfo();
    }

    public void setByMiddlePlaneType() {
        if (!this.helpLogin()) {
            return;
        }
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(this.ipmiMicroBladeOEMCommand.getIPMIInterface());
        FRUInfo fruInfo = ipmiFRUCommand.getFRUData((byte)2);
        if (new String(fruInfo.fru.board.boardPartNumber).contains("E314")) {
            this.supportedBladeSize = 14;
            this.supportedPowerSupplySize = 4;
            this.supportedGigabitSwitchSize = 2;
            this.MiddlePlaneType = GlobalDefine.ThreeUBlade;
        } else {
            this.supportedBladeSize = 28;
            this.supportedPowerSupplySize = 8;
            this.supportedGigabitSwitchSize = 4;
            this.MiddlePlaneType = GlobalDefine.SixUBlade;
        }
        this.helpLogout();
    }

    @Override
    public void addObserver(Observer o) {
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] [AddObserver] " + o.getClass().getName());
        }
        super.addObserver(o);
    }

    public void poolingData() {
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                try {
                    MicroBladeEntity.this.getData();
                }
                catch (Exception ex) {
                    System.out.println("An exception occured in poolingData " + ex.toString());
                    ex.printStackTrace();
                }
            }
        };
        this.poolingTimer = new Timer();
        this.poolingTimer.schedule(t, 0L, (long)(this.poolingInterval * 1000));
    }

    public void stopPooling() {
        if (this.poolingTimer != null) {
            this.poolingTimer.cancel();
            this.poolingTimer = null;
        }
    }

    public void addDisconnectListener(DisconnectListener l) {
        this.disconnectListeners.add(l);
    }

    public void removeDisconnectListener(DisconnectListener l) {
        this.disconnectListeners.remove(l);
    }

    public void removeallDisconnectListener() {
        this.disconnectListeners.clear();
    }

    public void notifyDisconnectListener() {
        for (DisconnectListener item : this.disconnectListeners) {
            item.disconnect(this);
        }
    }

    private boolean helpLogin() {
        this.sessionController = IPMIVersion.getSessionController(this.ipmiInterfaceConfig);
        this.ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        if (this.sessionController == null) {
            return false;
        }
        IPMINetworkInterface rmcp = this.sessionController.startup(this.ipmiInterfaceConfig);
        if (rmcp == null) {
            return false;
        }
        this.ipmiMicroBladeOEMCommand.setIPMIInterface(rmcp);
        return true;
    }

    private boolean helpLogout() {
        return this.sessionController.closeSession();
    }

    public synchronized void getData() throws IPMIException {
        this.helpGetData();
        this.notifyUI();
    }

    private void helpGetData() throws IPMIException {
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[MicriBladeEntity] 0.Start query");
        }
        ++this.countOfGetData;
        this.isLoginSuccessful = false;
        this.isLogoutSuccessful = false;
        if (this.useExistConnection) {
            this.isLoginSuccessful = true;
        } else {
            boolean result = false;
            for (int count = 0; count != 2; ++count) {
                result = this.helpLogin();
                if (!result) continue;
            }
            if (!result) {
                this.isLoginSuccessful = false;
                this.notifyDisconnectListener();
                return;
            }
            this.isLoginSuccessful = true;
        }
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[MicroBladeEntity] 0.Login");
        }
        if (this.isQueryBladeRemoteInfo) {
            this.bladeRemoteInfos = this.ipmiMicroBladeOEMCommand.getAllBladeRemoteInfo(28);
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[MicroBladeEntity] 1.get Blade Remote Info ok");
            }
        }
        if (this.isQueryNodeSensorInfo) {
            this.nodeSensorInfos = this.ipmiMicroBladeOEMCommand.getAllNodeSensor(28);
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[MicroBladeEntity] 2.Node Sensor ok");
            }
        }
        if (this.isQueryNodeStatusInfo) {
            this.nodeStatusInfos = this.ipmiMicroBladeOEMCommand.getAllNodeStatus(28);
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[MicroBladeEntity] 3.Node Status ok");
            }
        }
        if (this.isQuerySwitchInfo) {
            this.switchInfos = this.ipmiMicroBladeOEMCommand.getAllSwitch(4);
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[MicroBladeEntity] 4.Get Switch ok");
            }
        }
        if (this.isQueryPowerSupplyInfo) {
            this.powerSupplyInfos = this.ipmiMicroBladeOEMCommand.getAllPowerSupply(8);
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[MicroBladeEntity] 5.Get Power Supply ok");
            }
        }
        if (this.isQueryPowerSupplyInfo) {
            this.systemMiscInfo = this.ipmiMicroBladeOEMCommand.getSystemMisc();
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[MicroBladeEntity] 6.Get System Misc ok");
            }
        }
        if (this.isQueryCMMInfo) {
            this.cmm2cmmInfo = this.ipmiMicroBladeOEMCommand.getCMM2CMMInfo();
            this.redundantCMMInfo = this.ipmiMicroBladeOEMCommand.getRedundantCMMInfo();
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[MicroBladeEntity] 7.Get CMMInfo ok");
            }
        }
        this.isLogoutSuccessful = this.useExistConnection ? true : this.helpLogout();
        if (!this.isLogoutSuccessful) {
            this.notifyDisconnectListener();
            return;
        }
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[MicroBladeEntity] 6.logout ok");
        }
        if (this.debug) {
            this.debugMessage();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Login:" + (this.isLoginSuccessful ? "OK" : "X"));
        sb.append(", Logout:" + (this.isLoginSuccessful ? "O" : "X"));
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[MicroBladeEntity] 7.done");
        }
    }

    private void notifyUI() {
        if (!this.isLoginSuccessful || !this.isLogoutSuccessful) {
            return;
        }
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 13.Start Notify");
        }
        Calendar cStart = Calendar.getInstance();
        this.setChanged();
        this.notifyObservers();
        Calendar cEnd = Calendar.getInstance();
        double time = cEnd.getTimeInMillis() - cStart.getTimeInMillis();
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 14.End Notify  Notify(" + this.countObservers() + ") = " + time / 1000.0 + "secs");
        }
    }

    private void debugMessage() {
        int i;
        System.out.println("query count =" + this.queryCount++);
        for (i = 0; i < this.bladeRemoteInfos.length; ++i) {
            System.out.print("================Start MicroBlade (" + (i + 1) + ")================");
            System.out.println(this.bladeRemoteInfos[i].toString());
            System.out.println("================End MicroBlade (" + (i + 1) + ")================");
        }
        for (i = 0; i < this.nodeSensorInfos.length; ++i) {
            System.out.println("================Start MicroBlade Sensor (" + (i + 1) + ")================");
            System.out.println(this.nodeSensorInfos[i].toString());
            System.out.println("================End MicroBlade Sensor (" + (i + 1) + ")================");
        }
        for (i = 0; i < this.nodeStatusInfos.length; ++i) {
            System.out.println("================Start MicroBlade Status (" + (i + 1) + ")================");
            System.out.println(this.nodeStatusInfos[i].toString());
            System.out.println("================End MicroBlade Status (" + (i + 1) + ")================");
        }
        for (i = 0; i < this.switchInfos.length; ++i) {
            System.out.println("================Start gigabit switch (" + (i + 1) + ")================");
            System.out.println(this.switchInfos[i].toString());
            System.out.println("================End gigabit switch (" + (i + 1) + ")================");
        }
        for (i = 0; i < this.powerSupplyInfos.length; ++i) {
            System.out.println("================Start Power Supply (" + (i + 1) + ")================");
            System.out.println(this.powerSupplyInfos[i].toString());
            System.out.println("================End Power Supply (" + (i + 1) + ")================");
        }
    }

    public void setEnableAllQuery(boolean enable) {
        this.isQueryBladeRemoteInfo = enable;
        this.isQueryBladeServerInfo = enable;
        this.isQueryNodeSensorInfo = enable;
        this.isQueryNodeStatusInfo = enable;
        this.isQuerySwitchInfo = enable;
        this.isQueryPowerSupplyInfo = enable;
        this.isQuerySystemMiscInfo = enable;
        this.isQueryCMMInfo = enable;
    }

    public String doubleToString(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d;
    }

    public String getDataTimeString() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
        return f.format(date);
    }

    public BladeRemoteInfo[] getBladeRemoteInfos() {
        return this.bladeRemoteInfos;
    }

    public BladeServerInfo[] getBladeServerInfos() {
        return this.bladeServerInfos;
    }

    public NodeSensorInfo[] getNodeSensorInfos() {
        return this.nodeSensorInfos;
    }

    public NodeStatusInfo[] getNodeStatusInfos() {
        return this.nodeStatusInfos;
    }

    public SwitchInfo[] getSwitchInfos() {
        return this.switchInfos;
    }

    public PowerSupplyInfo[] getPowerSupplyInfos() {
        return this.powerSupplyInfos;
    }

    public SystemMiscInfo getSystemMiscInfo() {
        return this.systemMiscInfo;
    }

    public CMM2CMMInfo getCMM2CMMInfo() {
        return this.cmm2cmmInfo;
    }

    public RedundantCMMInfo getRedundantCMMInfo() {
        return this.redundantCMMInfo;
    }

    public int getPoolingInterval() {
        return this.poolingInterval;
    }

    public boolean isIsLoginSuccessful() {
        return this.isLoginSuccessful;
    }

    public boolean isIsLogoutSuccessful() {
        return this.isLogoutSuccessful;
    }

    public boolean isUseExistConnection() {
        return this.useExistConnection;
    }

    public void setPoolingInterval(int poolingInterval) {
        this.poolingInterval = poolingInterval;
    }

    public void setIsQueryBladeEntity(boolean isQueryBladeEntity) {
        this.isQueryBladeRemoteInfo = isQueryBladeEntity;
    }

    public void setIsQueryBladeServerInfo(boolean isQueryBladeServerInfo) {
        this.isQueryBladeServerInfo = isQueryBladeServerInfo;
    }

    public void setIsQuerySystemMiscInfo(boolean isQuerySystemMiscInfo) {
        this.isQuerySystemMiscInfo = isQuerySystemMiscInfo;
    }

    public void setIsQueryCMMInfo(boolean isQueryCMMInfo) {
        this.isQueryCMMInfo = isQueryCMMInfo;
    }

    public void setIsQueryNodeSensorInfo(boolean isQueryNodeSensorInfo) {
        this.isQueryNodeSensorInfo = isQueryNodeSensorInfo;
    }

    public void setIsQueryNodeStatusInfo(boolean isQueryNodeStatusInfo) {
        this.isQueryNodeStatusInfo = isQueryNodeStatusInfo;
    }

    public void setIsQueryPowerSupplyInfo(boolean isQueryPowerSupplyInfo) {
        this.isQueryPowerSupplyInfo = isQueryPowerSupplyInfo;
    }

    public void setIsQuerySwitchInfo(boolean isQuerySwitchInfo) {
        this.isQuerySwitchInfo = isQuerySwitchInfo;
    }

    public void setUseExistConnection(boolean useExistConnection) {
        this.useExistConnection = useExistConnection;
    }

    public void setIPMIMicroBladeOEMCommand(IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand) {
        this.ipmiMicroBladeOEMCommand = ipmiMicroBladeOEMCommand;
    }

    public String getBladeIndex(int index) {
        String alternateBladeIndex = null;
        switch (index) {
            case 0: {
                alternateBladeIndex = "A1";
                break;
            }
            case 1: {
                alternateBladeIndex = "A2";
                break;
            }
            case 2: {
                alternateBladeIndex = "A3";
                break;
            }
            case 3: {
                alternateBladeIndex = "A4";
                break;
            }
            case 4: {
                alternateBladeIndex = "A5";
                break;
            }
            case 5: {
                alternateBladeIndex = "A6";
                break;
            }
            case 6: {
                alternateBladeIndex = "A7";
                break;
            }
            case 7: {
                alternateBladeIndex = "A8";
                break;
            }
            case 8: {
                alternateBladeIndex = "A9";
                break;
            }
            case 9: {
                alternateBladeIndex = "A10";
                break;
            }
            case 10: {
                alternateBladeIndex = "A11";
                break;
            }
            case 11: {
                alternateBladeIndex = "A12";
                break;
            }
            case 12: {
                alternateBladeIndex = "A13";
                break;
            }
            case 13: {
                alternateBladeIndex = "A14";
                break;
            }
            case 14: {
                alternateBladeIndex = "B1";
                break;
            }
            case 15: {
                alternateBladeIndex = "B2";
                break;
            }
            case 16: {
                alternateBladeIndex = "B3";
                break;
            }
            case 17: {
                alternateBladeIndex = "B4";
                break;
            }
            case 18: {
                alternateBladeIndex = "B5";
                break;
            }
            case 19: {
                alternateBladeIndex = "B6";
                break;
            }
            case 20: {
                alternateBladeIndex = "B7";
                break;
            }
            case 21: {
                alternateBladeIndex = "B8";
                break;
            }
            case 22: {
                alternateBladeIndex = "B9";
                break;
            }
            case 23: {
                alternateBladeIndex = "B10";
                break;
            }
            case 24: {
                alternateBladeIndex = "B11";
                break;
            }
            case 25: {
                alternateBladeIndex = "B12";
                break;
            }
            case 26: {
                alternateBladeIndex = "B13";
                break;
            }
            case 27: {
                alternateBladeIndex = "B14";
            }
        }
        return alternateBladeIndex;
    }

    public String toSummaryFormatedString() {
        StringBuffer sbTitle = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        StringBuffer header = new StringBuffer();
        int available = 0;
        header.append(String.format(" %-5s | %-1s\n", "Blade", "Status"));
        header.append(String.format(" %-5s | %-8s\n", "-----", "------"));
        sb.append(header);
        header = new StringBuffer();
        header.append(String.format("    %-4s | %-15s | %-8s\n", "Node", "BMC IP", "Status"));
        header.append(String.format("    %-4s | %-15s | %-8s\n", "----", "------", "------"));
        int nodeIndex = 0;
        for (int i = 0; i < this.bladeRemoteInfos.length; ++i) {
            BladeRemoteInfo bladeRemoteInfo = this.bladeRemoteInfos[i];
            if (bladeRemoteInfo.isPresent()) {
                int j;
                StringBuffer sbTemp = new StringBuffer();
                boolean error = false;
                ++available;
                sbTemp.append(header);
                for (j = 0; j < bladeRemoteInfo.nodeCount; ++j) {
                    NodeRemoteInfo nodeRemoteInfo = bladeRemoteInfo.getNodeRemoteInfo(j);
                    if (this.nodeSensorInfos[nodeIndex++].error() == 0) {
                        sbTemp.append(String.format("    %-4s | %-15s | %-8s\n", j + 1, nodeRemoteInfo.getBMCPIP(), "Normal"));
                        continue;
                    }
                    error = true;
                    sbTemp.append(String.format("    %-4s | %-15s | %-8s\n", j + 1, nodeRemoteInfo.getBMCPIP(), "Error"));
                }
                sb.append(String.format(" %-5s | %-8s\n", this.getBladeIndex(i), error ? "Error" : "Normal"));
                sb.append(sbTemp);
                j = 4;
                while (j - bladeRemoteInfo.nodeCount > 0) {
                    ++nodeIndex;
                    --j;
                }
                continue;
            }
            ++nodeIndex;
            ++nodeIndex;
            ++nodeIndex;
            ++nodeIndex;
        }
        sb.append("\n");
        sb.append(this.toSwitchInfoFormatedString());
        sb.append("\n");
        sb.append(this.toPowerSupplyInfoFormatedString());
        sbTitle.append("Blade Module (" + available + "/" + this.supportedBladeSize + ")\n");
        sbTitle.append("------------------------\n");
        sbTitle.append(sb);
        return sbTitle.toString();
    }

    public String toBladeFormatedString() {
        BladeRemoteInfo b;
        int i;
        StringBuffer sb = new StringBuffer();
        int bladeCount = 0;
        for (i = 0; i < this.bladeRemoteInfos.length; ++i) {
            b = this.bladeRemoteInfos[i];
            if (!b.isPresent()) continue;
            ++bladeCount;
        }
        if (bladeCount > 0) {
            sb.append("Blade Module (" + bladeCount + "/" + this.bladeRemoteInfos.length + ")\n");
            sb.append("--------------------\n");
            sb.append(this.bladeRemoteInfos[0].toFormatedHeader());
            for (i = 0; i < this.bladeRemoteInfos.length; ++i) {
                b = this.bladeRemoteInfos[i];
                sb.append(b.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toNodeSensorFormatedString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Node Sensor (" + this.nodeSensorInfos.length + ")\n");
        sb.append("------------------------\n");
        sb.append(this.nodeSensorInfos[0].toFormatedHeader());
        for (int i = 0; i < this.nodeSensorInfos.length; ++i) {
            NodeSensorInfo e = this.nodeSensorInfos[i];
            sb.append(e.toFormatedString());
        }
        return sb.toString();
    }

    public String toNodeStatusInfoFormatedString() {
        int i;
        StringBuffer sb = new StringBuffer();
        int cmmCount = 0;
        for (i = 0; i < this.nodeStatusInfos.length; ++i) {
            NodeStatusInfo nodeStatusInfo = this.nodeStatusInfos[i];
            if (!nodeStatusInfo.isPresent()) continue;
            ++cmmCount;
        }
        if (cmmCount > 0) {
            sb.append("Node Status(" + cmmCount + "/" + this.nodeStatusInfos.length + ")\n");
            sb.append("----------------\n");
            sb.append(this.nodeStatusInfos[0].toFormatedHeader());
            for (i = 0; i < this.nodeStatusInfos.length; ++i) {
                NodeStatusInfo e = this.nodeStatusInfos[i];
                sb.append(e.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toSwitchInfoFormatedString() {
        StringBuffer sbTitle = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        StringBuffer header = new StringBuffer();
        int available = 0;
        header.append(String.format(" %-6s | %-8s\n", "Switch", "Status"));
        header.append(String.format(" %-6s | %-8s\n", "------", "------"));
        sb.append(header);
        for (int i = 0; i < this.switchInfos.length; ++i) {
            if (!this.switchInfos[i].isPresent()) continue;
            ++available;
            String status = this.switchInfos[i].getPowerStatus() && !this.switchInfos[i].getBit4_SysOK() ? "Initializing" : (this.switchInfos[i].getPowerStatus() ? "On" : "Off");
            sb.append(String.format(" %-6s | %-8s\n", SwitchInfo.getIndex(i), status));
        }
        sbTitle.append("Switch Module (" + available + "/" + this.supportedGigabitSwitchSize + ")\n");
        sbTitle.append("------------------------\n");
        sbTitle.append(sb);
        return sbTitle.toString();
    }

    public String toPowerSupplyInfoFormatedString() {
        StringBuffer sbTitle = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        StringBuffer header = new StringBuffer();
        int available = 0;
        header.append(String.format(" %-12s | %-8s\n", "Power Suuply", "Status"));
        header.append(String.format(" %-12s | %-8s\n", "------------", "------"));
        sb.append(header);
        for (int i = 0; i < this.powerSupplyInfos.length; ++i) {
            if (!this.powerSupplyInfos[i].isPresent()) continue;
            ++available;
            sb.append(String.format(" %-12s | %-8s\n", PowerSupplyInfo.getIndex(i), this.powerSupplyInfos[i].isPresent() ? "Normal" : "N/A"));
        }
        sbTitle.append("Power Supply Module (" + available + "/" + this.supportedPowerSupplySize + ")\n");
        sbTitle.append("------------------------\n");
        sbTitle.append(sb);
        return sbTitle.toString();
    }

    public String toSystemMiscInfoFormatedString() {
        StringBuffer sb = new StringBuffer();
        sb.append("System Misc\n");
        sb.append("------------------------\n");
        sb.append(this.systemMiscInfo.toFormatedHeader());
        sb.append(this.systemMiscInfo.toFormatedString());
        return sb.toString();
    }

    public String toFormatedString() {
        StringBuffer sb = new StringBuffer();
        String s1 = this.toBladeFormatedString();
        String s2 = this.toNodeSensorFormatedString();
        String s3 = this.toNodeStatusInfoFormatedString();
        String s4 = this.toSwitchInfoFormatedString();
        String s5 = this.toPowerSupplyInfoFormatedString();
        String s6 = this.toSystemMiscInfoFormatedString();
        sb.append(s1 + (s1.length() != 0 ? "\n" : ""));
        sb.append(s2 + (s2.length() != 0 ? "\n" : ""));
        sb.append(s3 + (s3.length() != 0 ? "\n" : ""));
        sb.append(s4 + (s4.length() != 0 ? "\n" : ""));
        sb.append(s5 + (s5.length() != 0 ? "\n" : ""));
        sb.append(s6);
        return sb.toString();
    }

    public static void main(String[] args) throws IPMIException {
        String ip = "";
        String id = "ADMIN";
        String pw = "ADMIN";
        String module = "";
        int index = 0;
        int number = 1;
        boolean infinite = false;
        if (args.length != 5 && args.length != 6) {
            System.out.println("MicroBladeEntity Build:140207");
            System.out.println("Usage: MicroBladeEntity IP USERNAME PASSWORD MODULE_NAME INDEX [number]");
            System.out.println("  IP:          IP address of CMM");
            System.out.println("  USERNAME:    username");
            System.out.println("  PASSWORD:    password");
            System.out.println("  MODULE_NAME: b(Blade),s(Node Sensor),ss(Node Status),g(Switch),");
            System.out.println("               p(Power Supply),m(System Misc)");
            System.out.println("  INDEX:       1-based index number of module. Use 0 for all ");
            System.out.println("  number:      run number of this command. Use 0 for infinite times (Ctr-C to stop).");
            System.exit(0);
        }
        ip = args[0];
        id = args[1];
        pw = args[2];
        module = args[3];
        try {
            index = Integer.parseInt(args[4]);
        }
        catch (NumberFormatException ex1) {
            System.out.println("INDEX parameter error");
            System.exit(0);
        }
        if (args.length == 6) {
            try {
                number = Integer.parseInt(args[5]);
            }
            catch (NumberFormatException ex1) {
                System.out.println("[number] parameter error");
                System.exit(0);
            }
        }
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(id);
        config.setPassword(pw);
        config.setPrivilege((byte)4);
        MicroBladeEntity bladeSystem = new MicroBladeEntity(config);
        if (number == 0) {
            number = 2;
            infinite = true;
        }
        int i = 0;
        while (i < number) {
            bladeSystem.getData();
            if (module.equalsIgnoreCase("b")) {
                if (index != 0) {
                    System.out.print("===== Blade " + index + ":");
                    System.out.println(bladeSystem.bladeRemoteInfos[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.bladeRemoteInfos.length; ++j) {
                        System.out.print("===== Blade " + (j + 1) + ":");
                        System.out.println(bladeSystem.bladeRemoteInfos[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("s")) {
                if (index != 0) {
                    System.out.print("===== CMM " + index + ":");
                    System.out.println(bladeSystem.nodeSensorInfos[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.nodeSensorInfos.length; ++j) {
                        System.out.print("===== CMM " + (j + 1) + ":");
                        System.out.println(bladeSystem.nodeSensorInfos[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("ss")) {
                if (index != 0) {
                    System.out.print("===== Switch " + index + ":");
                    System.out.println(bladeSystem.nodeStatusInfos[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.nodeStatusInfos.length; ++j) {
                        System.out.print("===== Switch " + (j + 1) + ":");
                        System.out.println(bladeSystem.nodeStatusInfos[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("g")) {
                if (index != 0) {
                    System.out.print("===== Switch " + index + ":");
                    System.out.println(bladeSystem.switchInfos[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.switchInfos.length; ++j) {
                        System.out.print("===== Switch " + (j + 1) + ":");
                        System.out.println(bladeSystem.switchInfos[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("p")) {
                if (index != 0) {
                    System.out.print("===== Power Supply " + index + ":");
                    System.out.println(bladeSystem.powerSupplyInfos[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.powerSupplyInfos.length; ++j) {
                        System.out.print("===== Power Supply " + (j + 1) + ":");
                        System.out.println(bladeSystem.powerSupplyInfos[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("m")) {
                System.out.print("===== System Misc:");
                System.out.println(bladeSystem.systemMiscInfo.toString());
            }
            if (i != number - 1) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (infinite) continue;
            ++i;
        }
    }

    public static void main_poolingTest(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.240");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        MicroBladeEntity bladeSystem = new MicroBladeEntity(config);
        bladeSystem.debug = true;
        bladeSystem.poolingData();
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        bladeSystem.stopPooling();
    }
}

