/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task.mbtauto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class MBTConfig {
    public String ecoPath;
    public String productKeyServer;
    public String productKeyUsername;
    public String productKeyPassword;
    public ArrayList<IPMIAccount> ipmiAccounts = new ArrayList();

    public void load(String filename) throws Exception {
        String propertyFileContents = "";
        String line = "";
        BufferedReader in = new BufferedReader(new FileReader(filename));
        while ((line = in.readLine()) != null) {
            propertyFileContents = propertyFileContents + line + "\n";
        }
        Properties p = new Properties();
        p.load(new StringReader(propertyFileContents.replace("\\", "\\\\")));
        this.ecoPath = p.getProperty("ecoPath");
        this.productKeyServer = p.getProperty("productKeyServer");
        this.productKeyUsername = p.getProperty("productKeyUsername");
        this.productKeyPassword = p.getProperty("productKeyPassword");
        String account = p.getProperty("ipmiAccount");
        StringTokenizer st = new StringTokenizer(account, ";");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            String t1 = t.substring(0, t.indexOf("/"));
            String t2 = t.substring(t.indexOf("/") + 1, t.length());
            IPMIAccount ipmiAccount = new IPMIAccount(t1.trim(), t2.trim());
            this.ipmiAccounts.add(ipmiAccount);
        }
        File ff = new File(this.ecoPath);
        if (!ff.isDirectory()) {
            throw new Exception(this.ecoPath + " is not exist !");
        }
        System.out.println(filename);
        System.out.println("-------------");
        System.out.println(this.toString());
    }

    public String toString() {
        String result = "";
        result = result + "ecoPath             = " + this.ecoPath + "\n";
        result = result + "productKeyServer    = " + this.productKeyServer + "\n";
        result = result + "productKeyUsername  = " + this.productKeyUsername + "\n";
        result = result + "productKeyPassword  = " + this.productKeyPassword + "\n";
        result = result + "ipmiAccount         = " + this.ipmiAccounts.toString();
        return result;
    }

    public static void main(String[] args) throws Exception {
        MBTConfig mbtConfig = new MBTConfig();
        mbtConfig.load("c:\\mbt.ini");
        System.out.println(mbtConfig.toString());
    }

    class IPMIAccount {
        String username;
        String password;

        public IPMIAccount(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String toString() {
            return this.username + "/" + this.password + " ";
        }
    }
}

