/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeAliasCommand
extends SuperBladeCommand {
    String name = null;

    @Override
    public boolean preValidate() {
        this.name = null;
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        if (this.parameters != null) {
            this.name = this.parameters[0];
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (this.name != null && this.name.length() > 20) {
            MOut.G(this).println("20 characters limited");
            return;
        }
        if (this.name != null) {
            try {
                this.ipmiCMMOEMCommand.setBladeName(bladeIndex, this.name);
                MOut.G(this).println("Done");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {}
            }
            catch (IPMIException ex) {
                ex.printStackTrace();
            }
        }
        try {
            String bladename = this.ipmiCMMOEMCommand.getBladeName(bladeIndex);
            MOut.G(this).println("Blade " + bladeIndex + " : " + bladename);
        }
        catch (IPMIException ex1) {
            ex1.printStackTrace();
        }
        this.statusCode = 0;
    }
}

