/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.blade.TenGSwitchEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class GBStatusCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        byte gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (gbIndex < 1 || gbIndex > 4) {
            MOut.G(this).println("Gigabit switch Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryGigabitSwitchEntity(true);
        bladeSystem.setIsQueryInfiniBandEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        if (index == 1 || index == 2) {
            GigabitSwitchEntity gb = bladeSystem.getGigabitSwitchs()[index - 1];
            if (gb.getPresent() == 0) {
                MOut.G(this).println("Gigabit Switch " + index + " is not presented");
                this.statusCode = 151;
                return;
            }
            MOut.G(this).print(gb.toFormatedHeader());
            MOut.G(this).print(gb.toFormatedString());
            if (gb.showModelName) {
                MOut.G(this).print(gb.toFormatedHeaderLine2());
                MOut.G(this).print(gb.toFormatedStringLine2());
            }
        } else if (index == 3 || index == 4) {
            if (bladeSystem.getGigabitSwitchs().length == 4) {
                GigabitSwitchEntity gb = bladeSystem.getGigabitSwitchs()[index - 1];
                if (gb.getPresent() == 0) {
                    MOut.G(this).println("Gigabit Switch " + index + " is not presented");
                    this.statusCode = 151;
                    return;
                }
                MOut.G(this).print(gb.toFormatedHeader());
                MOut.G(this).print(gb.toFormatedString());
                if (gb.showModelName) {
                    MOut.G(this).print(gb.toFormatedHeaderLine2());
                    MOut.G(this).print(gb.toFormatedStringLine2());
                }
            } else {
                TenGSwitchEntity g = bladeSystem.getTenGSwitches()[index - 3];
                if (g.getPresent() > 0 && g.is10GSwitch()) {
                    MOut.G(this).print(g.toFormatedHeader());
                    MOut.G(this).print(g.toFormatedString());
                    if (g.showModelName) {
                        MOut.G(this).print(g.toFormatedHeaderLine2());
                        MOut.G(this).print(g.toFormatedStringLine2());
                    }
                } else {
                    MOut.G(this).println("10 Gigabit Switch " + index + " is not presented");
                    this.statusCode = 151;
                    return;
                }
            }
        }
        this.statusCode = 0;
    }
}

