/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;

public class IPMIOEMAlertLevelCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    @Override
    public boolean preValidate() {
        block7: {
            try {
                if (this.parameters.length == 1) {
                    if (Integer.parseInt(this.parameters[0]) < 1 || Integer.parseInt(this.parameters[0]) > 16) {
                        MOut.G(this).println("Out of range! (1 - 16)");
                        return false;
                    }
                    break block7;
                }
                if (this.parameters.length == 2) {
                    if (Integer.parseInt(this.parameters[0]) < 1 || Integer.parseInt(this.parameters[0]) > 16) {
                        MOut.G(this).println("Out of range! (1 - 16)");
                        return false;
                    }
                    if (Integer.parseInt(this.parameters[1]) < 1 || Integer.parseInt(this.parameters[1]) > 5) {
                        MOut.G(this).println("Parameter error!");
                        this.printLevel();
                        return false;
                    }
                    break block7;
                }
                MOut.G(this).println("Parameter error!");
                return false;
            }
            catch (Exception ex) {
                MOut.G(this).println("Parameter error!");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This command supports X10 platform only");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters.length == 1) {
            byte level = ipmiOEMWebSettingCommand.getAlert((byte)(Integer.parseInt(this.parameters[0]) - 1), (byte)0)[0];
            MOut.G(this).println(this.levelString(level));
            this.printLevel();
        } else {
            byte[] level = new byte[1];
            switch (Integer.parseInt(this.parameters[1])) {
                case 1: {
                    level[0] = 0;
                    break;
                }
                case 2: {
                    level[0] = 2;
                    break;
                }
                case 3: {
                    level[0] = 8;
                    break;
                }
                case 4: {
                    level[0] = 16;
                    break;
                }
                case 5: {
                    level[0] = 32;
                }
            }
            ipmiOEMWebSettingCommand.setAlert((byte)(Integer.parseInt(this.parameters[0]) - 1), (byte)2, level);
            MOut.G(this).println("Done");
        }
        this.statusCode = 0;
    }

    private void printLevel() {
        MOut.G(this).println("\nFor Alert Level:");
        MOut.G(this).println("Disable All              : 1");
        MOut.G(this).println("Information and Above    : 2");
        MOut.G(this).println("Warning and Above        : 3");
        MOut.G(this).println("Critical And Above       : 4");
        MOut.G(this).println("Non-recoverable and Above: 5");
    }

    private String levelString(byte type) {
        switch (type) {
            case 0: {
                return "Disable All";
            }
            case 2: {
                return "Information and Above";
            }
            case 8: {
                return "Warning and Above";
            }
            case 16: {
                return "Critical and Above";
            }
            case 32: {
                return "Non-recoverable and Above";
            }
        }
        return "N/A";
    }
}

