/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public class IPMIOEMIpCtrlEditCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private byte id;
    private byte[] ip;
    private byte[] netmask;
    private byte policy;

    @Override
    public boolean preValidate() {
        String usage = "Usage: ipmi oem x10cfg ipCtrl edit <rule no> <ip address> <netmask> <policy> \n\nFor Policy:\nAccept : 1\nDrop   : 0\n";
        if (this.parameters == null || this.parameters.length != 4) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.id = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("rule no should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.id < 1 || this.id > 10) {
            MOut.G(this).println("rule no should be 1-10");
            MOut.G(this).println(usage);
            return false;
        }
        String IPV4_REGEX = "(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))";
        try {
            if (!Pattern.compile(IPV4_REGEX).matcher(this.parameters[1]).matches()) {
                throw new NumberFormatException();
            }
            this.ip = ByteUtility.ipToBytes(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("ip address should be ###.###.###.###");
            MOut.G(this).println(usage);
            return false;
        }
        try {
            if (!Pattern.compile(IPV4_REGEX).matcher(this.parameters[2]).matches()) {
                throw new NumberFormatException();
            }
            this.netmask = ByteUtility.ipToBytes(this.parameters[2]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("netmask should be ###.###.###.###");
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.policy = Byte.parseByte(this.parameters[3]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("policy should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.policy < 0 || this.policy > 1) {
            MOut.G(this).println("Policy error");
            MOut.G(this).println("Accept : 1");
            MOut.G(this).println("Drop   : 0");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This command supports X10 platform only ");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        this.id = (byte)(this.id - 1);
        byte[] rule = ipmiOEMWebSettingCommand.getIpCtrlRule(this.id);
        if (rule == null || rule.length != 9) {
            MOut.G(this).println("The ip access rule is empty");
            this.statusCode = 149;
            return;
        }
        ByteBuffer target = ByteBuffer.allocate(10);
        target.put(this.id);
        target.put(this.ip);
        target.put(this.netmask);
        target.put(this.policy);
        if (!ipmiOEMWebSettingCommand.setIpCtrl((byte)1, target.array())) {
            MOut.G(this).println("Set ip access rule failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

