/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeNodeLanMaskCommand
extends MicroBladeCommand {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute() throws Exception {
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        int nodeIndex = 0;
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            this.statusCode = 145;
            return;
        }
        if (this.getParameters() == null) {
            MOut.G(this).println("Usage: microBlade node mask <bladeID> <nodeID> [Subnet mask]");
        } else if (this.getParameters().length == 2) {
            String bladeIndex = this.getParameters()[0];
            nodeIndex = Integer.parseInt(this.getParameters()[1]);
            byte bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            if (bIndex < 0) {
                MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex);
            NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus(bIndex, (byte)(nodeIndex - 1));
            if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                MOut.G(this).println("Blade " + bladeIndex + " Node " + nodeIndex + " is not presented");
                this.statusCode = 151;
                sessionController.closeSession();
                return;
            }
            if (nodeIndex < 1 || nodeIndex > 4) {
                MOut.G(this).println("The node index must be 1-4");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            MOut.G(this).println("Usage: microBlade node mask <bladeID> <nodeID> [Subnet mask]");
            String s = ipmiMicroBladeOEMCommand.getNodeLanSubnetMask(bIndex, nodeIndex - 1);
            MOut.G(this).println("Subnet mask: " + s);
        } else if (this.getParameters().length == 3) {
            String bladeIndex = this.getParameters()[0];
            nodeIndex = Integer.parseInt(this.getParameters()[1]);
            byte bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            if (bIndex < 0) {
                MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex);
            NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus(bIndex, (byte)(nodeIndex - 1));
            if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                MOut.G(this).println("Blade " + bladeIndex + " Node " + nodeIndex + " is not presented");
                this.statusCode = 151;
                sessionController.closeSession();
                return;
            }
            if (nodeIndex < 1 || nodeIndex > 4) {
                MOut.G(this).println("The node index must be 1-4");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            boolean b = ipmiMicroBladeOEMCommand.setNodeLanSubnetMask(bIndex, nodeIndex - 1, this.getParameters()[2]);
            if (!b) {
                MOut.G(this).println("Update Subnet Mask Fail");
                this.statusCode = 149;
                sessionController.closeSession();
                return;
            }
            MOut.G(this).println("Update Subnet Mask Successfully");
        } else {
            MOut.G(this).println("Usage: microBlade node mask <bladeID> <nodeID> [Subnet mask]");
        }
        sessionController.closeSession();
        this.statusCode = 0;
    }
}

