/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMPTStateCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 0;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        try {
            byte[] state = ipmiDCMOEMCommand.getMaxAllowedCPU_P_T_State((byte)0);
            byte[] nOfState = ipmiDCMOEMCommand.getNumberOf_P_T_StateRequest((byte)0);
            MOut.G(this).println("P-State : " + this.stateGraphics(state[0], nOfState[0]));
            MOut.G(this).println("T-State : " + this.stateGraphics(state[1], nOfState[1]));
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        this.statusCode = 0;
    }

    public String stateGraphics(byte p, byte psize) {
        String ret = "";
        for (int i = 0; i < psize; ++i) {
            ret = p == i ? ret + "#" : ret + "_";
        }
        ret = "High |" + ret + "| Low \t[" + p + "/" + psize + "] (Current/Number of State)";
        return ret;
    }
}

