/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class PMBusInfoCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmiI2CPMBusCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte busID = 0;
        byte slaveAddr = 0;
        if (this.parameters == null) {
            ipmiI2CPMBusCommand.detectBusID();
            ipmiI2CPMBusCommand.detectSlaveAddress();
            if (ipmiI2CPMBusCommand.getBusID() == 0) {
                MOut.G(this).println("Cannot detect BusID");
                this.statusCode = 147;
                return;
            }
            if (ipmiI2CPMBusCommand.getAvailableSlaveAddrs() == null) {
                MOut.G(this).println("Cannot detect slave address");
                this.statusCode = 147;
                return;
            }
            for (int i = 0; i < ipmiI2CPMBusCommand.getAvailableSlaveAddrs().length; ++i) {
                String moduleLabel = "";
                int module = ipmiI2CPMBusCommand.getModule(ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i]);
                if (module != 0) {
                    moduleLabel = "[Module " + module + "]";
                }
                MOut.G(this).println(" [SlaveAddress = " + ByteUtility.byteToHex(ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i]) + "h] " + moduleLabel);
                ipmiI2CPMBusCommand.setSlaveAddr(ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i]);
                IPMII2CPMBusCommand.PMBusHealth pmBusHealth = ipmiI2CPMBusCommand.getAll();
                MOut.G(this).println(pmBusHealth.toFormatedHeader() + pmBusHealth.toFormatedString());
            }
        } else {
            if (this.parameters.length < 2) {
                MOut.G(this).println("[<busId> <SlaveAddr>] both parameters required");
                this.statusCode = 147;
                return;
            }
            try {
                busID = (byte)Integer.parseInt(this.parameters[0], 16);
                slaveAddr = (byte)Integer.parseInt(this.parameters[1], 16);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            ipmiI2CPMBusCommand.setBusID(busID);
            ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
            IPMII2CPMBusCommand.PMBusHealth pmBusHealth = ipmiI2CPMBusCommand.getAll();
            MOut.G(this).println(pmBusHealth.toFormatedHeader() + pmBusHealth.toFormatedString());
        }
        this.statusCode = 0;
    }
}

